/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.fa.formplugin.DSField;

public class FaDepreSplitUtil {
    public static List<QFilter> getAssTypeFilter(long orgId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_asstacttype", (Long)orgId);
        if (baseDataFilter != null) {
            filters.add(baseDataFilter);
        }
        filters.add(new QFilter("valuetype", "!=", (Object)"3"));
        return filters;
    }

    public static List<DSField> generateFields(DynamicObjectCollection asstypes) {
        ArrayList<DSField> fields = new ArrayList<DSField>();
        int i = 0;
        int j = 0;
        ArrayList<String> errList = new ArrayList<String>(5);
        HashMap<String, String> existsEntities = new HashMap<String, String>(5);
        for (DynamicObject o : asstypes) {
            DynamicObject entityObject = (DynamicObject)o.get("fbasedataid");
            String fbdtype = entityObject.getString("valuetype");
            String astName = entityObject.getString("name");
            String sourceNumber = "";
            if ("1".equals(fbdtype)) {
                sourceNumber = entityObject.getString("valuesource.number");
            } else if ("2".equals(fbdtype)) {
                sourceNumber = entityObject.getString("assistanttype.id");
            }
            String mapKey = fbdtype + sourceNumber;
            if (existsEntities.containsKey(mapKey)) {
                errList.add(astName);
                String dumpName = (String)existsEntities.get(mapKey);
                errList.add(dumpName);
                continue;
            }
            existsEntities.put(mapKey, astName);
            DSField field = new DSField();
            field.setDataType(fbdtype);
            if ("1".equals(fbdtype)) {
                field.setEntityId(entityObject.getString("valuesource.number"));
                field.setFieldName(new LocaleString(entityObject.getString("valuesource.name")));
                field.setFieldKey("basedata" + i);
                ++i;
            } else if ("2".equals(fbdtype)) {
                field.setEntityId(entityObject.getString("assistanttype.id"));
                field.setFieldName(new LocaleString(entityObject.getString("assistanttype.name")));
                field.setFieldKey("assistant" + j);
                ++j;
            }
            fields.add(field);
        }
        if (errList.size() > 0) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u503c\u6765\u6e90\u76f8\u540c\u7684\u6838\u7b97\u7ef4\u5ea6\u503c\uff0c\u201c%s\u201d\u3002", (String)"FaDepreSplitUtil_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), String.join((CharSequence)",", errList)));
        }
        return fields;
    }
}

