/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import com.alibaba.fastjson.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.logorm.LogORM;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.fi.fa.business.enums.depre.FaOperationOpTypeEnum;
import kd.fi.fa.business.utils.FaBillParamUtils;
import kd.fi.fa.common.util.Fa;

public class FaFormCurPeriodBizUtils {
    private static final Log log = LogFactory.getLog(FaFormCurPeriodBizUtils.class);
    public static final String CONFIRM_SHOW_UPGRADEGUIDE = "show_upgradeguide";

    public static void showGuideConfirm4EditView(BeforeDoOperationEventArgs args, IFormView view, String entityName, IFormPlugin formPlugin) {
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        boolean needShowConfirm = FaFormCurPeriodBizUtils.showGuideConfirm4CurPeriodBiz(view, entityName, operateKey, false, formPlugin);
        if (needShowConfirm) {
            args.setCancel(true);
        }
    }

    public static void showGuideConfirm4List(BeforeItemClickEvent evt, IFormView view, String entityName, IFormPlugin formPlugin) {
        String operationKey = evt.getOperationKey();
        boolean needShowConfirm = FaFormCurPeriodBizUtils.showGuideConfirm4CurPeriodBiz(view, entityName, operationKey, true, formPlugin);
        if (needShowConfirm) {
            evt.setCancel(true);
        }
    }

    public static void guideConfirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent, IFormView view) {
        if (CONFIRM_SHOW_UPGRADEGUIDE.equals(messageBoxClosedEvent.getCallBackId()) && "Yes".equals(messageBoxClosedEvent.getResultValue())) {
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fa_finori_upg_guide");
            showParameter.setStatus(OperationStatus.ADDNEW);
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            showParameter.setHasRight(true);
            view.showForm(showParameter);
        }
    }

    private static boolean showGuideConfirm4CurPeriodBiz(IFormView view, String entityName, String operateKey, boolean isListView, IFormPlugin formPlugin) {
        String promptingMode;
        boolean guideConfirmed;
        if ((operateKey.equals("submit") || operateKey.equals("save")) && !(guideConfirmed = FaFormCurPeriodBizUtils.checkCurPeriodGuideAllConfirmed()) && FaFormCurPeriodBizUtils.checkHasCurPeriodBiz(view, entityName, isListView) && "B".equals(promptingMode = FaBillParamUtils.getStringValue(null, null, null, (String)"currentperiod.biz.prompting.mode", (boolean)false))) {
            ConfirmCallBackListener listener = new ConfirmCallBackListener(CONFIRM_SHOW_UPGRADEGUIDE, formPlugin);
            view.showConfirm(ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u8d22\u52a1\u5361\u7247\u539f\u59cb\u6570\u636e\u7684\u5347\u7ea7\u6307\u5f15\uff0c\u518d\u8fdb\u884c\u65b0\u589e\u5f53\u671f\u4e1a\u52a1\u3002", (String)"FaFormCurPeriodBizUtils_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, ConfirmTypes.Default, listener);
            return true;
        }
        return false;
    }

    private static boolean checkCurPeriodGuideAllConfirmed() {
        boolean guideConfirmed = true;
        LogORM logORM = LogORM.create();
        DynamicObjectCollection logList = logORM.query("fa_operation_log", "result_tag", new QFilter[]{new QFilter("optype", "=", (Object)FaOperationOpTypeEnum.UPGRADEGUIDECONFIRM.name())}, 1, 0);
        if (CollectionUtils.isEmpty((Collection)logList)) {
            return false;
        }
        DynamicObject logObj = (DynamicObject)logList.get(0);
        String resultTag = logObj.getString("result_tag");
        if (StringUtils.isEmpty((String)resultTag)) {
            guideConfirmed = false;
        } else {
            List list = (List)JSONArray.parseObject((String)resultTag, List.class);
            for (Map step : list) {
                Boolean status = (Boolean)step.get("status");
                if (status.booleanValue()) continue;
                guideConfirmed = false;
                break;
            }
        }
        return guideConfirmed;
    }

    private static boolean checkHasCurPeriodBiz(IFormView view, String entityName, boolean isListView) {
        ArrayList<DynamicObject> bizBillObjs = new ArrayList<DynamicObject>(16);
        if (isListView) {
            ListSelectedRowCollection selectedRows = ((ListView)view).getSelectedRows();
            Object[] pks = selectedRows.getPrimaryKeyValues();
            String queryFields = null;
            switch (entityName) {
                case "fa_assetsplitbill": {
                    queryFields = Fa.comma((String[])new String[]{"splitperiod", Fa.dot((String[])new String[]{"assetsplitentry", "bef_fincard"})});
                    break;
                }
                case "fa_clearbill": {
                    queryFields = Fa.comma((String[])new String[]{"clearperiod", Fa.dot((String[])new String[]{"detail_entry", "isclearall"}), Fa.dot((String[])new String[]{"detail_entry", "fincard"})});
                    break;
                }
                case "fa_mergebill": {
                    queryFields = Fa.comma((String[])new String[]{"org", "mergeperiod", "realcard", "inentryentity", Fa.dot((String[])new String[]{"inentryentity", "outentryentity"}), "OUTREALCARDMASTERID"});
                }
            }
            DynamicObject[] bizBillRecords = BusinessDataServiceHelper.load((String)entityName, queryFields, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)pks)});
            bizBillObjs.addAll(Arrays.asList(bizBillRecords));
        } else {
            bizBillObjs.add(view.getModel().getDataEntity(true));
        }
        if ("fa_mergebill".equals(entityName)) {
            return FaFormCurPeriodBizUtils.checkHasCurPeriod4Merge(bizBillObjs);
        }
        for (DynamicObject bizBill : bizBillObjs) {
            boolean hasCurPeriodBiz = false;
            switch (entityName) {
                case "fa_assetsplitbill": {
                    hasCurPeriodBiz = FaFormCurPeriodBizUtils.checkHasCurPeriod4Split(bizBill);
                    break;
                }
                case "fa_clearbill": {
                    hasCurPeriodBiz = FaFormCurPeriodBizUtils.checkHasCurPeriod4PartClear(bizBill);
                }
            }
            if (!hasCurPeriodBiz) continue;
            return true;
        }
        return false;
    }

    private static boolean checkHasCurPeriod4Split(DynamicObject splitBill) {
        Long splitPeriodId = splitBill.getLong(Fa.id((String)"splitperiod"));
        DynamicObjectCollection befEntries = splitBill.getDynamicObjectCollection("assetsplitentry");
        for (DynamicObject befEntry : befEntries) {
            DynamicObject finDy = befEntry.getDynamicObject("bef_fincard");
            DynamicObject cardPeriodId = finDy.getDynamicObject("period");
            if (cardPeriodId == null || splitPeriodId.longValue() != cardPeriodId.getLong("id")) continue;
            return true;
        }
        return false;
    }

    private static boolean checkHasCurPeriod4PartClear(DynamicObject clearBill) {
        long clrPeriodId = clearBill.getLong(Fa.id((String)"clearperiod"));
        DynamicObjectCollection clrEntries = clearBill.getDynamicObjectCollection("detail_entry");
        List partClearEntries = clrEntries.stream().filter(t -> !"1".equals(t.getString("isclearall"))).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(partClearEntries)) {
            for (DynamicObject entry : partClearEntries) {
                long cardBizPeriodId;
                DynamicObject finCard = entry.getDynamicObject("fincard");
                long addPeriodId = finCard.getLong(Fa.id((String)"period"));
                if (addPeriodId != (cardBizPeriodId = finCard.getLong(Fa.id((String)"bizperiod"))) || clrPeriodId != addPeriodId) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkHasCurPeriod4Merge(List<DynamicObject> mergeBills) {
        HashMap<String, Long> orgIdDepreuseId2CurPeriodIdMap = new HashMap<String, Long>(mergeBills.size());
        HashSet<Long> orgIds = new HashSet<Long>(mergeBills.size());
        HashSet<Long> realCardIds = new HashSet<Long>(mergeBills.size());
        for (DynamicObject dynamicObject : mergeBills) {
            Long orgId = dynamicObject.getLong(Fa.id((String)"org"));
            orgIds.add(orgId);
            DynamicObjectCollection inEntryEntity = dynamicObject.getDynamicObjectCollection("inentryentity");
            DynamicObject inEntry = (DynamicObject)inEntryEntity.get(0);
            DynamicObjectCollection outEntryEntity = inEntry.getDynamicObjectCollection("outentryentity");
            DynamicObject realCard = dynamicObject.getDynamicObject("realcard");
            if (realCard != null) {
                realCardIds.add(realCard.getLong("id"));
            }
            Set outRealCardIds = outEntryEntity.stream().map(v -> v.getLong("OUTREALCARDMASTERID")).collect(Collectors.toSet());
            realCardIds.addAll(outRealCardIds);
        }
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"org", "depreuse", "curperiod"}), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        for (DynamicObject book : books) {
            Long orgId = book.getLong("org");
            Long depreuseId = book.getLong("depreuse");
            Long curPeriodId = book.getLong("curperiod");
            String key = orgId + "_" + depreuseId;
            orgIdDepreuseId2CurPeriodIdMap.put(key, curPeriodId);
        }
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"fa_card_fin", (String)Fa.comma((String[])new String[]{"org", "depreuse", "period", "bizperiod"}), (QFilter[])new QFilter[]{new QFilter("realcardmasterid", "in", realCardIds), new QFilter("endperiod", "=", (Object)99999999999L)});
        for (DynamicObject finCard : dynamicObjectCollection) {
            Long orgId = finCard.getLong("org");
            Long depreuseId = finCard.getLong("depreuse");
            long cardPeriodId = finCard.getLong("period");
            long cardBizPeriodId = finCard.getLong("bizperiod");
            String key = orgId + "_" + depreuseId;
            long mergePeriodId = (Long)orgIdDepreuseId2CurPeriodIdMap.get(key);
            if (cardPeriodId != cardBizPeriodId || mergePeriodId != cardPeriodId) continue;
            return true;
        }
        return false;
    }
}

