/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.filter.SortType;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.JSONUtils;
import kd.fi.fa.business.operate.FaOpCmdFactory;
import kd.fi.fa.business.operate.FaOpCmdUtils;

public class FaFormUtils {
    private static final String ORG = "orgid";
    private static final String DEPRE_USE = "depreuseid";
    private static final Log logger = LogFactory.getLog(FaFormUtils.class);

    public static void checkUndoOperable(DynamicObject dataEntity) {
        FaFormUtils.checkUndoOperable(dataEntity.getDataEntityType().toString(), dataEntity.getPkValue());
    }

    public static void checkUndoOperable(String dataEntityType, Object pk) {
        ArrayList<String> errorList = new ArrayList<String>();
        boolean isOperable = FaOpCmdUtils.isUndoOperable((Object)pk, (String)dataEntityType, errorList);
        if (!isOperable) {
            throw new KDBizException(new ErrorCode("UNKNOWN_ERR", FaFormUtils.handleError(errorList)), new Object[0]);
        }
    }

    public static void doOp(DynamicObject dataEntity) {
        FaFormUtils.doOp(dataEntity.getDataEntityType().toString(), dataEntity.getPkValue());
    }

    public static void doOp(String dataEntityType, Object pk) {
        FaOpCmdFactory.getInstance((String)dataEntityType, (Object)pk).doAudit();
    }

    public static void undoOp(DynamicObject dataEntity) {
        FaFormUtils.undoOp(dataEntity.getDataEntityType().toString(), dataEntity.getPkValue());
    }

    public static void undoOp(String dataEntityType, Object pk) {
        FaOpCmdFactory.getInstance((String)dataEntityType, (Object)pk).doUnaudit();
    }

    public static long getCardOrg(IDataModel idm) {
        Long orgId = null;
        IDataEntityProperty p = idm.getProperty(ORG);
        if (p == null) {
            throw new KDBizException(new LocaleString(ResManager.loadKDString((String)"\u8be5\u5361\u7247\u53ea\u80fd\u5728\u8d44\u4ea7\u7684\u5de5\u4f5c\u53f0\u4f7f\u7528\u3002", (String)"FaFormUtils_0", (String)"fi-fa-formplugin", (Object[])new Object[0])).toString());
        }
        DynamicObject org = (DynamicObject)idm.getValue(ORG);
        if (org == null) {
            return 0L;
        }
        orgId = org.getLong("id");
        return orgId;
    }

    private static String handleError(List<String> errorList) {
        StringBuilder sb = new StringBuilder();
        for (String error : errorList) {
            sb.append(sb.length() > 0 ? "\r\n" : "");
            sb.append(error);
        }
        return sb.toString();
    }

    public static String buildOrderByString(SetFilterEvent e) {
        String sortInfo = ((BillList)e.getSource()).getEntryState().getSortInfo();
        if (StringUtils.isNotEmpty((CharSequence)sortInfo)) {
            ((BillList)e.getSource()).getEntryState().setSortInfo(sortInfo.replace(".name", ".id"));
        } else {
            List sortFields = ((BillList)e.getSource()).getListFields().stream().filter(item -> item.getSortType() != null && (SortType.ASC == item.getSortType() || SortType.DESC == item.getSortType())).map(item -> FaFormUtils.nameToId(item.getFieldName()) + " " + (SortType.ASC == item.getSortType() ? SortType.ASC.name() : SortType.DESC.name())).collect(Collectors.toList());
            sortInfo = String.join((CharSequence)",", sortFields);
        }
        return sortInfo;
    }

    public static String nameToId(String name) {
        if (name.startsWith("org.") || name.startsWith("period.")) {
            return name.split("\\.")[0];
        }
        return name;
    }

    public static long getCardDepreUse(IDataModel idm) {
        IDataEntityProperty p = idm.getProperty(DEPRE_USE);
        if (p == null) {
            throw new KDBizException(new LocaleString(ResManager.loadKDString((String)"\u8be5\u5361\u7247\u53ea\u80fd\u5728\u8d44\u4ea7\u7684\u5de5\u4f5c\u53f0\u4f7f\u7528\u3002", (String)"FaFormUtils_0", (String)"fi-fa-formplugin", (Object[])new Object[0])).toString());
        }
        DynamicObject depreUse = (DynamicObject)idm.getValue(DEPRE_USE);
        if (depreUse == null) {
            return 0L;
        }
        Long depreUseId = depreUse.getLong("id");
        return depreUseId;
    }

    public static String linkOrgContainerInit(IPageCache pageCache, IFormView view, String field) throws IOException {
        String linkQueryInfoJson = pageCache.get("filtercontainerap_linkQueryPkIdCollection");
        List linkQueryInfoList = (List)JSONUtils.cast((String)linkQueryInfoJson, List.class);
        QFilter qFilter = null;
        if (!linkQueryInfoList.isEmpty()) {
            Set pkIds = linkQueryInfoList.stream().map(v -> ((Map)v).get("pkId")).collect(Collectors.toSet());
            qFilter = new QFilter("id", "in", pkIds);
        } else {
            FormShowParameter formShowParameter = view.getFormShowParameter();
            Map customParams = formShowParameter.getCustomParams();
            Object filter = customParams.get("filter");
            if (filter != null) {
                qFilter = QFilter.fromSerializedString((String)filter.toString());
            }
        }
        String jsonString = null;
        if (qFilter != null) {
            String billFormId = ((ListView)view).getBillFormId();
            DynamicObjectCollection query = QueryServiceHelper.query((String)billFormId, (String)field, (QFilter[])new QFilter[]{qFilter});
            if (!query.isEmpty()) {
                Set assetUnit = query.stream().map(v -> v.getString(field)).collect(Collectors.toSet());
                jsonString = SerializationUtils.toJsonString(assetUnit);
            }
        }
        return jsonString;
    }

    public static List<Long> getLinkQueryId(IPageCache pageCache, String type, String entityName) {
        String linkQueryInfoJson = pageCache.get("filtercontainerap_linkQueryPkIdCollection");
        List linkQueryInfoList = Collections.EMPTY_LIST;
        ArrayList<Long> rsList = new ArrayList<Long>();
        HashSet<Long> typeSet = new HashSet<Long>();
        try {
            if (!kd.bos.util.StringUtils.isBlank((String)linkQueryInfoJson)) {
                linkQueryInfoList = (List)JSONUtils.cast((String)linkQueryInfoJson, List.class);
            }
        }
        catch (IOException e) {
            logger.error("kd.fi.fa.formplugin.FaFormUtils\uff1a\u8f6c\u6362\u7f13\u5b58\u4e2d\u7684\u8054\u67e5\u4fe1\u606f\u65f6\u51fa\u9519", (Throwable)e);
        }
        if (!linkQueryInfoList.isEmpty()) {
            HashSet pkIds = new HashSet();
            linkQueryInfoList.stream().forEach(r -> {
                Long pkId = (Long)((Map)r).get("pkId");
                pkIds.add(pkId);
            });
            QFilter[] filters = new QFilter[]{new QFilter("id", "in", pkIds)};
            DynamicObjectCollection bills = QueryServiceHelper.query((String)entityName, (String)type, (QFilter[])filters);
            for (DynamicObject bill : bills) {
                typeSet.add(bill.getLong(type));
            }
            rsList.addAll(typeSet);
        }
        return rsList;
    }
}

