/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.IBasedataField;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaInventoryUtils {
    private static final String algoKey = "kd.fi.fa.utils.FaInventoryUtils.updateProgress";

    public static void setColumnVisible(IFormView view, Set<String> excludeColumnNames) {
        ArrayList<String> columnNames = new ArrayList<String>(16);
        for (int i = 0; i < 11; ++i) {
            columnNames.add("entrytext" + i);
        }
        columnNames.removeAll(excludeColumnNames);
        view.setVisible(Boolean.FALSE, columnNames.toArray(new String[0]));
        view.setVisible(Boolean.TRUE, excludeColumnNames.toArray(new String[0]));
    }

    public static Map<String, Map<String, Object>> getBaseEntityIdMap() {
        HashMap<String, Map<String, Object>> baseEntityIdMap = new HashMap<String, Map<String, Object>>(16);
        Map allFields = ((EntityType)EntityMetadataCache.getDataEntityType((String)"fa_inventory_taskrule").getAllEntities().get("taskruleentity")).getFields();
        for (IDataEntityProperty value : allFields.values()) {
            if (!(value instanceof BasedataProp) && !(value instanceof MulBasedataProp)) continue;
            HashMap<String, String> map = new HashMap<String, String>(2, 1.0f);
            map.put("entityId", ((IBasedataField)value).getBaseEntityId());
            map.put("displayName", (String)value.getDisplayName());
            baseEntityIdMap.put(value.getName(), map);
        }
        baseEntityIdMap.remove("inventperson");
        return baseEntityIdMap;
    }

    public static String getAllNamesString(List<String> strings) {
        StringBuilder sb = new StringBuilder();
        char c = ';';
        for (String string : strings) {
            sb.append(string).append(c);
        }
        return sb.length() > 0 ? sb.toString().substring(0, sb.length() - 1) : "";
    }

    public static Map<String, Set<Long>> transferSplitFieldValue(String splitFieldStr) {
        Map map = (Map)SerializationUtils.fromJsonString((String)splitFieldStr, Map.class);
        HashMap<String, Set<Long>> resMap = new HashMap<String, Set<Long>>(map.size(), 1.0f);
        for (Map.Entry entry : map.entrySet()) {
            Set<Long> ids = FaInventoryUtils.getSplitFieldIds((String)entry.getValue());
            if (ids.isEmpty()) continue;
            resMap.put((String)entry.getKey(), ids);
        }
        return resMap;
    }

    public static Set<Long> getSplitFieldIds(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return new HashSet<Long>();
        }
        String[] strs = FaInventoryUtils.splitString(str);
        HashSet<Long> ids = new HashSet<Long>(strs.length);
        for (String s : strs) {
            if (!StringUtils.isNotEmpty((CharSequence)s)) continue;
            ids.add(Long.parseLong(s));
        }
        return ids;
    }

    public static String[] splitString(String str) {
        return str.split(",");
    }

    public static void setResultMapValue(Map<String, Set<Long>> queryMap, Map<String, Map<String, Object>> baseEntityIdMap, Map<String, Map<Long, String>> resultMap) {
        for (Map.Entry<String, Set<Long>> entry : queryMap.entrySet()) {
            DynamicObjectCollection dynamicObjectCollection;
            Map<String, Object> map = baseEntityIdMap.get(entry.getKey());
            if (null == map.get("entityId")) continue;
            String entityName = map.get("entityId").toString();
            BasedataEntityType entityType = (BasedataEntityType)EntityMetadataCache.getDataEntityType((String)entityName);
            IBasedataField basedataField = (IBasedataField)((EntityType)EntityMetadataCache.getDataEntityType((String)"fa_inventory_taskrule").getAllEntities().get("taskruleentity")).getFields().get(entry.getKey());
            String splitDisplayProp = basedataField.getDisplayProp();
            String nameDisplayProp = entityType.getNameProperty();
            String numberDisplayProp = entityType.getNumberProperty();
            String selectFields = "id";
            if (StringUtils.isNotEmpty((CharSequence)nameDisplayProp)) {
                selectFields = Fa.join((String)",", (String[])new String[]{selectFields, nameDisplayProp});
            }
            if (StringUtils.isNotEmpty((CharSequence)numberDisplayProp)) {
                selectFields = Fa.join((String)",", (String[])new String[]{selectFields, numberDisplayProp});
            }
            if (splitDisplayProp.toLowerCase(Locale.ROOT).contains("longnumber")) {
                selectFields = Fa.comma((String[])new String[]{selectFields, "longnumber"});
            }
            if (splitDisplayProp.toLowerCase(Locale.ROOT).contains("fullname")) {
                selectFields = Fa.comma((String[])new String[]{selectFields, "fullname"});
            }
            if ((dynamicObjectCollection = QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())})) == null) continue;
            HashMap<Long, String> idAndNameMap = new HashMap<Long, String>(dynamicObjectCollection.size(), 1.0f);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String[] str;
                String name = StringUtils.isNotEmpty((CharSequence)nameDisplayProp) ? dynamicObject.getString(nameDisplayProp) : "";
                String number = StringUtils.isNotEmpty((CharSequence)numberDisplayProp) ? dynamicObject.getString(numberDisplayProp) : "";
                String longNumber = selectFields.contains("longnumber") ? dynamicObject.getString("longnumber") : "";
                String fullName = selectFields.contains("fullname") ? dynamicObject.getString("fullname") : "";
                StringBuilder sb = new StringBuilder();
                if (splitDisplayProp.contains(",")) {
                    str = splitDisplayProp.split(",");
                    sb.append(FaInventoryUtils.replaceFieldValue(str[0], name, number, longNumber, fullName)).append(",").append(FaInventoryUtils.replaceFieldValue(str[1], name, number, longNumber, fullName));
                } else if (splitDisplayProp.contains(" ")) {
                    str = splitDisplayProp.split(" ");
                    sb.append(FaInventoryUtils.replaceFieldValue(str[0], name, number, longNumber, fullName)).append(" ").append(FaInventoryUtils.replaceFieldValue(str[1], name, number, longNumber, fullName));
                } else if (splitDisplayProp.contains("/")) {
                    str = splitDisplayProp.split("/");
                    sb.append(FaInventoryUtils.replaceFieldValue(str[0], name, number, longNumber, fullName)).append("/").append(FaInventoryUtils.replaceFieldValue(str[1], name, number, longNumber, fullName));
                } else if (splitDisplayProp.contains("_")) {
                    str = splitDisplayProp.split("_");
                    sb.append(FaInventoryUtils.replaceFieldValue(str[0], name, number, longNumber, fullName)).append("_").append(FaInventoryUtils.replaceFieldValue(str[1], name, number, longNumber, fullName));
                } else if (splitDisplayProp.contains("(")) {
                    str = splitDisplayProp.split("\\(");
                    sb.append(FaInventoryUtils.replaceFieldValue(str[0], name, number, longNumber, fullName)).append("(").append(FaInventoryUtils.replaceFieldValue(str[1].split("\\)")[0], name, number, longNumber, fullName)).append(")");
                } else {
                    sb.append(FaInventoryUtils.replaceFieldValue(splitDisplayProp, name, number, longNumber, fullName));
                }
                idAndNameMap.put(dynamicObject.getLong("id"), sb.toString());
            }
            resultMap.put(entry.getKey(), idAndNameMap);
        }
    }

    private static String replaceFieldValue(String field, String name, String number, String longNumber, String fullName) {
        if ("name".equals(field)) {
            return name;
        }
        if ("number".equals(field)) {
            return number;
        }
        if ("longNumber".equals(field)) {
            return longNumber;
        }
        return fullName;
    }

    public static Map<Long, Map<String, Integer>> updateProgress(DynamicObjectCollection inventoryTasks) {
        Row row;
        Set ids = inventoryTasks.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
        QFilter qFilter1 = new QFilter("inventorytask", "in", ids);
        QFilter qFilter2 = new QFilter("inventorystate", "!=", (Object)"B");
        QFilter qFilter3 = new QFilter("billstate", "=", (Object)"C");
        DataSet taskSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_inventory_record", (String)"inventorytask", (QFilter[])qFilter1.toArray(), null).groupBy(new String[]{"inventorytask"}).count().finish();
        DataSet inventSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_inventory_record", (String)"inventorytask", (QFilter[])new QFilter[]{qFilter1, qFilter2}, null).groupBy(new String[]{"inventorytask"}).count().finish();
        DataSet auditSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"fa_inventory_record", (String)"inventorytask", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, null).groupBy(new String[]{"inventorytask"}).count().finish();
        HashMap<Long, Integer> taskMap = new HashMap<Long, Integer>(ids.size());
        HashMap<Long, Integer> inventMap = new HashMap<Long, Integer>(ids.size());
        HashMap<Long, Integer> auditMap = new HashMap<Long, Integer>(ids.size());
        HashMap<Long, Map<String, Integer>> result = new HashMap<Long, Map<String, Integer>>(ids.size());
        while (taskSet.hasNext()) {
            row = taskSet.next();
            taskMap.put(row.getLong("inventorytask"), row.getInteger("count"));
        }
        while (inventSet.hasNext()) {
            row = inventSet.next();
            inventMap.put(row.getLong("inventorytask"), row.getInteger("count"));
        }
        while (auditSet.hasNext()) {
            row = auditSet.next();
            auditMap.put(row.getLong("inventorytask"), row.getInteger("count"));
        }
        for (Map.Entry entry : taskMap.entrySet()) {
            HashMap<String, Integer> rate = new HashMap<String, Integer>(2);
            Integer inventCount = (Integer)inventMap.get(entry.getKey());
            Integer auditCount = (Integer)auditMap.get(entry.getKey());
            rate.put("inventRate", FaInventoryUtils.getProgressRate(inventCount == null ? 0 : inventCount, (Integer)entry.getValue()));
            rate.put("auditRate", FaInventoryUtils.getProgressRate(auditCount == null ? 0 : auditCount, (Integer)entry.getValue()));
            result.put((Long)entry.getKey(), (Map<String, Integer>)rate);
        }
        return result;
    }

    public static int getProgressRate(int count, int total) {
        double realRate = (double)count * 1.0 / (double)total * 100.0;
        if (realRate < 1.0) {
            return (int)Math.ceil(realRate);
        }
        return (int)Math.floor(realRate);
    }

    public static Set<String> getSplitFields(DynamicObjectCollection inventoryTasks) {
        HashSet<String> splitfields = new HashSet<String>(8);
        List splitfieldvalues = inventoryTasks.stream().map(v -> v.getString("splitfieldvalue")).collect(Collectors.toList());
        for (String splitfieldvalue : splitfieldvalues) {
            if (!StringUtils.isNotEmpty((CharSequence)splitfieldvalue)) continue;
            Map<String, Set<Long>> map = FaInventoryUtils.transferSplitFieldValue(splitfieldvalue);
            splitfields.addAll(map.keySet());
        }
        splitfields.remove(null);
        return splitfields;
    }
}

