/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.fa.utils.FaRealCardFieldUtil;

public class FaStorekeeperMatchUtil {
    private static final String ASSETCAT = "assetcat";
    private static final String STOREPLACEGROUP = "storeplacegroup";

    public static Long getStoreKeeperId(DynamicObject realCard, String assetunitId) {
        Long id;
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("org", "=", (Object)Long.valueOf(assetunitId)));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObject storeKeeper = BusinessDataServiceHelper.loadSingle((String)"fa_storekeeper", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (storeKeeper == null) {
            return -1L;
        }
        String dimension = storeKeeper.getString("dimension");
        Long billHeadStoreKeeperId = storeKeeper.getDynamicObject("storekeeper").getLong("id");
        if (StringUtils.isBlank((String)dimension)) {
            return billHeadStoreKeeperId;
        }
        String[] dimensions = dimension.split(",");
        List<String> dimensionList = Arrays.asList(dimensions);
        DynamicObjectCollection storeKeeperEntry = storeKeeper.getDynamicObjectCollection("storekeeperentry");
        if (storeKeeperEntry.isEmpty()) {
            return billHeadStoreKeeperId;
        }
        if (realCard.get(ASSETCAT) instanceof DynamicObject) {
            DynamicObject queryCard = QueryServiceHelper.queryOne((String)"fa_card_real", (String)"id,assetcat,storeplace", (QFilter[])new QFilter("id", "=", (Object)realCard.getLong("id")).toArray());
            id = FaStorekeeperMatchUtil.getIdFromEntry(dimensionList, storeKeeperEntry, queryCard);
        } else {
            id = FaStorekeeperMatchUtil.getIdFromEntry(dimensionList, storeKeeperEntry, realCard);
        }
        if (id == -1L) {
            return billHeadStoreKeeperId;
        }
        return id;
    }

    public static Long getStorekeeperFromEntry(DynamicObject realCard, String assetunitId) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter("org", "=", (Object)Long.valueOf(assetunitId)));
        qFilters.add(new QFilter("enable", "=", (Object)"1"));
        DynamicObject storeKeeper = BusinessDataServiceHelper.loadSingle((String)"fa_storekeeper", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (storeKeeper == null) {
            return -1L;
        }
        String dimension = storeKeeper.getString("dimension");
        Long billHeadStoreKeeperId = storeKeeper.getDynamicObject("storekeeper").getLong("id");
        if (StringUtils.isBlank((String)dimension)) {
            return billHeadStoreKeeperId;
        }
        String[] dimensions = dimension.split(",");
        List<String> dimensionList = Arrays.asList(dimensions);
        DynamicObjectCollection storeKeeperEntry = storeKeeper.getDynamicObjectCollection("storekeeperentry");
        if (storeKeeperEntry.isEmpty()) {
            return -1L;
        }
        return FaStorekeeperMatchUtil.getIdFromEntry(dimensionList, storeKeeperEntry, realCard);
    }

    private static Long getIdFromEntry(List<String> dimensionList, DynamicObjectCollection storeKeeperEntry, DynamicObject realCard) {
        QFilter[] qFilters1 = new QFilter[]{new QFilter("id", "=", (Object)realCard.getLong("storeplace"))};
        DynamicObject realCardStorePlace = QueryServiceHelper.queryOne((String)"fa_storeplace", (String)"id,group", (QFilter[])qFilters1);
        QFilter[] qFilters2 = new QFilter[]{new QFilter("id", "=", (Object)realCard.getLong(ASSETCAT))};
        DynamicObject realCardAssetCat = QueryServiceHelper.queryOne((String)"fa_assetcategory", (String)"id,parent,level", (QFilter[])qFilters2);
        HashMap<Integer, String> parentMap = new HashMap<Integer, String>(10);
        HashMap<String, Integer> dimIdLevemMap = new HashMap<String, Integer>(100);
        if (dimensionList.contains(ASSETCAT)) {
            int minLevel = 100;
            int realCardLevel = realCardAssetCat.getInt("level");
            ArrayList<Object> assetCategoryPkList = new ArrayList<Object>(100);
            for (Object entryItem : storeKeeperEntry) {
                for (DynamicObject dimItem : entryItem.getDynamicObjectCollection(ASSETCAT)) {
                    assetCategoryPkList.add(dimItem.getDynamicObject("fbasedataid").getPkValue());
                }
            }
            DynamicObjectCollection assetCategoryDimCollection = QueryServiceHelper.query((String)"fa_assetcategory", (String)"id,parent,level", (QFilter[])new QFilter[]{new QFilter("id", "in", assetCategoryPkList)});
            for (DynamicObject actDimItem : assetCategoryDimCollection) {
                dimIdLevemMap.put(actDimItem.getString("id"), actDimItem.getInt("level"));
                minLevel = Math.min(minLevel, actDimItem.getInt("level"));
            }
            QFilter qFilter1 = new QFilter("level", "<", (Object)realCardLevel);
            QFilter qFilter2 = new QFilter("level", ">=", (Object)minLevel);
            QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
            DynamicObjectCollection assetCategoryBetweenLevelsCollection = QueryServiceHelper.query((String)"fa_assetcategory", (String)"id,level,parent", (QFilter[])new QFilter[]{qFilter1, qFilter2, qFilter3}, (String)"level");
            parentMap.put(realCardLevel, realCard.getString(ASSETCAT));
            String parentId = realCardAssetCat.getString("parent");
            int currentLevel = realCardLevel - 1;
            for (int i = assetCategoryBetweenLevelsCollection.size() - 1; i >= 0; --i) {
                DynamicObject actItem = (DynamicObject)assetCategoryBetweenLevelsCollection.get(i);
                if (actItem.getInt("level") != currentLevel || !actItem.getString("id").equals(parentId)) continue;
                parentMap.put(currentLevel, parentId);
                --currentLevel;
                parentId = actItem.getString("parent");
            }
        }
        long storeKeeperId = -1L;
        FaRealCardFieldUtil fieldUtil = new FaRealCardFieldUtil();
        StringBuilder selectFields = new StringBuilder("id,assetcat,storeplace");
        for (String dimension : dimensionList) {
            String propStr;
            if (dimension.equals(ASSETCAT) || dimension.equals(STOREPLACEGROUP) || !StringUtils.isNotEmpty((String)(propStr = fieldUtil.getPropName(dimension)))) continue;
            selectFields.append(",").append(fieldUtil.getPropName(dimension));
        }
        realCard = QueryServiceHelper.queryOne((String)"fa_card_real", (String)selectFields.toString(), (QFilter[])new QFilter[]{new QFilter("id", "=", realCard.get("id"))});
        for (DynamicObject entryItem : storeKeeperEntry) {
            int currentLevel = -1;
            int assetCatLevel = -1;
            boolean result = true;
            for (String dimension : dimensionList) {
                if (StringUtils.isEmpty((String)dimension) || !entryItem.containsProperty(dimension)) continue;
                String propStr = fieldUtil.getPropName(dimension);
                if (StringUtils.isEmpty((String)dimension)) {
                    String errMsg = String.format(ResManager.loadKDString((String)"%s\u7ef4\u5ea6\u4e0e\u5b9e\u7269\u5361\u7247\u4e0d\u5339\u914d\u3002", (String)"FaStorekeeperMatchUtil_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), dimension);
                    throw new KDBizException(errMsg);
                }
                if (dimension.equals(ASSETCAT)) {
                    DynamicObjectCollection assetCollection = entryItem.getDynamicObjectCollection(ASSETCAT);
                    currentLevel = FaStorekeeperMatchUtil.assetCatMatch(parentMap, assetCollection, dimIdLevemMap);
                    if (currentLevel != -1) continue;
                    result = false;
                    continue;
                }
                if (dimension.equals(STOREPLACEGROUP)) {
                    DynamicObjectCollection placeGroupCollection = entryItem.getDynamicObjectCollection(STOREPLACEGROUP);
                    if (FaStorekeeperMatchUtil.storePlaceGroupMatch(realCardStorePlace, placeGroupCollection)) continue;
                    result = false;
                    continue;
                }
                if (FaStorekeeperMatchUtil.isMulBasedata(dimension).booleanValue()) {
                    if (FaStorekeeperMatchUtil.mulBasedataMatch(propStr, entryItem.getDynamicObjectCollection(dimension), realCard)) continue;
                    result = false;
                    continue;
                }
                if (FaStorekeeperMatchUtil.isBasedata(dimension).booleanValue()) {
                    if (FaStorekeeperMatchUtil.basedataMatch(propStr, entryItem.getDynamicObject(dimension), realCard)) continue;
                    result = false;
                    continue;
                }
                if (entryItem.getString(dimension).equals(realCard.getString(propStr))) continue;
                result = false;
            }
            if (result && currentLevel > assetCatLevel) {
                assetCatLevel = currentLevel;
                storeKeeperId = entryItem.getDynamicObject("dimstorekeeper").getLong("id");
            }
            if (dimensionList.contains(ASSETCAT)) continue;
            return entryItem.getDynamicObject("dimstorekeeper").getLong("id");
        }
        return storeKeeperId;
    }

    private static int assetCatMatch(Map<Integer, String> parentMap, DynamicObjectCollection dimAct, Map<String, Integer> dimIdLevemMap) {
        for (DynamicObject dimItem : dimAct) {
            int dimLevel;
            String realCardParentid;
            String dimItemId = dimItem.getDynamicObject("fbasedataid").getString("id");
            if (!dimItemId.equals(realCardParentid = parentMap.get(dimLevel = dimIdLevemMap.get(dimItemId).intValue()))) continue;
            return dimLevel;
        }
        return -1;
    }

    private static boolean storePlaceGroupMatch(DynamicObject realCardStorePlace, DynamicObjectCollection storePlaceGroupDimension) {
        if (storePlaceGroupDimension == null || storePlaceGroupDimension.isEmpty()) {
            return false;
        }
        String groupId = realCardStorePlace.getString("group");
        if (StringUtils.isBlank((String)groupId)) {
            return false;
        }
        for (DynamicObject dimItem : storePlaceGroupDimension) {
            if (!dimItem.getDynamicObject("fbasedataid").getString("id").equals(groupId)) continue;
            return true;
        }
        return false;
    }

    private static boolean mulBasedataMatch(String dimension, DynamicObjectCollection dimensionDetailCollection, DynamicObject realCard) {
        if (dimensionDetailCollection == null) {
            return false;
        }
        String realCardFieldValue = realCard.getString(dimension);
        for (DynamicObject obj : dimensionDetailCollection) {
            String dimensionValue = obj.getDynamicObject("fbasedataid").getString("id");
            if (!dimensionValue.equals(realCardFieldValue)) continue;
            return true;
        }
        return false;
    }

    private static boolean basedataMatch(String dimension, DynamicObject dimensionDetail, DynamicObject realCard) {
        if (dimensionDetail == null) {
            return false;
        }
        String realCardValue = realCard.getString(dimension);
        String dimensionValue = dimensionDetail.getString("id");
        return realCardValue.equals(dimensionValue);
    }

    public static Boolean isMulBasedata(String propertyName) {
        MainEntityType storeKeeperEntityType = EntityMetadataCache.getDataEntityType((String)"fa_storekeeper");
        IDataEntityType entryType = ((EntryProp)storeKeeperEntityType.getProperty("storekeeperentry")).getItemType();
        DataEntityPropertyCollection propertys = entryType.getProperties();
        IDataEntityProperty property = (IDataEntityProperty)propertys.get((Object)propertyName);
        boolean result = property instanceof MulBasedataProp;
        return result;
    }

    public static Boolean isBasedata(String propertyName) {
        MainEntityType storeKeeperEntityType = EntityMetadataCache.getDataEntityType((String)"fa_storekeeper");
        IDataEntityType entryType = ((EntryProp)storeKeeperEntityType.getProperty("storekeeperentry")).getItemType();
        DataEntityPropertyCollection propertys = entryType.getProperties();
        IDataEntityProperty property = (IDataEntityProperty)propertys.get((Object)propertyName);
        boolean result = property instanceof BasedataProp;
        return result;
    }
}

