/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.utils;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.AbstractGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.ExchangeTypeEnum;
import kd.fi.fa.business.dao.factory.FaBillDaoFactory;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;

public class FaUtils {
    public static final String ALGOKEY = "kd.fi.fa.utils.FaUtils";
    public static final String TABAP = "tabap";
    public static final String SOURCEBILLID = "sourcebillid";
    public static final String AI_DAPTRACKER = "ai_daptracker";
    public static final String VOUCHERID = "voucherid";
    public static final String BILLNO = "billno";
    public static final String ID = "id";
    public static final String GL_VOUCHER = "gl_voucher";
    public static final String FA_CLRBILL = "fa_clrbill";
    private static final Log log = LogFactory.getLog(FaUtils.class);

    public static Boolean isFieldEmpty(IDataModel model, String field) {
        DynamicObject dynObj = model.getDataEntity();
        return dynObj == null || dynObj.get(field) == null;
    }

    public static String removeString_id(String str) {
        if (str.length() > 3 && str.substring(str.length() - 3).equalsIgnoreCase("_id")) {
            return str.substring(0, str.length() - 3);
        }
        return str;
    }

    public static Boolean isZero(Object num) {
        return Pattern.matches("(0+\\.0*)|(0+)", num.toString());
    }

    public static String parseDateByFormatString(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat simple = new SimpleDateFormat(format);
        return simple.format(date);
    }

    public static Object[] getSelectedPks(IFormView view) {
        Object[] pkArr = null;
        ListSelectedRowCollection selectedRows = ((IListView)view).getSelectedRows();
        if (selectedRows.size() > 0) {
            pkArr = new Object[selectedRows.size()];
            for (int i = 0; i < selectedRows.size(); ++i) {
                ListSelectedRow selectedRow = selectedRows.get(i);
                pkArr[i] = selectedRow.getPrimaryKeyValue();
            }
        } else {
            pkArr = new Object[]{};
        }
        return pkArr;
    }

    public static boolean isF7(IFormView view) {
        ListShowParameter listShowParameter = (ListShowParameter)view.getFormShowParameter();
        return listShowParameter.isLookUp();
    }

    public static void showTabForm(String formId, String formName, Object pkValue, IFormView view) {
        BaseShowParameter parameter = new BaseShowParameter();
        parameter.setPkId(pkValue);
        parameter.setCaption(formName);
        parameter.getOpenStyle().setTargetKey(TABAP);
        parameter.setParentFormId(view.getFormShowParameter().getParentFormId());
        parameter.setStatus(OperationStatus.EDIT);
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        parameter.setFormId(formId);
        view.showForm((FormShowParameter)parameter);
    }

    public static Object getRowPk(Object rowPk) {
        String rowPkv = rowPk.toString();
        return FaUtils.getVouncherId(rowPkv);
    }

    public static Object getRowRealCardNo(int rowIndex, IFormView view) {
        ListSelectedRow selectedRow = ((IListView)view).getCurrentListAllRowCollection().get(rowIndex);
        String rowPk = selectedRow.getPrimaryKeyValue().toString();
        String rowEntryPk = selectedRow.getEntryPrimaryKeyValue().toString();
        return FaUtils.getRealCardId(rowPk, rowEntryPk);
    }

    public static String getVouncherId(String fid) {
        String voucherId = "";
        QFilter filterRe = new QFilter(SOURCEBILLID, "=", (Object)Long.parseLong(fid));
        QFilter[] filterRes = new QFilter[]{filterRe};
        ORM orm = ORM.create();
        DynamicObjectCollection listDO = orm.query(AI_DAPTRACKER, filterRes);
        DynamicObject relation = null;
        if (listDO == null || listDO.size() == 0) {
            return voucherId;
        }
        relation = (DynamicObject)listDO.get(0);
        String voucherid = relation.getString(VOUCHERID);
        return voucherid;
    }

    public static String getRealCardId(String fid, String rowEntryPk) {
        if (StringUtils.isEmpty((CharSequence)fid)) {
            return null;
        }
        ORM.create();
        DynamicObject realcardId = BusinessDataServiceHelper.loadSingle((Object)fid, (String)"fa_clearbill");
        DynamicObjectCollection entrys = (DynamicObjectCollection)realcardId.get("detail_entry");
        String realCardPk = "";
        for (DynamicObject entry : entrys) {
            if (!rowEntryPk.equals(String.valueOf(entry.getPkValue()))) continue;
            DynamicObject realCard = entry.getDynamicObject("realcard");
            realCardPk = String.valueOf(realCard.getPkValue());
            break;
        }
        return realCardPk;
    }

    public static Map<String, String> getVouncherNumber(List<String> fids) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        log.info("\u4e0d\u901a\u8fc7\u4e1a\u52a1\u65b9\u83b7\u53d6\u51ed\u8bc1\u53f7\uff0c\u5df2\u96c6\u6210\u6807\u51c6\u63a7\u4ef6\u5904\u7406");
        return map;
    }

    public static String getDefaultOrgId(List<ComboItem> items) {
        Long currOrgId = RequestContext.get().getOrgId();
        for (int i = 0; i < items.size(); ++i) {
            Long nextId;
            if (null == items.get(i) || items.get(i).getValue().length() == 0 || (nextId = Long.valueOf(Long.parseLong(items.get(i).getValue()))).longValue() != currOrgId.longValue()) continue;
            return currOrgId.toString();
        }
        String defaultStr = items.get(0).getValue();
        return defaultStr;
    }

    public static DynamicObject getPeriodByDate(Date date, long periodType) {
        String selectField = "id,periodtype.id,periodyear,periodnumber,begindate,enddate,isadjustperiod,number,name";
        DynamicObjectCollection period = FaUtils.getPeriodByDate(date, selectField, periodType);
        if (!period.isEmpty()) {
            return (DynamicObject)period.get(0);
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4e1a\u52a1\u65e5\u671f\u201c%s\u201d\u5bf9\u5e94\u7684\u671f\u95f4\u6570\u636e\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaUtils_0", (String)"fi-fa-formplugin", (Object[])new Object[0]), date == null ? " " : date));
    }

    public static DynamicObjectCollection getPeriodByDate(Date date, String selectField, long periodType) {
        QFilter f = new QFilter("beginDate", "<=", (Object)date);
        QFilter g = new QFilter("enddate", ">=", (Object)date);
        QFilter t = new QFilter("periodtype", "=", (Object)periodType);
        return QueryServiceHelper.query((String)"bd_period", (String)selectField, (QFilter[])new QFilter[]{f, g, t}, (String)"number");
    }

    public static DynamicObjectCollection getFincardByOrgAndDepreuse(long org, long depreuse) {
        QFilter orgFil = new QFilter("org", "=", (Object)org);
        QFilter depreuseFil = new QFilter("depreuse", "=", (Object)depreuse);
        QFilter endperiodFil = new QFilter("endperiod", "=", (Object)99999999999L);
        DynamicObjectCollection fincard = QueryServiceHelper.query((String)"fa_card_fin", (String)ID, (QFilter[])new QFilter[]{orgFil, depreuseFil, endperiodFil});
        return fincard;
    }

    public static Map<String, Map<String, BigDecimal>> getExrates(List<Map<String, Object>> valueList) {
        HashMap<String, Map<String, BigDecimal>> exrateMap = new HashMap<String, Map<String, BigDecimal>>(valueList.size());
        HashMap dateMap = new HashMap(2);
        HashMap keyAndValue = new HashMap(2);
        HashMap<String, List> keyAndIndex = new HashMap<String, List>(2);
        valueList.sort(new Comparator<Map<String, Object>>(){

            @Override
            public int compare(Map<String, Object> o1, Map<String, Object> o2) {
                Object date1Obj = o1.get("date");
                Date date1 = FaUtils.getDate(date1Obj);
                Object date2Obj = o2.get("date");
                Date date2 = FaUtils.getDate(date2Obj);
                return FaUtils.compareDate(date1, date2);
            }
        });
        for (int i = 0; i < valueList.size(); ++i) {
            Object dateObj;
            List<Date> dateList;
            Map<String, Object> value = valueList.get(i);
            Object curExchangeTableId = value.get("exctable");
            Object curPurchaseCurrencyId = value.get("orgcur");
            Object curBaseCurrencyId = value.get("cur");
            String key = FaUtils.getStringValue(curExchangeTableId) + "_" + FaUtils.getStringValue(curPurchaseCurrencyId) + "_" + FaUtils.getStringValue(curBaseCurrencyId);
            if (!dateMap.containsKey(key)) {
                dateList = new ArrayList(1);
                dateObj = value.get("date");
                dateList.add(FaUtils.getDate(dateObj));
                dateMap.put(key, dateList);
                HashMap<String, Long> idMap = new HashMap<String, Long>(4);
                idMap.put("exchangeTableId", FaUtils.getLongValue(curExchangeTableId));
                idMap.put("purchaseCurrencyId", FaUtils.getLongValue(curPurchaseCurrencyId));
                idMap.put("baseCurrencyId", FaUtils.getLongValue(curBaseCurrencyId));
                keyAndValue.put(key, idMap);
                ArrayList<Integer> indexList = new ArrayList<Integer>(1);
                indexList.add(i);
                keyAndIndex.put(key, indexList);
                continue;
            }
            dateList = (List)dateMap.get(key);
            dateObj = value.get("date");
            dateList.add(FaUtils.getDate(dateObj));
            dateMap.put(key, dateList);
            List indexList = (List)keyAndIndex.get(key);
            indexList.add(i);
            keyAndIndex.put(key, indexList);
        }
        for (Map.Entry entrySet : dateMap.entrySet()) {
            List values = (List)entrySet.getValue();
            String key = (String)entrySet.getKey();
            if (values.size() > 1) {
                values.sort(new Comparator<Date>(){

                    @Override
                    public int compare(Date date1, Date date2) {
                        return FaUtils.compareDate(date1, date2);
                    }
                });
                Date firstDay = (Date)values.get(0);
                Date lastDay = (Date)values.get(values.size() - 1);
                Map idMap = (Map)keyAndValue.get(key);
                long exchangeTableId = (Long)idMap.get("exchangeTableId");
                long purchaseCurrencyId = (Long)idMap.get("purchaseCurrencyId");
                long baseCurrencyId = (Long)idMap.get("baseCurrencyId");
                QFilter exchangeTableFilter = new QFilter("exctable", "=", (Object)exchangeTableId);
                QFilter purchaseCurrencyFilter = new QFilter("orgcur", "=", (Object)purchaseCurrencyId);
                QFilter baseCurrencyFilter = new QFilter("cur", "=", (Object)baseCurrencyId);
                QFilter firstDayFilter = new QFilter("effectdate", "<=", (Object)firstDay);
                QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
                String orderBy = "effectdate desc";
                String orderByAsc = "effectdate asc";
                int top = 1;
                HashMap<String, BigDecimal> curValue = new HashMap<String, BigDecimal>(2);
                DynamicObjectCollection firstDayExrates = QueryServiceHelper.query((String)"bd_exrate_tree", (String)Fa.comma((String[])new String[]{"orgcur", "excval", "indirectexrate"}), (QFilter[])new QFilter[]{exchangeTableFilter, purchaseCurrencyFilter, baseCurrencyFilter, firstDayFilter, enableFilter}, (String)orderBy, (int)top);
                if (firstDayExrates != null && firstDayExrates.size() > 0) {
                    DynamicObject dynamicObject = (DynamicObject)firstDayExrates.get(0);
                    curValue.put("excval", dynamicObject.getBigDecimal("excval"));
                    curValue.put("indirectexrate", dynamicObject.getBigDecimal("indirectexrate"));
                }
                QFilter lastDayFilter = new QFilter("effectdate", "<=", (Object)lastDay);
                QFilter largethanFirstDayFilter = new QFilter("effectdate", ">", (Object)firstDay);
                DynamicObjectCollection otherDayExrates = QueryServiceHelper.query((String)"bd_exrate_tree", (String)Fa.comma((String[])new String[]{"orgcur", "excval", "indirectexrate", "effectdate"}), (QFilter[])new QFilter[]{exchangeTableFilter, purchaseCurrencyFilter, baseCurrencyFilter, largethanFirstDayFilter, lastDayFilter, enableFilter}, (String)orderByAsc);
                if (otherDayExrates == null) continue;
                if (otherDayExrates.size() == 0) {
                    for (Date value : values) {
                        exrateMap.put(key + "_" + value, curValue);
                    }
                }
                if (otherDayExrates.size() == 1) {
                    Date date;
                    DynamicObject dynamicObject = (DynamicObject)otherDayExrates.get(0);
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext() && FaUtils.compareDate(date = (Date)iterator.next(), dynamicObject.getDate("effectdate")) < 0) {
                        HashMap curnewValue = new HashMap(2);
                        curnewValue.put("excval", curValue.get("excval"));
                        curnewValue.put("indirectexrate", curValue.get("indirectexrate"));
                        exrateMap.put(key + "_" + date, curnewValue);
                        iterator.remove();
                    }
                    HashMap<String, BigDecimal> curnewValue = new HashMap<String, BigDecimal>(2);
                    curnewValue.put("excval", dynamicObject.getBigDecimal("excval"));
                    curnewValue.put("indirectexrate", dynamicObject.getBigDecimal("indirectexrate"));
                    for (Date date2 : values) {
                        exrateMap.put(key + "_" + date2, curnewValue);
                    }
                    continue;
                }
                if (otherDayExrates.size() <= 1) continue;
                otherDayExrates.sort((Comparator)new Comparator<DynamicObject>(){

                    @Override
                    public int compare(DynamicObject o1, DynamicObject o2) {
                        Date date1 = o1.getDate("effectdate");
                        Date date2 = o2.getDate("effectdate");
                        return FaUtils.compareDate(date1, date2);
                    }
                });
                HashMap storeValue = new HashMap(2);
                storeValue.put("excval", curValue.get("excval"));
                storeValue.put("indirectexrate", curValue.get("indirectexrate"));
                HashMap keyMap = new HashMap(valueList.size());
                HashMap valueMap = new HashMap(valueList.size());
                for (int i = 0; i < otherDayExrates.size(); ++i) {
                    Date date = ((DynamicObject)otherDayExrates.get(0)).getDate("effectdate");
                    DynamicObject curDynamicObject = (DynamicObject)otherDayExrates.get(i);
                    DynamicObject nextDynamicObject = null;
                    if (i + 1 < otherDayExrates.size()) {
                        nextDynamicObject = (DynamicObject)otherDayExrates.get(i + 1);
                    }
                    Iterator iterator = values.iterator();
                    while (iterator.hasNext()) {
                        Date nextDate;
                        Date date3 = (Date)iterator.next();
                        Date curDate = curDynamicObject.getDate("effectdate");
                        if (nextDynamicObject != null) {
                            nextDate = nextDynamicObject.getDate("effectdate");
                        } else {
                            nextDate = new Date();
                            Calendar instance = Calendar.getInstance();
                            instance.setTime(nextDate);
                            instance.set(1, 29999);
                            nextDate = instance.getTime();
                        }
                        if (FaUtils.compareDate(date3, curDate) >= 0 && FaUtils.compareDate(date3, nextDate) < 0) {
                            List<String> keyList;
                            String dateKey = curDate + "_" + nextDate;
                            if (!keyMap.containsKey(dateKey)) {
                                keyList = new ArrayList<String>();
                                keyList.add(key + "_" + date3);
                                keyMap.put(dateKey, keyList);
                                HashMap<String, BigDecimal> curnewValue = new HashMap<String, BigDecimal>(2);
                                curnewValue.put("excval", curDynamicObject.getBigDecimal("excval"));
                                curnewValue.put("indirectexrate", curDynamicObject.getBigDecimal("indirectexrate"));
                                valueMap.put(dateKey, curnewValue);
                                iterator.remove();
                                continue;
                            }
                            keyList = (List)keyMap.get(dateKey);
                            keyList.add(key + "_" + date3);
                            iterator.remove();
                            continue;
                        }
                        if (FaUtils.compareDate(date3, firstDay) < 0 || FaUtils.compareDate(date3, date) >= 0) break;
                        HashMap curnewValue = new HashMap(2);
                        curnewValue.put("excval", storeValue.get("excval"));
                        curnewValue.put("indirectexrate", storeValue.get("indirectexrate"));
                        exrateMap.put(key + "_" + date3, curnewValue);
                        iterator.remove();
                    }
                    storeValue.put("excval", curDynamicObject.getBigDecimal("excval"));
                    storeValue.put("indirectexrate", curDynamicObject.getBigDecimal("indirectexrate"));
                    if (values == null || values.size() == 0) break;
                }
                for (Date date : values) {
                    exrateMap.put(key + "_" + date, storeValue);
                }
                for (Map.Entry entry : keyMap.entrySet()) {
                    List keys = (List)entry.getValue();
                    Map exrates = (Map)valueMap.get(entry.getKey());
                    for (String s : keys) {
                        exrateMap.put(s, exrates);
                    }
                }
                continue;
            }
            Date date = (Date)values.get(0);
            Map idMap = (Map)keyAndValue.get(key);
            long exchangeTableId = (Long)idMap.get("exchangeTableId");
            long purchaseCurrencyId = (Long)idMap.get("purchaseCurrencyId");
            long baseCurrencyId = (Long)idMap.get("baseCurrencyId");
            Map<String, Map<String, BigDecimal>> curExrateMap = FaUtils.getExrate(exchangeTableId, purchaseCurrencyId, baseCurrencyId, date);
            exrateMap.putAll(curExrateMap);
        }
        return exrateMap;
    }

    public static Map<String, Map<String, BigDecimal>> getExrate(long exchangeTableId, long sourceCurrencyId, long targetCurrencyId, Date date) {
        HashMap<String, Map<String, BigDecimal>> exrateMap = new HashMap<String, Map<String, BigDecimal>>(2);
        QFilter exchangeTableFilter = new QFilter("exctable", "=", (Object)exchangeTableId);
        QFilter sourceCurrencyFilter = new QFilter("orgcur", "=", (Object)sourceCurrencyId);
        QFilter targetCurrencyFilter = new QFilter("cur", "=", (Object)targetCurrencyId);
        QFilter endDateFilter = new QFilter("effectdate", "<=", (Object)date);
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        String orderBy = "effectdate desc";
        int top = 1;
        DynamicObjectCollection lastDayExrates = QueryServiceHelper.query((String)"bd_exrate_tree", (String)Fa.comma((String[])new String[]{"orgcur", "excval", "indirectexrate"}), (QFilter[])new QFilter[]{exchangeTableFilter, sourceCurrencyFilter, targetCurrencyFilter, endDateFilter, enableFilter}, (String)orderBy, (int)top);
        if (lastDayExrates != null && lastDayExrates.size() == 1) {
            DynamicObject lastDayExrate = (DynamicObject)lastDayExrates.get(0);
            BigDecimal excval = lastDayExrate.getBigDecimal("excval");
            BigDecimal indirectexrate = lastDayExrate.getBigDecimal("indirectexrate");
            HashMap<String, BigDecimal> valueMap = new HashMap<String, BigDecimal>(2);
            valueMap.put("excval", excval);
            valueMap.put("indirectexrate", indirectexrate);
            String key = exchangeTableId + "_" + sourceCurrencyId + "_" + targetCurrencyId + "_" + date;
            exrateMap.put(key, valueMap);
        }
        return exrateMap;
    }

    public static BigDecimal getExrate(long exchangeTableId, long sourceCurrencyId, long targetCurrencyId, Date date, String exchangerateType) {
        String valueName = ExchangeTypeEnum.A.getValue().equals(exchangerateType) ? "excval" : "indirectexrate";
        Map<String, Map<String, BigDecimal>> exrateMap = FaUtils.getExrate(exchangeTableId, sourceCurrencyId, targetCurrencyId, date);
        if (exrateMap == null || exrateMap.size() == 0) {
            return BigDecimal.ZERO;
        }
        String key = exchangeTableId + "_" + sourceCurrencyId + "_" + targetCurrencyId + "_" + date;
        Map<String, BigDecimal> valueMap = exrateMap.get(key);
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (valueMap.get(valueName) != null) {
            exchangeRate = valueMap.get(valueName);
        }
        return exchangeRate;
    }

    public static String getStringValue(Object obj) {
        return obj == null ? null : obj.toString();
    }

    public static long getLongValue(Object obj) {
        return obj == null ? 0L : Long.parseLong(obj.toString());
    }

    public static int compareDate(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String)"FaUtils_1", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        return d1.compareTo(d2);
    }

    public static Date getDate(Object dateObj) {
        if (dateObj == null) {
            return null;
        }
        try {
            Date date = DateUtil.getShortDate().parse(dateObj.toString());
            return date;
        }
        catch (Exception exception) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u9519\u8bef", (String)"FaUtils_2", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
    }

    public static DynamicObject getMainBookByOrg(Long orgId) {
        QFilter mainF = new QFilter("ismainbook", "=", (Object)"1");
        QFilter orgF = new QFilter("org", "=", (Object)orgId);
        DynamicObject mainBook = QueryServiceHelper.queryOne((String)"fa_assetbook", (String)"id,periodtype,basecurrency,curperiod,startperiod,depresystem,status,enable", (QFilter[])new QFilter[]{mainF, orgF});
        return mainBook;
    }

    public static List<Long> getCurRealCard(Date date, Long orgId) {
        return FaUtils.getCurRealCard(date, orgId, Boolean.FALSE);
    }

    public static List<Long> getCurRealCard(Date date, Long orgId, Boolean includeBef) {
        DynamicObject mainBook = FaUtils.getMainBookByOrg(orgId);
        if (mainBook == null) {
            return null;
        }
        long periodType = mainBook.getLong("periodtype");
        DynamicObject period = FaUtils.getPeriodByDate(date, periodType);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        if (!includeBef.booleanValue()) {
            filters.add(new QFilter("bizperiod", "<=", period.get(ID)));
        }
        filters.add(new QFilter("endperiod", ">=", period.get(ID)));
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        DynamicObjectCollection cards = QueryServiceHelper.query((String)"fa_card_fin", (String)"realcard", (QFilter[])filterArr);
        ArrayList<Long> cardList = new ArrayList<Long>();
        for (DynamicObject card : cards) {
            cardList.add(card.getLong("realcard"));
        }
        return cardList;
    }

    @Deprecated
    public static Set<Long> getDecValCard(DynamicObject dataEntity, Long orgId, Boolean includeBef, Set<Long> readCardIds) {
        HashSet<Long> existsIds = new HashSet();
        DynamicObject org = dataEntity.getDynamicObject("org");
        DynamicObject depreuse = dataEntity.getDynamicObject("depreuse");
        Map assetBooks = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"curperiod, depresystem", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)org.getLong(ID)), new QFilter("status", "=", (Object)BillStatus.C.toString()), new QFilter("depreuse", "=", (Object)depreuse.getLong(ID))});
        if (assetBooks == null || assetBooks.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8d44\u4ea7\u8d26\u7c3f\u51fa\u9519\u3002", (String)"FaUtils_3", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject assetBook = (DynamicObject)assetBooks.values().iterator().next();
        DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
        if (currentPeriod == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u8d44\u4ea7\u7ec4\u7ec7\u7684\u542f\u7528\u671f\u95f4\u3002", (String)"FaUtils_4", (String)"fi-fa-formplugin", (Object[])new Object[0]));
        }
        DynamicObject depresystem = assetBook.getDynamicObject("depresystem");
        DynamicObjectCollection assetPolicy = depresystem.getDynamicObjectCollection("assetpolicy_entry");
        existsIds = FaUtils.filterNoDecCards(dataEntity, org, depreuse, (List<DynamicObject>)assetPolicy, readCardIds);
        return existsIds;
    }

    @Deprecated
    private static Set<Long> filterNoDecCards(DynamicObject dataEntity, DynamicObject org, DynamicObject depreuse, List<DynamicObject> assetPolicy, Set<Long> readCardIds) {
        HashSet<Long> realcardids = new HashSet<Long>(10);
        DynamicObject devalueperiod = dataEntity.getDynamicObject("devalueperiod");
        QFilter orgFilter = new QFilter("org", "=", (Object)org.getLong(ID));
        QFilter periodFilter = new QFilter("bizperiod", "<=", devalueperiod.getPkValue());
        QFilter endperiodFilter = new QFilter("endperiod", ">", devalueperiod.getPkValue());
        QFilter finStatus = new QFilter("billstatus", "=", (Object)BillStatus.C.toString());
        QFilter depreuseFilter = new QFilter("depreuse", "=", depreuse.getPkValue());
        QFilter realCardFilter = new QFilter("realcard", "in", readCardIds);
        QFilter[] filters = new QFilter[]{orgFilter, periodFilter, endperiodFilter, finStatus, depreuseFilter, realCardFilter};
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)String.join((CharSequence)",", "realcard", "assetcat.longnumber  longnumber", "number"), (QFilter[])filters);
        HashSet<Long> catId = new HashSet<Long>(assetPolicy.size());
        for (DynamicObject row : assetPolicy) {
            DynamicObject entry = row.getDynamicObject("assetcat");
            catId.add(entry.getLong(ID));
        }
        DynamicObjectCollection catoryColls = QueryServiceHelper.query((String)"fa_assetcategory", (String)"id, longnumber", (QFilter[])new QFilter[]{new QFilter(ID, "in", catId)});
        HashMap<Long, String> catLongNumberMap = new HashMap<Long, String>(catoryColls.size());
        for (DynamicObject cat : catoryColls) {
            catLongNumberMap.put(cat.getLong(ID), cat.getString("longnumber"));
        }
        String DEV1 = "2";
        String DEV2 = "3";
        String DEV4 = "4";
        for (DynamicObject finCard : finCards) {
            int flg = 999;
            boolean isdevalue = false;
            String assetcat = finCard.getString("longnumber");
            if (assetcat == null) continue;
            String catLongNumber = null;
            for (DynamicObject row : assetPolicy) {
                DynamicObject cat = row.getDynamicObject("assetcat");
                catLongNumber = (String)catLongNumberMap.get(cat.getLong(ID));
                int diff = assetcat.length() - catLongNumber.length();
                if (!assetcat.startsWith(catLongNumber) || diff >= flg) continue;
                flg = diff;
                String dec = row.getString("decpolicy");
                boolean bl = isdevalue = "2".equals(dec) || "3".equals(dec) || "4".equals(dec);
                if (flg != 0) continue;
                break;
            }
            if (!isdevalue) continue;
            realcardids.add(finCard.getLong("realcard"));
        }
        return realcardids;
    }

    @Deprecated
    public static Set<Long> getCurRealCard(Date date, Long orgId, Boolean includeBef, Set<Long> readCardIds, BusyTypeDetailEnum busyType) {
        HashSet<Long> existsIds = new HashSet<Long>();
        DynamicObject mainBook = FaUtils.getMainBookByOrg(orgId);
        if (mainBook == null) {
            return existsIds;
        }
        long periodType = mainBook.getLong("periodtype");
        DynamicObject period = FaUtils.getPeriodByDate(date, periodType);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("org", "=", (Object)orgId));
        filters.add(new QFilter("endperiod", ">", period.get(ID)));
        filters.add(new QFilter("realcard", "in", readCardIds));
        filters.add(new QFilter("finaccountdate", "<=", (Object)period.getDate("enddate")));
        QFilter[] filterArr = filters.toArray(new QFilter[0]);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"fa_card_fin", (String)"fa_card_fin", (String)"realcard", (QFilter[])filterArr, null);){
            while (ds.hasNext()) {
                existsIds.add(ds.next().getLong("realcard"));
            }
        }
        Set futureBizRealCards = new FutureBizChecker(null, (Object)orgId, new HashSet<Long>(readCardIds), date, busyType).checkAndReturnRealCard();
        existsIds.removeAll(futureBizRealCards);
        return existsIds;
    }

    @Deprecated
    public static Set<Long> getCurRealCard(Date date, Long orgId, Boolean includeBef, Set<Long> readCardIds) {
        return FaUtils.getCurRealCard(date, orgId, includeBef, readCardIds, BusyTypeDetailEnum.REAL_FIN_CHG);
    }

    public static void showErrorRealCardMsg(int errCount, String msg, DynamicObject card, IFormView view) {
        if (card != null) {
            msg = card.getString(BILLNO);
        }
        String part1 = ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247", (String)"FaUtils_5", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        String part2 = ResManager.loadKDString((String)"\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\u6216\u8005\u662f\u672a\u6765\u671f\u95f4\u5165\u8d26\u7684\u5361\u7247\uff0c\u4e0d\u53ef\u505a\u5f53\u524d\u4e1a\u52a1\u3002", (String)"FaUtils_6", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        String part3 = ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a", (String)"FaUtils_7", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        if (errCount == 1) {
            view.showErrorNotification(part3 + msg + " " + part2);
        } else {
            view.showMessage(part1 + part2, part3 + msg, MessageTypes.Default);
        }
    }

    public static void showErrorNoDevRealCardMsg(int errCount, String msg, DynamicObject card, IFormView view) {
        if (card != null) {
            msg = card.getString(BILLNO);
        }
        String part1 = ResManager.loadKDString((String)"\u4e0b\u5217\u5361\u7247", (String)"FaUtils_5", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        String part2 = ResManager.loadKDString((String)"\u6839\u636e\u8d44\u4ea7\u653f\u7b56\u4e0d\u5141\u8bb8\u51cf\u503c\u3002", (String)"FaUtils_8", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        String part3 = ResManager.loadKDString((String)"\u5361\u7247\u7f16\u7801\uff1a", (String)"FaUtils_7", (String)"fi-fa-formplugin", (Object[])new Object[0]);
        if (errCount == 1) {
            view.showErrorNotification(part3 + msg + " " + part2);
        } else {
            view.showMessage(part1 + part2, part3 + msg, MessageTypes.Default);
        }
    }

    public static List<DynamicObject> getRealCard(List<String> asseNums) {
        ArrayList<DynamicObject> cardList = new ArrayList<DynamicObject>();
        if (asseNums.size() == 0) {
            return cardList;
        }
        QFilter[] filters = FaUtils.getRealCardByAsseNumfilters(asseNums);
        DynamicObject[] realCards = FaBillDaoFactory.getInstance((String)"fa_card_real").query(filters);
        cardList = new ArrayList<DynamicObject>(Arrays.asList(realCards));
        return cardList;
    }

    private static QFilter[] getRealCardByAsseNumfilters(List<String> asseNums) {
        QFilter[] filters = new QFilter[]{new QFilter("number", "in", asseNums), new QFilter("isbak", "=", (Object)Character.valueOf('0')), new QFilter("bizstatus", "=", (Object)BizStatusEnum.READY), new QFilter("billstatus", "=", (Object)BillStatus.C)};
        return filters;
    }

    public static List<DynamicObject> queryFinCards(Set<Object> realCardPKSet) {
        return FaUtils.queryFinCardList(realCardPKSet, null);
    }

    @Deprecated
    public static List<DynamicObject> queryFinCardList(Set<Object> realCardPKSet, Set<String> curstoms) {
        HashSet realCardSet = new HashSet(realCardPKSet.size());
        realCardPKSet.forEach(r -> realCardSet.add(Long.parseLong(String.valueOf(r))));
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "in", realCardSet)};
        String[] fieldArr = new String[]{ID, "realcard", "currency", "number", FaDaoOrmImpl.dot((String[])new String[]{"realcard", "usestatus", "isdepre"}), "originalval", "accumdepre", "decval", "netamount", "preresidualval", "preusingamount", FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "basecurrency"}), FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "curperiod", ID}), "depreuse", "isneeddepre", "bizperiod", "endperiod", "period", "monthdepre", "networth", "addupyeardepre", "depremethod", "assetcat", "isdynamic", "monthorigvalchg", "monthdeprechg", "yearorigvalchg"};
        HashSet<String> fieldSet = new HashSet<String>();
        fieldSet.addAll(Arrays.asList(fieldArr));
        if (curstoms != null) {
            fieldSet.addAll(curstoms);
        }
        String selector = String.join((CharSequence)",", fieldSet);
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])filters, (String)"depreuse asc");
        Set bookIdSet = Stream.of(finCards).map(v -> v.get("assetbook_id")).collect(Collectors.toSet());
        selector = FaDaoOrmImpl.comma((String[])new String[]{ID, "curperiod"});
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selector, (QFilter[])new QFilter(ID, "in", bookIdSet).toArray());
        Map<Object, Long> bookMap = books.stream().collect(Collectors.toMap(v -> v.get(ID), v -> v.getLong("curperiod")));
        List<DynamicObject> finCardLst = Stream.of(finCards).filter(fincard -> FaUtils.filterFinCards((Long)bookMap.get(fincard.get("assetbook_id")), fincard)).collect(Collectors.toList());
        return finCardLst;
    }

    @Deprecated
    public static List<DynamicObject> queryFinCards(Set<Object> realCardPKSet, Long depreuseId) {
        HashSet realCardSet = new HashSet(realCardPKSet.size());
        realCardPKSet.forEach(r -> realCardSet.add(Long.parseLong(String.valueOf(r))));
        QFilter[] filters = new QFilter[]{new QFilter("realcard", "in", realCardSet), new QFilter("depreuse", "=", (Object)depreuseId)};
        String selector = FaDaoOrmImpl.comma((String[])new String[]{ID, "realcard", "currency", FaDaoOrmImpl.dot((String[])new String[]{"realcard", "usestatus", "isdepre"}), "originalval", "accumdepre", "decval", "netamount", "preresidualval", "preusingamount", FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "basecurrency"}), FaDaoOrmImpl.dot((String[])new String[]{"assetbook", "curperiod", ID}), "depreuse", "isneeddepre", "bizperiod", "endperiod", "monthdepre", "period", "networth", "addupyeardepre", "yearorigvalchg", "monthorigvalchg", "monthdeprechg", "depredamount", "depremethod", "assetcat"});
        DynamicObject[] finCards = BusinessDataServiceHelper.load((String)"fa_card_fin", (String)selector, (QFilter[])filters);
        Set bookIdSet = Stream.of(finCards).map(v -> v.get("assetbook_id")).collect(Collectors.toSet());
        selector = FaDaoOrmImpl.comma((String[])new String[]{ID, "curperiod"});
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selector, (QFilter[])new QFilter(ID, "in", bookIdSet).toArray());
        Map<Object, Long> bookMap = books.stream().collect(Collectors.toMap(v -> v.get(ID), v -> v.getLong("curperiod")));
        List<DynamicObject> finCardLst = Stream.of(finCards).filter(fincard -> FaUtils.filterFinCards((Long)bookMap.get(fincard.get("assetbook_id")), fincard)).collect(Collectors.toList());
        return finCardLst;
    }

    public static boolean filterFinCards(long curPeriodId, DynamicObject fincard) {
        boolean isRight;
        DynamicObject bizPeriodDyn = fincard.getDynamicObject("bizperiod");
        long periodId = 0L;
        if (fincard.getDynamicObject("period") != null) {
            periodId = fincard.getDynamicObject("period").getLong(ID);
        }
        long bizPeriodId = 0L;
        if (bizPeriodDyn != null) {
            bizPeriodId = fincard.getDynamicObject("bizperiod").getLong(ID);
        }
        long endPeriodId = 99999999999L;
        DynamicObject endPeriod = fincard.getDynamicObject("endperiod");
        if (endPeriod != null) {
            endPeriodId = endPeriod.getLong(ID);
        }
        boolean bl = isRight = bizPeriodId <= curPeriodId && curPeriodId < endPeriodId;
        if (isRight) {
            if (bizPeriodId < curPeriodId) {
                fincard.set("monthorigvalchg", (Object)BigDecimal.ZERO);
                fincard.set("monthdeprechg", (Object)BigDecimal.ZERO);
            }
            if (periodId != 0L && bizPeriodId / FaBizUtils.YEAR_PERIOD_L < curPeriodId / FaBizUtils.YEAR_PERIOD_L) {
                fincard.set("yearorigvalchg", (Object)BigDecimal.ZERO);
                fincard.set("addupyeardepre", (Object)BigDecimal.ZERO);
            }
        }
        return isRight;
    }

    public static DynamicObject getFinCardByNumberOrgAndDepreuse(String realNumber, long org, long depreuse) {
        QFilter realNumberFil = new QFilter("number", "=", (Object)realNumber);
        QFilter orgFil = new QFilter("org", "=", (Object)org);
        QFilter depreuseFil = new QFilter("depreuse", "=", (Object)depreuse);
        QFilter endPeriodFil = new QFilter("endperiod", "=", (Object)99999999999L);
        QFilter[] filters = new QFilter[]{realNumberFil, orgFil, depreuseFil, endPeriodFil};
        DynamicObject finCard = QueryServiceHelper.queryOne((String)"fa_card_fin", (String)ID, (QFilter[])filters);
        return finCard;
    }

    public static void showDepreAnalyzeButton(final AbstractFormPlugin formPlugin, final String key) {
        AbstractGrid grid = (AbstractGrid)formPlugin.getControl(key);
        grid.addCellClickListener(new CellClickListener(){

            public void cellClick(CellClickEvent p0) {
                IPageCache pageCache = formPlugin.getPageCache();
                if (pageCache.get(key) == null) {
                    pageCache.put(key, System.currentTimeMillis() + ":" + 1);
                } else {
                    String[] arr = pageCache.get(key).split(":");
                    if (Integer.parseInt(arr[1]) >= 5) {
                        if (System.currentTimeMillis() - Long.parseLong(arr[0]) < 3000L) {
                            formPlugin.getView().setVisible(Boolean.valueOf(true), new String[]{"fetchdepreinfo"});
                        }
                        pageCache.remove(key);
                    } else {
                        pageCache.put(key, arr[0] + ":" + (Integer.parseInt(arr[1]) + 1));
                    }
                }
            }

            public void cellDoubleClick(CellClickEvent p0) {
            }
        });
    }

    public static String getRealCardPrint(String teplateKey) {
        String defaultTemplateId = "ROW3+Q90=V6";
        Long userId = ContextUtil.getUserId();
        if (userId == null) {
            return defaultTemplateId;
        }
        String settingData = UserConfigServiceHelper.getSetting((long)userId, (String)teplateKey);
        if (StringUtils.isNotBlank((CharSequence)settingData)) {
            Map jsonData = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
            Object defaultTemplate = jsonData.get("template");
            Object settingId = jsonData.get("templateid");
            if (StringUtils.isBlank(settingId) && StringUtils.isNotBlank(defaultTemplate)) {
                String baseEntity = MetadataDao.getIdByNumber((String)defaultTemplate.toString(), (MetaCategory)MetaCategory.Form);
                settingId = baseEntity;
            }
            if (StringUtils.isNotBlank(settingId)) {
                defaultTemplateId = settingId.toString();
            }
        }
        return defaultTemplateId;
    }
}

