/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DepreSplitAssInfo {
    private Set<String> headAssEntity;
    private String orgDutyName;
    private BigDecimal percent;
    private String msg;
    private int dataIndex = 0;
    private Map<Integer, Boolean> dataIndexMap = new HashMap<Integer, Boolean>(10);
    private List<String> bizNum;
    private List<Long> bizDataId;
    private List<String> schemaAssValueField;

    private void init() {
        if (this.bizNum == null) {
            this.bizNum = new ArrayList<String>(6);
            this.headAssEntity = new HashSet<String>(6);
            this.bizDataId = new ArrayList<Long>(6);
            this.schemaAssValueField = new ArrayList<String>(4);
            this.dataIndex = 0;
            this.dataIndexMap.clear();
        }
    }

    public void addBaseDataInfo(String bizNum, Long bizDataId) {
        this.init();
        this.bizNum.add(bizNum);
        this.bizDataId.add(bizDataId);
        this.headAssEntity.add(bizNum);
        this.dataIndexMap.put(this.dataIndex++, Boolean.TRUE);
    }

    public void addAsstData(String asstGroupId, Long dataId) {
        this.init();
        this.bizNum.add(asstGroupId);
        this.bizDataId.add(dataId);
        this.headAssEntity.add(asstGroupId);
        this.dataIndexMap.put(this.dataIndex++, Boolean.FALSE);
    }

    public void addSchemaBaseDataInfo(String bizNum, Long bizDataId, String fieldKey) {
        this.init();
        this.bizNum.add(bizNum);
        this.bizDataId.add(bizDataId);
        this.schemaAssValueField.add(fieldKey);
        this.dataIndexMap.put(this.dataIndex++, Boolean.TRUE);
    }

    public void assSchemaAsstDataInfo(String asstGroupId, String fieldKey) {
        this.init();
        this.bizNum.add(asstGroupId);
        this.bizDataId.add(0L);
        this.schemaAssValueField.add(fieldKey);
        this.dataIndexMap.put(this.dataIndex++, Boolean.FALSE);
    }

    public int getDataIndex() {
        return this.dataIndex;
    }

    public boolean isBaseDataByIndex(int index) {
        if (index > this.dataIndex) {
            return false;
        }
        return this.dataIndexMap.get(index);
    }

    public Set<String> getHeadAssEntity() {
        return this.headAssEntity;
    }

    public String getOrgDutyName() {
        return this.orgDutyName;
    }

    public void setOrgDutyName(String orgDutyName) {
        this.orgDutyName = orgDutyName;
    }

    public BigDecimal getPercent() {
        return this.percent;
    }

    public void setPercent(BigDecimal percent) {
        this.percent = percent;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public List<String> getBizNum() {
        return this.bizNum;
    }

    public List<Long> getBizDataId() {
        return this.bizDataId;
    }

    public List<String> getSchemaAssValueField() {
        return this.schemaAssValueField;
    }
}

