/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.depretask.DailyDepreImpl;
import kd.fi.fa.business.lease.utils.LeaseUtil;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.PermissonType;
import kd.fi.fa.report.AbstractFaRptFormPlugin;

public class FaAmortisedCostPlugin
extends AbstractFaRptFormPlugin {
    private boolean isPropertyChanged = Boolean.TRUE;
    private static final Log logger = LogFactory.getLog(FaAmortisedCostPlugin.class);
    private static final String DIM_VALUE_CACHE = "fa_rpt_amortisedCost.dim_values";

    public void initialize() {
        super.initialize();
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber("fa_lease_contract");
        this.setVoucherFilterFields(filterGrid);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.getView().setEnable(Boolean.FALSE, 0, new String[]{"overdueage", "bar_year"});
        this.getView().setEnable(Boolean.FALSE, 1, new String[]{"overdueage"});
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        this.processDataAfterQuery(rowData);
        this.fillAgingGroupValues(rowData);
        this.fillPointTimeLeaseId(rowData);
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap", "asstopr1"});
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("q_org");
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            List collect = qFilters.stream().filter(f -> !"id = -1".equals(f.toString())).collect(Collectors.toList());
            param.getListFilterParameter().setQFilters(collect);
        });
        BasedataEdit periodF7 = (BasedataEdit)this.getControl("q_period_select");
        periodF7.addBeforeF7SelectListener(evt -> {
            String selectFields = Fa.comma((String[])new String[]{"id", "curperiod", "periodtype", "periodtype_id", "startperiod", "startperiod_id"});
            DynamicObjectCollection q_org = (DynamicObjectCollection)this.getModel().getValue("q_org");
            if (q_org == null) {
                return;
            }
            ArrayList<Long> orgList = new ArrayList<Long>(q_org.size());
            for (DynamicObject org : q_org) {
                orgList.add(org.getLong("fbasedataid_id"));
            }
            Map bookMap = BusinessDataServiceHelper.loadFromCache((String)"fa_lease_init", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("org", "in", orgList)});
            if (null == bookMap.values()) {
                return;
            }
            DynamicObject[] bookList = bookMap.values().toArray(new DynamicObject[0]);
            this.changePeriodFilter(bookList);
            DynamicObject defaultCurPeriodType = (DynamicObject)this.getModel().getValue("periodtype");
            if (defaultCurPeriodType == null) {
                return;
            }
            Object defaultCurPeriodTypeId = defaultCurPeriodType.get("id");
            Long defaultCurPeriodId = 0L;
            for (DynamicObject leaseInitbook : bookList) {
                if (defaultCurPeriodId != 0L && defaultCurPeriodId.compareTo(leaseInitbook.getLong("startperiod_id")) <= 0) continue;
                defaultCurPeriodId = leaseInitbook.getLong("startperiod_id");
            }
            List filters = ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter().getQFilters();
            filters.add(new QFilter("periodtype", "=", defaultCurPeriodTypeId).and("id", ">=", (Object)defaultCurPeriodId).and("isadjustperiod", "=", (Object)false));
        });
    }

    public void afterCreateNewData(EventObject e) {
        Long curLoginOrg = RequestContext.get().getOrgId();
        String pageId = this.getView().getPageId();
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        List orgIds = permOrgRs.getHasPermOrgs();
        HashSet<Long> ids = new HashSet<Long>();
        BasedataEdit orgBd = (BasedataEdit)this.getControl("q_org");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (orgIds.isEmpty() && !permOrgRs.hasAllOrgPerm()) {
            list.add(new QFilter("id", "in", new ArrayList()));
            orgBd.setQFilters(list);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAmortisedCostPlugin_0", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        if (permOrgRs.hasAllOrgPerm()) {
            DynamicObject[] assetBooks;
            for (DynamicObject assetBook : assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"org,startperiod,curperiod", null)) {
                if (assetBook.getDynamicObject("org") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
        } else {
            for (DynamicObject assetBook : BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,curperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgIds)})) {
                if (assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null || assetBook.getDynamicObject("org") == null) continue;
                ids.add(assetBook.getLong(Fa.id((String)"org")));
            }
        }
        if (ids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7b26\u5408\u6761\u4ef6\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAmortisedCostPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        list.add(new QFilter("id", "in", ids));
        orgBd.setQFilters(list);
        if (!ids.contains(curLoginOrg) && !ids.isEmpty()) {
            curLoginOrg = (Long)new ArrayList(ids).get(0);
        }
        DynamicObject[] leaseInits = BusinessDataServiceHelper.load((String)"fa_lease_init", (String)"id,org,startperiod,curperiod,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)curLoginOrg)});
        this.getModel().setValue("q_org", (Object)new Long[]{curLoginOrg});
        DynamicObjectCollection agingentity = (DynamicObjectCollection)this.getModel().getValue("agingentity");
        agingentity.clear();
        DynamicObjectType agingentityType = agingentity.getDynamicObjectType();
        DynamicObject aginge = new DynamicObject(agingentityType);
        aginge.set("overdueage", (Object)"0 - 1");
        aginge.set("bar_year", (Object)"1");
        agingentity.add(0, aginge);
        DynamicObject aginge1 = new DynamicObject(agingentityType);
        aginge1.set("overdueage", (Object)String.format(ResManager.loadKDString((String)"%s - \u4e0d\u8bbe\u7f6e", (String)"FaAmortisedCostPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]), "1"));
        agingentity.add(1, aginge1);
        if (leaseInits.length == 0) {
            return;
        }
        this.changePeriodFilter(leaseInits);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection agingEntity = this.getModel().getEntryEntity("agingentity");
        ArrayList<String> overDueRangeList = new ArrayList<String>(16);
        for (DynamicObject row : agingEntity) {
            String overdueAge = row.getString("overdueage");
            overDueRangeList.add(overdueAge);
        }
        filterInfo.addFilterItem("OVERDUERANGE", overDueRangeList);
    }

    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        boolean includeTermination = event.getQueryParam().getFilter().getBoolean("q_includetermination");
        List columns = event.getColumns();
        for (AbstractReportColumn col : columns) {
            ReportColumn reportColumn;
            String fieldKey;
            if (!(col instanceof ReportColumn) || !"istermination".equals(fieldKey = (reportColumn = (ReportColumn)col).getFieldKey())) continue;
            reportColumn.setHide(!includeTermination);
            break;
        }
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        IReportView view = this.getView();
        DynamicObjectCollection orgs = filterCondition.getDynamicObjectCollection("q_org");
        IDataModel model = this.getModel();
        int idx = model.getEntryCurrentRowIndex("agingentity");
        DynamicObjectCollection agingentity = this.getModel().getEntryEntity("agingentity");
        DynamicObject agingDy = (DynamicObject)agingentity.get(idx);
        Map customParam = queryParam.getCustomParam();
        String pageId = view.getPageId();
        customParam.put("pageId", pageId);
        if (orgs == null || orgs.size() <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAmortisedCostPlugin_3", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (DynamicObject org : orgs) {
            orgIds.add(org.getLong("id"));
        }
        Map bookMap = BusinessDataServiceHelper.loadFromCache((String)"fa_lease_init", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds)});
        if (bookMap == null || bookMap.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u8d44\u4ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\u79df\u8d41\u521d\u59cb\u5316\uff0c\u8bf7\u68c0\u67e5", (String)"FaAmortisedCostPlugin_4", (String)"fi-fa-report", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        Collection initBooks = bookMap.values();
        HashSet<Long> periodTypeId = new HashSet<Long>(initBooks.size());
        for (DynamicObject initBook : initBooks) {
            DynamicObject periodType = initBook.getDynamicObject("periodtype");
            periodTypeId.add((Long)periodType.getPkValue());
        }
        if (periodTypeId.size() > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\uff0c\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u4e0d\u4e00\u81f4", (String)"FaAmortisedCostPlugin_5", (String)"fi-fa-report", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (filterCondition.getDynamicObject("q_period_select") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u671f\u95f4\u6709\u8bef\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u67e5\u8be2\u671f\u95f4\u3002", (String)"FaAmortisedCostPlugin_6", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (!StringUtils.isNotBlank((CharSequence)agingDy.getString("overdueage"))) {
            view.showTipNotification(ResManager.loadKDString((String)"\u5230\u671f\u79df\u8d41\u8d1f\u503a\u6709\u7a7a\u503c\uff0c\u8bf7\u5220\u9664\u7a7a\u884c\u6216\u586b\u5199\u5bf9\u5e94\u5e74\u6570\u540e\u67e5\u8be2\u3002", (String)"FaAmortisedCostPlugin_7", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        IDataModel model = this.getModel();
        String propName = e.getProperty().getName();
        LinkedList<Object> orgIds = new LinkedList<Object>();
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("q_org");
        for (DynamicObject org : orgs) {
            orgIds.add(org.getDynamicObject("fbasedataid").getPkValue());
        }
        QFilter forg = new QFilter("org", "in", orgIds);
        if (!this.isPropertyChanged) {
            return;
        }
        DynamicObject[] leaseInits = BusinessDataServiceHelper.load((String)"fa_lease_init", (String)"id,org,startperiod,curperiod,periodtype", (QFilter[])new QFilter[]{forg});
        if (propName.equals("bar_year")) {
            ChangeData changeData = e.getChangeSet()[0];
            int yearValue = (Integer)changeData.getNewValue();
            Object oldValue = changeData.getOldValue();
            int rowIndex = changeData.getRowIndex();
            DynamicObjectCollection agingentity = model.getEntryEntity("agingentity");
            int size = agingentity.size();
            if (rowIndex > 0 && rowIndex < size - 1) {
                DynamicObject preDy = (DynamicObject)agingentity.get(rowIndex - 1);
                int preYear = preDy.getInt("bar_year");
                DynamicObject nextDy = (DynamicObject)agingentity.get(rowIndex + 1);
                int nextYear = nextDy.getInt("bar_year");
                if (yearValue >= nextYear || yearValue <= preYear && nextYear != 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u586b\u5165\u5e74\u6570\u5fc5\u987b\u5927\u4e8e\u4e0a\u4e00\u884c\u5e74\u6570\u4e14\u5c0f\u4e8e\u4e0b\u4e00\u884c\u5e74\u6570\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"FaAmortisedCostPlugin_8", (String)"fi-fa-report", (Object[])new Object[0]));
                    this.rollbackValue("bar_year", oldValue, rowIndex);
                    return;
                }
            }
            this.updateAgingDay("bar_year", "overdueage", oldValue, yearValue);
        } else if (propName.equals("q_org")) {
            this.changePeriodFilter(leaseInits);
        } else if (propName.equals("periodtype")) {
            BasedataEdit q_peroid = (BasedataEdit)this.getControl("q_period_select");
            long mixPeriod = 0L;
            long compareMixPeriod = 0L;
            long maxPeriod = 99999999L;
            long compareMaxPeriod = 99999999L;
            if (leaseInits.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b64\u671f\u95f4\u7c7b\u578b\u7684\u79df\u8d41\u521d\u59cb\u5316\u8d26\u7c3f", (String)"FaAmortisedCostPlugin_9", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject leaseInit : leaseInits) {
                DynamicObject startPeriod = leaseInit.getDynamicObject("startperiod");
                if (startPeriod == null) continue;
                long startPeriodId = Long.parseLong(startPeriod.getString("number"));
                DynamicObject currentPeriod = leaseInit.getDynamicObject("curperiod");
                if (currentPeriod == null) continue;
                long currentPeriodId = Long.parseLong(currentPeriod.getString("number"));
                if (compareMixPeriod == 0L || startPeriodId < compareMixPeriod) {
                    mixPeriod = (Long)startPeriod.getPkValue();
                    compareMixPeriod = startPeriodId;
                }
                if (compareMaxPeriod != 99999999L && currentPeriodId >= compareMaxPeriod) continue;
                maxPeriod = (Long)currentPeriod.getPkValue();
                compareMaxPeriod = currentPeriodId;
            }
            List periodIds = FaPeriodUtils.getPeriodIdByRange((long)mixPeriod, (long)maxPeriod);
            q_peroid.setQFilter(new QFilter("id", "in", (Object)periodIds));
            model.setValue("q_period_select", (Object)maxPeriod);
        }
    }

    private void updateAgingDay(String fieldKey, String updateFieldKey, Object oldVal, Object newVal) {
        Integer preRowDay;
        IDataModel model = this.getModel();
        int idx = model.getEntryCurrentRowIndex("agingentity");
        DynamicObjectCollection entity = this.getModel().getEntryEntity("agingentity");
        int rowCount = entity.size();
        if (idx < 0 || idx >= rowCount) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8f93\u5165\u884c\u7684\u8303\u56f4\u8d85\u51fa\u5355\u636e\u4f53\u5927\u5c0f", (String)"FaAmortisedCostPlugin_10", (String)"fi-fa-report", (Object[])new Object[0]));
            this.rollbackValue(fieldKey, oldVal, idx);
            return;
        }
        String tagField = fieldKey.equals("bar_year") ? "" : "-";
        int rangeDay = Integer.parseInt(newVal.toString());
        if (rangeDay < 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5e74\u6570\u4e0d\u80fd\u4e3a\u8d1f\u6570\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e", (String)"FaAmortisedCostPlugin_11", (String)"fi-fa-report", (Object[])new Object[0]));
            this.rollbackValue(fieldKey, oldVal, idx);
            return;
        }
        if (rangeDay == 0) {
            model.setValue(updateFieldKey, (Object)"", idx);
            return;
        }
        if (idx > 0 && (preRowDay = (Integer)this.getModel().getValue(fieldKey, idx - 1)).compareTo(rangeDay) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672c\u884c\u8bbe\u7f6e\u7684\u5e74\u6570\u5e94\u5927\u4e8e\u4e0a\u4e00\u884c\u8bbe\u7f6e\u7684\u5e74\u6570\u3002", (String)"FaAmortisedCostPlugin_12", (String)"fi-fa-report", (Object[])new Object[0]));
            this.rollbackValue(fieldKey, oldVal, idx);
            return;
        }
        int curDays = 0;
        for (int i = 0; i < rowCount; ++i) {
            if (i == idx) {
                model.setValue(updateFieldKey, (Object)String.format(tagField + "%s - " + tagField + "%s", curDays, rangeDay), idx);
                int nextIdx = ++i;
                if (nextIdx >= rowCount) {
                    nextIdx = model.createNewEntryRow("agingentity");
                    String value = tagField + String.format(ResManager.loadKDString((String)"%s - \u4e0d\u8bbe\u7f6e", (String)"FaAmortisedCostPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]), rangeDay);
                    model.setValue(updateFieldKey, (Object)value, nextIdx);
                    this.setAgingEntityEnable();
                    break;
                }
                DynamicObject nextRow = (DynamicObject)entity.get(nextIdx);
                int nextDays = nextRow.getInt(fieldKey);
                if (nextIdx <= rowCount - 2) {
                    model.setValue(updateFieldKey, (Object)String.format(tagField + "%s - " + tagField + "%s", rangeDay, nextDays), nextIdx);
                    break;
                }
                String value = tagField + String.format(ResManager.loadKDString((String)"%s - \u4e0d\u8bbe\u7f6e", (String)"FaAmortisedCostPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]), rangeDay);
                model.setValue(updateFieldKey, (Object)value, nextIdx);
                break;
            }
            DynamicObject row = (DynamicObject)entity.get(i);
            curDays = row.getInt(fieldKey);
        }
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operate = (FormOperate)args.getSource();
        IDataModel model = this.getModel();
        int idx = model.getEntryCurrentRowIndex("agingentity");
        DynamicObjectCollection entryEntity = model.getEntryEntity("agingentity");
        if ("newentry".equals(operate.getOperateKey())) {
            DynamicObject aging = (DynamicObject)entryEntity.get(entryEntity.size() - 1);
            if ("0".equals(aging.getString("bar_year"))) {
                throw new KDBizException(ResManager.loadKDString((String)"\u586b\u5199\u4e0a\u4e00\u884c\u5e74\u6570\u540e\u624d\u53ef\u65b0\u589e\u884c\u6570", (String)"FaAmortisedCostPlugin_13", (String)"fi-fa-report", (Object[])new Object[0]));
            }
        } else if ("deleteentry".equals(operate.getOperateKey()) && 0 == idx) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u80fd\u5220\u9664\u7b2c\u4e00\u884c\u9884\u7f6e\u8d26\u9f84\u6570\u636e", (String)"FaAmortisedCostPlugin_14", (String)"fi-fa-report", (Object[])new Object[0]));
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        int rowIndex = e.getRowIndexs()[0];
        IDataModel model = this.getModel();
        DynamicObjectCollection entryEntity = model.getEntryEntity("agingentity");
        if ("agingentity".equals(e.getEntryProp().getName())) {
            if (rowIndex == entryEntity.size()) {
                return;
            }
            DynamicObject nextRow = (DynamicObject)entryEntity.get(rowIndex);
            String nextYear = nextRow.getString("bar_year");
            DynamicObject preRow = (DynamicObject)entryEntity.get(rowIndex - 1);
            String preYear = preRow.getString("bar_year");
            if (!"0".equals(nextYear)) {
                model.setValue("overdueage", (Object)(preYear + " - " + nextYear), rowIndex);
            } else {
                String value = String.format(ResManager.loadKDString((String)"%s - \u4e0d\u8bbe\u7f6e", (String)"FaAmortisedCostPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]), preYear);
                model.setValue("overdueage", (Object)value, rowIndex);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("tool_qing".equals(itemKey)) {
            IReportView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fa_qing_amortised_cost");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("queryparam", (Object)SerializationUtils.serializeToBase64((Object)this.getQueryParam()));
            ReportList reportList = (ReportList)this.getControl("reportlistap");
            List columns = reportList.getColumns();
            showParameter.setCustomParam("columns", (Object)SerializationUtils.serializeToBase64((Object)columns));
            view.showForm(showParameter);
        } else if ("addnewagbtn".equals(itemKey)) {
            DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("agingentity");
            int size = entryEntity.size();
            this.getView().setEnable(Boolean.FALSE, size - 1, new String[]{"overdueage"});
        }
    }

    private void rollbackValue(String fieldKey, Object oldVal, int idx) {
        this.isPropertyChanged = Boolean.FALSE;
        if (oldVal == null) {
            oldVal = 0;
        }
        this.getModel().setValue(fieldKey, oldVal, idx);
        this.isPropertyChanged = Boolean.TRUE;
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        ArrayList<String> filterFileds = new ArrayList<String>(1);
        filterFileds.add("number");
        filterFileds.add("name");
        filterFileds.add("leaser.name");
        filterFileds.add("assetcat.number");
        filterFileds.add("assetname");
        filterFileds.add("storeplace.name");
        filterFileds.add("contrsigndate");
        filterFileds.add("leasestartdate");
        filterFileds.add("leasestartdate");
        filterFileds.add("freeleasestartdate");
        filterFileds.add("payperiod");
        filterFileds.add("paymethod");
        filterFileds.add("invoicetype");
        filterFileds.add("initconfirmdate");
        filterFileds.add("depremonths");
        filterGrid.setFilterFieldKeys(filterFileds);
    }

    private void setAgingEntityEnable() {
        int rowCount = this.getModel().getEntryRowCount("agingentity");
        for (int i = 0; i < rowCount; ++i) {
            this.getView().setEnable(Boolean.FALSE, i, new String[]{"overdueage"});
        }
    }

    private void fillAgingGroupValues(DynamicObjectCollection rowData) {
        IAppCache appCache = AppCache.get((String)"fa");
        String pageId = this.getView().getPageId();
        String dimValueStr = (String)appCache.get(pageId + DIM_VALUE_CACHE, String.class);
        HashMap rangeValues = new HashMap(16);
        if (null != dimValueStr) {
            rangeValues = (HashMap)SerializationUtils.deSerializeFromBase64((String)dimValueStr);
        }
        if (rangeValues == null || rangeValues.isEmpty() || rowData.isEmpty()) {
            return;
        }
        for (DynamicObject row : rowData) {
            DynamicObject leaseContract = row.getDynamicObject("leasecontract");
            String masterId = leaseContract.getString("masterid");
            BigDecimal endleaseliab = row.getBigDecimal("endleaseliab");
            Boolean isDisplay = Boolean.TRUE;
            if (endleaseliab.compareTo(BigDecimal.ZERO) == 0) {
                isDisplay = Boolean.FALSE;
            }
            for (Map.Entry entryMap : rangeValues.entrySet()) {
                BigDecimal leaseLiab = (BigDecimal)entryMap.getValue();
                String rangeId = ((String)entryMap.getKey()).split("_split_")[0];
                String rangePeriod = ((String)entryMap.getKey()).split("_split_")[1];
                if (!masterId.equals(rangeId)) continue;
                row.set(rangePeriod, (Object)leaseLiab);
                if (isDisplay.booleanValue()) continue;
                row.set(rangePeriod, (Object)BigDecimal.ZERO);
            }
        }
    }

    private void processDataAfterQuery(DynamicObjectCollection rowData) {
        if (rowData.isEmpty()) {
            return;
        }
        DynamicObject queryPeriod = (DynamicObject)this.getModel().getValue("q_period_select");
        queryPeriod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"begindate,enddate,periodtype,periodnumber,periodyear", (QFilter[])new QFilter("id", "=", (Object)queryPeriod.getLong("id")).toArray());
        Date queryDate = queryPeriod.getDate("begindate");
        DynamicObjectCollection filterOrg = (DynamicObjectCollection)this.getModel().getValue("q_org");
        List<Long> orgIds = filterOrg.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList());
        Map<String, Object> data = this.getFormCalData(orgIds, queryPeriod, new ArrayList<Object>((Collection<Object>)rowData), Boolean.FALSE);
        for (DynamicObject row : rowData) {
            DynamicObject leaseContract = row.getDynamicObject("leasecontract");
            long masterId = leaseContract.getLong("masterid");
            DataEntityPropertyCollection properties = row.getDataEntityType().getProperties();
            for (IDataEntityProperty prop : properties) {
                String propName = prop.getName();
                Object value = data.get(masterId + "_split_" + propName);
                if (value == null) continue;
                row.set(propName, value);
            }
        }
    }

    public Map<String, Object> getFormCalData(List<Long> orgIds, DynamicObject queryDate, List<Object> rowData, Boolean fromQing) {
        HashMap<String, Object> result = new HashMap<String, Object>(rowData.size());
        Long queryDatePeriodId = queryDate.getLong("id");
        int periodYear = queryDate.getInt("periodyear");
        HashSet<Long> masterIds = new HashSet<Long>(rowData.size());
        for (Object row : rowData) {
            long masterId = this.getContractLongField(row, "masterid", fromQing);
            masterIds.add(masterId);
        }
        Map terminaPeriodMap = LeaseUtil.calTerminationAmortizationPeriodId(masterIds);
        Map<Long, Date> terminationDateMap = this.queryTerminationDate(masterIds);
        HashSet<Long> contractId4LeaseLiab = new HashSet<Long>(rowData.size());
        HashSet<Long> contractIdLeaseLiab = new HashSet<Long>(rowData.size());
        HashSet<Long> contractId4UseRight = new HashSet<Long>(rowData.size());
        HashSet<Long> contractIdUseRight = new HashSet<Long>(rowData.size());
        for (Object row : rowData) {
            long masterId = this.getContractLongField(row, "masterid", fromQing);
            Date terminationDate = terminationDateMap.get(masterId);
            if (terminationDate == null) continue;
            long contractId = this.getContractLongField(row, "id", fromQing);
            long shareId = this.getContractLongField(row, "settlesharesrcid", fromQing);
            long id4LeaseLiab = shareId == 0L ? contractId : shareId;
            Long terminaPeriodId = (Long)terminaPeriodMap.get(masterId);
            if (null == terminaPeriodId) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5408\u540cid:[%s]\u6709\u79df\u8d41\u7ec8\u6b62\u65e5\u4f46\u662f\u65e0\u5bf9\u5e94\u6e05\u7406\u5355\uff0c\u8bf7\u68c0\u67e5", (String)"FaAmortisedCostPlugin_15", (String)"fi-fa-report", (Object[])new Object[0]), masterId));
            }
            if (queryDatePeriodId.compareTo(terminaPeriodId) > 0) {
                result.put(masterId + "_split_" + "istermination", Boolean.TRUE);
                contractId4LeaseLiab.add(id4LeaseLiab);
                contractId4UseRight.add(masterId);
                continue;
            }
            if (queryDatePeriodId.compareTo(terminaPeriodId) != 0) continue;
            result.put(masterId + "_split_" + "istermination", Boolean.TRUE);
            contractIdLeaseLiab.add(id4LeaseLiab);
            contractIdUseRight.add(masterId);
        }
        this.processTerminaLeaseLiabData(rowData, contractId4LeaseLiab, fromQing, result, queryDate, terminationDateMap, contractIdLeaseLiab);
        Map<Long, BigDecimal> lastPeriodEndBalanceMap4Term = this.processLastEndBalance(masterIds, contractId4LeaseLiab, queryDatePeriodId);
        this.updateLeaseLiabBeginBalance(rowData, fromQing, result, lastPeriodEndBalanceMap4Term);
        this.updateLeaseAmountChg(rowData, fromQing, result);
        this.processUseRightData(orgIds, periodYear, rowData, contractId4UseRight, terminationDateMap, fromQing, result);
        this.processTerminaUseRightData(rowData, contractIdUseRight, fromQing, result);
        return result;
    }

    private void updateLeaseAmountChg(List<Object> rowData, Boolean fromQing, Map<String, Object> result) {
        for (Object row : rowData) {
            long masterId = this.getContractLongField(row, "masterid", fromQing);
            BigDecimal endBalance = this.getRowBigDecimalField(row, "endleaseliab", fromQing, masterId, result);
            BigDecimal monthRent = this.getRowBigDecimalField(row, "rent", fromQing, masterId, result);
            BigDecimal monthInterest = this.getRowBigDecimalField(row, "interest", fromQing, masterId, result);
            BigDecimal beginBalance = (BigDecimal)result.get(masterId + "_split_" + "startleaseliab");
            BigDecimal chgAmount = endBalance.add(monthRent).subtract(monthInterest).subtract(beginBalance);
            result.put(masterId + "_split_" + "leaseamountchg", chgAmount);
        }
    }

    private Map<Long, BigDecimal> processLastEndBalance(Set<Long> allContractMasterIds, Set<Long> historyPeriodTermContractIds, Long queryDatePeriodId) {
        HashSet needQueryContractIds = new HashSet(allContractMasterIds.size() - historyPeriodTermContractIds.size());
        allContractMasterIds.stream().forEach(t -> {
            if (!historyPeriodTermContractIds.contains(t)) {
                needQueryContractIds.add(t);
            }
        });
        HashMap<Long, BigDecimal> lastPeriodEndBalanceMap = new HashMap<Long, BigDecimal>(needQueryContractIds.size());
        if (CollectionUtils.isEmpty(needQueryContractIds)) {
            return lastPeriodEndBalanceMap;
        }
        DynamicObject lastPeriodObj = FaBizUtils.queryNeighborPeriod((Object)queryDatePeriodId, (int)-1);
        if (lastPeriodObj != null) {
            Long lastPeriodId = lastPeriodObj.getLong("id");
            SqlBuilder querySql = new SqlBuilder();
            querySql.append("select fleasecontractid leasecontract, sum(case when famortizationperiodid = ? then fendleaseliab else 0 end) endleaseliab  from t_fa_lease_rent_settle where ", new Object[]{lastPeriodId});
            querySql.appendIn(" fleasecontractid ", (Object[])needQueryContractIds.toArray(new Long[0]));
            querySql.append(" group by fleasecontractid", new Object[0]);
            try (DataSet dataSet = DB.queryDataSet((String)"FaAmortisedCostPlugin_processLastEndBalance", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)querySql);){
                for (Row row : dataSet) {
                    Long contractId = row.getLong("leasecontract");
                    BigDecimal endBalance = row.getBigDecimal("endleaseliab");
                    lastPeriodEndBalanceMap.put(contractId, endBalance);
                }
            }
        }
        return lastPeriodEndBalanceMap;
    }

    private Map<Long, Date> queryTerminationDate(Set<Long> masterIds) {
        QFilter filter = new QFilter("id", "in", masterIds);
        String selectFields = Fa.comma((String[])new String[]{"id", "leaseterminationdate"});
        DynamicObjectCollection contracts = QueryServiceHelper.query((String)"fa_lease_contract", (String)selectFields, (QFilter[])filter.toArray());
        HashMap<Long, Date> terminationDateMap = new HashMap<Long, Date>(contracts.size());
        for (DynamicObject row : contracts) {
            long id = row.getLong("id");
            Date terminationDate = row.getDate("leaseterminationdate");
            terminationDateMap.put(id, terminationDate);
        }
        return terminationDateMap;
    }

    private void updateIsTermination(Date lastDate, Map<Long, Date> terminationDateMap, Map<String, Object> result) {
        for (Map.Entry<Long, Date> entry : terminationDateMap.entrySet()) {
            Date terminationDate = entry.getValue();
            if (terminationDate == null || DateUtil.compareDate((Date)terminationDate, (Date)lastDate) > 0) continue;
            result.put(entry.getKey() + "_split_" + "istermination", Boolean.TRUE);
        }
    }

    private Map<String, Object> collectionDataFromInterestDetail(DynamicObject interestDetail, Date terminationDate, boolean isCurYearTermination, boolean isCurMonthTermination, Date firstDateOfYear, Date firstDateOfMonth) {
        BigDecimal monthRent = BigDecimal.ZERO;
        BigDecimal monthInterest = BigDecimal.ZERO;
        BigDecimal addUpYearRent = BigDecimal.ZERO;
        BigDecimal addUpYearInterest = BigDecimal.ZERO;
        BigDecimal accumRent = BigDecimal.ZERO;
        BigDecimal accumInterest = BigDecimal.ZERO;
        int interestDays = 0;
        DynamicObjectCollection entry = interestDetail.getDynamicObjectCollection("detailentry");
        for (DynamicObject detail : entry) {
            Date date = detail.getDate("date");
            String soruceType = detail.getString("sourcetype");
            if ("B".equals(soruceType)) continue;
            BigDecimal rent = detail.getBigDecimal("leaseliabpay");
            BigDecimal interest = detail.getBigDecimal("leaseliabint");
            if (DateUtil.compareDate((Date)date, (Date)terminationDate) > 0) continue;
            accumRent = accumRent.add(rent);
            accumInterest = accumInterest.add(interest);
            if (isCurYearTermination && DateUtil.compareDate((Date)date, (Date)firstDateOfYear) >= 0) {
                addUpYearRent = addUpYearRent.add(rent);
                addUpYearInterest = addUpYearInterest.add(interest);
            }
            if (!isCurMonthTermination || DateUtil.compareDate((Date)date, (Date)firstDateOfMonth) < 0) continue;
            monthRent = monthRent.add(rent);
            monthInterest = monthInterest.add(interest);
            ++interestDays;
        }
        HashMap<String, Object> data = new HashMap<String, Object>(16);
        data.put("rent", monthRent);
        data.put("interest", monthInterest);
        data.put("rptaddupyearrent", addUpYearRent);
        data.put("rptaddupyearinterest", addUpYearInterest);
        data.put("rptaccumrent", accumRent);
        data.put("rptaccuminterest", accumInterest);
        data.put("finterestdays", interestDays);
        return data;
    }

    private void updateLeaseLiabBeginBalance(List<Object> rowData, Boolean fromQing, Map<String, Object> result, Map<Long, BigDecimal> lastPeriodEndBalanceMap4Term) {
        for (Object row : rowData) {
            long masterId = this.getContractLongField(row, "masterid", fromQing);
            BigDecimal lastPeriodEndBalance = lastPeriodEndBalanceMap4Term.get(masterId);
            BigDecimal beginBalance = lastPeriodEndBalance != null ? lastPeriodEndBalance : BigDecimal.ZERO;
            result.put(masterId + "_split_" + "startleaseliab", beginBalance);
        }
    }

    private void processUseRightData(List<Long> orgIds, Integer queryYear, List<Object> rowData, Set<Long> contractId4UseRight, Map<Long, Date> terminationDateMap, Boolean fromQing, Map<String, Object> result) {
        Map<Long, DynamicObject> mainBookMap = this.getMainBook(orgIds);
        DynamicObjectCollection realCards = this.queryRealCardByContractId(contractId4UseRight);
        Map<String, Boolean> finCardMap = this.queryFinCardIsNeedDepre(realCards, mainBookMap);
        HashMap<Long, String> contractCardMap = new HashMap<Long, String>(contractId4UseRight.size());
        for (DynamicObject card : realCards) {
            long srcBillId = card.getLong("srcbillid");
            String string = card.getString("number");
            contractCardMap.put(srcBillId, string);
        }
        HashMap<String, Set<String>> depredCardMap = new HashMap<String, Set<String>>(contractId4UseRight.size());
        HashMap<String, Set<String>> predictCardMap = new HashMap<String, Set<String>>(contractId4UseRight.size());
        HashSet<Long> contractMasterIdList = new HashSet<Long>(rowData.size());
        for (Object object : rowData) {
            long masterId = this.getContractLongField(object, "masterid", fromQing);
            contractMasterIdList.add(masterId);
        }
        Map leaseTerminaPeriodMap = LeaseUtil.calTerminationAmortizationPeriodId(contractMasterIdList);
        for (Object row : rowData) {
            String number;
            long masterId = this.getContractLongField(row, "masterid", fromQing);
            if (!contractId4UseRight.contains(masterId) || (number = (String)contractCardMap.get(masterId)) == null) continue;
            long orgId = this.getOrgId(row, fromQing);
            DynamicObject mainBook = mainBookMap.get(orgId);
            long depreUseId = mainBook.getLong("depreuse");
            Date terminationDate = terminationDateMap.get(masterId);
            long periodTypeId = mainBook.getLong("periodtype");
            long terminationPeriodId = (Long)leaseTerminaPeriodMap.get(masterId);
            Boolean isNeedDepre = finCardMap.get(number);
            String key = orgId + "-" + depreUseId + "-" + terminationPeriodId;
            Set numberSet = isNeedDepre != false ? predictCardMap.computeIfAbsent(key, v -> new HashSet()) : depredCardMap.computeIfAbsent(key, v -> new HashSet());
            numberSet.add(number);
        }
        Map<String, Map<String, Object>> map = this.getCardDepreData(depredCardMap, predictCardMap);
        for (Object row : rowData) {
            long masterId = this.getContractLongField(row, "masterid", fromQing);
            if (!contractId4UseRight.contains(masterId)) continue;
            Date terminationDate = terminationDateMap.get(masterId);
            int terminationYear = DateUtil.getDateField((Date)terminationDate, (int)1);
            boolean isQueryYearTermination = terminationYear == queryYear;
            String number = (String)contractCardMap.get(masterId);
            Map<String, Object> depreData = map.get(number);
            if (depreData == null) continue;
            BigDecimal netAmount = (BigDecimal)depreData.get("netamount");
            BigDecimal monthDepre = BigDecimal.ZERO;
            result.put(masterId + "_split_" + "startnetamount", BigDecimal.ZERO);
            result.put(masterId + "_split_" + "monthdepre", monthDepre);
            result.put(masterId + "_split_" + "addupyeardepre", !isQueryYearTermination ? BigDecimal.ZERO : depreData.get("addupyeardepre"));
            result.put(masterId + "_split_" + "accumdepre", depreData.get("accumdepre"));
            result.put(masterId + "_split_" + "endnetamount", BigDecimal.ZERO);
        }
    }

    private long getContractLongField(Object row, String field, Boolean fromQing) {
        if (fromQing.booleanValue()) {
            if ("id".equals(field)) {
                field = "leasecontract";
            }
            return ((Row)row).getLong(field);
        }
        DynamicObject leaseContract = ((DynamicObject)row).getDynamicObject("leasecontract");
        return leaseContract.getLong(field);
    }

    private BigDecimal getContractBigDecimalField(Object row, String field, Boolean fromQing) {
        if (fromQing.booleanValue()) {
            return ((Row)row).getBigDecimal(field);
        }
        DynamicObject leaseContract = ((DynamicObject)row).getDynamicObject("leasecontract");
        return leaseContract.getBigDecimal(field);
    }

    private BigDecimal getRowBigDecimalField(Object row, String field, Boolean fromQing, long masterId, Map<String, Object> result) {
        BigDecimal value;
        if (result.containsKey(masterId + "_split_" + field)) {
            value = (BigDecimal)result.get(masterId + "_split_" + field);
            value = value == null ? BigDecimal.ZERO : value;
        } else if (fromQing.booleanValue()) {
            value = ((Row)row).getBigDecimal(field);
            if (value == null || BigDecimal.ZERO.compareTo(value) == 0) {
                value = (BigDecimal)result.get(masterId + "_split_" + field);
                value = value == null ? BigDecimal.ZERO : value;
            }
        } else {
            value = ((DynamicObject)row).getBigDecimal(field);
        }
        return value;
    }

    private Date getSysSwitchDate(Object row, Boolean fromQing) {
        if (fromQing.booleanValue()) {
            return ((Row)row).getDate("sysswitchdate");
        }
        DynamicObject leaseContract = ((DynamicObject)row).getDynamicObject("leasecontract");
        return leaseContract.getDate("sysswitchdate");
    }

    private long getOrgId(Object row, Boolean fromQing) {
        if (fromQing.booleanValue()) {
            return ((Row)row).getLong("org");
        }
        DynamicObject leaseContract = ((DynamicObject)row).getDynamicObject("leasecontract");
        return leaseContract.getLong(Fa.id((String)"org"));
    }

    private Map<Long, DynamicObject> getMainBook(List<Long> orgIds) {
        String selectFields = Fa.comma((String[])new String[]{"org", "depreuse", "periodtype"});
        QFilter[] filters = new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("ismainbook", "=", (Object)true)};
        DynamicObjectCollection books = QueryServiceHelper.query((String)"fa_assetbook", (String)selectFields, (QFilter[])filters);
        return books.stream().collect(Collectors.toMap(v -> v.getLong("org"), v -> v, (v1, v2) -> v2));
    }

    private DynamicObjectCollection queryRealCardByContractId(Set<Long> contractIds) {
        QFilter[] filters = new QFilter[]{new QFilter("isbak", "=", (Object)Character.valueOf('0')), new QFilter("srcbillid", "in", contractIds)};
        String selectCardFields = Fa.comma((String[])new String[]{"id", "number", "srcbillid"});
        return QueryServiceHelper.query((String)"fa_card_real", (String)selectCardFields, (QFilter[])filters);
    }

    private Map<String, Boolean> queryFinCardIsNeedDepre(DynamicObjectCollection realCards, Map<Long, DynamicObject> mainBook) {
        List realCardIds = realCards.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        Set depreUseIds = mainBook.values().stream().map(v -> v.getLong("depreuse")).collect(Collectors.toSet());
        QFilter[] finCardFilter = new QFilter[]{new QFilter("realcardmasterid", "in", realCardIds), new QFilter("endperiod", "=", (Object)99999999999L), new QFilter("depreuse", "in", depreUseIds)};
        String selectFields = Fa.comma((String[])new String[]{"number", "isneeddepre"});
        DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])finCardFilter);
        HashMap<String, Boolean> result = new HashMap<String, Boolean>(realCardIds.size());
        for (DynamicObject finCard : finCards) {
            String number = finCard.getString("number");
            boolean isNeedDepre = finCard.getBoolean("isneeddepre");
            result.put(number, isNeedDepre);
        }
        return result;
    }

    private Map<String, Map<String, Object>> getCardDepreData(Map<String, Set<String>> depredCardMap, Map<String, Set<String>> predictCardMap) {
        HashMap<String, Map<String, Object>> depreDataMap = new HashMap<String, Map<String, Object>>(depredCardMap.size());
        if (depredCardMap.size() == 0 && predictCardMap.size() == 0) {
            return depreDataMap;
        }
        for (Map.Entry<String, Set<String>> entry : depredCardMap.entrySet()) {
            String[] splitKey = entry.getKey().split("-");
            long orgId = Long.parseLong(splitKey[0]);
            long depreUseId = Long.parseLong(splitKey[1]);
            long periodId = Long.parseLong(splitKey[2]);
            Map hisDepredData = FaDepreUtil.depreHisCardHandle((Long)orgId, (Long)depreUseId, (Long)periodId, entry.getValue());
            for (Map depreData : hisDepredData.values()) {
                String number = (String)depreData.get("number");
                depreDataMap.put(number, depreData);
            }
        }
        DailyDepreImpl dailyDepreImpl = new DailyDepreImpl(Boolean.FALSE, "fa_amortised_cost_report");
        for (Map.Entry<String, Set<String>> entry : predictCardMap.entrySet()) {
            String[] splitKey = entry.getKey().split("-");
            long orgId = Long.parseLong(splitKey[0]);
            long depreUseId = Long.parseLong(splitKey[1]);
            long periodId = Long.parseLong(splitKey[2]);
            DynamicObject period = BusinessDataServiceHelper.loadSingleFromCache((Object)periodId, (String)"bd_period");
            Map predictResult = dailyDepreImpl.predictPeriodDepe((Object)orgId, Long.valueOf(depreUseId), period, false, true, entry.getValue());
            for (Map predictEntry : predictResult.values()) {
                if (predictEntry == null || predictEntry.size() == 0) continue;
                for (Map predictData : predictEntry.values()) {
                    String number = (String)predictData.get("number");
                    depreDataMap.put(number, predictData);
                }
            }
        }
        return depreDataMap;
    }

    private void changePeriodFilter(DynamicObject[] leaseInitBooks) {
        IDataModel model = this.getModel();
        if (leaseInitBooks == null || leaseInitBooks.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u79df\u8d41\u521d\u59cb\u5316\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FaAmortisedCostPlugin_16", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        BasedataEdit q_peroid = (BasedataEdit)this.getControl("q_period_select");
        BasedataEdit q_peroidType = (BasedataEdit)this.getControl("periodtype");
        long mixPeriod = 0L;
        long compareMixPeriod = 0L;
        long mixCureentPeriod = 0L;
        long comparecureentMixPeriod = 0L;
        HashSet<Long> periodTypes = new HashSet<Long>(leaseInitBooks.length);
        DynamicObject periodType = leaseInitBooks[0].getDynamicObject("periodtype");
        long periodTypeIdTemp = (Long)periodType.getPkValue();
        periodTypes.add(periodTypeIdTemp);
        for (DynamicObject leaseInitBook : leaseInitBooks) {
            DynamicObject startPeriod;
            DynamicObject assetPeriodType = leaseInitBook.getDynamicObject("periodtype");
            periodTypes.add(assetPeriodType.getLong("id"));
            if (periodTypeIdTemp != assetPeriodType.getLong("id") || (startPeriod = leaseInitBook.getDynamicObject("startperiod")) == null) continue;
            long startPeriodId = Long.parseLong(startPeriod.getString("number"));
            DynamicObject currentPeriod = leaseInitBook.getDynamicObject("curperiod");
            long currentPeriodId = Long.parseLong(currentPeriod.getString("number"));
            if (currentPeriod == null) continue;
            if (compareMixPeriod == 0L || startPeriodId < compareMixPeriod) {
                mixPeriod = (Long)startPeriod.getPkValue();
                compareMixPeriod = startPeriodId;
            }
            if (mixCureentPeriod != 0L && currentPeriodId >= comparecureentMixPeriod) continue;
            comparecureentMixPeriod = mixCureentPeriod = ((Long)currentPeriod.getPkValue()).longValue();
        }
        q_peroid.setQFilter(new QFilter("id", ">=", (Object)mixPeriod));
        model.setValue("q_period_select", (Object)mixCureentPeriod);
        q_peroidType.setQFilter(new QFilter("id", "in", periodTypes));
        model.setValue("periodtype", periodTypes.toArray()[0]);
        this.getView().setVisible(Boolean.FALSE, new String[]{"periodtype"});
    }

    private void processTerminaLeaseLiabData(List<Object> rowData, Set<Long> contractId4LeaseLiab, Boolean fromQing, Map<String, Object> result, DynamicObject queryDate, Map<Long, Date> terminationDateMap, Set<Long> contractIdLeaseLiab) {
        List oldTerminalLeaseDataSet = LeaseUtil.queryOldTerminaBillparam();
        HashSet<Long> processTerminaLeaseSet = new HashSet<Long>(contractId4LeaseLiab.size() + contractIdLeaseLiab.size());
        processTerminaLeaseSet.addAll(contractId4LeaseLiab);
        processTerminaLeaseSet.addAll(contractIdLeaseLiab);
        HashSet<Long> queryOldterminalLeaseIdSet = new HashSet<Long>(processTerminaLeaseSet.size());
        queryOldterminalLeaseIdSet.addAll(processTerminaLeaseSet);
        queryOldterminalLeaseIdSet.retainAll(oldTerminalLeaseDataSet);
        this.queryTerminaDataFromInterDetail(queryOldterminalLeaseIdSet, queryDate, rowData, fromQing, result, terminationDateMap, contractIdLeaseLiab);
        contractId4LeaseLiab.removeAll(queryOldterminalLeaseIdSet);
        this.queryTerminaDataFromRentSettle(rowData, fromQing, contractId4LeaseLiab, result, contractIdLeaseLiab);
    }

    private void processTerminaLeaseData(List<Object> rowData, Set<Long> contractId4LeaseLiab, Boolean fromQing, Map<String, Object> result) {
        for (Object row : rowData) {
            long masterId = this.getContractLongField(row, "masterid", fromQing);
            if (!contractId4LeaseLiab.contains(masterId)) continue;
            result.put(masterId + "_split_" + "endleaseliab", BigDecimal.ZERO);
        }
    }

    private void processTerminaUseRightData(List<Object> rowData, Set<Long> contractId4LeaseLiab, Boolean fromQing, Map<String, Object> result) {
        for (Object row : rowData) {
            long masterId = this.getContractLongField(row, "masterid", fromQing);
            if (!contractId4LeaseLiab.contains(masterId)) continue;
            result.put(masterId + "_split_" + "endnetamount", BigDecimal.ZERO);
        }
    }

    private void fillPointTimeLeaseId(DynamicObjectCollection rowData) {
        Long masterid;
        String algoKey = "kd.fi.fa.report.formplugin.FaAmortisedCostPlugin";
        DBRoute faRoute = DBRoute.of((String)"fa");
        if (rowData.isEmpty()) {
            return;
        }
        ArrayList<Long> contractId = new ArrayList<Long>(16);
        for (DynamicObject row : rowData) {
            long leaseContractId = row.getLong("leasecontract.masterid");
            contractId.add(leaseContractId);
        }
        DynamicObject queryPeriod = (DynamicObject)this.getModel().getValue("q_period_select");
        DynamicObjectCollection queryOrgs = (DynamicObjectCollection)this.getModel().getValue("q_org");
        ArrayList<Long> orgIdList = new ArrayList<Long>(1);
        for (DynamicObject org : queryOrgs) {
            orgIdList.add(org.getLong("fbasedataid_id"));
        }
        queryPeriod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"begindate,enddate,periodtype,periodnumber,periodyear", (QFilter[])new QFilter("id", "=", (Object)queryPeriod.getLong("id")).toArray());
        Date endDate = queryPeriod.getDate("enddate");
        SqlBuilder queryTerminationPeriodSql = new SqlBuilder();
        queryTerminationPeriodSql.append("select max(C.feffectivedate) as maxeffectivedate,T.fmasterid ", new Object[0]);
        queryTerminationPeriodSql.append(" from t_fa_lease_change_bill C ", new Object[0]);
        queryTerminationPeriodSql.append(" left join t_fa_lease_contract_new T ", new Object[0]);
        queryTerminationPeriodSql.append(" on T.fid = C.fleasecontractid ", new Object[0]);
        queryTerminationPeriodSql.append(" where C.fbillstatus = 'C'", new Object[0]);
        queryTerminationPeriodSql.append(" and C.famortizationdate <= ?", new Object[]{endDate});
        queryTerminationPeriodSql.appendIn(" and C.forgid", orgIdList.toArray());
        queryTerminationPeriodSql.append(" group by T.fmasterid;", new Object[0]);
        DataSet amortizationPeriodDataSet = DB.queryDataSet((String)algoKey, (DBRoute)faRoute, (SqlBuilder)queryTerminationPeriodSql);
        HashMap<Long, Date> amortizationMap = new HashMap<Long, Date>(16);
        for (Row row : amortizationPeriodDataSet) {
            Long contractMsterId = row.getLong("fmasterid");
            Date maxeffectiveDate = row.getDate("maxeffectivedate");
            amortizationMap.put(contractMsterId, maxeffectiveDate);
        }
        logger.info("masterId\u5bf9\u5e94\u7684\u6700\u5927\u644a\u9500\u65e5\u671famortizationMap:" + ((Object)amortizationMap).toString());
        SqlBuilder queryLeaseContractSql = new SqlBuilder();
        queryLeaseContractSql.append(" select T.fid,T.fmasterid,T.fversion,C.faftcontractid,C.fleasecontractid,C.feffectivedate,C.famortizationdate from t_fa_lease_contract_new T left join t_fa_lease_change_bill C", new Object[0]);
        queryLeaseContractSql.append(" on T.fid = C.fleasecontractid ", new Object[0]);
        queryLeaseContractSql.appendIn("where T.fmasterid", contractId.toArray());
        DataSet leaseContractDs = DB.queryDataSet((String)algoKey, (DBRoute)faRoute, (SqlBuilder)queryLeaseContractSql);
        HashMap<Long, Long> originLeaseMap = new HashMap<Long, Long>(16);
        HashMap<Long, Date> leaseMinDateMap = new HashMap<Long, Date>(16);
        for (Object row : leaseContractDs.copy()) {
            String version = row.getString("fversion");
            Long leaseId = row.getLong("fid");
            masterid = row.getLong("fmasterid");
            Date amortizationdate = row.getDate("famortizationdate");
            Date minDate = (Date)leaseMinDateMap.get(masterid);
            if (null != amortizationdate && null == minDate) {
                leaseMinDateMap.put(masterid, amortizationdate);
            }
            if (null != amortizationdate && DateUtil.compareDate((Date)amortizationdate, (Date)((Date)leaseMinDateMap.get(masterid))) < 0) {
                leaseMinDateMap.put(masterid, amortizationdate);
            }
            if (!"0".equals(version)) continue;
            originLeaseMap.put(masterid, leaseId);
        }
        logger.info("\u539f\u59cb\u5408\u540cmasterid\u5bf9\u5e94fid\u7684map originLeaseMap:" + ((Object)originLeaseMap).toString());
        HashMap<Long, Long> leaseIdMap = new HashMap<Long, Long>(16);
        for (Row row : leaseContractDs) {
            Long aftcontractid = row.getLong("faftcontractid");
            masterid = row.getLong("fmasterid");
            Date effectivedate = row.getDate("feffectivedate");
            Date amortizationdate = row.getDate("famortizationdate");
            Date maxEffectivedate = (Date)amortizationMap.get(masterid);
            if (null != maxEffectivedate && null != effectivedate && DateUtil.compareDate((Date)maxEffectivedate, (Date)effectivedate) == 0) {
                leaseIdMap.put(masterid, aftcontractid);
            }
            Date minAmortizationDate = (Date)leaseMinDateMap.get(masterid);
            if (null == amortizationdate || DateUtil.compareDate((Date)endDate, (Date)minAmortizationDate) >= 0) continue;
            Long originLeaseId = (Long)originLeaseMap.get(masterid);
            leaseIdMap.put(masterid, originLeaseId);
        }
        logger.info("\u6700\u540e\u8d4b\u503c\u7684\u884cmasterid\u5bf9\u5e94id\u7684map originLeaseMap:" + ((Object)leaseIdMap).toString());
        Collection values = leaseIdMap.values();
        MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)"fa_lease_contract");
        DynamicObject[] ids = BusinessDataServiceHelper.load((Object[])values.toArray(), (DynamicObjectType)dataEntityType);
        HashMap<Long, DynamicObject> leaseDyMap = new HashMap<Long, DynamicObject>(16);
        for (DynamicObject leaseDy : ids) {
            long masterid2 = leaseDy.getLong("masterid");
            leaseDyMap.put(masterid2, leaseDy);
        }
        for (DynamicObject row : rowData) {
            DynamicObject leaseContract = row.getDynamicObject("leasecontract");
            long masterid3 = leaseContract.getLong("masterid");
            DynamicObject versionLease = (DynamicObject)leaseDyMap.get(masterid3);
            if (null == versionLease) continue;
            row.set("leasecontract_id", (Object)versionLease.getLong("id"));
            row.set("leasecontract", (Object)versionLease);
        }
    }

    private void queryTerminaDataFromRentSettle(List<Object> rowData, Boolean fromQing, Set<Long> contractId4LeaseLiab, Map<String, Object> result, Set<Long> contractIdLeaseLiab) {
        for (Object row : rowData) {
            long masterId = this.getContractLongField(row, "masterid", fromQing);
            if (contractId4LeaseLiab.contains(masterId) || contractIdLeaseLiab.contains(masterId)) {
                result.put(masterId + "_split_" + "endleaseliab", BigDecimal.ZERO);
            }
            if (!contractId4LeaseLiab.contains(masterId)) continue;
            result.put(masterId + "_split_" + "rent", BigDecimal.ZERO);
            result.put(masterId + "_split_" + "interest", BigDecimal.ZERO);
            result.put(masterId + "_split_" + "finterestdays", BigDecimal.ZERO);
        }
    }

    private void queryTerminaDataFromInterDetail(Set<Long> queryOldterminalLeaseIdSet, DynamicObject queryDate, List<Object> rowData, Boolean fromQing, Map<String, Object> result, Map<Long, Date> terminationDateMap, Set<Long> contractIdLeaseLiab) {
        QFilter filter = new QFilter("leasecontract", "in", queryOldterminalLeaseIdSet);
        Map interestDetails = BusinessDataServiceHelper.loadFromCache((String)"fa_interest_detail", (QFilter[])filter.toArray());
        Map<Object, DynamicObject> interestDetailMap = interestDetails.values().stream().collect(Collectors.toMap(v -> v.getLong(Fa.id((String)"leasecontract")), v -> v));
        int periodYear = queryDate.getInt("periodyear");
        Date firstDateOfMonth = queryDate.getDate("begindate");
        Date lastDateOfMonth = queryDate.getDate("enddate");
        Date firstDateOfYear = DateUtil.getMinDateOfYear((Date)firstDateOfMonth);
        for (Object row : rowData) {
            boolean isCurMonthTermination;
            long contractId = this.getContractLongField(row, "id", fromQing);
            long shareId = this.getContractLongField(row, "settlesharesrcid", fromQing);
            long id4LeaseLiab = shareId == 0L ? contractId : shareId;
            if (!queryOldterminalLeaseIdSet.contains(id4LeaseLiab)) continue;
            long masterId = this.getContractLongField(row, "masterid", fromQing);
            Date terminationDate = terminationDateMap.get(masterId);
            int terminationYear = DateUtil.getDateField((Date)terminationDate, (int)1);
            boolean isCurYearTermination = terminationYear == periodYear;
            boolean bl = isCurMonthTermination = DateUtil.compareDate((Date)terminationDate, (Date)firstDateOfMonth) >= 0 && DateUtil.compareDate((Date)terminationDate, (Date)lastDateOfMonth) <= 0;
            DynamicObject interestDetail = interestDetailMap.get(contractId);
            if (interestDetail == null) continue;
            Date sysSwitchDate = this.getSysSwitchDate(row, fromQing);
            boolean isCurYearInit = sysSwitchDate != null && DateUtil.getDateField((Date)sysSwitchDate, (int)1) == periodYear;
            Map<String, Object> data = this.collectionDataFromInterestDetail(interestDetail, terminationDate, isCurYearTermination, isCurMonthTermination, firstDateOfYear, firstDateOfMonth);
            BigDecimal addUpYearRent = (BigDecimal)data.get("rptaddupyearrent");
            BigDecimal addUpYearInterest = (BigDecimal)data.get("rptaddupyearinterest");
            BigDecimal accumRent = (BigDecimal)data.get("rptaccumrent");
            BigDecimal accumInterest = (BigDecimal)data.get("rptaccuminterest");
            if (isCurYearInit) {
                BigDecimal initAddUpYearRent = this.getContractBigDecimalField(row, "addupyearrent", fromQing);
                addUpYearRent = addUpYearRent.add(initAddUpYearRent);
                BigDecimal initAddUpYearInterest = this.getContractBigDecimalField(row, "addupyearinterest", fromQing);
                addUpYearInterest = addUpYearInterest.add(initAddUpYearInterest);
            }
            if (sysSwitchDate != null) {
                BigDecimal initAccumRent = this.getContractBigDecimalField(row, "accumrent", fromQing);
                accumRent = accumRent.add(initAccumRent);
                BigDecimal initAccumInterest = this.getContractBigDecimalField(row, "accuminterest", fromQing);
                accumInterest = accumInterest.add(initAccumInterest);
            }
            result.put(masterId + "_split_" + "rptaddupyearrent", addUpYearRent);
            result.put(masterId + "_split_" + "rptaddupyearinterest", addUpYearInterest);
            result.put(masterId + "_split_" + "rptaccumrent", accumRent);
            result.put(masterId + "_split_" + "rptaccuminterest", accumInterest);
            result.put(masterId + "_split_" + "interest", data.get("interest"));
            result.put(masterId + "_split_" + "rent", data.get("rent"));
            result.put(masterId + "_split_" + "finterestdays", data.get("finterestdays"));
            result.put(masterId + "_split_" + "endleaseliab", BigDecimal.ZERO);
            if (contractIdLeaseLiab.contains(id4LeaseLiab)) continue;
            result.put(masterId + "_split_" + "rent", BigDecimal.ZERO);
            result.put(masterId + "_split_" + "interest", BigDecimal.ZERO);
            result.put(masterId + "_split_" + "finterestdays", BigDecimal.ZERO);
        }
    }
}

