/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.orm.query.QFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.report.util.FaReportUtils;

public class FaAssetSubsiDiaryTreeFormRptPlugin
extends AbstractReportFormPlugin {
    private boolean isTreeReport() {
        String name = this.getModel().getDataEntityType().getName();
        if ("fa_rpt_card_tree".equals(name)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void initialize() {
        super.initialize();
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber("fa_card_fin");
        this.setVoucherFilterFields(filterGrid);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener(evt -> this.beforeDeptSelect(evt));
    }

    private void beforeDeptSelect(BeforeFilterF7SelectEvent evt) {
        List filters = evt.getQfilters();
        IDataModel model = this.getModel();
        DynamicObjectCollection org = (DynamicObjectCollection)model.getValue("q_org");
        if (evt.getFieldName().equals("realcard.headusedept.name")) {
            QFilter headUseDeptQFilter = PermissionServiceHelper.getDataRuleForBdProp((long)ContextUtil.getUserId(), (String)"fa", (String)"fa_card_real", (String)"headusedept");
            if (headUseDeptQFilter != null) {
                filters.add(headUseDeptQFilter);
            }
        } else if (evt.getFieldName().equals("assetcat.name")) {
            List<Long> orgIds = org.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList());
            filters.add(FaReportUtils.getAssetCateFilter(orgIds));
        } else if ("realcard.assetname".equals(evt.getFieldName())) {
            List orgIds = org.stream().map(v -> v.getLong("fbasedataid_id")).collect(Collectors.toList());
            filters.add(new QFilter("org", "in", orgIds));
        }
    }

    private void setVoucherFilterFields(FilterGrid filterGrid) {
        HashSet<String> filterFiledSet = new HashSet<String>();
        filterFiledSet.add("assetcat.applytype");
        if (this.isTreeReport()) {
            filterFiledSet.add("assetcat.name");
            filterFiledSet.add("realcard.headusedept.name");
            filterFiledSet.add("realcard.sourceflag");
            filterFiledSet.add("realcard.usestatus.name");
        } else {
            filterFiledSet.add("assetcat.name");
            filterFiledSet.add("number");
            filterFiledSet.add("realcard.assetname");
            filterFiledSet.add("realcard.originmethod.name");
            filterFiledSet.add("realcard.supplier.name");
            filterFiledSet.add("realcard.storeplace.name");
            filterFiledSet.add("realcard.usestatus.name");
            filterFiledSet.add("realcard.headusedept.name");
            filterFiledSet.add("realcard.headuseperson.name");
            filterFiledSet.add("depremethod.name");
            filterFiledSet.add("realcard.sourceflag");
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String keyLike = "filtergridap";
        Set<String> mapValueSet = this.getMapValueSetByLikeKey(customParams, keyLike);
        if (mapValueSet.size() > 0) {
            for (String value : mapValueSet) {
                Arrays.stream(value.split(",")).forEach(v -> filterFiledSet.add(v.trim()));
            }
        }
        filterGrid.setFilterFieldKeys(new ArrayList(filterFiledSet));
    }

    private Set<String> getMapValueSetByLikeKey(Map<String, Object> map, String keyLike) {
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Object> entity : map.entrySet()) {
            if (!entity.getKey().contains(keyLike)) continue;
            set.add((String)entity.getValue());
        }
        return set;
    }
}

