/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.TreeReportListEvent;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.PermissonType;
import kd.fi.fa.report.AbstractFaRptFormPlugin;

public class FaAssetTreeListPlugin
extends AbstractFaRptFormPlugin
implements HyperLinkClickListener {
    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        IReportView view = this.getView();
        DynamicObjectCollection orgs = filterCondition.getDynamicObjectCollection("q_org");
        if (orgs == null || orgs.size() <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAssetTreeListPlugin_0", (String)"fi-fa-report", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (filterCondition.getDynamicObject("depreuse") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"FaAssetTreeListPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        if (filterCondition.getDynamicObject("q_period") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"FaAssetTreeListPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("q_org");
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            List collect = qFilters.stream().filter(f -> !"id = -1".equals(f.toString())).collect(Collectors.toList());
            param.getListFilterParameter().setQFilters(collect);
        });
    }

    private DynamicObject getMainAssetBook(DynamicObject[] assetBooks) {
        for (DynamicObject assetBook : assetBooks) {
            if (!assetBook.getBoolean("ismainbook")) continue;
            return assetBook;
        }
        return null;
    }

    private boolean isErrorOrgLevel(List<Object> orgIds) {
        Object oneOrgId = orgIds.get(0);
        List allSuperiorOrgList = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)((Long)oneOrgId));
        int level = allSuperiorOrgList.size();
        for (Object orgId : orgIds) {
            List allSuperiorOrgs = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"10", (long)((Long)orgId));
            if (level == allSuperiorOrgs.size()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        DynamicObjectCollection orgs = (DynamicObjectCollection)model.getValue("q_org");
        if (orgs == null || orgs.size() <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaAssetTreeListPlugin_3", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        LinkedList<Object> orgIds = new LinkedList<Object>();
        for (DynamicObject org : orgs) {
            orgIds.add(org.getDynamicObject("fbasedataid").getPkValue());
        }
        if (this.isErrorOrgLevel(orgIds)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FaAssetTreeListPlugin_4", (String)"fi-fa-report", (Object[])new Object[0]));
            ChangeData changeData = e.getChangeSet()[0];
            if (Objects.nonNull(changeData)) {
                MulBasedataDynamicObjectCollection oldValue = (MulBasedataDynamicObjectCollection)changeData.getOldValue();
                Long[] longs = (Long[])oldValue.stream().map(dynamicObject -> dynamicObject.getLong(2)).toArray(Long[]::new);
                model.setValue("q_org", (Object)longs);
            }
            return;
        }
        List orgIdLongList = orgIds.stream().map(o -> (Long)o).collect(Collectors.toList());
        List allSubordinateOrgs = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"10", orgIdLongList, (boolean)Boolean.TRUE);
        ArrayList orgIdList = new ArrayList(allSubordinateOrgs);
        QFilter forg = new QFilter("org", "in", orgIdList);
        if (propName.equals("q_org")) {
            DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype,ismainbook", (QFilter[])new QFilter[]{forg});
            DynamicObject mainAssetbook = this.getMainAssetBook(assetBooks);
            if (mainAssetbook != null) {
                this.getModel().setValue("depreuse", (Object)mainAssetbook.getDynamicObject("depreuse"));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6240\u9009\u6838\u7b97\u7ec4\u7ec7\u6ca1\u6709\u4e3b\u8d26\u7c3f\u3002", (String)"FaAssetTreeListPlugin_5", (String)"fi-fa-report", (Object[])new Object[0]));
            }
            this.changeFilterPanel(assetBooks, true);
        } else if (propName.equals("depreuse")) {
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            if (depreuse == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaAssetTreeListPlugin_6", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            QFilter fdepreuse = new QFilter("depreuse", "=", depreuse.getPkValue());
            DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype,ismainbook", (QFilter[])new QFilter[]{forg, fdepreuse});
            this.changeFilterPanel(assetBooks, false);
        } else if (propName.equals("periodtype")) {
            QFilter fperiodType;
            BasedataEdit q_peroid = (BasedataEdit)this.getControl("q_period");
            long mixPeriod = 0L;
            long compareMixPeriod = 0L;
            long maxPeriod = 99999999L;
            long compareMaxPeriod = 99999999L;
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            DynamicObject periodType = (DynamicObject)model.getValue("periodtype");
            QFilter fdepreuse = new QFilter("depreuse", "=", depreuse.getPkValue());
            DynamicObject[] assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{forg, fdepreuse, fperiodType = new QFilter("periodtype", "=", periodType.getPkValue())});
            if (assetBooks.length == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6b64\u671f\u95f4\u7c7b\u578b\u7684\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaAssetTreeListPlugin_7", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            for (DynamicObject assetBook : assetBooks) {
                DynamicObject startPeriod = assetBook.getDynamicObject("startperiod");
                if (startPeriod == null) continue;
                long startPeriodId = Long.parseLong(startPeriod.getString("number"));
                DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
                if (currentPeriod == null) continue;
                long currentPeriodId = Long.parseLong(currentPeriod.getString("number"));
                if (compareMixPeriod == 0L || startPeriodId < compareMixPeriod) {
                    mixPeriod = (Long)startPeriod.getPkValue();
                    compareMixPeriod = startPeriodId;
                }
                if (compareMaxPeriod != 99999999L && currentPeriodId >= compareMaxPeriod) continue;
                maxPeriod = (Long)currentPeriod.getPkValue();
                compareMaxPeriod = currentPeriodId;
            }
            List periodIds = FaPeriodUtils.getPeriodIdByRange((long)mixPeriod, (long)maxPeriod);
            q_peroid.setQFilter(new QFilter("id", "in", (Object)periodIds));
            model.setValue("q_period", (Object)maxPeriod);
        }
    }

    public void afterCreateNewData(EventObject e) {
        Map assetBooksMap;
        Long orgId = RequestContext.get().getOrgId();
        String pageId = this.getView().getPageId();
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        List orgIds = permOrgRs.getHasPermOrgs();
        HashSet<Long> assetBookOrgSet = new HashSet<Long>();
        BasedataEdit orgBd = (BasedataEdit)this.getControl("q_org");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        boolean isShowDepre = false;
        if (orgIds.isEmpty() && !permOrgRs.hasAllOrgPerm()) {
            list.add(new QFilter("id", "in", new ArrayList()));
            orgBd.setQFilters(list);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAssetTreeListPlugin_8", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        if (permOrgRs.hasAllOrgPerm()) {
            assetBooksMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"org,startperiod,curperiod", null);
            for (DynamicObject assetBook : assetBooksMap.values()) {
                if (assetBook.getDynamicObject("org") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                assetBookOrgSet.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
            if (assetBookOrgSet.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6298\u65e7\u7528\u9014\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAssetTreeListPlugin_9", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
        } else {
            assetBooksMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgIds)});
            for (DynamicObject assetBook : assetBooksMap.values()) {
                if (assetBook.getDynamicObject("depreuse") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                assetBookOrgSet.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
            list.add(new QFilter("id", "in", (Object)orgIds));
            orgBd.setQFilters(list);
        }
        if (assetBookOrgSet.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6298\u65e7\u7528\u9014\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaAssetTreeListPlugin_9", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        if (!assetBookOrgSet.contains(orgId)) {
            orgId = (Long)new ArrayList(assetBookOrgSet).get(0);
        }
        this.getModel().setValue("q_org", (Object)new Long[]{orgId});
        Map assetBookMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod,periodtype", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgId)});
        DynamicObject[] assetBook = assetBookMap.values().toArray(new DynamicObject[0]);
        if (assetBook.length > 1) {
            isShowDepre = true;
        }
        this.getModel().setValue("depreuse", assetBook[0].getDynamicObject("depreuse").getPkValue());
        this.getView().setVisible(Boolean.valueOf(isShowDepre), new String[]{"depreuse"});
        this.changeFilterPanel(assetBook, true);
    }

    private void changeFilterPanel(DynamicObject[] assetbooks, boolean isHideDepre) {
        boolean bl;
        IDataModel model = this.getModel();
        if (assetbooks == null || assetbooks.length <= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FaAssetTreeListPlugin_10", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        BasedataEdit q_peroid = (BasedataEdit)this.getControl("q_period");
        BasedataEdit q_Depre = (BasedataEdit)this.getControl("depreuse");
        BasedataEdit q_peroidType = (BasedataEdit)this.getControl("periodtype");
        long mixPeriod = 0L;
        long compareMixPeriod = 0L;
        long maxPeriod = 99999999L;
        long compareMaxPeriod = 99999999L;
        DynamicObject compareMaxAssetBook = null;
        HashMap<String, DynamicObject> regDepreuseMap = new HashMap<String, DynamicObject>();
        HashSet<Long> depres = new HashSet<Long>(6);
        HashSet<Long> orgIds = new HashSet<Long>(20);
        HashSet<Long> periodTypes = new HashSet<Long>(assetbooks.length + 1);
        DynamicObject periodType = assetbooks[0].getDynamicObject("periodtype");
        long periodTypeIdTemp = (Long)periodType.getPkValue();
        periodTypes.add(periodTypeIdTemp);
        for (DynamicObject assetBook : assetbooks) {
            String key;
            DynamicObject tempAssetBook;
            DynamicObject dynamicObject;
            DynamicObject org = assetBook.getDynamicObject("org");
            orgIds.add(org.getLong("id"));
            DynamicObject assetPeriodType = assetBook.getDynamicObject("periodtype");
            periodTypes.add(assetPeriodType.getLong("id"));
            depres.add((Long)assetBook.getDynamicObject("depreuse").getPkValue());
            if (periodTypeIdTemp != assetPeriodType.getLong("id") || (dynamicObject = assetBook.getDynamicObject("startperiod")) == null) continue;
            long startPeriodId = Long.parseLong(dynamicObject.getString("number"));
            DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
            if (currentPeriod == null) continue;
            long currentPeriodId = Long.parseLong(currentPeriod.getString("number"));
            if (compareMixPeriod == 0L || startPeriodId < compareMixPeriod) {
                mixPeriod = (Long)dynamicObject.getPkValue();
                compareMixPeriod = startPeriodId;
            }
            if ((tempAssetBook = (DynamicObject)regDepreuseMap.get(key = assetBook.getDynamicObject("depreuse").getString("number"))) == null) {
                regDepreuseMap.put(key, assetBook);
                continue;
            }
            DynamicObject tempMaxPeriod = tempAssetBook.getDynamicObject("curperiod");
            long tempMaxPeriodId = Long.parseLong(tempMaxPeriod.getString("number"));
            if (currentPeriodId <= tempMaxPeriodId) continue;
            regDepreuseMap.put(key, assetBook);
        }
        DynamicObject q_DepreNum = (DynamicObject)this.getModel().getValue("depreuse");
        Boolean flag = Boolean.TRUE;
        if (q_DepreNum != null) {
            compareMaxAssetBook = (DynamicObject)regDepreuseMap.get(q_DepreNum.getString("number"));
            if (null != compareMaxAssetBook) {
                DynamicObject maxPeriodObj = compareMaxAssetBook.getDynamicObject("curperiod");
                maxPeriod = (Long)maxPeriodObj.getPkValue();
            } else {
                flag = Boolean.FALSE;
            }
        }
        if (!flag.booleanValue() || null == q_DepreNum) {
            DynamicObject maxPeriodObj;
            DynamicObject ismainAssetBook = null;
            String firstDepreuseNumber = null;
            DynamicObject firstDepreuseAssetBook = null;
            for (Map.Entry entry : regDepreuseMap.entrySet()) {
                String key = (String)entry.getKey();
                DynamicObject valueObj = (DynamicObject)entry.getValue();
                boolean ismainbook = valueObj.getBoolean("ismainbook");
                if (ismainbook) {
                    ismainAssetBook = valueObj;
                    break;
                }
                if (firstDepreuseNumber == null) {
                    firstDepreuseNumber = key;
                    firstDepreuseAssetBook = valueObj;
                    continue;
                }
                if (Long.getLong(firstDepreuseNumber) <= Long.getLong(key)) continue;
                firstDepreuseNumber = key;
                firstDepreuseAssetBook = valueObj;
            }
            if (ismainAssetBook != null) {
                compareMaxAssetBook = ismainAssetBook;
                maxPeriodObj = compareMaxAssetBook.getDynamicObject("curperiod");
                maxPeriod = (Long)maxPeriodObj.getPkValue();
            } else if (firstDepreuseAssetBook != null) {
                compareMaxAssetBook = firstDepreuseAssetBook;
                maxPeriodObj = firstDepreuseAssetBook.getDynamicObject("curperiod");
                maxPeriod = (Long)maxPeriodObj.getPkValue();
            }
        }
        if (compareMaxAssetBook == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u67e5\u8be2\u6761\u4ef6\u671f\u95f4\u7684\u9ed8\u8ba4\u503c\u3002", (String)"FaAssetTreeListPlugin_11", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        List periodIds = FaPeriodUtils.getPeriodIdByRange((long)mixPeriod, (long)maxPeriod);
        if (isHideDepre) {
            q_Depre.setQFilter(new QFilter("id", "in", depres));
        }
        q_peroid.setQFilter(new QFilter("id", "in", (Object)periodIds));
        Object qPeriodValue = model.getValue("q_period");
        if (Objects.isNull(qPeriodValue)) {
            model.setValue("q_period", (Object)maxPeriod);
        }
        q_peroidType.setQFilter(new QFilter("id", "in", periodTypes));
        DynamicObject depreUse = compareMaxAssetBook.getDynamicObject("depreuse");
        model.setValue("depreuse", depreUse.getPkValue());
        model.setValue("periodtype", periodTypes.toArray()[0]);
        boolean visible1 = true;
        if (depres.size() == 1 && orgIds.size() <= 0 && isHideDepre) {
            visible1 = false;
        }
        this.getView().setVisible(Boolean.valueOf(visible1), new String[]{"depreuse"});
        boolean bl2 = true;
        if (periodTypes.size() == 1) {
            bl = false;
        }
        this.getView().setVisible(Boolean.valueOf(bl), new String[]{"periodtype"});
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        FilterItemInfo listUnAduitFilterItem;
        FilterItemInfo listClearCardFilterItem;
        FilterItemInfo periodTypeFilterItem;
        FilterItemInfo qPeriodFilterItem;
        int selectedRowIndex = event.getRowIndex();
        ReportList reportList = (ReportList)event.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject selectedRowData = reportModel.getRowData(selectedRowIndex);
        ReportShowParameter showParameter = new ReportShowParameter();
        showParameter.setFormId("fa_rpt_card");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        String orgId = selectedRowData.getDynamicObject("assetbook").get("id").toString();
        ReportQueryParam reportQueryParam = new ReportQueryParam();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.addFilterItem("q_org", (Object)Long.parseLong(orgId));
        FilterInfo filter = this.getQueryParam().getFilter();
        FilterItemInfo depreUseFilterItem = filter.getFilterItem("depreuse");
        if (Objects.nonNull(depreUseFilterItem)) {
            long depreUseId = ((DynamicObject)depreUseFilterItem.getValue()).getLong("id");
            filterInfo.addFilterItem("depreuse", (Object)depreUseId);
        }
        if (Objects.nonNull(qPeriodFilterItem = filter.getFilterItem("q_period"))) {
            long periodId = ((DynamicObject)qPeriodFilterItem.getValue()).getLong("id");
            filterInfo.addFilterItem("q_period", (Object)periodId);
        }
        if (Objects.nonNull(periodTypeFilterItem = filter.getFilterItem("periodtype"))) {
            long periodTypeId = ((DynamicObject)periodTypeFilterItem.getValue()).getLong("id");
            filterInfo.addFilterItem("periodtype", (Object)periodTypeId);
        }
        if (Objects.nonNull(listClearCardFilterItem = filter.getFilterItem("list_clearcard"))) {
            Object value = listClearCardFilterItem.getValue();
            filterInfo.addFilterItem("list_clearcard", value);
        }
        if (Objects.nonNull(listUnAduitFilterItem = filter.getFilterItem("list_unaduit"))) {
            Object value = listUnAduitFilterItem.getValue();
            filterInfo.addFilterItem("list_unaduit", value);
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterCondition filterCondition = filterGrid.getFilterGridState().getFilterCondition();
        reportQueryParam.getCustomParam().put("assetTreeReportCommFilterCondition", SerializationUtils.toJsonString((Object)filterCondition));
        reportQueryParam.setFilter(filterInfo);
        showParameter.setQueryParam(reportQueryParam);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void packageData(PackageDataEvent evt) {
        super.packageData(evt);
        Object formatValue = evt.getFormatValue();
        ReportColumn reportColumn = (ReportColumn)evt.getSource();
        String fieldKey = reportColumn.getFieldKey();
        if (Objects.isNull(formatValue) || !"isgroupnode".equals(fieldKey)) {
            return;
        }
        if (formatValue.equals("1")) {
            evt.getNoLinkKey().add("assetbook");
        }
    }

    public void setTreeReportList(TreeReportListEvent event) {
        super.setTreeReportList(event);
        event.setTreeReportList(Boolean.TRUE.booleanValue());
        event.setTreeExpandColId("assetbook");
    }
}

