/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.PermissonType;
import kd.fi.fa.report.AbstractFaRptFormPlugin;

public class FaDepreciationAssignPlugin
extends AbstractFaRptFormPlugin {
    private static final Log logger = LogFactory.getLog(FaDepreciationAssignPlugin.class);
    private static final String FILTER_GRID_AP = "filtergridap";

    @Override
    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID_AP);
        this.setFilterFields(filterGrid);
    }

    private void setFilterFields(FilterGrid filterGrid) {
        filterGrid.setEntityNumber("fa_depresplitdetail");
        HashSet<String> filterFiledSet = new HashSet<String>(10);
        filterFiledSet.add("copyrealcard.number");
        filterFiledSet.add("copyrealcard.assetcat.number");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String keyLike = FILTER_GRID_AP;
        Set<String> mapValueSet = this.getMapValueSetByLikeKey(customParams, keyLike);
        if (mapValueSet.size() > 0) {
            for (String value : mapValueSet) {
                Arrays.stream(value.split(",")).forEach(v -> filterFiledSet.add(v.trim()));
            }
        }
        filterGrid.setFilterFieldKeys(new ArrayList(filterFiledSet));
    }

    private Set<String> getMapValueSetByLikeKey(Map<String, Object> map, String keyLike) {
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Object> entity : map.entrySet()) {
            if (!entity.getKey().contains(keyLike)) continue;
            set.add((String)entity.getValue());
        }
        return set;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        if (rowData.isEmpty()) {
            return;
        }
        Map<Long, Map<String, String>> dimInfoMap = this.queryDimInfoMap(rowData);
        HashMap<String, HashMap<String, String>> dimValues = this.getDimValues(dimInfoMap);
        DynamicObjectType rowType = rowData.getDynamicObjectType();
        for (DynamicObject row : rowData) {
            this.fillRealCardInfo(row);
            long entryId = row.getLong("entryid");
            Map<String, String> dimInfo = dimInfoMap.get(entryId);
            if (dimInfo == null) continue;
            for (Map.Entry<String, String> entry : dimInfo.entrySet()) {
                String assType = entry.getKey();
                String assId = entry.getValue();
                HashMap<String, String> dimIdNameMap = dimValues.get(assType);
                if (dimIdNameMap == null) {
                    logger.info(String.format("\u6298\u65e7\u5206\u644a\u8868\u8868\u5355\u63d2\u4ef6==>\u672a\u83b7\u53d6\u5230\u5206\u644a\u7ef4\u5ea6[%1$s]\u7684\u76f8\u5173\u6570\u636e\uff0centryId[%2$s]\uff0c\u6298\u65e7\u5206\u644a\u660e\u7ec6\u7684\u5b50\u5206\u5f55\u6709\u5206\u644a\u6570\u636e\u3002\u53ef\u80fd\u7684\u60c5\u51b5\uff1a1.\u5206\u644a\u65b9\u6848\u914d\u4e86\u8fd9\u4e2a\u7ef4\u5ea6\uff0c\u4f46\u5361\u7247\u4e0a\u8fd9\u4e2a\u7ef4\u5ea6\u5bf9\u5e94\u7684\u5b57\u6bb5\u662f\u7a7a\u7684\uff0c\u5206\u644a\u660e\u7ec6\u5b50\u5206\u5f55\u4e2d\uff0c\u7eac\u5ea6\u503cid\u662f0\uff1b2.\u5361\u7247\u5b9e\u9645\u7684\u5206\u644a\u7ef4\u5ea6\u6ca1\u5b58\u5230\u6298\u65e7\u6c47\u603b\u5197\u4f59\u7684\u5206\u644a\u7ef4\u5ea6\u5206\u5f55\u4e2d\uff1b3.\u8ba1\u63d0\u5206\u644a\u8fc7\uff0c\u53c8\u5220\u4e86\u76f8\u5173\u7684\u6570\u636e\uff08\u5361\u7247\u3001\u5206\u644a\u8bbe\u7f6e/\u65b9\u6848\u7b49\uff09\uff0c\u9700\u8981\u91cd\u65b0\u5206\u644a\u3002\u53ef\u4ee5\u6392\u67e5\u4e00\u4e0b", assType, entryId));
                    continue;
                }
                String fieldKey = "tp__" + assType;
                if (rowType.getProperty(fieldKey) == null) {
                    logger.info(String.format("\u6298\u65e7\u5206\u644a\u8868\u8868\u5355\u63d2\u4ef6==>\u672a\u627e\u5230\u5bf9\u5e94\u7684\u7ef4\u5ea6\u5217[%1$s]\uff0centryId[%2$s]\uff0c\u6298\u65e7\u5206\u644a\u660e\u7ec6\u7684\u5b50\u5206\u5f55\u6709\u5206\u644a\u6570\u636e\uff0c\u4f46\u6ca1\u6709\u6784\u9020\u5bf9\u5e94\u7684\u7ef4\u5ea6\u5217\uff08\u6784\u9020\u7684\u7ef4\u5ea6\u5217\u7531\u6298\u65e7\u6c47\u603b\u5197\u4f59\u7684\u7ef4\u5ea6\u5206\u5f55\u786e\u5b9a\uff09\u3002\u53ef\u80fd\u7684\u60c5\u51b5\uff1a1.\u5361\u7247\u5b9e\u9645\u7684\u5206\u644a\u7ef4\u5ea6\u6ca1\u5b58\u5230\u6298\u65e7\u6c47\u603b\u5197\u4f59\u7684\u5206\u644a\u7ef4\u5ea6\u5206\u5f55\u4e2d\uff1b2.\u8ba1\u63d0\u5206\u644a\u8fc7\uff0c\u53c8\u5220\u4e86\u76f8\u5173\u7684\u6570\u636e\uff08\u5361\u7247\u3001\u5206\u644a\u8bbe\u7f6e/\u65b9\u6848\u7b49\uff09\uff0c\u9700\u8981\u91cd\u65b0\u5206\u644a\u3002\u53ef\u4ee5\u6392\u67e5\u4e00\u4e0b", assType, entryId));
                    continue;
                }
                String dimName = dimIdNameMap.get(assId);
                row.set(fieldKey, (Object)dimName);
            }
        }
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("q_org");
        this.addItemClickListeners(new String[]{"toolbarap"});
        orgEdit.addBeforeF7SelectListener(evt -> {
            ListShowParameter param = (ListShowParameter)evt.getFormShowParameter();
            List qFilters = param.getListFilterParameter().getQFilters();
            List collect = qFilters.stream().filter(f -> !"id = -1".equals(f.toString())).collect(Collectors.toList());
            param.getListFilterParameter().setQFilters(collect);
        });
        FilterGrid filterGrid = (FilterGrid)this.getControl(FILTER_GRID_AP);
        filterGrid.addBeforeF7SelectListener(this::beforeSelect);
    }

    private void beforeSelect(BeforeFilterF7SelectEvent evt) {
        List filters = evt.getQfilters();
        IDataModel model = this.getModel();
        DynamicObject org = (DynamicObject)model.getValue("q_org");
        if ("copyrealcard.number".equals(evt.getFieldName())) {
            filters.add(new QFilter("org", "=", org.getPkValue()));
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
        }
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject[] assetBooks;
        this.getView().setVisible(Boolean.FALSE, new String[]{"qinganalysisap"});
        Long curLoginOrg = RequestContext.get().getOrgId();
        String pageId = this.getView().getPageId();
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        List orgIds = permOrgRs.getHasPermOrgs();
        HashSet<Long> ids = new HashSet<Long>();
        BasedataEdit orgBd = (BasedataEdit)this.getControl("q_org");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        if (orgIds.isEmpty() && !permOrgRs.hasAllOrgPerm()) {
            list.add(new QFilter("id", "in", new ArrayList()));
            orgBd.setQFilters(list);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaDepreciationAssignPlugin_0", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        if (permOrgRs.hasAllOrgPerm()) {
            for (DynamicObject assetBook : assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"org,startperiod,curperiod", null)) {
                if (assetBook.getDynamicObject("org") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
            if (ids.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6298\u65e7\u7528\u9014\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaDepreciationAssignPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
        } else {
            for (DynamicObject assetBook : assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)orgIds)})) {
                if (assetBook.getDynamicObject("depreuse") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null || assetBook.getDynamicObject("org") == null) continue;
                ids.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
        }
        if (ids.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6298\u65e7\u7528\u9014\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaDepreciationAssignPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        list.add(new QFilter("id", "in", ids));
        orgBd.setQFilters(list);
        if (!ids.contains(curLoginOrg)) {
            curLoginOrg = (Long)new ArrayList(ids).get(0);
        }
        this.getModel().setValue("q_org", (Object)curLoginOrg);
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)curLoginOrg)});
        this.getModel().setValue("depreuse", assetBook.getDynamicObject("depreuse").getPkValue());
        this.changeFilterPanel(assetBook);
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        QFilter fdepreuse;
        FilterInfo filterCondition = queryParam.getFilter();
        IReportView view = this.getView();
        Map customParam = queryParam.getCustomParam();
        String pageId = view.getPageId();
        customParam.put("pageId", pageId);
        IAppCache appCache = AppCache.get((String)"fa");
        appCache.remove(pageId + "fa_rpt_depre_assgin.totalAmount");
        if (filterCondition.getDynamicObject("q_org") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaDepreciationAssignPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("depreuse") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"FaDepreciationAssignPlugin_3", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("period_start") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d77\u59cb\u671f\u95f4\u3002", (String)"FaDepreciationAssignPlugin_4", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("period_end") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7ed3\u675f\u671f\u95f4\u3002", (String)"FaDepreciationAssignPlugin_5", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject org = (DynamicObject)this.getModel().getValue("q_org");
        DynamicObject depreuse = (DynamicObject)this.getModel().getValue("depreuse");
        QFilter forg = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(org.getPkValue())));
        DynamicObject assetBook = BusinessDataServiceHelper.loadSingleFromCache((String)"fa_assetbook", (String)"id", (QFilter[])new QFilter[]{forg, fdepreuse = new QFilter("depreuse", "=", (Object)Long.parseLong(String.valueOf(depreuse.getPkValue())))});
        if (assetBook == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FaDepreciationAssignPlugin_6", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        DynamicObject periodStart = filterCondition.getDynamicObject("period_start");
        DynamicObject periodEnd = filterCondition.getDynamicObject("period_end");
        if (periodStart != null && periodEnd != null && FaPeriodUtils.compare2period((long)((Long)periodStart.getPkValue()), (long)((Long)periodEnd.getPkValue())) == 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u5f00\u59cb\u671f\u95f4\u665a\u4e8e\u67e5\u8be2\u7684\u7ed3\u675f\u671f\u95f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"FaDepreciationAssignPlugin_7", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        IDataModel model = this.getModel();
        if (propName.equals("q_org")) {
            DynamicObject org = (DynamicObject)model.getValue("q_org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDepreciationAssignPlugin_8", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            QFilter forg = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(org.getPkValue())));
            DynamicObject assetBook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{forg});
            this.changeFilterPanel(assetBook);
        } else if (propName.equals("depreuse")) {
            DynamicObject org = (DynamicObject)model.getValue("q_org");
            if (org == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDepreciationAssignPlugin_8", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            DynamicObject depreuse = (DynamicObject)model.getValue("depreuse");
            if (depreuse == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6298\u65e7\u7528\u9014\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaDepreciationAssignPlugin_9", (String)"fi-fa-report", (Object[])new Object[0]));
                return;
            }
            QFilter forg = new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(org.getPkValue())));
            QFilter fdepreuse = new QFilter("depreuse", "=", (Object)Long.parseLong(String.valueOf(depreuse.getPkValue())));
            DynamicObject assetBook = BusinessDataServiceHelper.loadSingle((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{forg, fdepreuse});
            this.changeFilterPanel(assetBook);
        } else if (propName.equals("period_start")) {
            DynamicObject startPeriod = (DynamicObject)model.getValue("period_start");
            DynamicObject endPeriod = (DynamicObject)model.getValue("period_end");
            if (startPeriod == null || endPeriod == null) {
                return;
            }
            if (FaPeriodUtils.compare2period((long)((Long)startPeriod.getPkValue()), (long)((Long)endPeriod.getPkValue())) == 1) {
                model.setValue("period_end", startPeriod.getPkValue());
            }
        } else if (propName.equals("period_end")) {
            DynamicObject startPeriod = (DynamicObject)model.getValue("period_start");
            DynamicObject endPeriod = (DynamicObject)model.getValue("period_end");
            if (startPeriod == null || endPeriod == null) {
                return;
            }
            if (FaPeriodUtils.compare2period((long)((Long)startPeriod.getPkValue()), (long)((Long)endPeriod.getPkValue())) == 1) {
                model.setValue("period_start", endPeriod.getPkValue());
            }
        }
    }

    private void changeFilterPanel(DynamicObject assetbook) {
        IDataModel model = this.getModel();
        if (assetbook == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FaDepreciationAssignPlugin_6", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        DynamicObject enablePeriod = assetbook.getDynamicObject("startperiod");
        DynamicObject currentPeriod = assetbook.getDynamicObject("curperiod");
        if (enablePeriod == null || enablePeriod.getPkValue() == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u672a\u8bbe\u7f6e\u542f\u7528\u671f\u95f4\u3002", (String)"FaDepreciationAssignPlugin_10", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        Long currentPeriodPk = Long.valueOf(currentPeriod.getPkValue().toString());
        List periodIds = FaPeriodUtils.getPeriodIdByRange((long)Long.parseLong(enablePeriod.getPkValue().toString()), (long)currentPeriodPk);
        BasedataEdit start = (BasedataEdit)this.getControl("period_start");
        BasedataEdit end = (BasedataEdit)this.getControl("period_end");
        start.setQFilter(new QFilter("id", "in", (Object)periodIds));
        end.setQFilter(new QFilter("id", "in", (Object)periodIds));
        model.setValue("period_start", (Object)currentPeriodPk);
        model.setValue("period_end", (Object)currentPeriodPk);
        this.getModel().setValue("depreuse", assetbook.getDynamicObject("depreuse").getPkValue());
        DynamicObject org = assetbook.getDynamicObject("org");
        DynamicObject[] depreUses = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"depreuse", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(String.valueOf(org.getPkValue())))});
        this.getView().setVisible(Boolean.valueOf(depreUses.length != 1), new String[]{"depreuse"});
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("tool_qing".equals(itemKey)) {
            IReportView view = this.getView();
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("fa_qing_assgin");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("queryparam", (Object)SerializationUtils.serializeToBase64((Object)this.getQueryParam()));
            view.showForm(showParameter);
        }
    }

    private void fillRealCardInfo(DynamicObject row) {
        DynamicObject realCard = row.getDynamicObject("realcard");
        if (realCard == null) {
            String sumFlag = row.getString("summarytype");
            if ("1".equals(sumFlag)) {
                row.set("realnumber", (Object)ResManager.loadKDString((String)"\u5408\u8ba1", (String)"FaDepreciationAssignPlugin_11", (String)"fi-fa-report", (Object[])new Object[0]));
            }
            return;
        }
        row.set("assetcat", (Object)realCard.getDynamicObject("assetcat"));
        row.set("headusedept", (Object)realCard.getDynamicObject("headusedept"));
        row.set("billno", (Object)realCard.getString("billno"));
        row.set("realnumber", (Object)realCard.getString("number"));
        row.set("realcardname", (Object)realCard.getString("assetname"));
    }

    private Map<Long, Map<String, String>> queryDimInfoMap(DynamicObjectCollection rowData) {
        HashMap<Long, Map<String, String>> result = new HashMap<Long, Map<String, String>>(200, 1.0f);
        if (rowData == null || rowData.isEmpty()) {
            return result;
        }
        List entryIds = rowData.stream().map(v -> v.getLong("entryid")).collect(Collectors.toList());
        if (entryIds.isEmpty()) {
            return result;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fentryid, fasstype, fassid from t_fa_depredetailsubentry where ", new Object[0]);
        sql.appendIn("fentryid", entryIds);
        DataSet subEntry = DB.queryDataSet((String)"FaDepreciationAssignPlugin.queryDimInfoMap", (DBRoute)DBRoute.of((String)"fa"), (SqlBuilder)sql);
        for (Row row : subEntry) {
            Long entryId = row.getLong("fentryid");
            String assType = row.getString("fasstype");
            String assId = row.getString("fassid");
            Map dimInfoMap = result.computeIfAbsent(entryId, v -> new HashMap(8));
            dimInfoMap.put(assType, assId);
        }
        return result;
    }

    private HashMap<String, HashMap<String, String>> getDimValues(Map<Long, Map<String, String>> dimInfoMap) {
        DynamicObject[] basDimNames;
        String selectProps;
        FilterInfo filterCondition = this.getQueryParam().getFilter();
        String showType = "";
        if (null != filterCondition.getFilterItem("asstshowtype").getValue()) {
            showType = filterCondition.getFilterItem("asstshowtype").getValue().toString();
        }
        String switchShowType = showType;
        switch (showType) {
            case "1": {
                selectProps = "id,number";
                break;
            }
            case "2": {
                selectProps = "id,number,name";
                break;
            }
            default: {
                selectProps = "id,name";
            }
        }
        HashMap<String, List> assTypeMap = new HashMap<String, List>(8);
        for (Map<String, String> map : dimInfoMap.values()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                String assType = entry.getKey();
                List assValueList = assTypeMap.computeIfAbsent(assType, v -> new ArrayList());
                assValueList.add(Long.parseLong(entry.getValue()));
            }
        }
        Set assTypeSet = assTypeMap.keySet();
        LinkedList<String> baseDimIds = new LinkedList<String>();
        for (DynamicObject dimName : basDimNames = BusinessDataServiceHelper.load((String)"bos_entityobject", (String)selectProps, (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)assTypeSet.toArray(new String[0]))})) {
            baseDimIds.add(dimName.getString("id"));
        }
        HashMap<String, HashMap<String, String>> hashMap = new HashMap<String, HashMap<String, String>>(8);
        baseDimIds.forEach(entityName -> {
            if (StringUtils.isEmpty((CharSequence)entityName)) {
                return;
            }
            QFilter filter = new QFilter("id", "in", assTypeMap.get(entityName));
            Map baseNameMap = BusinessDataServiceHelper.loadFromCache((String)entityName, (String)selectProps, (QFilter[])filter.toArray());
            Collection baseNames = baseNameMap.values();
            block8: for (DynamicObject baseName : baseNames) {
                HashMap baseValues = dimValues.computeIfAbsent((String)entityName, k -> new HashMap(8));
                switch (switchShowType) {
                    case "1": {
                        baseValues.put(baseName.getString("id"), baseName.getString("number"));
                        continue block8;
                    }
                    case "2": {
                        baseValues.put(baseName.getString("id"), baseName.getString("number") + "," + baseName.getLocaleString("name").toString());
                        continue block8;
                    }
                }
                baseValues.put(baseName.getString("id"), baseName.getLocaleString("name").toString());
            }
        });
        assTypeSet.removeAll(baseDimIds);
        HashSet<Long> groupIds = new HashSet<Long>(assTypeSet.size(), 1.0f);
        for (String assType : assTypeSet) {
            if (StringUtils.isEmpty((CharSequence)assType) || "null".equals(assType)) continue;
            groupIds.add(Long.parseLong(assType));
        }
        Map assDimNameMap = BusinessDataServiceHelper.loadFromCache((String)"bos_assistantdata_detail", (String)(selectProps + ",group"), (QFilter[])new QFilter[]{new QFilter("group", "in", groupIds)});
        Collection assDimNames = assDimNameMap.values();
        block20: for (DynamicObject assDimName : assDimNames) {
            DynamicObject group = assDimName.getDynamicObject("group");
            String groupId = group.getString("id");
            HashMap baseValues = hashMap.computeIfAbsent(groupId, k -> new HashMap(8));
            switch (showType) {
                case "1": {
                    baseValues.put(assDimName.getString("id"), assDimName.getString("number"));
                    continue block20;
                }
                case "2": {
                    baseValues.put(assDimName.getString("id"), assDimName.getString("number") + "," + assDimName.getLocaleString("name").toString());
                    continue block20;
                }
            }
            baseValues.put(assDimName.getString("id"), assDimName.getLocaleString("name").toString());
        }
        return hashMap;
    }
}

