/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.plugin.AbstractPrintServicePlugin;
import kd.bos.entity.plugin.args.CustomPrintDataEntitiesArgs;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.report.util.RptPrintHelper;

public class FaDepreciationPrintPlugin
extends AbstractPrintServicePlugin {
    private static final String REPORT_LIST = "reportlist";
    private static final int PRECISION = 4;
    private static final String[] STRING_FIELD_KEYS = new String[]{"orgname", "category", "number"};
    private static final String[] INT_AND_LONG_FIELD_KEYS = new String[]{"fseq", "prepare_use_amount", "depreciation_amount"};
    private static final String[] BIG_DECIMAL_FIELD_KEYS = new String[]{"depreciation_rate"};
    private static final String[] BASE_DATA_FIELD_KEYS = new String[]{"period", "realcard", "depreciation_method"};
    private static final String[] BASE_DATA_PROP_FIELD_KEYS = new String[]{Fa.dot((String[])new String[]{"realcard", "billno"})};
    private static final String[] AMOUNT_FIELD_KEYS = new String[]{"original_value_begin", "accumulated_depre_begin", "depre_reserves_begin", "net_value_begin", "net_amount_begin", "original_adjust", "accumulated_depre_adjust", "depre_adjust", "actual_depreciation", "year_depreciation", "original_value_end", "accumulated_depre_end", "depre_reserves_end", "net_value_end", "net_amount_end"};

    public void customPrintDataEntities(CustomPrintDataEntitiesArgs e) {
        List dataEntities = e.getDataEntities();
        if (!e.isMainDs() && REPORT_LIST.equals(e.getDataSourceName())) {
            String pageId = e.getPageId();
            ReportListModel listModel = RptPrintHelper.getListModel(pageId);
            if (listModel == null) {
                return;
            }
            int rowCount = listModel.getRowCount();
            DynamicObjectCollection rowData = listModel.getRowData(0, rowCount);
            if (rowData == null || rowData.isEmpty()) {
                return;
            }
            for (DynamicObject row : rowData) {
                DynamicObjectType dataSourceType = e.getDynamicObjectType();
                DynamicObject dataSource = new DynamicObject(dataSourceType);
                RptPrintHelper.copyStringFields(row, dataSource, STRING_FIELD_KEYS);
                RptPrintHelper.copyIntAndLongFields(row, dataSource, false, INT_AND_LONG_FIELD_KEYS);
                RptPrintHelper.copyBigDecimalFields(row, dataSource, 4, false, BIG_DECIMAL_FIELD_KEYS);
                RptPrintHelper.copyBaseDataFields(row, dataSource, BASE_DATA_FIELD_KEYS);
                RptPrintHelper.copyBaseDataPropField(row, dataSource, BASE_DATA_PROP_FIELD_KEYS);
                FormatObject formatObj = InteServiceHelper.getUserFormat((Long)ContextUtil.getUserId());
                RptPrintHelper.copyAmountFields(row, dataSource, formatObj, "basecurrency", false, AMOUNT_FIELD_KEYS);
                this.copyBaseDataProp4Ext(row, dataSource);
                dataEntities.add(dataSource);
            }
        }
    }

    private void copyBaseDataProp4Ext(DynamicObject from, DynamicObject to) {
        Set stringFieldSet = Stream.of(STRING_FIELD_KEYS).collect(Collectors.toSet());
        Set intAndLongFieldSet = Stream.of(INT_AND_LONG_FIELD_KEYS).collect(Collectors.toSet());
        Set bigDecimalFieldSet = Stream.of(BIG_DECIMAL_FIELD_KEYS).collect(Collectors.toSet());
        Set baseDataFieldSet = Stream.of(BASE_DATA_FIELD_KEYS).collect(Collectors.toSet());
        Set baseDataPropFieldSet = Stream.of(BASE_DATA_PROP_FIELD_KEYS).collect(Collectors.toSet());
        Set amountFieldSet = Stream.of(AMOUNT_FIELD_KEYS).collect(Collectors.toSet());
        HashSet<String> standardDataSource = new HashSet<String>(32);
        standardDataSource.addAll(stringFieldSet);
        standardDataSource.addAll(intAndLongFieldSet);
        standardDataSource.addAll(bigDecimalFieldSet);
        standardDataSource.addAll(baseDataFieldSet);
        standardDataSource.addAll(baseDataPropFieldSet);
        standardDataSource.addAll(amountFieldSet);
        DataEntityPropertyCollection properties = to.getDataEntityType().getProperties();
        HashSet<String> extDataSource = new HashSet<String>(32);
        properties.forEach(prop -> extDataSource.add(prop.getName()));
        RptPrintHelper.copyBaseDataProp4Ext(from, to, standardDataSource, extDataSource);
    }
}

