/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.formplugin;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.report.IReportView;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.PermissonType;
import kd.fi.fa.report.AbstractFaRptFormPlugin;
import kd.fi.fa.report.util.FaReportUtils;

public class FaHealthStatusListPlugin
extends AbstractFaRptFormPlugin {
    private static final Log logger = LogFactory.getLog(FaHealthStatusListPlugin.class);

    @Override
    protected String getOrgKey() {
        return "q_org_multiple";
    }

    @Override
    public void beforeBindData(EventObject e) {
        this.setFilterFields();
    }

    private void setFilterFields() {
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.setEntityNumber("fa_card_fin");
        HashSet<String> filterFiledSet = new HashSet<String>();
        filterFiledSet.add("assetcat.name");
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String keyLike = "filtergridap";
        Set<String> mapValueSet = this.getMapValueSetByLikeKey(customParams, keyLike);
        if (mapValueSet.size() > 0) {
            for (String value : mapValueSet) {
                Arrays.stream(value.split(",")).forEach(v -> filterFiledSet.add(v.trim()));
            }
        }
        filterGrid.setFilterFieldKeys(new ArrayList(filterFiledSet));
    }

    private Set<String> getMapValueSetByLikeKey(Map<String, Object> map, String keyLike) {
        if (map == null || map.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, Object> entity : map.entrySet()) {
            if (!entity.getKey().contains(keyLike)) continue;
            set.add((String)entity.getValue());
        }
        return set;
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        FilterGrid filterGrid = (FilterGrid)this.getControl("filtergridap");
        filterGrid.addBeforeF7SelectListener(this::beforeFilterF7SelectEvent);
    }

    private void beforeFilterF7SelectEvent(BeforeFilterF7SelectEvent evt) {
        DynamicObjectCollection orgDynObjList = (DynamicObjectCollection)this.getModel().getValue("q_org_multiple");
        ArrayList<Long> orgIdSet = new ArrayList<Long>(orgDynObjList.size());
        for (DynamicObject orgDynObj : orgDynObjList) {
            Long orgId = orgDynObj.getLong("fbasedataid_id");
            orgIdSet.add(orgId);
        }
        List filters = evt.getQfilters();
        String fieldName = evt.getFieldName();
        if (fieldName.equals("assetcat.name")) {
            filters.add(FaReportUtils.getAssetCateFilter(orgIdSet));
        }
    }

    @Override
    public void afterSetModelValue(DynamicObject scheme) {
        DynamicObject oldQOrg = scheme.getDynamicObject("q_org");
        if (Objects.nonNull(oldQOrg)) {
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection();
            dynamicObjectCollection.add((Object)oldQOrg);
            this.getModel().setValue("q_org_multiple", (Object)dynamicObjectCollection);
        }
        super.afterSetModelValue(scheme);
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        for (DynamicObject row : rowData) {
            BigDecimal valuerate;
            BigDecimal accumdeprerate;
            BigDecimal originalvalrate;
            this.setRate(row, "qty_rate_zero");
            this.setRate(row, "qty_rate_less");
            this.setRate(row, "qty_rate_more");
            this.setRate(row, "networth_rate_zero");
            this.setRate(row, "networth_rate_less");
            this.setRate(row, "networth_rate_more");
            if (!"".equals(row.getString("networth_rate_less").trim()) && (originalvalrate = row.getBigDecimal("qty_rate_zero").setScale(2, 4)).compareTo(BigDecimal.ZERO) == 0) {
                row.set("qty_rate_zero", (Object)"");
            }
            if (!"".equals(row.getString("qty_rate_more").trim()) && (accumdeprerate = row.getBigDecimal("networth_rate_zero").setScale(2, 4)).compareTo(BigDecimal.ZERO) == 0) {
                row.set("networth_rate_zero", (Object)"");
            }
            if ("".equals(row.getString("networth_rate_more").trim()) || (valuerate = row.getBigDecimal("qty_rate_less").setScale(2, 4)).compareTo(BigDecimal.ZERO) != 0) continue;
            row.set("qty_rate_less", (Object)"");
        }
    }

    private void setRate(DynamicObject row, String rate) {
        if (!"".equals(row.getString(rate).trim())) {
            BigDecimal valRate;
            BigDecimal result;
            BigDecimal assetAmount;
            if ("qty_rate_zero".equals(rate)) {
                BigDecimal qtyZero = this.getValueByField(row, "qty_zero");
                assetAmount = this.getValueByField(row, "assetamount");
                result = qtyZero.divide(assetAmount, 8, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                row.set(rate, (Object)result);
            }
            if ("qty_rate_less".equals(rate)) {
                BigDecimal qtyLess = this.getValueByField(row, "qty_less");
                assetAmount = this.getValueByField(row, "assetamount");
                result = qtyLess.divide(assetAmount, 8, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                row.set(rate, (Object)result);
            }
            if ("qty_rate_more".equals(rate)) {
                BigDecimal qtyMore = this.getValueByField(row, "qty_more");
                assetAmount = this.getValueByField(row, "assetamount");
                result = qtyMore.divide(assetAmount, 8, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                row.set(rate, (Object)result);
            }
            BigDecimal netWorth = this.getValueByField(row, "networth");
            if ("networth_rate_zero".equals(rate)) {
                if (netWorth.compareTo(BigDecimal.ZERO) == 0) {
                    row.set(rate, (Object)0);
                } else {
                    BigDecimal netWorthZero = this.getValueByField(row, "networth_zero");
                    result = netWorthZero.divide(netWorth, 8, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                    row.set(rate, (Object)result);
                }
            }
            if ("networth_rate_less".equals(rate)) {
                if (netWorth.compareTo(BigDecimal.ZERO) == 0) {
                    row.set(rate, (Object)0);
                } else {
                    BigDecimal netWorthLess = this.getValueByField(row, "networth_less");
                    result = netWorthLess.divide(netWorth, 8, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                    row.set(rate, (Object)result);
                }
            }
            if ("networth_rate_more".equals(rate)) {
                if (netWorth.compareTo(BigDecimal.ZERO) == 0) {
                    row.set(rate, (Object)0);
                } else {
                    BigDecimal netWorthMore = this.getValueByField(row, "networth_more");
                    result = netWorthMore.divide(netWorth, 8, RoundingMode.HALF_UP).multiply(new BigDecimal("100")).setScale(2, RoundingMode.HALF_UP);
                    row.set(rate, (Object)result);
                }
            }
            if ((valRate = row.getBigDecimal(rate).setScale(2, 4)).compareTo(BigDecimal.ZERO) == 0) {
                row.set(rate, (Object)"");
            }
        }
    }

    private BigDecimal getValueByField(DynamicObject row, String field) {
        if (Objects.isNull(row) || Objects.isNull(field) || field.length() == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal bigDecimal = row.getBigDecimal(field);
        if (Objects.isNull(bigDecimal)) {
            return BigDecimal.ZERO;
        }
        return bigDecimal;
    }

    @Override
    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterCondition = queryParam.getFilter();
        IReportView view = this.getView();
        DynamicObjectCollection orgDynObjList = filterCondition.getDynamicObjectCollection("q_org_multiple");
        if (orgDynObjList == null || orgDynObjList.size() == 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaHealthStatusListPlugin_0", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("depreuse") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6298\u65e7\u7528\u9014\u3002", (String)"FaHealthStatusListPlugin_1", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        if (filterCondition.getDynamicObject("q_period") == null) {
            view.showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4f1a\u8ba1\u671f\u95f4\u3002", (String)"FaHealthStatusListPlugin_2", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        List orgIdList = orgDynObjList.stream().map(dynObj -> (Long)dynObj.getPkValue()).collect(Collectors.toList());
        QFilter orgFilter = new QFilter("org", "in", orgIdList);
        boolean exists = QueryServiceHelper.exists((String)"fa_assetbook", (QFilter[])new QFilter[]{orgFilter});
        if (!exists) {
            view.showTipNotification(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaHealthStatusListPlugin_3", (String)"fi-fa-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("isallperm", "0");
        this.getPageCache().put("hasassetbook", "1");
        try {
            this.setDataFilter();
        }
        catch (Exception ex) {
            this.getModel().setValue("q_org_multiple", null);
            this.getModel().setValue("depreuse", null);
            this.getModel().setValue("q_period", null);
            this.getView().showTipNotification(ex.getMessage());
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        queryParam.getCustomParam().put("pageId", this.getView().getPageId());
    }

    private void setDataFilter() {
        IDataModel model = this.getModel();
        String pageId = this.getView().getPageId();
        String appId = SessionManager.getCurrent().getFormShowParameter(pageId).getAppId();
        HasPermOrgResult permOrgRs = PermissionServiceHelper.getAllPermOrgs((Long)ContextUtil.getUserId(), (String)appId, (String)this.getView().getEntityId(), (String)PermissonType.VIEW.getPermId());
        List hasPermOrgIds = permOrgRs.getHasPermOrgs();
        HashSet<Long> assetBookOrgIdSet = new HashSet<Long>();
        BasedataEdit orgBd = (BasedataEdit)this.getControl("q_org_multiple");
        BasedataEdit DepreBd = (BasedataEdit)this.getControl("depreuse");
        BasedataEdit PeriodBd = (BasedataEdit)this.getControl("q_period");
        ArrayList<QFilter> list = new ArrayList<QFilter>();
        DynamicObject[] assetBooks = null;
        if (hasPermOrgIds.isEmpty() && !permOrgRs.hasAllOrgPerm()) {
            list.add(new QFilter("id", "in", new ArrayList()));
            orgBd.setQFilters(list);
            DepreBd.setQFilters(list);
            PeriodBd.setQFilters(list);
            model.setValue("q_period", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u7684\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaHealthStatusListPlugin_4", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        if (permOrgRs.hasAllOrgPerm()) {
            this.getPageCache().put("isallperm", "1");
            for (DynamicObject assetBook : assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", null)) {
                if (assetBook.getDynamicObject("org") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                assetBookOrgIdSet.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
        } else {
            for (DynamicObject assetBook : assetBooks = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{new QFilter("org", "in", (Object)hasPermOrgIds)})) {
                if (assetBook.getDynamicObject("depreuse") == null || assetBook.getDynamicObject("startperiod") == null || assetBook.getDynamicObject("curperiod") == null) continue;
                assetBookOrgIdSet.add((Long)assetBook.getDynamicObject("org").getPkValue());
            }
            if (assetBookOrgIdSet.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5b58\u5728\u8d44\u4ea7\u8d26\u7c3f\u7684\u7ec4\u7ec7\u3002", (String)"FaHealthStatusListPlugin_5", (String)"fi-fa-report", (Object[])new Object[0]));
                list.add(new QFilter("id", "in", new ArrayList()));
                orgBd.setQFilters(list);
                DepreBd.setQFilters(list);
                PeriodBd.setQFilters(list);
                model.setValue("q_period", null);
                return;
            }
            assetBookOrgIdSet.retainAll(hasPermOrgIds);
            if (assetBookOrgIdSet.size() == 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6709\u6743\u9650\u8bbf\u95ee\uff0c\u4e14\u5b58\u5728\u8d44\u4ea7\u8d26\u7c3f\u7684\u7ec4\u7ec7\u3002", (String)"FaHealthStatusListPlugin_6", (String)"fi-fa-report", (Object[])new Object[0]));
                list.add(new QFilter("id", "in", new ArrayList()));
                orgBd.setQFilters(list);
                DepreBd.setQFilters(list);
                PeriodBd.setQFilters(list);
                model.setValue("q_period", null);
                return;
            }
        }
        orgBd.setQFilter(new QFilter("id", "in", assetBookOrgIdSet));
        Long curLoginOrgId = FaReportUtils.getDefaultAcctOrg(new ArrayList<Long>(assetBookOrgIdSet));
        model.setValue("q_org_multiple", (Object)new Long[]{curLoginOrgId});
        Map<Object, DynamicObject> assetBookMap = this.getAssetBookByOrgIdList(Collections.singletonList(curLoginOrgId));
        this.setDefaultDepre(assetBookMap.values().toArray(new DynamicObject[0]));
    }

    private Map<Object, DynamicObject> getAssetBookByOrgIdList(List<Long> orgIdList) {
        QFilter qOrgMultiple = new QFilter("org", "in", orgIdList);
        return BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)"id,org,startperiod,depreuse,curperiod", (QFilter[])new QFilter[]{qOrgMultiple});
    }

    private void setDefaultDepre(DynamicObject[] assetBookDynObjArray) {
        if (assetBookDynObjArray == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8be5\u8d44\u4ea7\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FaHealthStatusListPlugin_7", (String)"fi-fa-report", (Object[])new Object[0]));
            return;
        }
        HashSet<Long> depreUseSet = new HashSet<Long>(1);
        IDataModel model = this.getModel();
        for (DynamicObject assetBookDynObj : assetBookDynObjArray) {
            Long depreUseId = assetBookDynObj.getLong("depreuse_id");
            depreUseSet.add(depreUseId);
            model.setValue("depreuse", (Object)assetBookDynObj.getLong(FaDaoOrmImpl.id((String)"depreuse")));
        }
        if (depreUseSet.size() == 1) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"depreuse"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"depreuse"});
        }
        this.setDefaultPeriod(Arrays.asList(assetBookDynObjArray));
    }

    private void setDefaultPeriod(List<DynamicObject> assetBooksTemp) {
        BasedataEdit periodEdit = (BasedataEdit)this.getControl("q_period");
        if (assetBooksTemp == null) {
            periodEdit.setQFilter(new QFilter("id", "in", (Object)0));
            return;
        }
        long mixPeriod = 0L;
        long maxPeriod = 99999999L;
        for (DynamicObject assetBook : assetBooksTemp) {
            DynamicObject startPeriod = assetBook.getDynamicObject("startperiod");
            if (startPeriod == null) continue;
            long startPeriodId = (Long)startPeriod.getPkValue();
            DynamicObject currentPeriod = assetBook.getDynamicObject("curperiod");
            if (currentPeriod == null) continue;
            long currentPeriodId = (Long)currentPeriod.getPkValue();
            if (mixPeriod == 0L) {
                mixPeriod = startPeriodId;
            }
            if (startPeriodId < mixPeriod) {
                mixPeriod = startPeriodId;
            }
            if (maxPeriod == 99999999L) {
                maxPeriod = currentPeriodId;
            }
            if (currentPeriodId <= maxPeriod) continue;
            maxPeriod = currentPeriodId;
        }
        List periodIds = FaPeriodUtils.getPeriodIdByRange((long)mixPeriod, (long)maxPeriod);
        periodEdit.setQFilter(new QFilter("id", "in", (Object)periodIds));
        IDataModel model = this.getModel();
        Object qPeriodValue = model.getValue("q_period");
        if (Objects.isNull(qPeriodValue)) {
            model.setValue("q_period", (Object)maxPeriod);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        IDataModel model = this.getModel();
        DynamicObjectCollection orgDynObjList = (DynamicObjectCollection)model.getValue("q_org_multiple");
        switch (propName = e.getProperty().getName()) {
            case "q_org_multiple": {
                if (orgDynObjList == null || orgDynObjList.size() == 0) {
                    return;
                }
                List<Long> qOrgIdLst = orgDynObjList.stream().map(dynObj -> ((DynamicObject)dynObj.get("fbasedataid")).getLong("id")).collect(Collectors.toList());
                Map<Object, DynamicObject> assetBookMap = this.getAssetBookByOrgIdList(qOrgIdLst);
                this.setDefaultDepre(assetBookMap.values().toArray(new DynamicObject[0]));
                break;
            }
        }
    }
}

