/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.qing;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.CacheHint;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.dataset.PersistedArrayRow;
import kd.bos.algo.datatype.BooleanType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.FractionalType;
import kd.bos.algo.datatype.IntegralType;
import kd.bos.algo.datatype.NullType;
import kd.bos.algo.datatype.TimestampType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.qing.IQingDataProvider;
import kd.bos.entity.qing.QingData;
import kd.bos.entity.qing.QingFieldType;
import kd.bos.entity.qing.QingMeta;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.report.formplugin.FaAmortisedCostPlugin;
import kd.fi.fa.report.query.FaCostListQuery;

public class AmortisedCostQingDataProvider
implements IQingDataProvider {
    public static final String QING_PAGE = "fa_qing_amortised_cost";
    public static final String CACHE_QUERY_PARAM = "queryparam";
    public static final String COLUMNS = "columns";
    private static final String CACHE_ID = "AmortisedCostQingDataProvider_cacheID";
    private static final String QING_META = "AmortisedCostQingDataProvider_qingMeta";
    private static final Log logger = LogFactory.getLog(AmortisedCostQingDataProvider.class);

    public QingData getData(String pageId, int startRow, int limit) {
        IAppCache appCache = AppCache.get((String)"fa");
        IPageCache pageCache = this.getPageCache(pageId);
        QingMeta qingMeta = (QingMeta)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(QING_META + pageId, String.class)));
        String cacheId = (String)SerializationUtils.deSerializeFromBase64((String)((String)appCache.get(CACHE_ID + pageId, String.class)));
        String filterStr = pageCache.get(CACHE_QUERY_PARAM);
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)filterStr);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject queryPeriod = filterInfo.getDynamicObject("q_period_select");
        queryPeriod = BusinessDataServiceHelper.loadSingle((String)"bd_period", (String)"begindate,enddate,periodtype,periodnumber,periodyear", (QFilter[])new QFilter("id", "=", (Object)queryPeriod.getLong("id")).toArray());
        Date queryDate = queryPeriod.getDate("begindate");
        DynamicObjectCollection filterOrg = filterInfo.getDynamicObjectCollection("q_org");
        List<Long> orgIds = filterOrg.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        QingData qingData = new QingData();
        Map<String, Integer> fieldMap = this.buildQingDataIndexMap(qingMeta);
        ArrayList<Object[]> rowList = new ArrayList<Object[]>();
        if (cacheId != null) {
            CachedDataSet cacheDataSet = Algo.getCacheDataSet((String)cacheId);
            int rowCount = cacheDataSet.getRowCount();
            List list = startRow - 1 >= rowCount ? new ArrayList(0) : cacheDataSet.getList(startRow - 1, limit);
            Set<Map.Entry<String, Integer>> entrySet = fieldMap.entrySet();
            int size = entrySet.size();
            HashMap rangeValues = new HashMap(16);
            Map customParam = queryParam.getCustomParam();
            String queryPageId = (String)customParam.get("pageId");
            String dimValueStr = (String)appCache.get(queryPageId + "fa_rpt_amortisedCost.dim_values", String.class);
            if (null != dimValueStr) {
                rangeValues = (HashMap)SerializationUtils.deSerializeFromBase64((String)dimValueStr);
            }
            Map<String, Object> formCalData = new FaAmortisedCostPlugin().getFormCalData(orgIds, queryPeriod, new ArrayList<Object>(list), Boolean.TRUE);
            for (Row row : list) {
                Object[] data = new Object[size];
                RowMeta rowMeta = ((PersistedArrayRow)row).getRowMeta();
                String masterId = row.getString("masterid");
                for (Map.Entry<String, Integer> entry : entrySet) {
                    String fieldName = entry.getKey();
                    int columnIndex = entry.getValue();
                    Object fieldValue = null;
                    DataType dataType = rowMeta.getField(fieldName).getDataType();
                    if (DataType.DateType.equals((Object)dataType) || DataType.TimestampType.equals((Object)dataType)) {
                        Date date = row.getDate(fieldName);
                        if (date != null) {
                            fieldValue = date.getTime();
                        }
                    } else {
                        fieldValue = row.get(fieldName);
                    }
                    String key = masterId + "_split_" + fieldName;
                    if (rangeValues.containsKey(key)) {
                        fieldValue = rangeValues.get(key);
                        fieldValue = fieldValue == null ? BigDecimal.ZERO : fieldValue;
                    } else if (formCalData.containsKey(key)) {
                        fieldValue = formCalData.get(key);
                    }
                    if (fieldValue == null && DataType.BigDecimalType.equals((Object)dataType)) {
                        fieldValue = BigDecimal.ZERO;
                    }
                    data[columnIndex] = fieldValue;
                }
                rowList.add(data);
            }
        }
        qingData.setDataindex(fieldMap);
        qingData.setRows(rowList);
        return qingData;
    }

    private Map<String, Integer> buildQingDataIndexMap(QingMeta qingMeta) {
        LinkedHashMap<String, Integer> qingDataIndexMap = new LinkedHashMap<String, Integer>(qingMeta.getColumns().size());
        int columnSeqNo = 0;
        for (kd.bos.entity.qing.Field col : qingMeta.getColumns()) {
            qingDataIndexMap.put(col.getKey().toLowerCase(), columnSeqNo++);
        }
        return qingDataIndexMap;
    }

    public QingMeta getMeta(String pageId) {
        IAppCache appCache = AppCache.get((String)"fa");
        IPageCache pageCache = this.getPageCache(pageId);
        String filterStr = pageCache.get(CACHE_QUERY_PARAM);
        String columns = pageCache.get(COLUMNS);
        ReportQueryParam queryParam = (ReportQueryParam)SerializationUtils.deSerializeFromBase64((String)filterStr);
        List<AbstractReportColumn> columnLst = (List<AbstractReportColumn>)SerializationUtils.deSerializeFromBase64((String)columns);
        HashMap<String, ReportColumn> columnMap = new HashMap<String, ReportColumn>(columnLst.size());
        ArrayList<String> otherRealFields = new ArrayList<String>(15);
        for (AbstractReportColumn _column : columnLst) {
            if (_column instanceof ReportColumnGroup) {
                for (AbstractReportColumn _columnChildren : ((ReportColumnGroup)_column).getChildren()) {
                    ReportColumn columnChildren = (ReportColumn)_columnChildren;
                    LocaleString groupLs = _column.getCaption();
                    LocaleString childrenLs = columnChildren.getCaption();
                    for (Map.Entry entry : childrenLs.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        String groupValue = (String)groupLs.get((Object)key);
                        childrenLs.setItem(key, (Object)((String)groupValue + "-" + value));
                    }
                    this.columnOp((AbstractReportColumn)columnChildren, columnMap, otherRealFields);
                }
                continue;
            }
            this.columnOp(_column, columnMap, otherRealFields);
        }
        otherRealFields.add("number");
        otherRealFields.add("sysswitchdate");
        otherRealFields.add("settlesharesrcid");
        otherRealFields.add("addupyearrent");
        otherRealFields.add("addupyearinterest");
        otherRealFields.add("accumrent");
        otherRealFields.add("accuminterest");
        FaCostListQuery faCostListQuery = new FaCostListQuery();
        DataSet dataSet = faCostListQuery.query(queryParam, otherRealFields);
        try {
            columnLst = faCostListQuery.getColumns(columnLst, queryParam);
            String columnJson = SerializationUtils.serializeToBase64(columnLst);
            pageCache.put(COLUMNS, columnJson);
        }
        catch (Throwable e) {
            logger.error("\u8c03\u7528\u62a5\u8868\u67e5\u8be2\u63d2\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38", e);
            throw new KDBizException(ResManager.loadKDString((String)"\u8c03\u7528\u62a5\u8868\u67e5\u8be2\u63d2\u4ef6\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u5728monitor\u67e5\u770b\u8be6\u7ec6\u4fe1\u606f\u3002", (String)"AmortisedCostQingDataProvider_0", (String)"fi-fa-report", (Object[])new Object[0]));
        }
        dataSet = dataSet.addNullField(new String[]{"startleaseliab", "leaseamountchg"});
        for (AbstractReportColumn column : columnLst) {
            ReportColumnGroup columnGroup;
            String columnGroupFieldKey;
            if (!(column instanceof ReportColumnGroup) || !"undue_group".equals(columnGroupFieldKey = (columnGroup = (ReportColumnGroup)column).getFieldKey())) continue;
            for (AbstractReportColumn abstractChildrenCol : columnGroup.getChildren()) {
                ReportColumn childrenCol = (ReportColumn)abstractChildrenCol;
                LocaleString groupLs = columnGroup.getCaption();
                LocaleString childrenLs = childrenCol.getCaption();
                for (Map.Entry entry : childrenLs.entrySet()) {
                    String key = (String)entry.getKey();
                    String value = (String)childrenLs.get((Object)key);
                    String groupValue = (String)groupLs.get((Object)key);
                    childrenLs.setItem(key, (Object)(groupValue + "-" + value));
                    dataSet = dataSet.addNullField(value);
                }
                this.columnOp((AbstractReportColumn)childrenCol, columnMap, otherRealFields);
            }
        }
        CachedDataSet cachedDataSet = dataSet.cache(CacheHint.getDefault());
        String cacheId = cachedDataSet.getCacheId();
        appCache.put(CACHE_ID + pageId, (Object)SerializationUtils.serializeToBase64((Object)cacheId));
        RowMeta rowMeta = dataSet.getRowMeta();
        Field[] fields = rowMeta.getFields();
        QingMeta qingMeta = new QingMeta();
        for (Field field : fields) {
            DataType dataType;
            String fieldName = field.getName().toLowerCase();
            ReportColumn reportColumn = (ReportColumn)columnMap.get(fieldName);
            if (reportColumn == null) continue;
            kd.bos.entity.qing.Field qingField = new kd.bos.entity.qing.Field();
            qingField.setKey(fieldName);
            qingField.setName(reportColumn.getCaption());
            qingField.setHide(reportColumn.isHide());
            if ("leasecontract".equals(fieldName)) {
                qingField.setHide(true);
            }
            if ((dataType = field.getDataType()) instanceof NullType) {
                dataType = DataType.BigDecimalType;
            }
            qingField.setFieldType(this.getQingTypeByAlgoType(dataType).toNumber());
            qingMeta.addColumn(qingField);
        }
        appCache.put(QING_META + pageId, (Object)SerializationUtils.serializeToBase64((Object)qingMeta));
        return qingMeta;
    }

    private void columnOp(AbstractReportColumn _column, Map<String, ReportColumn> columnMap, List<String> otherRealFields) {
        ReportColumn column = (ReportColumn)_column;
        if (column.getRefBasedataProp() != null && "leasecontract".equals(column.getRefBasedataProp())) {
            String realRefField = column.getDisplayProp();
            realRefField = realRefField.toLowerCase();
            otherRealFields.add(realRefField);
            columnMap.put(realRefField, column);
        } else {
            columnMap.put(column.getFieldKey().toLowerCase(), column);
            if (column.getFieldKey().equals("leasecontract")) {
                columnMap.put("number", column);
            }
        }
    }

    private IPageCache getPageCache(String pageId) {
        IFormView view = SessionManager.getCurrent().getView(pageId);
        return (IPageCache)view.getService(IPageCache.class);
    }

    private QingFieldType getQingTypeByAlgoType(DataType algoType) {
        if (algoType instanceof FractionalType) {
            return QingFieldType.Number;
        }
        if (algoType instanceof IntegralType) {
            return QingFieldType.Int;
        }
        if (algoType instanceof DateType) {
            return QingFieldType.Date;
        }
        if (algoType instanceof TimestampType) {
            return QingFieldType.DateTime;
        }
        if (algoType instanceof BooleanType) {
            return QingFieldType.Boolean;
        }
        return QingFieldType.String;
    }
}

