/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportBatchQueryInfo;
import kd.bos.entity.report.ReportBatchQueryInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.enums.changemode.ChangeModeTypeEnum;
import kd.fi.fa.business.utils.FaAssetBookDataUpgradeLogUtils;
import kd.fi.fa.business.utils.FaPeriodUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.report.util.IntervalCalcUtil;
import kd.fi.fa.report.util.Rpt;

public class FaAssetRecordListQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(FaAssetRecordListQuery.class);
    private static final String algoXalgoKey = "kd.fi.fa.report.query.FaAssetRecordListQuery";
    private String querySelector;
    private String orderSelector;
    private Set<String> otherRealFields = new HashSet<String>(1);
    private static final String ADDRED_METHOD_NAME_ADD_ID = "1455098287437775872";
    private static final String ADDRED_METHOD_NAME_REDUCE_ID = "1455100429317956608";
    private static final Long MERGE_CHANGE_ID = 21L;

    public DataSet queryBatchBy(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection orgDynObjCollection = filterInfo.getDynamicObjectCollection("q_org");
        DynamicObject fdepreUse = filterInfo.getDynamicObject("depreuse");
        DynamicObject fstartPeriod = filterInfo.getDynamicObject("period_start");
        DynamicObject fendPeriod = filterInfo.getDynamicObject("period_end");
        LinkedList<Long> orgIdList = new LinkedList<Long>();
        for (DynamicObject org : orgDynObjCollection) {
            orgIdList.add((Long)org.getPkValue());
        }
        QFilter qOrg = new QFilter("org", "in", orgIdList);
        QFilter qDepreUse = new QFilter("depreuse", "=", fdepreUse.getPkValue());
        String selectAssetBookField = Fa.join((String)",", (String[])new String[]{"id", "startperiod", "curperiod", "org"});
        DynamicObject[] assetBookDynObjArray = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)selectAssetBookField, (QFilter[])new QFilter[]{qOrg, qDepreUse});
        if (assetBookDynObjArray == null || assetBookDynObjArray.length == 0) {
            return this.getEmptyDataSet();
        }
        long queryStartPeriod = (Long)fstartPeriod.getPkValue();
        long queryEndPeriod = (Long)fendPeriod.getPkValue();
        Long[] queryInterval = new Long[]{queryStartPeriod, queryEndPeriod};
        HashMap<Long, Long[]> org2PeriodIntersection = new HashMap<Long, Long[]>(assetBookDynObjArray.length);
        for (DynamicObject assetBookDynObj : assetBookDynObjArray) {
            long orgId2 = (Long)assetBookDynObj.getDynamicObject("org").getPkValue();
            long staPeriod = (Long)assetBookDynObj.getDynamicObject("startperiod").getPkValue();
            long curPeriod = (Long)assetBookDynObj.getDynamicObject("curperiod").getPkValue();
            Long[] assetBookInterval = new Long[]{staPeriod, curPeriod};
            Long[] intersection2 = IntervalCalcUtil.intersection(queryInterval, assetBookInterval);
            if (intersection2 == null) continue;
            org2PeriodIntersection.put(orgId2, intersection2);
        }
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("orgId", (DataType)DataType.LongType), new Field("startPeriod", (DataType)DataType.LongType), new Field("endPeriod", (DataType)DataType.LongType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        org2PeriodIntersection.forEach((orgId, intersection) -> {
            Long startPeriod = intersection[0];
            Long endPeriod = intersection[1];
            dataSetBuilder.append(new Object[]{orgId, startPeriod, endPeriod});
        });
        IReportBatchQueryInfo byBatchInfo = queryParam.byBatchInfo();
        byBatchInfo.setCountPerBatch(1);
        return dataSetBuilder.build();
    }

    public DataSet query(ReportQueryParam queryParam, Object select) throws Throwable {
        return this.query(queryParam, new HashSet<String>(), Boolean.TRUE, Boolean.FALSE);
    }

    private DataSet getEmptyDataSet() {
        RowMeta rowMeta = new RowMeta(new Field[0]);
        DataSetBuilder dataSetBuilder = Algo.create((String)algoXalgoKey).createDataSetBuilder(rowMeta);
        return dataSetBuilder.build();
    }

    public DataSet query(ReportQueryParam param, Set<String> otherFields, Boolean isSum, Boolean isQingQuery) {
        this.otherRealFields.addAll(otherFields);
        FilterInfo filterInfo = param.getFilter();
        ReportBatchQueryInfo byBatchInfo = (ReportBatchQueryInfo)param.byBatchInfo();
        List currentBatchRows = byBatchInfo.getCurrentBatchRows();
        if (currentBatchRows.size() == 0) {
            this.getQueryParam().getCustomParam().put("isNotData", Boolean.TRUE);
            return this.getEmptyDataSet();
        }
        ReportQueryParam queryParam = this.getQueryParam();
        if (Objects.nonNull(queryParam) && queryParam.getCustomParam().size() > 0) {
            this.getQueryParam().getCustomParam().remove("isNotData");
        }
        Long orgId = null;
        Long startPeriod = null;
        Long endPeriod = null;
        DynamicObject fdepreUse = filterInfo.getDynamicObject("depreuse");
        for (Row row : currentBatchRows) {
            orgId = row.getLong(0);
            startPeriod = row.getLong(1);
            endPeriod = row.getLong(2);
        }
        ArrayList<Long> orgList = new ArrayList<Long>();
        if (isQingQuery.booleanValue()) {
            DynamicObjectCollection orgDynObjCollection = filterInfo.getDynamicObjectCollection("q_org");
            for (DynamicObject dynamicObject : orgDynObjCollection) {
                orgId = Long.parseLong(dynamicObject.getPkValue().toString());
                orgList.add(orgId);
            }
            return this.getDataSet(isSum, filterInfo, fdepreUse, startPeriod, endPeriod, orgList);
        }
        return this.getDataSet(isSum, filterInfo, fdepreUse, startPeriod, endPeriod, Collections.singletonList(orgId));
    }

    private DataSet getDataSet(Boolean isSum, FilterInfo filterInfo, DynamicObject fdepreUse, Long startPeriod, Long endPeriod, List<Long> orgList) {
        DataSet result;
        List periodIds = FaPeriodUtils.getPeriodIdByRange((long)startPeriod, (long)endPeriod);
        DataSet[] dataSet = this.queryDataSet(orgList, periodIds, filterInfo, fdepreUse, startPeriod, endPeriod);
        if (isSum.booleanValue()) {
            result = this.operateDataSet(dataSet);
        } else {
            dataSet[0] = dataSet[0].addNullField("aftervalue");
            dataSet[0] = dataSet[0].addNullField("beforevalue");
            dataSet[1] = dataSet[1].addNullField("aftervalue");
            dataSet[1] = dataSet[1].addNullField("beforevalue");
            dataSet[3] = dataSet[3].addNullField("aftervalue");
            dataSet[3] = dataSet[3].addNullField("beforevalue");
            String[] fieldNames = dataSet[0].getRowMeta().getFieldNames();
            dataSet[1] = dataSet[1].select(fieldNames);
            dataSet[2] = dataSet[2].select(fieldNames);
            result = dataSet[0].union(dataSet[1]).union(dataSet[2]).union(dataSet[3]);
            result = this.orderByDs(result);
        }
        return result;
    }

    private DataSet operateDataSet(DataSet[] dataSet) {
        DataSet sumCDataSet = this.querySum(dataSet);
        sumCDataSet = this.orderByDs(sumCDataSet);
        return sumCDataSet;
    }

    private DataSet orderByDs(DataSet sumCDataSet) {
        sumCDataSet = sumCDataSet.orderBy(new String[]{"orgid", "assetcat", "addredmethodtype", "addredmethod", "rowtype", "assetnumber"});
        return sumCDataSet;
    }

    private DataSet querySum(DataSet[] dataSet) {
        DataSet changeAdd = dataSet[2].filter("addredmethodtype = 'ADD'");
        DataSet sumChangeAddDataSet = changeAdd.groupBy(new String[]{"orgid", "currency", "assetcat", "addredmethod"}).sum("fincardid").sum("null", "addredperoid").sum("null", "assetnumber").sum("null", "assetname").sum("assetamount").sum("originalval").sum("0", "accumdepre").sum("networth").sum("decval").sum("netamount").sum("null", "preusingamount").sum("null", "depredamount").sum("null", "remianamount").sum("null", "vouchernumber").sum("null", "voucherids").finish();
        sumChangeAddDataSet = sumChangeAddDataSet.addField("0L", "realcard");
        sumChangeAddDataSet = sumChangeAddDataSet.addField(String.format("'%s'", ChangeModeTypeEnum.ADD.getValue()), "addredmethodtype");
        sumChangeAddDataSet = sumChangeAddDataSet.addField("'2'", "rowtype");
        sumChangeAddDataSet = sumChangeAddDataSet.addField(String.format("'%s'", ResManager.loadKDString((String)"\u589e\u52a0", (String)"FaAssetRecordListQuery_0", (String)"fi-fa-report", (Object[])new Object[0])), "addredtype");
        DataSet changeReduce = dataSet[2].filter("addredmethodtype = 'REDUCE'");
        DataSet sumChangeReduceDataSet = changeReduce.groupBy(new String[]{"orgid", "currency", "assetcat", "addredmethod"}).sum("fincardid").sum("null", "addredperoid").sum("null", "assetnumber").sum("null", "assetname").sum("assetamount").sum("originalval").sum("0", "accumdepre").sum("networth").sum("decval").sum("netamount").sum("null", "preusingamount").sum("null", "depredamount").sum("null", "remianamount").sum("null", "vouchernumber").sum("null", "voucherids").finish();
        sumChangeReduceDataSet = sumChangeReduceDataSet.addField("0L", "realcard");
        sumChangeReduceDataSet = sumChangeReduceDataSet.addField(String.format("'%s'", ChangeModeTypeEnum.REDUCE.getValue()), "addredmethodtype");
        sumChangeReduceDataSet = sumChangeReduceDataSet.addField("'2'", "rowtype");
        sumChangeReduceDataSet = sumChangeReduceDataSet.addField(String.format("'%s'", ResManager.loadKDString((String)"\u51cf\u5c11", (String)"FaAssetRecordListQuery_1", (String)"fi-fa-report", (Object[])new Object[0])), "addredtype");
        DataSet sumADataSet = dataSet[0].groupBy(new String[]{"orgid", "currency", "assetcat", "addredmethod"}).sum("fincardid").sum("null", "addredperoid").sum("null", "assetnumber").sum("null", "assetname").sum("assetamount").sum("originalval").sum("accumdepre").sum("networth").sum("decval").sum("netamount").sum("null", "preusingamount").sum("null", "depredamount").sum("null", "remianamount").sum("null", "vouchernumber").sum("null", "voucherids").finish();
        sumADataSet = sumADataSet.addField("0L", "realcard");
        sumADataSet = sumADataSet.addField(String.format("'%s'", ChangeModeTypeEnum.ADD.getValue()), "addredmethodtype");
        sumADataSet = sumADataSet.addField("'2'", "rowtype");
        sumADataSet = sumADataSet.addField(String.format("'%s'", ResManager.loadKDString((String)"\u589e\u52a0", (String)"FaAssetRecordListQuery_0", (String)"fi-fa-report", (Object[])new Object[0])), "addredtype");
        DataSet sumCDataSet = dataSet[1].groupBy(new String[]{"orgid", "assetcat", "addredmethod", "currency"}).sum("fincardid").sum("null", "addredperoid").sum("null", "assetnumber").sum("null", "assetname").sum("assetamount").sum("originalval").sum("accumdepre").sum("networth").sum("decval").sum("netamount").sum("null", "preusingamount").sum("null", "depredamount").sum("null", "remianamount").sum("null", "vouchernumber").sum("null", "voucherids").finish();
        sumCDataSet = sumCDataSet.addField("0L", "realcard");
        sumCDataSet = sumCDataSet.addField(String.format("'%s'", ChangeModeTypeEnum.REDUCE.getValue()), "addredmethodtype");
        sumCDataSet = sumCDataSet.addField("'2'", "rowtype");
        sumCDataSet = sumCDataSet.addField(String.format("'%s'", ResManager.loadKDString((String)"\u51cf\u5c11", (String)"FaAssetRecordListQuery_1", (String)"fi-fa-report", (Object[])new Object[0])), "addredtype");
        logger.info("dataSet[0]-sumADataSet---------");
        Rpt.getRowMetaLog(dataSet[0], sumADataSet, logger);
        logger.info("dataSet[1]-sumCDataSet---------");
        Rpt.getRowMetaLog(dataSet[1], sumCDataSet, logger);
        DataSet sumRestartDataSet = dataSet[3].groupBy(new String[]{"orgid", "assetcat", "addredmethod", "currency"}).sum("fincardid").sum("null", "addredperoid").sum("null", "assetnumber").sum("null", "assetname").sum("assetamount").sum("originalval").sum("accumdepre").sum("networth").sum("decval").sum("netamount").sum("null", "preusingamount").sum("null", "depredamount").sum("null", "remianamount").sum("null", "vouchernumber").sum("null", "voucherids").finish();
        sumRestartDataSet = sumRestartDataSet.addField("0L", "realcard");
        sumRestartDataSet = sumRestartDataSet.addField(String.format("'%s'", ChangeModeTypeEnum.ADD.getValue()), "addredmethodtype");
        sumRestartDataSet = sumRestartDataSet.addField("'2'", "rowtype");
        sumRestartDataSet = sumRestartDataSet.addField(String.format("'%s'", ResManager.loadKDString((String)"\u589e\u52a0", (String)"FaAssetRecordListQuery_0", (String)"fi-fa-report", (Object[])new Object[0])), "addredtype");
        logger.info("dataSet[3]-sumADataSet---------");
        Rpt.getRowMetaLog(dataSet[3], sumRestartDataSet, logger);
        dataSet[0] = dataSet[0].addNullField("addredtype");
        dataSet[1] = dataSet[1].addNullField("addredtype");
        dataSet[3] = dataSet[3].addNullField("addredtype");
        changeAdd = changeAdd.addNullField("addredtype");
        changeReduce = changeReduce.addNullField("addredtype");
        dataSet[0] = dataSet[0].addNullField("aftervalue");
        dataSet[0] = dataSet[0].addNullField("beforevalue");
        dataSet[1] = dataSet[1].addNullField("aftervalue");
        dataSet[1] = dataSet[1].addNullField("beforevalue");
        dataSet[3] = dataSet[3].addNullField("aftervalue");
        dataSet[3] = dataSet[3].addNullField("beforevalue");
        sumADataSet = sumADataSet.addNullField("aftervalue");
        sumADataSet = sumADataSet.addNullField("beforevalue");
        sumCDataSet = sumCDataSet.addNullField("aftervalue");
        sumCDataSet = sumCDataSet.addNullField("beforevalue");
        sumChangeAddDataSet = sumChangeAddDataSet.addNullField("aftervalue");
        sumChangeAddDataSet = sumChangeAddDataSet.addNullField("beforevalue");
        sumChangeReduceDataSet = sumChangeReduceDataSet.addNullField("aftervalue");
        sumChangeReduceDataSet = sumChangeReduceDataSet.addNullField("beforevalue");
        sumRestartDataSet = sumRestartDataSet.addNullField("aftervalue");
        sumRestartDataSet = sumRestartDataSet.addNullField("beforevalue");
        String[] fieldNames = sumADataSet.getRowMeta().getFieldNames();
        sumADataSet = sumADataSet.select(fieldNames);
        dataSet[0] = dataSet[0].select(fieldNames);
        sumCDataSet = sumCDataSet.select(fieldNames);
        dataSet[1] = dataSet[1].select(fieldNames);
        dataSet[3] = dataSet[3].select(fieldNames);
        sumRestartDataSet = sumRestartDataSet.select(fieldNames);
        sumChangeAddDataSet = sumChangeAddDataSet.select(fieldNames);
        changeAdd = changeAdd.select(fieldNames);
        changeReduce = changeReduce.select(fieldNames);
        DataSet result = sumADataSet.union(dataSet[0]).union(sumCDataSet).union(dataSet[1]).union(changeAdd).union(sumChangeAddDataSet).union(changeReduce).union(sumChangeReduceDataSet).union(dataSet[3]).union(sumRestartDataSet);
        logger.info("result---------");
        Rpt.getRowMetaLog(dataSet[1], null, logger);
        return result;
    }

    public List<QFilter> getFinFilters(List<Long> orgs, List<Long> periodIds, DynamicObject fdepreUse) {
        ArrayList<QFilter> finCardFilters = new ArrayList<QFilter>();
        finCardFilters.add(new QFilter("org", "in", orgs));
        finCardFilters.add(new QFilter("bizperiod", "in", periodIds));
        finCardFilters.add(new QFilter("depreuse", "in", fdepreUse.getPkValue()));
        finCardFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        return finCardFilters;
    }

    public List<QFilter> getClearBillFilters(List<Long> orgs, DynamicObject depreuse, List<Long> periodIds) {
        ArrayList<QFilter> clearBillFilters = new ArrayList<QFilter>();
        QFilter cStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter cDepreuseFilter = new QFilter("detail_entry.depreuse", "=", depreuse.getPkValue());
        QFilter cFilter = new QFilter("org", "in", orgs);
        QFilter clearFilter = new QFilter("clearperiod", "in", periodIds);
        QFilter cmergeCardFilter = new QFilter("changemode", "!=", (Object)MERGE_CHANGE_ID);
        clearBillFilters.add(cStatusFilter);
        clearBillFilters.add(cDepreuseFilter);
        clearBillFilters.add(cFilter);
        clearBillFilters.add(clearFilter);
        clearBillFilters.add(cmergeCardFilter);
        return clearBillFilters;
    }

    public List<QFilter> getRestartBillFilters(List<Long> orgs, DynamicObject depreuse, List<Long> periodIds) {
        ArrayList<QFilter> restartBillFilters = new ArrayList<QFilter>();
        QFilter cStatusFilter = new QFilter("billstatus", "=", (Object)"C");
        QFilter cDepreuseFilter = new QFilter("restartentity.entitydepreuse", "=", depreuse.getPkValue());
        QFilter cFilter = new QFilter("org", "in", orgs);
        QFilter restartFilter = new QFilter("restartperiod", "in", periodIds);
        restartBillFilters.add(cStatusFilter);
        restartBillFilters.add(cDepreuseFilter);
        restartBillFilters.add(cFilter);
        restartBillFilters.add(restartFilter);
        return restartBillFilters;
    }

    private QFilter getSourceFlagsFilters(FilterInfo filterInfo) {
        QFilter qFilter = null;
        ArrayList<String> sourceflags = new ArrayList<String>();
        boolean showDispatch = (Boolean)filterInfo.getFilterItem("showdispatch").getValue();
        if (!showDispatch) {
            sourceflags.add("DISPATCH");
        }
        sourceflags.add("SPLIT");
        if (sourceflags.size() > 0) {
            qFilter = new QFilter("realcard.sourceflag", "not in", sourceflags);
        }
        return qFilter;
    }

    private QFilter getRealSourceFlagsFilters(FilterInfo filterInfo) {
        QFilter qFilter = null;
        ArrayList<String> sourceflags = new ArrayList<String>();
        boolean showDispatch = (Boolean)filterInfo.getFilterItem("showdispatch").getValue();
        if (!showDispatch) {
            sourceflags.add("DISPATCH");
        }
        if (sourceflags.size() > 0) {
            qFilter = new QFilter("sourceflag", "not in", sourceflags);
        }
        return qFilter;
    }

    private DataSet[] queryDataSet(List<Long> orgs, List<Long> periodIds, FilterInfo filterInfo, DynamicObject depreUse, Long startPeriod, Long endPeriod) {
        List<QFilter> finCardFilters = this.getFinFilters(orgs, periodIds, depreUse);
        List<QFilter> clearBillFilters = this.getClearBillFilters(orgs, depreUse, periodIds);
        List<QFilter> restartBillFilters = this.getRestartBillFilters(orgs, depreUse, periodIds);
        List<QFilter> changeBillFilterList = this.getChangeBillFilter(orgs, depreUse, startPeriod, endPeriod);
        Map<Date, Long> periodStartDateReversedAndPeriodIdMap = this.getPeriodStartDateReversedAndPeriodIdMap(startPeriod, endPeriod);
        Map commFilter = filterInfo.getCommFilter();
        QFilter qFilter = (QFilter)commFilter.get("fa_card_fin");
        if (Objects.nonNull(qFilter)) {
            finCardFilters.add(qFilter);
            String qFilterStr = qFilter.toString();
            String qFilterStrReplace = qFilterStr.replace("realcard", "fa_change_dept.fieldentry.realcard1").replace("number", "fa_change_dept.fieldentry.realcard1.number");
            changeBillFilterList.add(QFilter.of((String)qFilterStrReplace, (Object[])new Object[0]));
            String qFilterStrReplaceClearBillFilter = qFilterStr.replace("realcard", "detail_entry.realcard").replace("number", "detail_entry.realcard.number");
            clearBillFilters.add(QFilter.of((String)qFilterStrReplaceClearBillFilter, (Object[])new Object[0]));
            String qFilterStrReplaceStartBillFilter = qFilterStr.replace("realcard", Fa.dot((String[])new String[]{"restartentity", "realcard"})).replace("number", Fa.dot((String[])new String[]{"restartentity", "realcard", "number"}));
            restartBillFilters.add(QFilter.of((String)qFilterStrReplaceStartBillFilter, (Object[])new Object[0]));
        }
        finCardFilters.add(this.getSourceFlagsFilters(filterInfo));
        QFilter[] filters = finCardFilters.toArray(new QFilter[0]);
        QFilter addFilter = new QFilter("realcard.originmethod.type", "=", (Object)ChangeModeTypeEnum.ADD);
        QFilter addFilter2 = QFilter.of((String)"bizperiod.id = period.id", (Object[])new Object[0]);
        finCardFilters.add(addFilter);
        finCardFilters.add(addFilter2);
        boolean enableCurPeriodSplit = FaAssetBookDataUpgradeLogUtils.enableCurPeriodSplitByOrgId(orgs);
        if (enableCurPeriodSplit) {
            finCardFilters.add(new QFilter("originaldata", "=", (Object)true));
        } else {
            finCardFilters.add(new QFilter("originaldata", "=", (Object)Boolean.FALSE));
        }
        QFilter[] addFilters = finCardFilters.toArray(new QFilter[0]);
        return this.getDataSet(periodIds, filters, addFilters, clearBillFilters, (Long)depreUse.getPkValue(), orgs, filterInfo, changeBillFilterList, periodStartDateReversedAndPeriodIdMap, restartBillFilters);
    }

    private List<QFilter> getChangeBillFilter(List<Long> orgs, DynamicObject depreUse, Long periodIdStart, Long periodIdEnd) {
        ArrayList<QFilter> finCardFilters = new ArrayList<QFilter>();
        finCardFilters.add(new QFilter("org", "in", orgs));
        finCardFilters.add(new QFilter("fieldentry.depreuse1", "in", depreUse.getPkValue()));
        finCardFilters.add(new QFilter("billstatus", "=", (Object)"C"));
        finCardFilters.add(new QFilter("fieldentry.field", "=", (Object)"fa_card_fin.originalval"));
        DynamicObject periodStart = FaBaseDaoFactory.getInstance((String)"bd_period").queryOne((Object)periodIdStart);
        DynamicObject periodEnd = FaBaseDaoFactory.getInstance((String)"bd_period").queryOne((Object)periodIdEnd);
        finCardFilters.add(new QFilter("changedate", ">=", (Object)periodStart.getDate("begindate")));
        finCardFilters.add(new QFilter("changedate", "<=", (Object)periodEnd.getDate("enddate")));
        return finCardFilters;
    }

    private Map<Date, Long> getPeriodStartDateReversedAndPeriodIdMap(Long periodIdStart, Long periodIdEnd) {
        ArrayList<QFilter> periodFilters = new ArrayList<QFilter>(2);
        QFilter periodIdStartFilter = new QFilter("id", ">=", (Object)periodIdStart);
        QFilter periodIdEndFilter = new QFilter("id", "<=", (Object)periodIdEnd);
        periodFilters.add(periodIdStartFilter);
        periodFilters.add(periodIdEndFilter);
        DynamicObject[] periodDynObjArr = FaBaseDaoFactory.getInstance((String)"bd_period").query(periodFilters.toArray(new QFilter[0]));
        HashMap<Date, Long> map = new HashMap<Date, Long>(16);
        for (DynamicObject periodDyn : periodDynObjArr) {
            Date date = periodDyn.getDate("begindate");
            Long pkValue = (Long)periodDyn.getPkValue();
            map.put(date, pkValue);
        }
        return map.entrySet().stream().sorted(Map.Entry.comparingByValue().reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (oldVal, newVal) -> oldVal, LinkedHashMap::new));
    }

    private DataSet[] getDataSet(List<Long> periodIds, QFilter[] finCardFilters, QFilter[] addFilters, List<QFilter> clearBillFilters, Long fdepreUse, List<Long> orgIds, FilterInfo filterInfo, List<QFilter> changeBillFilterList, Map<Date, Long> periodStartDateReversedAndPeriodIdMap, List<QFilter> restartBillFilters) {
        this.querySelector = this.getSelectFields();
        this.orderSelector = this.getOrderFields();
        String qingFeild = this.getQingFeilds(this.otherRealFields);
        String[] orderVoucher = (qingFeild + this.orderSelector + ",vouchernumber,voucherids,addredmethod,addredmethodname,realcard,addredmethodtype").split(",");
        DataSet addQueryDs = this.getAddDataSet(addFilters);
        logger.info("\u6dfb\u52a0\u7684\u8d22\u52a1\u5361\u7247-----------");
        Rpt.getRowMetaLog(addQueryDs, null, logger);
        DataSet vQueryDs = this.getVoucherDataSet(orgIds, periodIds);
        DataSet vQueryDsFromFaCardFin = this.getVoucherDataSetFromFaCardFin(orgIds, periodIds);
        DataSet addResult = this.getAddDataSet(addQueryDs, vQueryDsFromFaCardFin, orderVoucher);
        DataSet queryDs = this.getFinDataSet(finCardFilters);
        DataSet clearQueryDs = this.getClearAndRestartDataSet(clearBillFilters, fdepreUse, orgIds, filterInfo, restartBillFilters, "clearBillFilters");
        DataSet clearResult = this.getDeDataSet(queryDs, clearQueryDs, vQueryDs, orderVoucher);
        DataSet restartQueryDs = this.getClearAndRestartDataSet(clearBillFilters, fdepreUse, orgIds, filterInfo, restartBillFilters, "restartBillFilters");
        DataSet restartResult = this.getDeDataSet(queryDs, restartQueryDs, vQueryDs, orderVoucher);
        DataSet changeBillDataSet = this.getChangeBillDataSet(changeBillFilterList, vQueryDs, periodStartDateReversedAndPeriodIdMap);
        return new DataSet[]{addResult, clearResult, changeBillDataSet, restartResult};
    }

    private DataSet getChangeBillDataSet(List<QFilter> changeBillFilterList, DataSet vQueryDs, Map<Date, Long> periodStartDateReversedAndPeriodIdMap) {
        String joinQingFieldStr = "";
        if (!this.otherRealFields.isEmpty()) {
            String qingFeild = this.getQingFeilds(this.otherRealFields);
            String[] split = qingFeild.split(",");
            ArrayList<String> qingFeildList = new ArrayList<String>(split.length);
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
            Set faFinCardFieldSet = dataEntityType.getFields().keySet();
            for (String s : split) {
                if (faFinCardFieldSet.contains(s)) {
                    qingFeildList.add("fa_change_dept.fieldentry.fincard1." + s + " " + s);
                    continue;
                }
                qingFeildList.add(s.replace("realcard", "fa_change_dept.fieldentry.realcard1") + " " + s);
            }
            String join = String.join((CharSequence)", ", qingFeildList);
            joinQingFieldStr = join + ",";
        }
        DataSet changeBillDataSet = QueryServiceHelper.queryDataSet((String)algoXalgoKey, (String)"fa_change_dept", (String)(joinQingFieldStr + " id,  org orgid, changedate addredperoid, fa_change_dept.fieldentry.realcard1 realcard, fa_change_dept.fieldentry.realcard1.assetcat assetcat, fa_change_dept.fieldentry.realcard1.assetname assetname, fa_change_dept.fieldentry.realcard1.number assetnumber, fa_change_dept.fieldentry.realcard1.assetamount assetamount, fa_change_dept.fieldentry.basecurrency1 currency, fa_change_dept.fieldentry.fincard1 fincardid, fa_change_dept.fieldentry.aftervalue aftervalue, fa_change_dept.fieldentry.beforevalue beforevalue, 0 accumdepre, 0 decval, fa_change_dept.fieldentry.fincard1.preusingamount preusingamount, fa_change_dept.fieldentry.fincard1.depredamount depredamount"), (QFilter[])changeBillFilterList.toArray(new QFilter[0]), null);
        String addredmethodtype = "case when cast(beforevalue as decimal) > cast(aftervalue as decimal) then 'REDUCE' when cast(beforevalue as decimal) < cast(aftervalue as decimal)  then 'ADD' else '' end";
        changeBillDataSet = changeBillDataSet.addField(addredmethodtype, "addredmethodtype");
        String addredmethod = "case when cast(beforevalue as decimal) > cast(aftervalue as decimal) then 1455098287437775872 when cast(beforevalue as decimal) < cast(aftervalue as decimal) then 1455100429317956608 else null end";
        changeBillDataSet = changeBillDataSet.addField(addredmethod, "addredmethod");
        changeBillDataSet = changeBillDataSet.addField("abs(cast(aftervalue as decimal) - cast(beforevalue as decimal))", "originalval");
        changeBillDataSet = changeBillDataSet.addField("abs(cast(aftervalue as decimal) - cast(beforevalue as decimal))", "networth");
        changeBillDataSet = changeBillDataSet.addField("abs(cast(aftervalue as decimal) - cast(beforevalue as decimal))", "netamount");
        changeBillDataSet = changeBillDataSet.addField("preusingamount - depredamount", "remianamount");
        DataSet faChangeModeBaseDataNameDataSet = this.getFaChangeModeBaseDataNameDataSet();
        changeBillDataSet = changeBillDataSet.leftJoin(faChangeModeBaseDataNameDataSet).on("addredmethod", "fachangemodeid").select(changeBillDataSet.getRowMeta().getFieldNames(), new String[]{"addredmethodname"}).finish();
        DataSet changeBillIdAndPeriodIdDS = this.getChangeBillIdAndPeriodIdDS(periodStartDateReversedAndPeriodIdMap, changeBillDataSet);
        changeBillDataSet = changeBillDataSet.leftJoin(changeBillIdAndPeriodIdDS).on("id", "id").select(changeBillDataSet.getRowMeta().getFieldNames(), new String[]{"periodId"}).finish();
        changeBillDataSet = changeBillDataSet.leftJoin(vQueryDs).on("id", "sourcebillid").on("periodId", "periodid").select(changeBillDataSet.getRowMeta().getFieldNames(), new String[]{"vouchernumber", "voucherids"}).finish();
        changeBillDataSet = changeBillDataSet.addField("'1'", "rowtype");
        return changeBillDataSet;
    }

    private DataSet getChangeBillIdAndPeriodIdDS(Map<Date, Long> periodStartDateReversedAndPeriodIdMap, DataSet changeBillDataSet) {
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("id", (DataType)DataType.LongType), new Field("periodId", (DataType)DataType.LongType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        block0: for (Row row : changeBillDataSet.copy()) {
            Date addredperoid = row.getDate("addredperoid");
            if (Objects.isNull(addredperoid)) continue;
            for (Map.Entry<Date, Long> map : periodStartDateReversedAndPeriodIdMap.entrySet()) {
                Date key = map.getKey();
                if (!addredperoid.after(key) && addredperoid.compareTo(key) != 0) continue;
                Long id = row.getLong("id");
                Long value = map.getValue();
                dataSetBuilder.append(new Object[]{id, value});
                continue block0;
            }
        }
        return dataSetBuilder.build().distinct();
    }

    private DataSet getFaChangeModeBaseDataNameDataSet() {
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        QFilter qFilter = new QFilter("id", "in", Arrays.asList(Long.parseLong(ADDRED_METHOD_NAME_ADD_ID), Long.parseLong(ADDRED_METHOD_NAME_REDUCE_ID)));
        String entityID = "fa_changemode";
        String selectFields = "id, name";
        DynamicObjectCollection dynamicObjectCollection = BaseDataServiceHelper.queryBaseData((String)entityID, (Long)rootOrgId, (QFilter)qFilter, (String)selectFields);
        String faChangemodeIdField = "fachangemodeid";
        String addRedmethodNameField = "addredmethodname";
        RowMeta rowMeta = new RowMeta(new Field[]{new Field(faChangemodeIdField, (DataType)DataType.LongType), new Field(addRedmethodNameField, (DataType)DataType.StringType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)algoXalgoKey).createDataSetBuilder(rowMeta);
        if (dynamicObjectCollection.isEmpty()) {
            return dataSetBuilder.build();
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            Object[] object = new Object[]{dynamicObject.get("id"), dynamicObject.get("name")};
            dataSetBuilder.append(object);
        }
        return dataSetBuilder.build();
    }

    private DataSet getDeDataSet(DataSet queryDs, DataSet clearQueryDs, DataSet vQueryDs, String[] orderVoucher) {
        clearQueryDs = clearQueryDs.join(queryDs, JoinType.LEFT).on("fincardid", "fincardid").select(new String[]{"id", "addredmethod", "addredmethodtype", "fincardid", "realcard", "addredperoid", "originalval", "accumdepre", "networth", "decval", "netamount", "depredamount", "assetamount", "addredmethodname", "orgid", "currency", "period"}, (this.getQingFeilds(this.otherRealFields) + "assetcat,assetnumber,assetname,preusingamount,preusingamount-depredamount remianamount").split(",")).finish();
        DataSet deFinVoucher = clearQueryDs.join(vQueryDs, JoinType.LEFT).on("id", "sourcebillid").on("period", "periodid").select(orderVoucher).finish();
        deFinVoucher = deFinVoucher.addField("'1'", "rowtype");
        return deFinVoucher;
    }

    private DataSet getAddDataSet(DataSet addQueryDs, DataSet vQueryDsFromFaCardFin, String[] orderVoucher) {
        DataSet addVoucher = addQueryDs.join(vQueryDsFromFaCardFin, JoinType.LEFT).on("assetnumber", "assetnumber").on("period", "periodid").select(orderVoucher).finish();
        addVoucher = addVoucher.addField("'1'", "rowtype");
        return addVoucher;
    }

    private DataSet getClearAndRestartDataSet(List<QFilter> clearBillFilters, Long fdepreUse, List<Long> orgIds, FilterInfo filterInfo, List<QFilter> restartBillFilters, String forPurpose) {
        boolean showDispatch;
        HashMap<String, String> finQingFieldMap = new HashMap<String, String>(16);
        HashSet<String> finAliasFields = new HashSet<String>(16);
        HashMap<String, String> realQingFieldMap = new HashMap<String, String>(16);
        HashSet<String> realAliasFields = new HashSet<String>(16);
        if (!this.otherRealFields.isEmpty()) {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_card_fin");
            Set faFinCardFieldSet = dataEntityType.getFields().keySet();
            for (String field : this.otherRealFields) {
                if (faFinCardFieldSet.contains(field)) {
                    finQingFieldMap.put(field, field);
                    finAliasFields.add(field);
                    continue;
                }
                realQingFieldMap.put(field.replace("realcard.", ""), field);
                realAliasFields.add(field);
            }
        }
        if (!(showDispatch = ((Boolean)filterInfo.getFilterItem("showdispatch").getValue()).booleanValue())) {
            clearBillFilters.add(new QFilter("clearsource", "!=", (Object)"DISPATCH"));
        }
        DataSet cDs = null;
        cDs = forPurpose.equals("clearBillFilters") ? QueryServiceHelper.queryDataSet((String)algoXalgoKey, (String)"fa_clearbill", (String)"id,billstatus,changemode addredmethod, changemode.type addredmethodtype,detail_entry.realcard.masterid realcardid,cleardate addredperoid, detail_entry.assetvalue originalval, detail_entry.addupdepre accumdepre, detail_entry.assetvalue-detail_entry.addupdepre networth, detail_entry.decval decval, detail_entry.netamount netamount, detail_entry.clearqty assetamount,changemode.name addredmethodname,detail_entry.realcard.org orgid, clearperiod period ", (QFilter[])clearBillFilters.toArray(new QFilter[0]), null) : QueryServiceHelper.queryDataSet((String)algoXalgoKey, (String)"fa_restartrealbill", (String)"id,billstatus,addchangemode addredmethod, addchangemode.type addredmethodtype,restartentity.realcard.masterid realcardid,restartdate addredperoid, restartentity.restassetvalue originalval, restartentity.restaddupdepre accumdepre, restartentity.restassetvalue-restartentity.restaddupdepre networth, restartentity.restdecval decval, restartentity.restassetvalue-restartentity.restaddupdepre-restartentity.restdecval netamount, restartentity.restclearqty assetamount,addchangemode.name addredmethodname,org orgid, restartperiod period ", (QFilter[])restartBillFilters.toArray(new QFilter[0]), null);
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter realSourceFlagsFilters = this.getRealSourceFlagsFilters(filterInfo);
        QFilter depreUseFilter = new QFilter("depreuse", "=", (Object)fdepreUse);
        String realQueryFields = "masterid, id realcardid";
        if (realQingFieldMap != null && !realQingFieldMap.isEmpty()) {
            StringBuilder qingFields = new StringBuilder();
            boolean i = false;
            for (Map.Entry entry : realQingFieldMap.entrySet()) {
                if (!i) {
                    qingFields.append(",");
                }
                qingFields.append((String)entry.getKey());
                qingFields.append(" ");
                qingFields.append((String)entry.getValue());
            }
            realQueryFields = realQueryFields + qingFields;
        }
        DataSet realCardDs = QueryServiceHelper.queryDataSet((String)algoXalgoKey, (String)"fa_card_real", (String)realQueryFields, (QFilter[])new QFilter[]{orgFilter, realSourceFlagsFilters}, null);
        String finQueryFields = "id fincardid, realcard.id realcardid, bizperiod, endperiod";
        if (finQingFieldMap != null && !finQingFieldMap.isEmpty()) {
            StringBuilder qingFields = new StringBuilder();
            boolean i = false;
            for (Map.Entry entry : finQingFieldMap.entrySet()) {
                if (!i) {
                    qingFields.append(",");
                }
                qingFields.append((String)entry.getKey());
                qingFields.append(" ");
                qingFields.append((String)entry.getValue());
            }
            finQueryFields = finQueryFields + qingFields;
        }
        DataSet finCardDs = QueryServiceHelper.queryDataSet((String)algoXalgoKey, (String)"fa_card_fin", (String)finQueryFields, (QFilter[])new QFilter[]{orgFilter, depreUseFilter}, null);
        String realDataSetReturnFields = "realcardid";
        if (CollectionUtils.isNotEmpty(realAliasFields)) {
            realDataSetReturnFields = Fa.comma((String[])new String[]{realDataSetReturnFields, realAliasFields.stream().collect(Collectors.joining(","))});
        }
        cDs = cDs.join(realCardDs, JoinType.FULL).on("realcardid", "masterid").select("id,billstatus,addredmethod, addredmethodtype,addredperoid,originalval, accumdepre,networth,decval,netamount, assetamount, addredmethodname,orgid,period".split(","), realDataSetReturnFields.split(",")).finish();
        String finDataSetReturnFields = "fincardid, bizperiod, endperiod";
        if (CollectionUtils.isNotEmpty(finAliasFields)) {
            finDataSetReturnFields = Fa.comma((String[])new String[]{finDataSetReturnFields, finAliasFields.stream().collect(Collectors.joining(","))});
        }
        cDs = cDs.join(finCardDs, JoinType.INNER).on("realcardid", "realcardid").select("id,billstatus,addredmethod, addredmethodtype,addredperoid,originalval, accumdepre,networth,decval,netamount, assetamount, addredmethodname,orgid,period".split(","), finDataSetReturnFields.split(",")).finish();
        cDs = cDs.filter("bizperiod <= period and period < endperiod");
        return cDs;
    }

    private DataSet getFinDataSet(QFilter[] finCardFilters) {
        DataSet fDs = QueryServiceHelper.queryDataSet((String)algoXalgoKey, (String)"fa_card_fin", (String)(this.getQingFeilds(this.otherRealFields) + this.querySelector), (QFilter[])finCardFilters, null);
        return fDs;
    }

    private DataSet getVoucherDataSetFromFaCardFin(List<Long> orgIds, List<Long> periodIds) {
        HashSet<String> billTypeSet = new HashSet<String>(1);
        billTypeSet.add("fa_card_fin");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT ai.FPERIODID AS periodid, cf.fnumber AS assetnumber, gl.FNUMBER AS vouchernumber, gl.FID AS voucherid FROM t_ai_daptracker ai LEFT JOIN t_gl_voucher gl ON ai.fvoucherid = gl.FID LEFT JOIN t_fa_card_fin cf ON cf.fid = ai.FSOURCEBILLID WHERE ", new Object[0]);
        sqlBuilder.appendIn("ai.forgid ", orgIds.toArray());
        sqlBuilder.appendIn("AND ai.FPERIODID ", periodIds.toArray());
        sqlBuilder.appendIn("AND ai.fbilltype ", billTypeSet.toArray());
        DataSet dataSet = DB.queryDataSet((String)algoXalgoKey, (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("periodid", (DataType)DataType.LongType), new Field("assetnumber", (DataType)DataType.StringType), new Field("vouchernumber", (DataType)DataType.StringType), new Field("voucherids", (DataType)DataType.StringType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        if (dataSet.isEmpty()) {
            return dataSetBuilder.build();
        }
        HashMap<String, Set> map = new HashMap<String, Set>(16);
        for (Row row : dataSet) {
            Long periodId = row.getLong("periodid");
            String assetNumber = row.getString("assetnumber");
            String voucherId = row.getString("voucherid");
            String voucherNumber = row.getString("vouchernumber");
            String key = periodId + "_" + assetNumber;
            HashSet<String> voucherNumberAndIdSet = (HashSet<String>)map.get(key);
            if (Objects.isNull(voucherNumberAndIdSet)) {
                voucherNumberAndIdSet = new HashSet<String>(16);
            }
            String value = voucherId + "_" + voucherNumber;
            voucherNumberAndIdSet.add(value);
            map.put(key, voucherNumberAndIdSet);
        }
        map.forEach((k, v) -> {
            String[] kArray = k.split("_");
            String periodId = kArray[0];
            String assetNumber = kArray[1];
            HashSet<String> voucherNumberSet = new HashSet<String>(16);
            HashSet<String> voucherIdSet = new HashSet<String>(16);
            for (String voucherNumberAndIdSet : v) {
                String[] vArray = voucherNumberAndIdSet.split("_");
                String voucherId = vArray[0];
                String voucherNumber = vArray[1];
                voucherIdSet.add(voucherId);
                voucherNumberSet.add(voucherNumber);
            }
            dataSetBuilder.append(new Object[]{Long.parseLong(periodId), assetNumber, String.join((CharSequence)",", voucherNumberSet), String.join((CharSequence)",", voucherIdSet)});
        });
        return dataSetBuilder.build();
    }

    private DataSet getVoucherDataSet(List<Long> orgIds, List<Long> periodIds) {
        HashSet<String> billTypeSet = new HashSet<String>(3);
        billTypeSet.add("fa_change_dept");
        billTypeSet.add("fa_clearbill");
        billTypeSet.add("fa_asset_devalue");
        billTypeSet.add("fa_restartrealbill");
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("SELECT ai.FPERIODID AS periodid, ai.FSOURCEBILLID AS sourcebillid, gl.FNUMBER AS vouchernumber, gl.FID AS voucherid FROM t_ai_daptracker ai LEFT JOIN t_gl_voucher gl ON ai.fvoucherid = gl.FID WHERE ", new Object[0]);
        sqlBuilder.appendIn("ai.forgid ", orgIds.toArray());
        sqlBuilder.appendIn("AND ai.FPERIODID ", periodIds.toArray());
        sqlBuilder.appendIn("AND ai.fbilltype ", billTypeSet.toArray());
        DataSet dataSet = DB.queryDataSet((String)algoXalgoKey, (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sqlBuilder);
        RowMeta rowMeta = new RowMeta(new Field[]{new Field("periodid", (DataType)DataType.LongType), new Field("sourcebillid", (DataType)DataType.LongType), new Field("vouchernumber", (DataType)DataType.StringType), new Field("voucherids", (DataType)DataType.StringType)});
        DataSetBuilder dataSetBuilder = Algo.create((String)((Object)((Object)this)).getClass().getName()).createDataSetBuilder(rowMeta);
        if (dataSet.isEmpty()) {
            return dataSetBuilder.build();
        }
        HashMap<String, Set> map = new HashMap<String, Set>(16);
        for (Row row : dataSet) {
            Long periodId = row.getLong("periodid");
            Long sourceBillId = row.getLong("sourcebillid");
            String voucherId = row.getString("voucherid");
            String voucherNumber = row.getString("vouchernumber");
            String key = periodId + "_" + sourceBillId;
            HashSet<String> voucherNumberAndIdSet = (HashSet<String>)map.get(key);
            if (Objects.isNull(voucherNumberAndIdSet)) {
                voucherNumberAndIdSet = new HashSet<String>(16);
            }
            String value = voucherId + "_" + voucherNumber;
            voucherNumberAndIdSet.add(value);
            map.put(key, voucherNumberAndIdSet);
        }
        map.forEach((k, v) -> {
            String[] kArray = k.split("_");
            String periodId = kArray[0];
            String sourceBillId = kArray[1];
            HashSet<String> voucherNumberSet = new HashSet<String>(16);
            HashSet<String> voucherIdSet = new HashSet<String>(16);
            for (String voucherNumberAndIdSet : v) {
                String[] vArray = voucherNumberAndIdSet.split("_");
                String voucherId = vArray[0];
                String voucherNumber = vArray[1];
                voucherIdSet.add(voucherId);
                voucherNumberSet.add(voucherNumber);
            }
            dataSetBuilder.append(new Object[]{Long.parseLong(periodId), Long.parseLong(sourceBillId), String.join((CharSequence)",", voucherNumberSet), String.join((CharSequence)",", voucherIdSet)});
        });
        return dataSetBuilder.build();
    }

    private DataSet getAddDataSet(QFilter[] addFilters) {
        DataSet addDs = QueryServiceHelper.queryDataSet((String)algoXalgoKey, (String)"fa_card_fin", (String)(this.getQingFeilds(this.otherRealFields) + this.querySelector), (QFilter[])addFilters, null);
        HashSet<Long> realCardIdSet = new HashSet<Long>(16);
        for (Row row : addDs.copy()) {
            realCardIdSet.add(row.getLong("realcard"));
        }
        QFilter[] filters = new QFilter[]{new QFilter("detail_entry.realcard", "in", realCardIdSet), new QFilter("detail_entry.isclearall", "=", (Object)"2"), new QFilter("billstatus", "=", (Object)"C")};
        String selectFields = "detail_entry.realcard realcardid, detail_entry.clearqty clearqty";
        DataSet partClearDs = QueryServiceHelper.queryDataSet((String)algoXalgoKey, (String)"fa_clearbill", (String)selectFields, (QFilter[])filters, null);
        partClearDs = partClearDs.groupBy(new String[]{"realcardid"}).sum("clearqty").finish();
        String joinAddDsFields = this.getQingFeilds(this.otherRealFields) + "orgid,currency,fincardid,realcard,assetcat,addredmethod,addredmethodname,addredmethodtype,addredperoid,assetnumber,assetname,assetamount,originalval,accumdepre,networth,decval,netamount,preusingamount,depredamount,period";
        String joinPartClearDsFields = "realcardid,clearqty";
        addDs = addDs.join(partClearDs, JoinType.LEFT).on("realcard", "realcardid").select(joinAddDsFields.split(","), joinPartClearDsFields.split(",")).finish();
        String mergeFields = this.getQingFeilds(this.otherRealFields) + "orgid,currency,fincardid, realcard, assetcat, addredmethod,addredmethodname, addredmethodtype, addredperoid, assetnumber, assetname, assetamount + clearqty assetamount, originalval, accumdepre, networth, decval, netamount, preusingamount, depredamount, period";
        addDs = addDs.select(mergeFields);
        addDs.addField("0", "remianamount");
        return addDs;
    }

    private String getSelectFields() {
        LinkedHashSet<String> querySet = new LinkedHashSet<String>(20);
        querySet.add("id fincardid,");
        querySet.add("realcard.org orgid,");
        querySet.add("assetbook.basecurrency currency,");
        querySet.add("realcard realcard,");
        querySet.add("assetcat.masterid assetcat,");
        querySet.add("realcard.originmethod addredmethod,");
        querySet.add("realcard.originmethod.type addredmethodtype,");
        querySet.add("realcard.originmethod.name addredmethodname,");
        querySet.add("finaccountdate addredperoid,");
        querySet.add("realcard.number assetnumber,");
        querySet.add("realcard.assetname assetname,");
        querySet.add("realcard.assetamount assetamount,");
        querySet.add("case when init_originalval = -1 then originalval else init_originalval end originalval,");
        querySet.add("accumdepre accumdepre,");
        querySet.add("networth networth,");
        querySet.add("decval decval,");
        querySet.add("netamount netamount,");
        querySet.add("PREUSINGAMOUNT preusingamount,");
        querySet.add("depredamount depredamount,");
        querySet.add("period period");
        StringBuilder tempStr = new StringBuilder(querySet.size());
        for (String field : querySet) {
            tempStr.append(field);
        }
        return tempStr.toString();
    }

    private String getOrderFields() {
        StringBuilder tempStr = new StringBuilder(14);
        tempStr.append("assetcat,");
        tempStr.append("fincardid,");
        tempStr.append("orgid,");
        tempStr.append("currency,");
        tempStr.append("addredperoid,");
        tempStr.append("assetnumber,");
        tempStr.append("assetname,");
        tempStr.append("assetamount,");
        tempStr.append("originalval,");
        tempStr.append("accumdepre,");
        tempStr.append("networth,");
        tempStr.append("decval,");
        tempStr.append("netamount,");
        tempStr.append("preusingamount,");
        tempStr.append("depredamount,");
        tempStr.append("preusingamount-depredamount remianamount");
        return tempStr.toString();
    }

    private String getQingFeilds(Set<String> otherRealFields) {
        StringBuilder tempStr = new StringBuilder();
        for (String feild : otherRealFields) {
            tempStr.append(feild);
            tempStr.append(",");
        }
        return tempStr.toString();
    }
}

