/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.fi.fa.business.utils.FaBizUtils;
import kd.fi.fa.business.utils.FaPermissionUtils;
import kd.fi.fa.common.util.Fa;

public class FaBlocListQuery
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(FaBlocListQuery.class);
    private static final String algoXalgoKey = "kd.fi.fa.report.query.FaBlocListQuery";
    private String pageId = null;

    private DataSet getEmptyDataSet() {
        RowMeta rowMeta = new RowMeta(new Field[0]);
        DataSetBuilder dataSetBuilder = Algo.create((String)algoXalgoKey).createDataSetBuilder(rowMeta);
        return dataSetBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    public DataSet query(ReportQueryParam param, Object obj) throws Throwable {
        DataSet allDataSet;
        DataSet dataSet = null;
        FilterInfo filterInfo = param.getFilter();
        this.pageId = String.valueOf(param.getCustomParam().get("pageId"));
        boolean showasset = (Boolean)filterInfo.getFilterItem("showasset").getValue();
        DynamicObject searchPeriod = filterInfo.getDynamicObject("q_period");
        DynamicObject nowDepreuse = filterInfo.getDynamicObject("depreuse");
        Long nowDepreusePk = (Long)nowDepreuse.getPkValue();
        Long searchPeriodPk = (Long)searchPeriod.getPkValue();
        long lastPeriodPk = this.getLastYearPeriod(searchPeriod);
        DynamicObjectCollection orgDynObjList = filterInfo.getDynamicObjectCollection("q_org_multiple");
        ArrayList<Long> orgIds = new ArrayList<Long>(orgDynObjList.size());
        for (DynamicObject orgDynObj : orgDynObjList) {
            orgIds.add((Long)orgDynObj.getPkValue());
        }
        QFilter qOrg = new QFilter("org", "in", orgIds);
        QFilter qDepreuse = new QFilter("depreuse", "=", (Object)nowDepreusePk);
        String selectAssetBookField = Fa.join((String)",", (String[])new String[]{"id", "basecurrency", "periodtype", "curperiod", "startperiod", "org"});
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)selectAssetBookField, (QFilter[])new QFilter[]{qOrg, qDepreuse});
        DynamicObject[] assetBooks = objectDynamicObjectMap.values().toArray(new DynamicObject[0]);
        HashSet<Long> currencyPks = new HashSet<Long>(16);
        HashMap<Long, Long> assetBookOrg2FinalQueryPeriodMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> assetBookOrg2FinalQueryLastPeriodMap = new HashMap<Long, Long>(16);
        HashMap<Long, Object> assetBookOrg2AssetBookMap = new HashMap<Long, Object>(16);
        for (DynamicObject assetBook : assetBooks) {
            long l = (Long)assetBook.getDynamicObject("org").getPkValue();
            long curPeriod = (Long)assetBook.getDynamicObject("curperiod").getPkValue();
            assetBookOrg2FinalQueryPeriodMap.put(l, Math.min(searchPeriodPk, curPeriod));
            assetBookOrg2FinalQueryLastPeriodMap.put(l, Math.min(lastPeriodPk, curPeriod));
            DynamicObject currency = assetBook.getDynamicObject("basecurrency");
            currencyPks.add((Long)currency.getPkValue());
            assetBookOrg2AssetBookMap.put(l, assetBook);
        }
        if (currencyPks.size() > 1) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u7684\u7ec4\u7ec7\u5e01\u522b\u4e0d\u4e00\u81f4", (String)"FaBlocListQuery_0", (String)"fi-fa-report", (Object[])new Object[0]));
        }
        Map commFilter = filterInfo.getCommFilter();
        QFilter qFilter = (QFilter)commFilter.get("fa_card_fin");
        ArrayList<DataSet> result = new ArrayList<DataSet>(16);
        for (Map.Entry entry : assetBookOrg2FinalQueryPeriodMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            DynamicObject assetBook = (DynamicObject)assetBookOrg2AssetBookMap.get(orgId);
            DynamicObject enablePeriod = assetBook.getDynamicObject("startperiod");
            Long finalLastPeriodPk = (Long)assetBookOrg2FinalQueryLastPeriodMap.get(orgId);
            List<QFilter> lastQFilters = this.getLastQFilter(finalLastPeriodPk, nowDepreusePk, (Long)enablePeriod.getPkValue(), orgId);
            Long finalQueryPeriodId = (Long)entry.getValue();
            List<QFilter> nowQFilters = this.getNowQFilter(finalQueryPeriodId, nowDepreusePk, orgId);
            if (Objects.nonNull(qFilter)) {
                lastQFilters.add(qFilter);
                nowQFilters.add(qFilter);
            }
            dataSet = this.queryLeafOrg(nowQFilters.toArray(new QFilter[0]), lastQFilters.toArray(new QFilter[0]), showasset);
            result.add(this.operateResult(dataSet, (Long)currencyPks.stream().findFirst().get(), showasset));
        }
        if (result.size() == 0) {
            return this.getEmptyDataSet();
        }
        if (result.size() == 1) {
            allDataSet = (DataSet)result.get(0);
        } else {
            void var27_31;
            allDataSet = (DataSet)result.get(0);
            boolean bl = true;
            while (var27_31 < result.size()) {
                allDataSet = allDataSet.union((DataSet)result.get((int)var27_31));
                ++var27_31;
            }
        }
        return allDataSet;
    }

    private Map<Long, List<String>> getPeriod_Org(Long nowDepreusePk, Long orgId) {
        List temps = new ArrayList<Long>();
        HashMap<Long, List<String>> period_Org = new HashMap<Long, List<String>>();
        temps.add(orgId);
        temps = OrgUnitServiceHelper.getAllSubordinateOrgs((Long)10L, temps, (boolean)false);
        QFilter qdepreUse = new QFilter("depreuse", "=", (Object)nowDepreusePk);
        List leafOrgs = FaPermissionUtils.getAllEnableBookAndPermissionOrgsV2((String)this.pageId, (String)"fa_bloc");
        temps.retainAll(leafOrgs);
        QFilter qorg = new QFilter("org", "in", temps);
        DynamicObject[] books = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"org,startperiod,basecurrency", (QFilter[])new QFilter[]{qorg, qdepreUse});
        DynamicObject book = null;
        int size = books.length;
        for (int i = 0; i < size; ++i) {
            List<String> orgIds;
            DynamicObject period = books[i].getDynamicObject("startperiod");
            Long periodPk = (Long)period.getPkValue();
            DynamicObject org = books[i].getDynamicObject("org");
            String orgId2 = String.valueOf(org.getPkValue());
            book = books[i];
            if (period_Org.containsKey(periodPk)) {
                orgIds = (List)period_Org.get(periodPk);
                orgIds.add(orgId2);
                continue;
            }
            orgIds = new LinkedList();
            orgIds.add(orgId2);
            period_Org.put(periodPk, orgIds);
        }
        if (book == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6839\u636e\u7ec4\u7ec7\u548c\u6298\u65e7\u7528\u9014\u672a\u627e\u5230\u8d44\u4ea7\u8d26\u7c3f", (String)"FaBlocListQuery_1", (String)"fi-fa-report", (Object[])new Object[0]));
        }
        DynamicObject currency = book.getDynamicObject("basecurrency");
        period_Org.put((Long)currency.getPkValue(), null);
        return period_Org;
    }

    private DataSet operateResult(DataSet allDataSet, Long currencypk, boolean showasset) {
        if (showasset) {
            DataSet littleallDataSet = allDataSet.groupBy(new String[]{"assetcatnumber", "assetcatId"}).sum("null", "org").sum("originalval").sum("accumdepre").sum("lastoriginalval").sum("lastaccumdepre").sum("currentvalue").sum("lastvalue").sum("null", "originalvalrate").sum("null", "accumdeprerate").sum("null", "valuerate").finish().addField("2", "rowtype");
            allDataSet = allDataSet.removeFields(new String[]{"rowtype"}).addField("4", "rowtype").union(littleallDataSet).orderBy(new String[]{"assetcatnumber", "assetcatId", "org"});
        } else {
            allDataSet = allDataSet.groupBy(new String[]{"assetcatnumber", "assetcatId"}).sum("originalval").sum("accumdepre").sum("lastoriginalval").sum("lastaccumdepre").sum("currentvalue").sum("lastvalue").sum("originalvalrate").sum("accumdeprerate").sum("valuerate").finish().addField("1", "rowtype");
        }
        DataSet sumCDataSet = this.querySum(allDataSet, showasset);
        sumCDataSet = this.addCurrency(sumCDataSet, currencypk);
        return sumCDataSet;
    }

    private DataSet querySum(DataSet allDataSet, boolean showasset) {
        DataSet sumDataSet = null;
        sumDataSet = showasset ? allDataSet.filter("rowtype=2").removeFields(new String[]{"assetcatnumber", "assetcatId", "org"}).addNullField(new String[]{"assetcatnumber", "assetcatId", "org"}).groupBy(new String[]{"assetcatnumber", "assetcatId", "org"}).sum("originalval").sum("accumdepre").sum("lastoriginalval").sum("lastaccumdepre").sum("currentvalue").sum("lastvalue").sum("0", "originalvalrate").sum("0", "accumdeprerate").sum("0 ", "valuerate").finish().addField("3", "rowtype") : allDataSet.removeFields(new String[]{"assetcatnumber", "assetcatId"}).addNullField(new String[]{"assetcatnumber", "assetcatId"}).groupBy(new String[]{"assetcatnumber", "assetcatId"}).sum("originalval").sum("accumdepre").sum("lastoriginalval").sum("lastaccumdepre").sum("currentvalue").sum("lastvalue").sum("0", "originalvalrate").sum("0", "accumdeprerate").sum("0 ", "valuerate").finish().addField("3", "rowtype");
        allDataSet = allDataSet.union(sumDataSet);
        return allDataSet;
    }

    private DataSet queryLeafOrg(QFilter[] nowQFilters, QFilter[] lastQFilters, boolean showasset) {
        String selectFields = this.getSelectField(showasset);
        DataSet nowDs = this.getNowDs(selectFields, nowQFilters);
        DataSet lastDs = this.getLastDs(selectFields, lastQFilters);
        DataSet ds = this.operateDataSet(nowDs, lastDs, showasset);
        return ds;
    }

    private DataSet getLastDs(String selectFields, QFilter[] lastQFilters) {
        DataSet nowDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fa_card_fin", (String)selectFields, (QFilter[])lastQFilters, null);
        return nowDs;
    }

    private DataSet getNowDs(String selectFields, QFilter[] nowQFilters) {
        DataSet nowDs = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fa_card_fin", (String)selectFields, (QFilter[])nowQFilters, null);
        return nowDs;
    }

    private DataSet addCurrency(DataSet sumCDataSet, Long currencypk) {
        sumCDataSet = sumCDataSet.addField(String.valueOf(currencypk), "currency");
        return sumCDataSet;
    }

    private DataSet operateDataSet(DataSet nowDs, DataSet lastDs, boolean showasset) {
        DataSet allDataSet = null;
        if (showasset) {
            nowDs = nowDs.groupBy(new String[]{"assetcatnumber", "assetcatId", "org"}).sum("originalval").sum("accumdepre").finish();
            lastDs = lastDs.groupBy(new String[]{"assetcatnumber", "assetcatId", "org"}).sum("originalval").sum("accumdepre").finish();
            DataSet dataSet = nowDs.join(lastDs, JoinType.LEFT).on("org", "org").on("assetcatnumber", "assetcatnumber").select(new String[]{"assetcatnumber", "originalval", "accumdepre", "assetcatId", "org"}, new String[]{"originalval lastoriginalval", "accumdepre lastaccumdepre"}).finish();
            allDataSet = dataSet.select(new String[]{"assetcatnumber", "assetcatId", "org", "originalval", "accumdepre", "lastoriginalval", "lastaccumdepre", "originalval-accumdepre currentvalue", "lastoriginalval-lastaccumdepre lastvalue", "(case when lastoriginalval=0 or lastoriginalval is null then 100 else ((originalval-lastoriginalval)*100/lastoriginalval) end) as originalvalrate", "(case when (lastaccumdepre=0 or lastaccumdepre is null) and accumdepre != 0 then 100 when (lastaccumdepre=0 or lastaccumdepre is null) and (accumdepre = 0 or accumdepre is null) then 0 else ((accumdepre-lastaccumdepre)*100/lastaccumdepre) end) as accumdeprerate", "(case when ((lastoriginalval-lastaccumdepre)=0 or lastoriginalval is null or lastaccumdepre is null) then 100 else ((originalval-accumdepre)-(lastoriginalval-lastaccumdepre))*100/(lastoriginalval-lastaccumdepre) end) as valuerate"}).addField("1", "rowtype");
        } else {
            nowDs = nowDs.groupBy(new String[]{"assetcatnumber", "assetcatId"}).sum("originalval").sum("accumdepre").finish();
            lastDs = lastDs.groupBy(new String[]{"assetcatnumber", "assetcatId"}).sum("originalval").sum("accumdepre").finish();
            DataSet dataSet = nowDs.join(lastDs, JoinType.LEFT).on("assetcatnumber", "assetcatnumber").select(new String[]{"assetcatnumber", "originalval", "accumdepre", "assetcatId"}, new String[]{"originalval lastoriginalval", "accumdepre lastaccumdepre"}).finish();
            allDataSet = dataSet.select(new String[]{"assetcatnumber", "assetcatId", "originalval", "accumdepre", "lastoriginalval", "lastaccumdepre", "originalval-accumdepre currentvalue", "lastoriginalval-lastaccumdepre lastvalue", "(case when lastoriginalval=0 or lastoriginalval is null then 100 else ((originalval-lastoriginalval)*100/lastoriginalval) end) as originalvalrate", "(case when (lastaccumdepre=0 or lastaccumdepre is null) and accumdepre != 0 then 100 when (lastaccumdepre=0 or lastaccumdepre is null) and (accumdepre = 0 or accumdepre is null) then 0 else ((accumdepre-lastaccumdepre)*100/lastaccumdepre) end) as accumdeprerate", "(case when ((lastoriginalval-lastaccumdepre)=0 or lastoriginalval is null or lastaccumdepre is null) then 100 else ((originalval-accumdepre)-(lastoriginalval-lastaccumdepre))*100/(lastoriginalval-lastaccumdepre) end) as valuerate"}).addField("1", "rowtype");
        }
        return allDataSet;
    }

    private List<QFilter> getLastQFilter(Long lastPeriod, Long nowDepreusePk, Long enablePeriodPk, Long orgId) {
        QFilter[] lastQFilters = this.getFinCardFilters(lastPeriod, nowDepreusePk, enablePeriodPk).toArray(new QFilter[0]);
        ArrayList<QFilter> lastNewFilters = new ArrayList<QFilter>();
        lastNewFilters.addAll(Arrays.asList(lastQFilters));
        lastNewFilters.add(new QFilter("org.id", "=", (Object)orgId));
        return lastNewFilters;
    }

    private List<QFilter> getNowQFilter(Long nowPeriodPk, Long nowDepreusePk, Long orgId) {
        QFilter[] nowQFilters = this.getFinCardFilters(nowPeriodPk, nowDepreusePk, null).toArray(new QFilter[0]);
        ArrayList<QFilter> nowNewFilters = new ArrayList<QFilter>();
        nowNewFilters.addAll(Arrays.asList(nowQFilters));
        nowNewFilters.add(new QFilter("org.id", "=", (Object)orgId));
        return nowNewFilters;
    }

    private List<Long> StringChangeLong(List<String> list) {
        ArrayList<Long> cc = new ArrayList<Long>(list.size());
        for (String aa : list) {
            cc.add(aa != null ? Long.parseLong(aa) : 0L);
        }
        return cc;
    }

    private Long getLastYearPeriod(DynamicObject currentPeriod) {
        return FaBizUtils.getPreviousYearSamePeriod((long)((Long)currentPeriod.getPkValue()));
    }

    private List<QFilter> getFinCardFilters(Long nowPeriodPk, Long nowDepreusePk, Long enablePeriodPk) {
        ArrayList<QFilter> finCardFilters = new ArrayList<QFilter>();
        if (nowPeriodPk != null) {
            DynamicObject enableLastPeriod;
            finCardFilters.add(new QFilter("endperiod", ">", (Object)nowPeriodPk));
            finCardFilters.add(new QFilter("bizperiod", "<=", (Object)nowPeriodPk));
            if (enablePeriodPk != null && (enableLastPeriod = FaBizUtils.queryNeighborPeriod((Object)enablePeriodPk, (int)-1)) != null && enableLastPeriod.getLong("id") > nowPeriodPk) {
                finCardFilters.add(new QFilter("period", ">=", (Object)enablePeriodPk));
            }
            finCardFilters.add(new QFilter("bizperiod", "<", (Object)"clearperiod", true).or(new QFilter("clearperiod", "=", (Object)0L)));
            finCardFilters.add(new QFilter("depreuse", "=", (Object)nowDepreusePk));
        } else {
            finCardFilters.add(new QFilter("ID", "=", null));
        }
        finCardFilters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
        return finCardFilters;
    }

    public String getSelectField(boolean showasset) {
        String selectFields = "originalval,accumdepre,period,realcard.assetcat.name assetcatId,assetcat.number assetcatnumber";
        if (showasset) {
            selectFields = "assetbook.org.name org,originalval,accumdepre,period,realcard.assetcat.name assetcatId,assetcat.number assetcatnumber";
        }
        return selectFields;
    }
}

