/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.report.enums.SumFlagEnum;

public class FaHealthStatusQuery
extends AbstractReportListDataPlugin {
    private final String algoKey = ((Object)((Object)this)).getClass().getName();
    private boolean showasset;

    private DataSet getEmptyDataSet() {
        RowMeta rowMeta = new RowMeta(new Field[0]);
        DataSetBuilder dataSetBuilder = Algo.create((String)this.algoKey).createDataSetBuilder(rowMeta);
        return dataSetBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        DataSet allDataSet;
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection orgDynObjList = filterInfo.getDynamicObjectCollection("q_org_multiple");
        ArrayList<Long> orgIds = new ArrayList<Long>(orgDynObjList.size());
        for (DynamicObject orgDynObj : orgDynObjList) {
            orgIds.add((Long)orgDynObj.getPkValue());
        }
        Long periodId = filterInfo.getDynamicObject("q_period").getLong("id");
        Long depreuse = filterInfo.getDynamicObject("depreuse").getLong("id");
        this.showasset = (Boolean)filterInfo.getFilterItem("showasset").getValue();
        QFilter qDepreuse = new QFilter("depreuse", "=", (Object)depreuse);
        String selectAssetBookField = Fa.join((String)",", (String[])new String[]{"id", "basecurrency", "periodtype", "curperiod", "org"});
        QFilter qOrg = new QFilter("org", "in", orgIds);
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"fa_assetbook", (String)selectAssetBookField, (QFilter[])new QFilter[]{qOrg, qDepreuse});
        DynamicObject[] assetBooks = objectDynamicObjectMap.values().toArray(new DynamicObject[0]);
        HashMap<Long, Long> assetBookOrg2FinalQueryPeriodMap = new HashMap<Long, Long>(16);
        for (DynamicObject assetBook : assetBooks) {
            long l = (Long)assetBook.getDynamicObject("org").getPkValue();
            long curPeriod = (Long)assetBook.getDynamicObject("curperiod").getPkValue();
            assetBookOrg2FinalQueryPeriodMap.put(l, Math.min(periodId, curPeriod));
        }
        Map commFilter = filterInfo.getCommFilter();
        QFilter qFilter = (QFilter)commFilter.get("fa_card_fin");
        ArrayList<DataSet> result = new ArrayList<DataSet>(16);
        for (Map.Entry entry : assetBookOrg2FinalQueryPeriodMap.entrySet()) {
            Long orgId = (Long)entry.getKey();
            Long finalQueryPeriodId = (Long)entry.getValue();
            result.add(this.queryDataSet(qDepreuse, orgId, finalQueryPeriodId, qFilter));
        }
        if (result.size() == 0) {
            return this.getEmptyDataSet();
        }
        if (result.size() == 1) {
            allDataSet = (DataSet)result.get(0);
        } else {
            void var18_23;
            allDataSet = (DataSet)result.get(0);
            boolean bl = true;
            while (var18_23 < result.size()) {
                allDataSet = allDataSet.union((DataSet)result.get((int)var18_23));
                ++var18_23;
            }
        }
        return allDataSet;
    }

    public DataSet queryDataSet(QFilter qDepreuse, Long orgId, Long periodId, QFilter qFilter) {
        String selectFields = this.getQuerySelectField();
        QFilter qOrg = new QFilter("org", "=", (Object)orgId);
        ArrayList<QFilter> filters = new ArrayList<QFilter>(7);
        filters.add(qOrg);
        filters.add(qDepreuse);
        filters.add(new QFilter("billstatus", "=", (Object)BillStatus.C.toString()));
        filters.add(new QFilter("bizperiod", "<=", (Object)periodId));
        filters.add(new QFilter("endperiod", ">", (Object)periodId));
        filters.add(new QFilter("bizperiod", "<", (Object)"clearperiod", true).or(new QFilter("clearperiod", "=", (Object)0L)));
        if (Objects.nonNull(qFilter)) {
            filters.add(qFilter);
        }
        DataSet ds = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fa_card_fin", (String)selectFields, (QFilter[])filters.toArray(new QFilter[0]), null);
        DataSet result = this.processData(ds);
        if (this.showasset) {
            DataSet sum = this.getSumData(result, true);
            return result.union(sum);
        }
        return result;
    }

    private DataSet processData(DataSet dataSet) {
        DataSet result;
        String[] groupFields;
        if (this.showasset) {
            groupFields = new String[]{"assetbook", "assetcat"};
            result = dataSet.copy().groupBy(groupFields).sum("assetamount").sum("originalval").sum("accumdepre").sum("networth").finish();
        } else {
            groupFields = new String[]{"assetbook"};
            result = dataSet.copy().groupBy(groupFields).sum("assetamount").sum("originalval").sum("accumdepre").sum("networth").finish();
        }
        DataSet ds_zero = dataSet.copy().filter("depredamount>=preusingamount").groupBy(groupFields).sum("assetamount", "qty_zero").sum("networth", "networth_zero").finish();
        DataSet ds_less = dataSet.copy().filter("depredamount*2 >= preusingamount").filter("depredamount/preusingamount< 1").groupBy(groupFields).sum("assetamount", "qty_less").sum("networth", "networth_less").finish();
        DataSet ds_more = dataSet.copy().filter("depredamount*2 < preusingamount").groupBy(groupFields).sum("assetamount", "qty_more").sum("networth", "networth_more").finish();
        ORMUtil.dumpDataSet((DataSet)dataSet.copy());
        DataSet ds_currency_fid = dataSet.copy().select("assetbook,currency,fid").top(1);
        if (this.showasset) {
            result = result.join(ds_zero, JoinType.FULL).on("assetbook", "assetbook").on("assetcat", "assetcat").select(this.getDataSetCols(result, true).split(","), this.getDataSetCols(ds_zero, false).split(",")).finish();
            result = result.join(ds_less, JoinType.FULL).on("assetbook", "assetbook").on("assetcat", "assetcat").select(this.getDataSetCols(result, true).split(","), this.getDataSetCols(ds_less, false).split(",")).finish();
            result = result.join(ds_more, JoinType.FULL).on("assetbook", "assetbook").on("assetcat", "assetcat").select(this.getDataSetCols(result, true).split(","), this.getDataSetCols(ds_more, false).split(",")).finish();
        } else {
            result = result.join(ds_zero, JoinType.FULL).on("assetbook", "assetbook").select(this.getDataSetCols(result, true).split(","), this.getDataSetCols(ds_zero, false).split(",")).finish();
            result = result.join(ds_less, JoinType.FULL).on("assetbook", "assetbook").select(this.getDataSetCols(result, true).split(","), this.getDataSetCols(ds_less, false).split(",")).finish();
            result = result.join(ds_more, JoinType.FULL).on("assetbook", "assetbook").select(this.getDataSetCols(result, true).split(","), this.getDataSetCols(ds_more, false).split(",")).finish();
        }
        result = result.join(ds_currency_fid, JoinType.FULL).on("assetbook", "assetbook").select(this.getDataSetCols(result, true).split(","), this.getDataSetCols(ds_currency_fid, false).split(",")).finish();
        result = result.addNullField("qty_rate_zero");
        result = result.addNullField("networth_rate_zero");
        result = result.addNullField("qty_rate_less");
        result = result.addNullField("networth_rate_less");
        result = result.addNullField("qty_rate_more");
        result = result.addNullField("networth_rate_more");
        result = result.addNullField("summarytype");
        result = this.showasset ? result.select("assetbook,assetcat,assetamount,originalval as originalval,accumdepre as accumdepre,networth as networth,qty_zero,qty_rate_zero,networth_zero as networth_zero,networth_rate_zero,qty_less,qty_rate_less,networth_less as networth_less,networth_rate_less,qty_more,qty_rate_more,networth_more as networth_more,networth_rate_more,summarytype,currency,fid") : result.select("assetbook,assetamount,originalval as originalval,accumdepre as accumdepre,networth as networth,qty_zero,qty_rate_zero,networth_zero as networth_zero,networth_rate_zero,qty_less,qty_rate_less,networth_less as networth_less,networth_rate_less,qty_more,qty_rate_more,networth_more as networth_more,networth_rate_more,summarytype,currency,fid");
        return result;
    }

    private DataSet getSumData(DataSet dataSet, boolean isTotal) {
        String[] groupFields = isTotal ? new String[]{} : new String[]{"fid"};
        DataSet result = dataSet.copy().filter("summarytype is null").groupBy(groupFields).sum("assetamount").sum("originalval").sum("accumdepre").sum("networth").sum("qty_zero").sum("networth_zero").sum("qty_less").sum("networth_less").sum("qty_more").sum("networth_more").finish();
        List<String> listField = this.getRptListField();
        listField.remove("fid");
        listField.remove("assetamount");
        listField.remove("originalval");
        listField.remove("accumdepre");
        listField.remove("networth");
        listField.remove("qty_zero");
        listField.remove("qty_rate_zero");
        listField.remove("networth_zero");
        listField.remove("networth_rate_zero");
        listField.remove("qty_less");
        listField.remove("qty_rate_less");
        listField.remove("networth_less");
        listField.remove("networth_rate_less");
        listField.remove("qty_more");
        listField.remove("qty_rate_more");
        listField.remove("networth_more");
        listField.remove("networth_rate_more");
        listField.remove("summarytype");
        listField.remove("currency");
        result = result.addNullField("qty_rate_zero");
        result = result.addNullField("networth_rate_zero");
        result = result.addNullField("qty_rate_less");
        result = result.addNullField("networth_rate_less");
        result = result.addNullField("qty_rate_more");
        result = result.addNullField("networth_rate_more");
        result = isTotal ? result.addField(SumFlagEnum.TOTAL.getIndex() + "L", "summarytype") : result.addField(SumFlagEnum.SUBTOTAL.getIndex() + "L", "summarytype");
        for (String field : listField) {
            if (field.equals("assetbook")) {
                if (isTotal) {
                    result = result.addField(ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"FaHealthStatusQuery_0", (String)"fi-fa-report", (Object[])new Object[0]), field);
                    continue;
                }
                result = result.addField(ResManager.loadKDString((String)"'\u5c0f\u8ba1'", (String)"FaHealthStatusQuery_1", (String)"fi-fa-report", (Object[])new Object[0]), field);
                continue;
            }
            result = result.addNullField(field);
        }
        DataSet ds_currency_fid = dataSet.copy().select("currency,fid").top(1).addField(ResManager.loadKDString((String)"'\u5408\u8ba1'", (String)"FaHealthStatusQuery_0", (String)"fi-fa-report", (Object[])new Object[0]), "assetbook");
        result = isTotal ? result.join(ds_currency_fid, JoinType.FULL).on("assetbook", "assetbook").select(this.getDataSetCols(result, true).split(","), new String[]{"currency", "fid"}).finish() : result.join(ds_currency_fid, JoinType.FULL).on("fid", "fid").select(this.getDataSetCols(result, true).split(","), new String[]{"currency"}).finish();
        result = result.select(this.getRptListField().toArray(new String[0]));
        return result;
    }

    private String getQuerySelectField() {
        ArrayList<String> result = new ArrayList<String>();
        result.add(String.format("%s as %s", "org.name", "assetbook"));
        result.add(String.format("%s as %s", "assetcat", "assetcat"));
        result.add(String.format("%s as %s", 1, "assetamount"));
        result.add(String.format("%s as %s", "originalval", "originalval"));
        result.add(String.format("%s as %s", "accumdepre", "accumdepre"));
        result.add(String.format("%s as %s", "networth", "networth"));
        result.add("preusingamount");
        result.add("depredamount");
        result.add(String.format("%s as %s", "assetbook.basecurrency", "currency"));
        result.add(String.format("%s as %s", "org.id", "fid"));
        return result.stream().collect(Collectors.joining(","));
    }

    private List<String> getRptListField() {
        ArrayList<String> result = new ArrayList<String>(21);
        result.add("assetbook");
        if (this.showasset) {
            result.add("assetcat");
        }
        result.add("assetamount");
        result.add("originalval");
        result.add("accumdepre");
        result.add("networth");
        result.add("qty_zero");
        result.add("qty_rate_zero");
        result.add("networth_zero");
        result.add("networth_rate_zero");
        result.add("qty_less");
        result.add("qty_rate_less");
        result.add("networth_less");
        result.add("networth_rate_less");
        result.add("qty_more");
        result.add("qty_rate_more");
        result.add("networth_more");
        result.add("networth_rate_more");
        result.add("summarytype");
        result.add("currency");
        result.add("fid");
        return result;
    }

    private String getDataSetCols(DataSet ds, boolean isLeft) {
        RowMeta rowMeta = ds.getRowMeta();
        Field[] fields = rowMeta.getFields();
        ArrayList<String> list = new ArrayList<String>(fields.length);
        for (Field field : fields) {
            list.add(field.getName().toLowerCase());
        }
        if (!isLeft) {
            list.remove("assetbook");
            if (this.showasset) {
                list.remove("assetcat");
            }
        }
        return list.stream().collect(Collectors.joining(","));
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        if (this.showasset) {
            ReportColumnGroup reportColumn = (ReportColumnGroup)columns.get(0);
            ReportColumn childColumn = (ReportColumn)reportColumn.getChildren().get(1);
            childColumn.setHide(false);
        }
        return columns;
    }
}

