/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.report.util;

import java.math.BigDecimal;
import java.text.Format;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.format.FormatFactory;
import kd.bos.entity.format.FormatObject;
import kd.bos.entity.format.FormatTypes;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.report.ReportListModel;
import kd.bos.mvc.report.ReportView;
import kd.bos.report.ReportList;

public class RptPrintHelper {
    public static ReportListModel getListModel(String pageId) {
        ReportView view = (ReportView)SessionManager.getCurrent().getView(pageId);
        if (view == null) {
            return null;
        }
        ReportList list = view.getReportList();
        return (ReportListModel)list.getReportModel();
    }

    public static void copyStringFields(DynamicObject from, DynamicObject to, String ... fields) {
        for (String field : fields) {
            to.set(field, from.get(field));
        }
    }

    public static void copyIntAndLongFields(DynamicObject from, DynamicObject to, boolean showZero, String ... fields) {
        for (String field : fields) {
            Object prop = from.get(field);
            if (prop == null) continue;
            String propStr = prop.toString();
            if (!showZero && "0".equals(propStr)) continue;
            to.set(field, (Object)propStr);
        }
    }

    public static void copyBigDecimalFields(DynamicObject from, DynamicObject to, int precision, boolean showZero, String ... fields) {
        for (String field : fields) {
            BigDecimal prop = (BigDecimal)from.get(field);
            if (prop == null || !showZero && BigDecimal.ZERO.compareTo(prop) == 0) continue;
            to.set(field, (Object)prop.setScale(precision, 4));
        }
    }

    public static void copyBaseDataFields(DynamicObject from, DynamicObject to, String ... fields) {
        for (String field : fields) {
            DynamicObject dyn = from.getDynamicObject(field);
            if (dyn == null) continue;
            String entityKey = dyn.getDataEntityType().getName();
            String dynName = "fa_card_real_base".equals(entityKey) ? dyn.getString("assetname") : dyn.getString("name");
            to.set(field, (Object)dynName);
        }
    }

    public static void copyBaseDataPropField(DynamicObject from, DynamicObject to, String ... fields) {
        for (String field : fields) {
            int splitIndex = field.indexOf(".");
            if (-1 == splitIndex) {
                return;
            }
            String baseDataFieldKey = field.substring(0, splitIndex);
            DynamicObject baseData = from.getDynamicObject(baseDataFieldKey);
            if (baseData == null) continue;
            String baseDataPropKey = field.substring(splitIndex + 1);
            String baseDataProp = baseData.getString(baseDataPropKey);
            to.set(field, (Object)baseDataProp);
        }
    }

    public static void copyAmountFields(DynamicObject from, DynamicObject to, FormatObject formatObj, String currencyField, boolean showZero, String ... fields) {
        String signStr = "";
        int amtprecision = 0;
        DynamicObject currency = from.getDynamicObject(currencyField);
        if (currency != null) {
            signStr = currency.getString("sign");
            amtprecision = currency.getInt("amtprecision");
        }
        formatObj.getCurrencyFormat().setMinimumFractionDigits(amtprecision);
        formatObj.getCurrencyFormat().setCurrencySymbols(signStr);
        Format format = FormatFactory.get((FormatTypes)FormatTypes.Currency).getFormat(formatObj);
        for (String field : fields) {
            BigDecimal amount = from.getBigDecimal(field);
            if (amount == null || !showZero && amount.compareTo(BigDecimal.ZERO) == 0) continue;
            to.set(field, (Object)format.format(amount));
        }
    }

    public static void copyBaseDataProp4Ext(DynamicObject from, DynamicObject to, Set<String> standardDataSource, Set<String> extDataSource) {
        extDataSource.removeAll(standardDataSource);
        RptPrintHelper.copyBaseDataPropField(from, to, extDataSource.toArray(new String[0]));
    }
}

