/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.List;

class AssetCatNode {
    protected final long id;
    protected final long parentId;
    protected final String number;
    protected boolean realChecked;
    protected boolean checked;
    protected List<AssetCatNode> children = new ArrayList<AssetCatNode>();

    public AssetCatNode(long id, long parentId, String number) {
        this.id = id;
        this.parentId = parentId;
        this.number = number;
    }

    public void check() {
        this.realChecked = true;
    }

    public void addChild(AssetCatNode node) {
        this.children.add(node);
    }

    public void addChildren(List<AssetCatNode> children) {
        this.children.addAll(children);
    }

    public void validate() {
        if (this.children.size() == 0) {
            this.checked = this.realChecked;
            return;
        }
        if (!this.realChecked) {
            this.children.forEach(v -> v.validate());
            if (this.children.stream().allMatch(v -> v.checked)) {
                this.checked = true;
            }
        } else {
            this.checked = this.realChecked;
        }
    }

    public String toString() {
        return String.format("id: %s, parentId: %s, number: %s, realChecked: %s", this.id, this.parentId, this.number, this.realChecked);
    }
}

