/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.Date;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.DepreAdjustBillAuditPlugin;
import kd.fi.fa.opplugin.FaMigrateDateValidator;

public class DepreAdjustBillUnAuditPlugin
extends DepreAdjustBillAuditPlugin {
    @Override
    protected boolean isAudit() {
        return false;
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("depreuse");
        e.getFieldKeys().add("period");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("realcard");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaMigrateDateValidator());
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    DynamicObjectCollection data = DepreAdjustBillUnAuditPlugin.this.queryDepReAdjustCurrPreClearBusiness(bill);
                    if (data.isEmpty()) continue;
                    Set numberSet = data.stream().map(v -> v.get(Fa.dot((String[])new String[]{Fa.dot((String[])new String[]{"detail_entry", "realcard"}), "number"}))).collect(Collectors.toSet());
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247[%s]\u5f53\u671f\u6298\u65e7\u8c03\u6574\u540e\u5b58\u5728\u6e05\u7406\u4e1a\u52a1\uff0c\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"DepreAdjustBillUnAuditPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), numberSet.toString()));
                }
            }
        });
    }

    @Override
    protected void handleDynamicCard(DynamicObject depreAdjustBill) {
        DynamicObjectCollection entries = depreAdjustBill.getDynamicObjectCollection("entryentity");
        Set adjustRealCardPkSet = entries.stream().filter(v -> v.getBoolean("isadjustdepre")).map(v -> v.getDynamicObject("realcard").getPkValue()).collect(Collectors.toSet());
        if (adjustRealCardPkSet.isEmpty()) {
            return;
        }
        DeleteServiceHelper.delete((String)"fa_card_dynamic", (QFilter[])new QFilter[]{new QFilter("entityname", "=", (Object)"fa_depreadjustbill"), new QFilter("changebillid", "=", (Object)depreAdjustBill.getLong("id"))});
    }

    protected DynamicObjectCollection queryDepReAdjustCurrPreClearBusiness(DynamicObject bill) {
        Date depReAdjustAuditDate = bill.getDate("auditdate");
        long periodId = bill.getDynamicObject("period").getLong("id");
        long orgId = bill.getDynamicObject("org").getLong("id");
        DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
        Set realCardIdSet = entries.stream().map(v -> v.getLong("realcard_id")).collect(Collectors.toSet());
        QFilter[] qFilters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("clearperiod", "=", (Object)periodId), new QFilter("createtime", ">", (Object)depReAdjustAuditDate), new QFilter(Fa.dot((String[])new String[]{"detail_entry", "realcard"}), "in", realCardIdSet)};
        DynamicObjectCollection queryData = QueryServiceHelper.query((String)"fa_clearbill", (String)Fa.dot((String[])new String[]{Fa.dot((String[])new String[]{"detail_entry", "realcard"}), "number"}), (QFilter[])qFilters);
        return queryData;
    }
}

