/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.opplugin.DepreConfig;
import kd.fi.fa.opplugin.depresetup.AbstractDepreSplitSetupValidator;

public class DepreSplitSetUpAuditValidator
extends AbstractDepreSplitSetupValidator {
    public void validate() {
        HashSet<Long> orgids = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject vo = dataEntity.getDataEntity();
            orgids.add(vo.getLong("org.id"));
        }
        DynamicObject[] books = BusinessDataServiceHelper.load((String)"fa_assetbook", (String)"id,org.id,depreuse.id,curperiod.id", (QFilter[])new QFilter[]{new QFilter("org", "in", orgids)});
        HashMap<String, Long> bookPeriodMap = new HashMap<String, Long>(books.length);
        for (DynamicObject book : books) {
            bookPeriodMap.put("" + book.getLong("org.id") + book.getLong("depreuse.id"), book.getLong("curperiod.id"));
        }
        HashMap<String, DepreConfig> configs = new HashMap<String, DepreConfig>(this.dataEntities.length);
        HashMap<String, ArrayList<ExtendedDataEntity>> configBills = new HashMap<String, ArrayList<ExtendedDataEntity>>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject vo = dataEntity.getDataEntity();
            String key = "" + vo.getLong("org.id") + vo.getLong("depreuse.id");
            long curPeriodId = (Long)bookPeriodMap.get(key);
            if (vo.getLong("beginperiod.id") != curPeriodId) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u5ba1\u6838\u5f53\u671f\u5206\u644a\u8bbe\u7f6e", (String)"DepreSplitSetUpAuditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
            DepreConfig config = new DepreConfig();
            config.setOrgid(vo.getLong("org.id"));
            config.setDepreuseid(vo.getLong("depreuse.id"));
            config.setBeginperiodid(vo.getLong("beginperiod.id"));
            config.setEndperiodid(vo.getLong("endperiod.id") == 0L ? 99999999999L : vo.getLong("endperiod.id"));
            String configKey = config.toString();
            configs.put(configKey, config);
            ArrayList<ExtendedDataEntity> bills = (ArrayList<ExtendedDataEntity>)configBills.get(configKey);
            if (bills == null) {
                bills = new ArrayList<ExtendedDataEntity>();
                configBills.put(configKey, bills);
            }
            bills.add(dataEntity);
        }
        this.validateFutureSetup(ResManager.loadKDString((String)"\u5b58\u5728\u540e\u7eed\u671f\u95f4\u7684\u6298\u65e7\u5206\u644a\u8bbe\u7f6e\uff0c\u4e0d\u53ef\u4ee5\u5ba1\u6838\u3002", (String)"DepreSplitSetUpAuditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.dataEntities.length);
        for (Map.Entry e : configs.entrySet()) {
            DepreConfig config = (DepreConfig)e.getValue();
            boolean enableSumMutilVoucher = false;
            Long orgId = config.getOrgid();
            if (orgId2SumMutilVou.get(orgId) != null) {
                enableSumMutilVoucher = (Boolean)orgId2SumMutilVou.get(orgId);
            } else {
                enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
                orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
            }
            QFilter q1 = new QFilter("org.id", "=", (Object)config.getOrgid());
            QFilter q2 = new QFilter("depreuse.id", "=", (Object)config.getDepreuseid());
            QFilter q3 = new QFilter("period.id", ">", (Object)config.getBeginperiodid());
            if (!enableSumMutilVoucher) {
                q3 = new QFilter("period.id", ">=", (Object)config.getBeginperiodid());
            }
            DynamicObjectCollection depreSumList = QueryServiceHelper.query((String)"fa_depre_sum", (String)"id", (QFilter[])new QFilter[]{q1, q2, q3});
            HashSet<Object> depreSumIdSet = new HashSet<Object>(16);
            for (DynamicObject depreSum : depreSumList) {
                depreSumIdSet.add(depreSum.get("id"));
            }
            if (depreSumIdSet.size() <= 0 || !FaDepreUtil.hashVouncher(depreSumIdSet)) continue;
            List bills = (List)configBills.get(e.getKey());
            for (ExtendedDataEntity dataEntity : bills) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u53d7\u5f71\u54cd\u7684\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u5ba1\u6838", (String)"DepreSplitSetUpAuditValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            }
        }
    }
}

