/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.cardgenerate.CardGenerateHelper;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.operate.IFaOpHandler;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.FaCardInitFieldUtil;
import kd.fi.fa.business.utils.FaCommonUtils;
import kd.fi.fa.business.utils.FaDepreUtil;
import kd.fi.fa.business.utils.FunctionMutexHelperV2Utils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.common.util.FaChangeItemUtil;
import kd.fi.fa.opplugin.realcard.FaAbstractRealCardOp;
import kd.fi.fa.utils.FaOpUtils;

public class FaCardOperationPlugin
extends FaAbstractRealCardOp
implements IFaOpHandler {
    private static final Log log = LogFactory.getLog(FaCardOperationPlugin.class);
    private static final String SEl_ASSBOOK_PRO = Fa.comma((String[])new String[]{"id", "org", "ismainbook", "status"});

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
        fieldKeys.add("assetcat");
        fieldKeys.add(Fa.dot((String[])new String[]{"assetcat", "isleaf"}));
        fieldKeys.add("billno");
        fieldKeys.add("barcode");
        fieldKeys.add("number");
        fieldKeys.add("assetname");
        fieldKeys.add("bizstatus");
        fieldKeys.add("realaccountdate");
        fieldKeys.add("assetamount");
        fieldKeys.add("unit");
        fieldKeys.add("originmethod");
        fieldKeys.add("storeplace");
        fieldKeys.add("usestatus");
        fieldKeys.add("headusedept");
        fieldKeys.add("initialcard");
        fieldKeys.add("barcoderule");
        fieldKeys.add("numberrule");
        fieldKeys.add("billnocoderule");
        fieldKeys.add("sourceflag");
        fieldKeys.add("sourceentryid");
        fieldKeys.add("usedate");
        fieldKeys.add("supplier");
        fieldKeys.add("srcbillnumber");
        fieldKeys.add("sourceentrysplitseq");
        fieldKeys.add("masterid");
        fieldKeys.add("createtime");
        fieldKeys.add("creator");
        fieldKeys.add("srcbillid");
        fieldKeys.add("barcoderecovery");
        fieldKeys.add("billnorecovery");
        fieldKeys.add("numberrecovery");
        fieldKeys.add("justrealcard");
        fieldKeys.add("price");
        fieldKeys.add("isimport");
        fieldKeys.add("srcbillentityname");
        fieldKeys.add("mergedcard");
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                boolean deleteClearBillByUnAudit = this.getOption().containsVariable("deleteRealCardByInvdiffer");
                if (deleteClearBillByUnAudit) {
                    return;
                }
                String operateName = this.getOperateKey();
                Set cardIds = Arrays.asList(dataEntities).parallelStream().map(v -> Long.parseLong(v.getDataEntity().getPkValue().toString())).collect(Collectors.toSet());
                HashMap<Long, Set<Long>> finMap = new HashMap<Long, Set<Long>>(cardIds.size(), 1.0f);
                DynamicObjectCollection fincards = QueryServiceHelper.query((String)"fa_card_fin", (String)"fa_card_fin", (String)"id,realcard, depreuse", (QFilter[])new QFilter[]{new QFilter("realcard", "in", cardIds)}, null);
                for (DynamicObject finCard : fincards) {
                    long realCardId = finCard.getLong("realcard");
                    long depreUseId = finCard.getLong("depreuse");
                    Set depreUseIdSet = finMap.computeIfAbsent(realCardId, v -> new HashSet(4));
                    depreUseIdSet.add(depreUseId);
                }
                DynamicObject realCard = dataEntities[0].getDataEntity();
                long org = realCard.getLong("org.id");
                DynamicObjectCollection assetbook = QueryServiceHelper.query((String)"fa_assetbook", (String)"id", (QFilter[])new QFilter("org", "=", (Object)org).toArray());
                this.checkNumberRepeat(dataEntities);
                HashMap<String, DynamicObject> catoryid2Catory = new HashMap<String, DynamicObject>(32);
                HashMap<String, DynamicObjectCollection> orgId2AssetBookList = new HashMap<String, DynamicObjectCollection>(3, 1.0f);
                HashMap<String, Boolean> orgIdDepreUseIdPeriodId2haVoucher = new HashMap<String, Boolean>(16);
                for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                    DynamicObject realCardObj = extendedDataEntity.getDataEntity();
                    boolean isLeafCatory = false;
                    DynamicObject catory = realCardObj.getDynamicObject("assetcat");
                    if (catory != null) {
                        DynamicObject catoryFromDB;
                        String catoryId = catory.getString("id");
                        DynamicObject catoryLocalCache = (DynamicObject)catoryid2Catory.get(catoryId);
                        if (catoryLocalCache == null) {
                            catoryFromDB = BusinessDataServiceHelper.loadSingleFromCache((Object)catory.getLong("id"), (String)"fa_assetcategory", (String)"isleaf");
                            if (catory != null) {
                                isLeafCatory = catoryFromDB.getBoolean("isleaf");
                                catoryid2Catory.put(catory.getString("id"), catoryFromDB);
                            }
                        } else {
                            catoryFromDB = catoryLocalCache;
                            isLeafCatory = catoryLocalCache.getBoolean("isleaf");
                        }
                        if (!isLeafCatory && catoryFromDB != null) {
                            String msgCaption = String.format(ResManager.loadKDString((String)"\u8d44\u4ea7\u7c7b\u522b\u3010%s\u3011\u4e3a\u975e\u660e\u7ec6\u7c7b\u522b\uff0c\u8bf7\u5f55\u5165\u660e\u7ec6\u8d44\u4ea7\u7c7b\u522b\u3002", (String)"FaCardOperationPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), catory.getString("number"));
                            this.addErrorMessage(extendedDataEntity, msgCaption);
                        }
                    }
                    if ("generatefincard".equals(operateName)) {
                        this.setOperationName(ResManager.loadKDString((String)"\u751f\u6210\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247", (String)"FaCardOperationPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                        this.checkExistInitailFinCard(realCardObj, extendedDataEntity, finMap, assetbook.size());
                        this.checkExistUnEnablebook(realCardObj, extendedDataEntity, orgId2AssetBookList);
                        continue;
                    }
                    if (!"deletefincard".equals(operateName)) continue;
                    this.setOperationName(ResManager.loadKDString((String)"\u5220\u9664\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247", (String)"FaCardOperationPlugin_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    this.checkExistUnEnablebook(realCardObj, extendedDataEntity, orgId2AssetBookList);
                    this.checkDeleteExistInitailFinCard(realCardObj, extendedDataEntity);
                    StringBuilder sb = new StringBuilder();
                    sb.append(realCardObj.getLong(Fa.id((String)"org")));
                    boolean isHasvoucher = false;
                    if (orgIdDepreUseIdPeriodId2haVoucher.get(sb.toString()) != null) {
                        isHasvoucher = (Boolean)orgIdDepreUseIdPeriodId2haVoucher.get(sb.toString());
                    } else {
                        isHasvoucher = FaDepreUtil.hasVoucher((Long)realCardObj.getLong(Fa.id((String)"org")), null, (Long)0L, (boolean)Boolean.TRUE);
                        orgIdDepreUseIdPeriodId2haVoucher.put(sb.toString(), isHasvoucher);
                    }
                    if (!isHasvoucher) continue;
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u671f\u6216\u540e\u7eed\u671f\u95f4\u6298\u65e7\u6c47\u603b\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FaCardOperationPlugin_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }

            private void checkNumberRepeat(ExtendedDataEntity[] dataEntities) {
                HashMap<String, ExtendedDataEntity> checkDataMap = new HashMap<String, ExtendedDataEntity>(dataEntities.length, 1.0f);
                HashSet<String> checkDataSet = new HashSet<String>(dataEntities.length, 1.0f);
                for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                    DynamicObject realCardObj = extendedDataEntity.getDataEntity();
                    String fNumber = realCardObj.getString("number");
                    if (null == fNumber || null == realCardObj.getString("sourceflag") || "DISPATCH".equals(realCardObj.getString("sourceflag"))) continue;
                    checkDataMap.put(fNumber, extendedDataEntity);
                    checkDataSet.add(fNumber);
                }
                if (!checkDataSet.isEmpty()) {
                    QFilter qNumber = new QFilter("number", "in", checkDataSet);
                    QFilter qIsBak = new QFilter("isbak", "=", (Object)Boolean.FALSE);
                    QFilter qIsClearAll = new QFilter("bizstatus", "!=", (Object)"DELETE");
                    QFilter qInitCard = new QFilter("initialcard", "=", (Object)Boolean.FALSE);
                    DynamicObjectCollection queryResult = QueryServiceHelper.query((String)"fa_card_real", (String)Fa.comma((String[])new String[]{"id", "number", "masterid"}), (QFilter[])new QFilter[]{qNumber, qIsBak, qIsClearAll, qInitCard});
                    for (DynamicObject queryCard : queryResult) {
                        String number = queryCard.getString("number");
                        ExtendedDataEntity extendedDataEntity = (ExtendedDataEntity)checkDataMap.get(number);
                        if (null == extendedDataEntity) {
                            log.info("extendedDataEntity checkDataMap:", (Object)((Object)checkDataMap).toString());
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u8d44\u4ea7\u7f16\u7801\u3010%s\u3011", (String)"FaCardOperationPlugin_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), number));
                        }
                        if (null == extendedDataEntity.getDataEntity()) {
                            log.info("extendedDataEntity.getDataEntity() checkDataMap:", (Object)((Object)checkDataMap).toString());
                            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7cfb\u7edf\u4e2d\u5b58\u5728\u91cd\u590d\u7684\u8d44\u4ea7\u7f16\u7801\u3010%s\u3011", (String)"FaCardOperationPlugin_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), number));
                        }
                        DynamicObject realCard = extendedDataEntity.getDataEntity();
                        Long id = realCard.getLong("masterid");
                        if (id == 0L) {
                            id = realCard.getLong("id");
                        }
                        if (id.equals(queryCard.get("masterid"))) continue;
                        String msgCaption = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u91cd\u590d\u7684\u8d44\u4ea7\u7f16\u7801\u3010%s\u3011", (String)"FaCardOperationPlugin_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), number);
                        this.addErrorMessage(extendedDataEntity, msgCaption);
                    }
                }
            }

            private void checkExistInitailFinCard(DynamicObject realCardObj, ExtendedDataEntity extendedDataEntity, Map<Long, Set<Long>> finMap, int assetbokSize) {
                String sourceFlag = realCardObj.getString("sourceflag");
                long realcardId = realCardObj.getLong("id");
                Boolean compareSize = Boolean.FALSE;
                if (finMap.containsKey(realcardId)) {
                    Set<Long> depreUseIdSet = finMap.get(realcardId);
                    int finSize = depreUseIdSet.size();
                    if (finSize == assetbokSize && !SourceFlagEnum.INITLEASECONTRACT.toString().equals(sourceFlag)) {
                        compareSize = Boolean.TRUE;
                    } else if (SourceFlagEnum.INITLEASECONTRACT.toString().equals(sourceFlag) && finSize == 1) {
                        compareSize = Boolean.TRUE;
                    }
                }
                if (SourceFlagEnum.INITIAL.toString().equalsIgnoreCase(sourceFlag)) {
                    if (Boolean.TRUE.equals(realCardObj.getBoolean("justrealcard"))) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d39\u7528\u5316\u8d44\u4ea7\u7684\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u65e0\u9700\u751f\u6210\u8d22\u52a1\u5361\u7247", (String)"FaCardOperationPlugin_6", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    } else if (compareSize.booleanValue()) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5b9e\u7269\u5361\u7247\u5728\u6240\u6709\u7684\u8d26\u7c3f\u5747\u5df2\u751f\u6210\u8d22\u52a1\u5361\u7247,\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u3002", (String)"FaCardOperationPlugin_7", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                }
                if (SourceFlagEnum.INITLEASECONTRACT.toString().equalsIgnoreCase(sourceFlag) && (BizStatusEnum.READY.name().equals(realCardObj.getString("bizstatus")) || compareSize.booleanValue()) && Boolean.FALSE.equals(realCardObj.getBoolean("justrealcard"))) {
                    this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u5b9e\u7269\u5361\u7247\u5df2\u751f\u6210\u8d22\u52a1\u5361\u7247,\u4e0d\u80fd\u91cd\u590d\u751f\u6210", (String)"FaCardOperationPlugin_8", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }

            private Optional<String> checkFutureBiz(DynamicObject realCardObj) {
                DynamicObject[] realCards = FaRealCardDaoFactory.getInstance().query("id", new QFilter("masterid", "=", (Object)realCardObj.getLong("masterid")));
                Set realCardPkSet = Arrays.stream(realCards).map(v -> (Long)v.get("id")).collect(Collectors.toSet());
                Object orgId = realCardObj.get("org.id");
                FutureBizChecker futureBizChecker = new FutureBizChecker(null, orgId, realCardPkSet, null, BusyTypeDetailEnum.REAL_FIN_CHG);
                futureBizChecker.setFromFin(true);
                return futureBizChecker.checkWhenun();
            }

            private void checkDeleteExistInitailFinCard(DynamicObject realCardObj, ExtendedDataEntity extendedDataEntity) {
                String sourceFlag = realCardObj.getString("sourceflag");
                if (SourceFlagEnum.INITIAL.name().equalsIgnoreCase(sourceFlag) || SourceFlagEnum.INITLEASECONTRACT.name().equalsIgnoreCase(sourceFlag)) {
                    boolean exists;
                    Optional<String> checkResult;
                    if (!FaOpUtils.checkFinCard(realCardObj)) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u672a\u751f\u6210\u8d22\u52a1\u5361\u7247\u3002", (String)"FaCardOperationPlugin_9", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if ((checkResult = this.checkFutureBiz(realCardObj)).isPresent()) {
                        String msg = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\uff1a%s\u3002", (String)"FaCardOperationPlugin_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get());
                        this.addErrorMessage(extendedDataEntity, msg);
                    }
                    if (SourceFlagEnum.INITLEASECONTRACT.name().equalsIgnoreCase(sourceFlag) && (exists = QueryServiceHelper.exists((String)"fa_asset_transfer", (QFilter[])new QFilter[]{new QFilter(Fa.dot((String[])new String[]{"assettransferentry", "realcard"}), "=", realCardObj.getPkValue())}))) {
                        String msg = String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\uff1a\u8d44\u4ea7\u79fb\u4ea4\u5355: %s\u3002", (String)"FaCardOperationPlugin_11", (String)"fi-fa-opplugin", (Object[])new Object[0]), realCardObj.getString("billno"));
                        this.addErrorMessage(extendedDataEntity, msg);
                    }
                }
            }

            private void checkExistUnEnablebook(DynamicObject realCardObj, ExtendedDataEntity extendedDataEntity, Map<String, DynamicObjectCollection> orgId2AssetBookList) {
                String sourceFlag = realCardObj.getString("sourceflag");
                if (SourceFlagEnum.INITIAL.name().equalsIgnoreCase(sourceFlag) || SourceFlagEnum.INITLEASECONTRACT.name().equals(sourceFlag)) {
                    String orgIdStr = realCardObj.getString("org_id");
                    DynamicObjectCollection assetBookCache = orgId2AssetBookList.get(orgIdStr);
                    if (assetBookCache == null) {
                        QFilter filterOrg = new QFilter("org.id", "=", (Object)realCardObj.getLong("org_id"));
                        assetBookCache = QueryServiceHelper.query((String)"fa_assetbook", (String)SEl_ASSBOOK_PRO, (QFilter[])new QFilter[]{filterOrg});
                        orgId2AssetBookList.put(orgIdStr, assetBookCache);
                    }
                    if (assetBookCache == null || assetBookCache.size() == 0) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u5bf9\u5e94\u8d26\u7c3f,\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"FaCardOperationPlugin_12", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (SourceFlagEnum.INITLEASECONTRACT.name().equals(sourceFlag)) {
                        boolean isExistMainBook = false;
                        for (DynamicObject assetBook : assetBookCache) {
                            if (!assetBook.getBoolean("ismainbook")) continue;
                            isExistMainBook = true;
                            break;
                        }
                        if (!isExistMainBook) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6ca1\u6709\u4e3b\u8d26\u7c3f\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"FaCardOperationPlugin_13", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                            return;
                        }
                    }
                    boolean isExistUnEnablebook = false;
                    for (DynamicObject assetBook : assetBookCache) {
                        if (!assetBook.getString("status").equals("C")) continue;
                        isExistUnEnablebook = true;
                        break;
                    }
                    if (isExistUnEnablebook) {
                        this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5bf9\u5e94\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"FaCardOperationPlugin_14", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                        return;
                    }
                }
            }
        });
    }

    public Date stripTime(Date d) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String dateS = sdf.format(d);
        Date rDate = null;
        try {
            rDate = sdf.parse(dateS);
        }
        catch (ParseException e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u5316\u5931\u8d25\u3002", (String)"FaCardOperationPlugin_15", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
        return rDate;
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operateName = e.getOperationKey();
        if ("save".equals(operateName) || "submit".equals(operateName)) {
            List<DynamicObject> cards = FaOpUtils.getDataEntities(e);
            for (DynamicObject card : cards) {
                long master = card.getLong("masterid");
                if (master != 0L) continue;
                card.set("masterid", (Object)card.getLong("id"));
            }
        } else if ("audit".equals(operateName)) {
            String operationKey = e.getOperationKey();
            FunctionMutexHelperV2Utils.doFaOpWithWithOrgPcChildLock((String)operationKey, (String)"fa_card_real", (DynamicObject[])e.getDataEntities(), null, (IFaOpHandler)this);
        } else if ("generatefincard".equals(operateName)) {
            FunctionMutexHelperV2Utils.doFaOpWithWithOrgPcChildLock((String)operateName, (String)"fa_card_real", (DynamicObject[])e.getDataEntities(), null, (IFaOpHandler)this);
        } else if ("unaudit".equals(operateName)) {
            String operationKey = e.getOperationKey();
            FunctionMutexHelperV2Utils.doFaOpWithWithOrgPcChildLock((String)operationKey, (String)"fa_card_real", (DynamicObject[])e.getDataEntities(), null, (IFaOpHandler)this);
        } else if ("deletefincard".equals(operateName)) {
            this.doFaOp("deletefincard", "fa_card_real", e.getDataEntities(), null);
        }
    }

    private void deleteFinCardOnly(List<DynamicObject> bills) {
        try {
            Set realIdSet = bills.stream().map(v -> v.getPkValue()).collect(Collectors.toSet());
            Object errInfo = null;
            DynamicObjectCollection finCards = QueryServiceHelper.query((String)"fa_card_fin", (String)"id,realcard", (QFilter[])new QFilter("realcard", "in", realIdSet).toArray());
            Set realCardPks = finCards.stream().map(v -> v.get("realcard")).collect(Collectors.toSet());
            FaRealCardDaoFactory.getInstance().batchUpdateBizStatus(realCardPks.toArray(), BizStatusEnum.ADD);
            HashMap<Long, Long> fin_RealMap = new HashMap<Long, Long>(finCards.size());
            for (DynamicObject fincard : finCards) {
                fin_RealMap.put(fincard.getLong("id"), fincard.getLong("realcard"));
            }
            if (fin_RealMap.size() > 0) {
                OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"fa_initcard_fin", (Object[])fin_RealMap.keySet().toArray(), null);
                FaCommonUtils.handleOperationResult((OperationResult)result);
            }
            IDataEntityType type = FaRealCardDaoFactory.getBaseInstance().getEmptyDynamicObject().getDataEntityType();
            DataEntityCacheManager cacheManager = new DataEntityCacheManager(type);
            cacheManager.removeByPrimaryKey(this.getOperationResult().getSuccessPkIds().toArray());
        }
        catch (Exception ex) {
            throw new KDBizException(new ErrorCode("UNKNOWN_ERR", String.format(ResManager.loadKDString((String)"%s\r\n\u5220\u9664\u8d22\u52a1\u5361\u7247\u5931\u8d25.", (String)"FaCardOperationPlugin_16", (String)"fi-fa-opplugin", (Object[])new Object[0]), ex.getMessage())), new Object[0]);
        }
    }

    private void restoreInitFields(DynamicObject[] dataEntities) {
        Set initFields = FaChangeItemUtil.getAllInitFields((String)"fa_card_real");
        if (initFields.isEmpty()) {
            return;
        }
        Set pks = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        DynamicObject[] realCards = BusinessDataServiceHelper.load((String)"fa_card_real", (String)String.join((CharSequence)",", initFields), (QFilter[])new QFilter("id", "in", pks).toArray());
        FaCardInitFieldUtil.restoreInitFields((DynamicObject[])realCards);
        SaveServiceHelper.save((DynamicObject[])realCards);
    }

    public void doFaOp(String operationKey, String billName, DynamicObject[] dataEntities, Map<String, Object> otherParams) {
        if ("audit".equals(operationKey) || "generatefincard".equals(operationKey)) {
            CardGenerateHelper.generateFinCard(Arrays.asList(dataEntities));
            this.restoreInitFields(dataEntities);
        } else if ("unaudit".equals(operationKey) || "deletefincard".equals(operationKey)) {
            this.deleteFinCardOnly(Arrays.asList(dataEntities));
            this.restoreInitFields(dataEntities);
        }
    }
}

