/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.business.dao.IFaClearDao;
import kd.fi.fa.business.dao.factory.FaClearBillDaoFactory;
import kd.fi.fa.business.dao.impl.FaDaoOrmImpl;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.FaClearApplyBillValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaClearApplyBillUnAuditOp
extends AbstractBizCtrOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("clrapplybill_entry");
        e.getFieldKeys().add("clrapplybill_entry.realcard");
        e.getFieldKeys().add("clrapplybill_entry.realcard.masterid");
        e.getFieldKeys().add("clrapplybill_entry.clearqty");
        e.getFieldKeys().add("cleardate");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("isgenclearbill");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaClearApplyBillValidator());
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        IFaClearDao clearDao = FaClearBillDaoFactory.getInstance();
        List<DynamicObject> clearApplyBillList = FaOpUtils.getDataEntities(e);
        Set billIdSet = clearApplyBillList.stream().map(v -> v.getPkValue()).collect(Collectors.toSet());
        HashMap billDataMap = new HashMap(clearApplyBillList.size());
        clearApplyBillList.forEach(v -> billDataMap.put(v.getPkValue(), v));
        for (Object billId : billIdSet) {
            OperateErrorInfo errInfo;
            DynamicObject clear = clearDao.queryOne(FaDaoOrmImpl.comma((String[])new String[]{"id", "billstatus"}), new QFilter[]{new QFilter("srcbill", "=", billId), new QFilter("clearsource", "=", (Object)"APPLY")});
            if (clear == null || BillStatus.C.name().equals(clear.get("billstatus"))) continue;
            OperateOption operateOption = OperateOption.create();
            operateOption.setVariableValue("deleteClearBillByUnAudit", "true");
            operateOption.setVariableValue("ishasright", String.valueOf(true));
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)"fa_clearbill", (Object[])new Object[]{clear.getPkValue()}, (OperateOption)operateOption);
            if (result.isSuccess()) continue;
            clearApplyBillList.remove(billDataMap.get(billId));
            this.getOperationResult().getSuccessPkIds().remove(billId);
            this.getOperationResult().setSuccess(false);
            List errorInfoList = result.getAllErrorOrValidateInfo();
            if (errorInfoList.size() == 0) {
                errInfo = new OperateErrorInfo();
                errInfo.setPkValue(billId);
                errInfo.setMessage(result.getMessage());
                errInfo.setLevel(ErrorLevel.FatalError);
                this.getOperationResult().getAllErrorInfo().add(errInfo);
                continue;
            }
            for (IOperateInfo ori : errorInfoList) {
                errInfo = (OperateErrorInfo)ori;
                errInfo.setPkValue(billId);
                this.getOperationResult().getAllErrorInfo().add(errInfo);
            }
        }
        e.setDataEntities(clearApplyBillList.toArray(new DynamicObject[0]));
        super.beginOperationTransaction(e);
        for (DynamicObject clearApplyBill : clearApplyBillList) {
            clearApplyBill.set("isgenclearbill", (Object)Boolean.FALSE);
        }
    }
}

