/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.clear.ClearBillGenerateFacade;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.FaClearBillAdjust2BizDateValidator;
import kd.fi.fa.opplugin.FaClearBillSaveValidator;
import kd.fi.fa.opplugin.changebill.validator.FaSourceFlagValidator;
import kd.fi.fa.opplugin.clear.FaClearBillOpUtils;
import kd.fi.fa.opplugin.validator.FaChangeApplyValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaClearBillSaveOp
extends AbstractBizCtrOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("clearsource");
        fieldKeys.add("cleardate");
        fieldKeys.add("fincard");
        fieldKeys.add("assetvalue");
        fieldKeys.add("detail_entry");
        fieldKeys.add("detail_entry.fincard.period");
        fieldKeys.add("detail_entry.fincard.finaccountdate");
        fieldKeys.add("detail_entry.realcardmasterid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaClearBillSaveValidator());
        e.addValidator((AbstractValidator)new FaClearBillAdjust2BizDateValidator());
        e.addValidator((AbstractValidator)new FaSourceFlagValidator("detail_entry", "realcard"));
        e.addValidator((AbstractValidator)new FaChangeApplyValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        FaClearBillOpUtils.clearPeriodValuation(e);
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        FaOpUtils.updateMasterIdByRealCard4Entries(e.getDataEntities(), "detail_entry", "realcard");
        FaModiRealStatsUtils.saveUpdate_clearBill_bizStatus((BeginOperationTransactionArgs)e, (String)"detail_entry", (String)"realcard");
        for (DynamicObject dataEntity : e.getDataEntities()) {
            FaModiRealStatsUtils.update_clearBill_partBizStatus((DynamicObject)dataEntity, (BizStatusEnum)BizStatusEnum.CLEAR_PART, (BizStatusEnum)BizStatusEnum.CLEAR_ALL);
        }
        for (DynamicObject dataEntity : e.getDataEntities()) {
            this.resetValueClearBill(dataEntity);
        }
    }

    public void resetValueClearBill(DynamicObject clearBill) {
        ClearBillGenerateFacade facade = new ClearBillGenerateFacade();
        facade.resetBeforeSave(clearBill, false);
    }
}

