/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.common.util.FaCurrencyUtil;

public class FaClearBillSubmitCompFieldValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            DynamicObjectCollection clearEntries = bill.getDynamicObjectCollection("detail_entry");
            int rowIndex = 0;
            for (DynamicObject clearEntryEntity : clearEntries) {
                BigDecimal clearqty_db;
                ++rowIndex;
                DynamicObject realCard = clearEntryEntity.getDynamicObject("realcard");
                if (realCard == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c,\u5361\u7247\u4e0d\u5b58\u5728\uff0c\u8bf7\u5148\u68c0\u67e5\u6570\u636e\u3002", (String)"FaClearBillSubmitCompFieldValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), rowIndex));
                }
                String bizStatus = clearEntryEntity.getString("realcard.bizstatus");
                String number = clearEntryEntity.getString("realcard.number");
                if (!(bizStatus.equals(BizStatusEnum.READY.name()) || bizStatus.equals(BizStatusEnum.CLEAR_ALL.name()) || bizStatus.equals(BizStatusEnum.CLEAR_PART.name()))) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247\u201c%s\u201d\u6b63\u5728\u505a\u522b\u7684\u4e1a\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FaClearBillSubmitCompFieldValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), number));
                    continue;
                }
                BigDecimal clearqty = clearEntryEntity.getBigDecimal("assetqty");
                if (clearqty.compareTo(clearqty_db = clearEntryEntity.getBigDecimal("realcard.assetamount")) != 0) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u524d\u8d44\u4ea7\u6570\u91cf[%2$s]\u4e0e\u5b9e\u7269\u5361\u7247\u7684\u6570\u91cf[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillSubmitCompFieldValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, clearqty, clearqty_db));
                    continue;
                }
                BigDecimal clearAssetValue = clearEntryEntity.getBigDecimal("assetvalue");
                BigDecimal cleardecval = clearEntryEntity.getBigDecimal("decval");
                BigDecimal clearpreresidualval = clearEntryEntity.getBigDecimal("preresidualval");
                BigDecimal originalval_db = clearEntryEntity.getBigDecimal("fincard.originalval");
                BigDecimal decval_db = clearEntryEntity.getBigDecimal("fincard.decval");
                BigDecimal preresidualval_db = clearEntryEntity.getBigDecimal("fincard.preresidualval");
                BigDecimal rate = BigDecimal.ONE;
                String isClearAll = clearEntryEntity.getString("isclearall");
                if (!"1".equals(isClearAll)) {
                    rate = clearEntryEntity.getBigDecimal("clearrate");
                }
                DynamicObject basecurrency = clearEntryEntity.getDynamicObject("basecurrency");
                if (clearqty_db.compareTo(BigDecimal.ONE) != 0 && rate.compareTo(BigDecimal.ONE) < 0) {
                    BigDecimal clearAssetValue_sh = originalval_db.multiply(rate);
                    if (clearAssetValue.compareTo(clearAssetValue_sh = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)clearAssetValue_sh)) != 0) {
                        this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u524d\u539f\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u539f\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillSubmitCompFieldValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, clearAssetValue, clearAssetValue_sh));
                        continue;
                    }
                }
                BigDecimal cleardecval_sh = decval_db.multiply(rate);
                cleardecval_sh = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)cleardecval_sh);
                BigDecimal clearpreresidualval_sh = preresidualval_db.multiply(rate);
                clearpreresidualval_sh = FaCurrencyUtil.parseByCurAmtPrecision((DynamicObject)basecurrency, (BigDecimal)clearpreresidualval_sh);
                if (clearEntryEntity.getBigDecimal("netamount").compareTo(clearEntryEntity.getBigDecimal("preresidualval")) != 0 && clearpreresidualval.compareTo(clearpreresidualval_sh) != 0) {
                    this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u524d\u6b8b\u503c[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u6b8b\u503c[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillSubmitCompFieldValidator_4", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, clearpreresidualval, clearpreresidualval_sh));
                    continue;
                }
                if (cleardecval.compareTo(cleardecval_sh) == 0) continue;
                this.addMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5361\u7247[%1$s]\u6e05\u7406\u524d\u51cf\u503c\u51c6\u5907[%2$s]\u4e0e\u8d22\u52a1\u5361\u7247\u7684\u51cf\u503c\u51c6\u5907[%3$s]\u4e0d\u4e00\u81f4\uff0c\u8bf7\u6838\u5bf9\u662f\u5426\u505a\u4e86\u5176\u4ed6\u4e1a\u52a1\uff1b", (String)"FaClearBillSubmitCompFieldValidator_5", (String)"fi-fa-opplugin", (Object[])new Object[0]), number, cleardecval, cleardecval_sh));
            }
        }
    }
}

