/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.opplugin.AbstractBizCtrOperationServicePlugIn;
import kd.fi.fa.opplugin.FaClearBillAdjust2BizDateValidator;
import kd.fi.fa.opplugin.FaClearBillSaveOp;
import kd.fi.fa.opplugin.FaClearBillSubmitCompFieldValidator;
import kd.fi.fa.opplugin.FaClearBillSubmitValidator;
import kd.fi.fa.opplugin.FaMigrateDateValidator;
import kd.fi.fa.opplugin.changebill.validator.FaSourceFlagValidator;
import kd.fi.fa.opplugin.clear.FaClearBillOpUtils;
import kd.fi.fa.opplugin.validator.FaChangeApplyValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaClearBillSubmitOp
extends AbstractBizCtrOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("detail_entry.fincard.period");
        fieldKeys.add("detail_entry.fincard.finaccountdate");
        fieldKeys.addAll(this.billEntityType.getAllFields().keySet());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaMigrateDateValidator());
        e.addValidator((AbstractValidator)new FaClearBillSubmitValidator());
        e.addValidator((AbstractValidator)new FaClearBillAdjust2BizDateValidator());
        e.addValidator((AbstractValidator)new FaClearBillSubmitCompFieldValidator());
        e.addValidator((AbstractValidator)new FaSourceFlagValidator("detail_entry", "realcard"));
        e.addValidator((AbstractValidator)new FaChangeApplyValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        FaOpUtils.updateMasterIdByRealCard4Entries(e.getDataEntities(), "detail_entry", "realcard");
        FaClearBillOpUtils.clearPeriodValuation(e);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            new FaClearBillSaveOp().resetValueClearBill(dataEntity);
        }
    }

    @Override
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        FaModiRealStatsUtils.saveUpdate_clearBill_bizStatus((BeginOperationTransactionArgs)e, (String)"detail_entry", (String)"realcard");
        for (DynamicObject dataEntity : e.getDataEntities()) {
            FaModiRealStatsUtils.update_clearBill_partBizStatus((DynamicObject)dataEntity, (BizStatusEnum)BizStatusEnum.CLEAR_PART, (BizStatusEnum)BizStatusEnum.CLEAR_ALL);
        }
    }
}

