/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;

public class FaDepreMethodSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("yeardeprerate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dpMethodEDEntitys;
                for (ExtendedDataEntity dpMethodEDEntity : dpMethodEDEntitys = this.getDataEntities()) {
                    String type = (String)dpMethodEDEntity.getValue("type");
                    if ("1".equals(type)) {
                        this.checkDepreMethodYear(dpMethodEDEntity);
                    }
                    if (!"51".equals(type) || dpMethodEDEntity.getBillPkId() != null && !dpMethodEDEntity.getBillPkId().equals(0L)) continue;
                    this.addErrorMessage(dpMethodEDEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u65b0\u589e\u7c7b\u578b\u4e3a\u201c\u6309\u65e5\u201d\u7684\u6298\u65e7\u65b9\u6cd5\u3002", (String)"FaDepreMethodSaveOp_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }

            public void checkDepreMethodYear(ExtendedDataEntity dpMethodEDEntity) {
                DynamicObject depreMethodDyn = dpMethodEDEntity.getDataEntity();
                int yearDepre = depreMethodDyn.getInt("yeardepreamount");
                if (yearDepre == 0) {
                    this.addErrorMessage(dpMethodEDEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6298\u65e7\u5e74\u9650", (String)"FaDepreMethodSaveOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection depreMethodYear = depreMethodDyn.getDynamicObjectCollection("entry_year");
                BigDecimal yearsRateCount = BigDecimal.ZERO;
                for (int i = 0; i < depreMethodYear.size(); ++i) {
                    int yearNumber = ((DynamicObject)depreMethodYear.get(i)).getInt("yearnumber");
                    BigDecimal yearDepReRate = ((DynamicObject)depreMethodYear.get(i)).getBigDecimal("yeardeprerate");
                    if (yearDepReRate.compareTo(BigDecimal.ZERO) == 0) {
                        this.addErrorMessage(dpMethodEDEntity, String.format(ResManager.loadKDString((String)"\u8be5\u5e74\uff08\u5e74\uff1a%d\uff09\u7684\u6298\u65e7\u7387\u4e0d\u80fd\u4e3a0\u6216\u8005\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FaDepreMethodSaveOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), yearNumber));
                        break;
                    }
                    DynamicObjectCollection depreMethodPeriod = ((DynamicObject)depreMethodYear.get(i)).getDynamicObjectCollection("entry_period");
                    this.checkDepreMethodPeriod(dpMethodEDEntity, depreMethodPeriod, yearNumber, yearDepReRate);
                    yearsRateCount = yearsRateCount.add(yearDepReRate);
                }
                if (yearsRateCount.compareTo(BigDecimal.valueOf(100L)) > 0) {
                    this.addErrorMessage(dpMethodEDEntity, ResManager.loadKDString((String)"\u5e74\u6298\u65e7\u7387\u76f8\u52a0\u4e0d\u80fd\u5927\u4e8e100%\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FaDepreMethodSaveOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }

            public void checkDepreMethodPeriod(ExtendedDataEntity dpMethodEDEntity, DynamicObjectCollection depreMethodPeriod, int yearNumber, BigDecimal yearDepreRate) {
                BigDecimal periodsRateCount = BigDecimal.ZERO;
                for (int i = 0; i < depreMethodPeriod.size(); ++i) {
                    BigDecimal periodDepReRate = ((DynamicObject)depreMethodPeriod.get(i)).getBigDecimal("perioddeprerate");
                    if (periodDepReRate.compareTo(BigDecimal.ZERO) == 0) continue;
                    periodsRateCount = periodsRateCount.add(periodDepReRate);
                }
                if (periodsRateCount.compareTo(yearDepreRate) != 0) {
                    this.addErrorMessage(dpMethodEDEntity, String.format(ResManager.loadKDString((String)"\u7b2c%s\u5e74\u7684\u671f\u6298\u65e7\u7387\u76f8\u52a0\u4e0d\u7b49\u4e8e\u8be5\u5e74\u7684\u6298\u65e7\u7387\uff0c\u8bf7\u4fee\u6539", (String)"FaDepreMethodSaveOp_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), yearNumber));
                }
            }
        });
        super.onAddValidators(e);
    }
}

