/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.depretask.FaDailyDepreTask;

public class FaDepreciateOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FaDepreciateOpPlugin.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] assetBooks;
        super.beginOperationTransaction(e);
        for (DynamicObject assetBook : assetBooks = e.getDataEntities()) {
            this.depreciate(assetBook);
        }
    }

    private void depreciate(DynamicObject assetBook) {
        String assetBookName = assetBook.getString("name");
        Object pkValue = assetBook.getPkValue();
        try {
            logger.info(assetBookName + ": \u5f00\u59cb\u6267\u884c\u6298\u65e7");
            OperateOption option = this.getOption();
            boolean userInvoke = option.containsVariable("fromFaDepreEditPlugin");
            if (userInvoke) {
                new FaDailyDepreTask().doExecute(true, pkValue, true, assetBook.get("org.id"));
            } else {
                FaDailyDepreTask.synExecuteDailyDepre((boolean)Boolean.TRUE, (Object)pkValue, (Object)assetBook.get("org.id"));
            }
            logger.info(assetBookName + ": \u6267\u884c\u6298\u65e7\u6210\u529f");
        }
        catch (Exception e) {
            logger.info("\u6298\u65e7\u5f02\u5e38\uff1a", (Object)e);
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setErrorLevel(ErrorLevel.Error.name());
            errorInfo.setPkValue(pkValue);
            errorInfo.setMessage(e.toString());
            if (e instanceof KDBizException) {
                errorInfo.setMessage(e.getMessage());
            }
            this.operationResult.addErrorInfo(errorInfo);
        }
    }
}

