/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.busyrecord.AbstractBusyRecordServicePlugin;
import kd.fi.fa.business.utils.FaModiRealStatsUtils;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaDevalueAssetValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaDevalueAssetSavePlugin
extends AbstractBusyRecordServicePlugin {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new FaDevalueAssetValidator());
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("changebillentry");
        e.getFieldKeys().add("realcard");
        e.getFieldKeys().add("fincard");
        e.getFieldKeys().add("fincard.decval");
        e.getFieldKeys().add("org");
        e.getFieldKeys().add("depreuse");
        e.getFieldKeys().add("decval");
        e.getFieldKeys().add("devalueperiod");
        e.getFieldKeys().add("businessdate");
        e.getFieldKeys().add("decvalsum");
        e.getFieldKeys().add("changebillentry.compfieldsv");
        e.getFieldKeys().add(Fa.dot((String[])new String[]{"changebillentry", "realcardmasterid"}));
        e.getFieldKeys().add("isadjustdepre");
        e.getFieldKeys().add("createtime");
        e.getFieldKeys().add("modifytime");
        e.getFieldKeys().add("auditdate");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        FaOpUtils.updateMasterIdByRealCard4Entries(e.getDataEntities(), "changebillentry", "realcard");
        DynamicObject[] bills = e.getDataEntities();
        FaModiRealStatsUtils.saveUpdate_allBill_bizStatus((BeginOperationTransactionArgs)e, (String)"changebillentry", (String)"realcard", (BizStatusEnum)BizStatusEnum.DEVALUE, (BizStatusEnum)BizStatusEnum.READY);
        for (DynamicObject devalueAsset : bills) {
            long orgId = devalueAsset.getLong(Fa.id((String)"org"));
            long depreUseId = devalueAsset.getLong(Fa.id((String)"depreuse"));
            long periodId = devalueAsset.getLong(Fa.id((String)"devalueperiod"));
            BigDecimal devalueSum = new BigDecimal(0);
            DynamicObjectCollection entry = devalueAsset.getDynamicObjectCollection("changebillentry");
            HashSet<Long> cardIds = new HashSet<Long>(FaUtils.getInitialCapacity43((int)entry.size()));
            for (DynamicObject dy : entry) {
                cardIds.add(dy.getLong("realcardmasterid"));
                devalueSum = devalueSum.add(dy.getBigDecimal("decval"));
            }
            devalueAsset.set("decvalsum", (Object)devalueSum);
            DataSet hasAdjustCardDataSet = QueryServiceHelper.queryDataSet((String)"queryCardsHasAdjust4Period", (String)"fa_depreadjustbill", (String)Fa.dot((String[])new String[]{"entryentity", "realcard"}), (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("depreuse", "=", (Object)depreUseId), new QFilter("period", "=", (Object)periodId), new QFilter(Fa.dot((String[])new String[]{"entryentity", "realcard"}), "in", cardIds)}, null);
            HashSet<Long> hasAdjustCardIds = new HashSet<Long>(FaUtils.getInitialCapacity43((int)cardIds.size()));
            while (hasAdjustCardDataSet.hasNext()) {
                hasAdjustCardIds.add(hasAdjustCardDataSet.next().getLong(Fa.dot((String[])new String[]{"entryentity", "realcard"})));
            }
            for (DynamicObject dy : entry) {
                dy.set("isadjustdepre", (Object)hasAdjustCardIds.contains(dy.getLong("realcardmasterid")));
            }
        }
    }
}

