/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.fi.fa.business.utils.SystemParamHelper;
import kd.fi.fa.business.validator.AssetDeValueValidator;
import kd.fi.fa.opplugin.AbstractFaValidator;

public class FaDevalueAssetValidator
extends AbstractFaValidator {
    public void validate() {
        HashMap<Long, Boolean> orgId2SumMutilVou = new HashMap<Long, Boolean>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String operateKey = this.getOperateKey();
            DynamicObject bill = dataEntity.getDataEntity();
            List errorInfo = new ArrayList();
            boolean enableSumMutilVoucher = false;
            Long orgId = bill.getLong("org.id");
            if (orgId2SumMutilVou.get(orgId) != null) {
                enableSumMutilVoucher = (Boolean)orgId2SumMutilVou.get(orgId);
            } else {
                enableSumMutilVoucher = SystemParamHelper.getBooleanParam((String)"enable_sum_mutil_voucher", (long)orgId, (boolean)false);
                orgId2SumMutilVou.put(orgId, enableSumMutilVoucher);
            }
            switch (operateKey) {
                case "submit": {
                    errorInfo = AssetDeValueValidator.validateForSubmit((DynamicObject)bill, (Boolean)enableSumMutilVoucher);
                    break;
                }
                case "save": {
                    errorInfo = AssetDeValueValidator.validateForSave((DynamicObject)bill, (Boolean)enableSumMutilVoucher);
                    break;
                }
                case "audit": {
                    errorInfo = AssetDeValueValidator.validateForAudit((DynamicObject)bill, (Boolean)enableSumMutilVoucher);
                    break;
                }
                case "unaudit": {
                    errorInfo = AssetDeValueValidator.validateForUnAudit((DynamicObject)bill, (Boolean)enableSumMutilVoucher);
                    break;
                }
            }
            if (errorInfo.isEmpty()) continue;
            String errorMsg = String.join((CharSequence)"", errorInfo);
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }
}

