/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.fa.business.utils.FaDisDepreLogUtils;
import kd.fi.fa.business.utils.FunctionMutexHelper;

public class FaDisDepreLogManInterupt
extends AbstractOperationServicePlugIn {
    private static String updateTaskInit2Interrupt = "update t_fa_disdepre_task set fentrystatus = 'E' where fid = ? and fentrystatus = 'A'";
    private static String updateDisDepre2Interrupt = "update t_fa_disdepre_log set fstatus = 'E',ffinishtime = ? where fid = ? and fstatus in ('A', 'B')";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("id");
        e.getFieldKeys().add("needlock");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        DynamicObject[] logList = args.getDataEntities();
        if (logList == null || logList.length == 0) {
            return;
        }
        for (DynamicObject log : logList) {
            Long disLogId = log.getLong("id");
            try (TXHandle h = TX.requiresNew();){
                try {
                    DB.update((DBRoute)DBRoute.of((String)"fa"), (String)updateTaskInit2Interrupt, (Object[])new Object[]{disLogId});
                    DB.update((DBRoute)DBRoute.of((String)"fa"), (String)updateDisDepre2Interrupt, (Object[])new Object[]{new Date(), disLogId});
                    h.commit();
                }
                catch (Throwable e1) {
                    h.markRollback();
                    throw e1;
                }
            }
            boolean isInitOrDoing = FaDisDepreLogUtils.haveInitOrDoingTask((Long)disLogId);
            if (isInitOrDoing) {
                return;
            }
            boolean needlock = log.getBoolean("needlock");
            if (!needlock) continue;
            Long bookId = log.getLong("assetbook.id");
            DynamicObject bookObj = BusinessDataServiceHelper.loadSingle((Object)bookId, (String)"fa_assetbook");
            FunctionMutexHelper.releaseLockWithBook((String)"fa_new_depre", (DynamicObject)bookObj);
        }
    }
}

