/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.fi.fa.business.constants.FaClearSourceEnum;
import kd.fi.fa.business.utils.FaFindPeriodHelper;
import kd.fi.fa.business.utils.FaUtils;
import kd.fi.fa.common.util.Fa;

public class FaDisposalSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Set orgIds = Arrays.stream(dataEntities).map(v -> v.getDataEntity().getLong(Fa.id((String)"org"))).collect(Collectors.toSet());
        DynamicObjectCollection mainBookByOrgIds = FaUtils.getMainBookByOrgIds(orgIds);
        Map<Long, Long> orgId2PeriodTypeIdMap = mainBookByOrgIds.stream().collect(Collectors.toMap(v -> v.getLong("org"), v -> v.getLong("periodtype")));
        HashMap<Long, FaFindPeriodHelper> periodType2PeriodTreeMap = new HashMap<Long, FaFindPeriodHelper>(orgId2PeriodTypeIdMap.size());
        for (Map.Entry<Long, Long> orgId2PeriodTypeId : orgId2PeriodTypeIdMap.entrySet()) {
            Long periodTypeId = orgId2PeriodTypeId.getValue();
            periodType2PeriodTreeMap.computeIfAbsent(periodTypeId, v -> new FaFindPeriodHelper(periodTypeId));
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Date disposalDate;
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObject org = entity.getDynamicObject("org");
            Long periodType = orgId2PeriodTypeIdMap.get(org.getLong("id"));
            if (periodType == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6838\u7b97\u7ec4\u7ec7\u3010%s\u3011\u5bf9\u5e94\u7684\u4e3b\u8d26\u7c3f\u4e0d\u5b58\u5728\u3002", (String)"FaDisposalSubmitValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), org.getString("name")));
                continue;
            }
            FaFindPeriodHelper findPeriodHelper = (FaFindPeriodHelper)periodType2PeriodTreeMap.get(periodType);
            DynamicObject periodDy = findPeriodHelper.findPeriodObjByDate(disposalDate = entity.getDate("bizdate"));
            if (periodDy == null) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8bb0\u8d26\u65e5\u671f\u201c%s\u201d\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u671f\u95f4\u3002", (String)"FaDisposalSubmitValidator_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), Fa.getDF().format(disposalDate)));
                continue;
            }
            Date endDate = periodDy.getDate("enddate");
            DynamicObjectCollection detail = (DynamicObjectCollection)dataEntity.getValue("detail");
            HashSet<Long> clearBillIdSet = new HashSet<Long>(detail.size());
            for (DynamicObject clearbill : detail) {
                clearBillIdSet.add(clearbill.getLong(Fa.dot((String[])new String[]{"clearbill", "id"})));
                Date clearDate = clearbill.getDate("clearbill.bizdate");
                if (clearDate.compareTo(endDate) <= 0) continue;
                int seq = clearbill.getInt("seq");
                this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u8d44\u4ea7\u6e05\u7406\u4e1a\u52a1\u65e5\u671f\u4e0d\u80fd\u5927\u4e8e\u5904\u7f6e\u5355\u4e1a\u52a1\u65e5\u671f\u5bf9\u5e94\u671f\u95f4\u6700\u540e\u4e00\u5929\u3002", (String)"FaDisposalSubmitValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), seq));
            }
            this.checkClearBillSource(dataEntity, clearBillIdSet);
        }
    }

    private void checkClearBillSource(ExtendedDataEntity dataEntity, Set<Long> clearBillIdSet) {
        QFilter[] filters = new QFilter[]{new QFilter("id", "in", clearBillIdSet), new QFilter("clearsource", "=", (Object)FaClearSourceEnum.MERGE.name())};
        DynamicObjectCollection clearBills = QueryServiceHelper.query((String)"fa_clearbill", (String)"billno", (QFilter[])filters);
        if (CollectionUtils.isNotEmpty((Collection)clearBills)) {
            String billNos = clearBills.stream().map(t -> t.getString("billno")).collect(Collectors.joining(";"));
            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u6e05\u7406\u5355[$s]\u7531\u5408\u5e76\u5355\u4ea7\u751f\uff0c\u4e0d\u5141\u8bb8\u505a\u8d44\u4ea7\u5904\u7f6e\u3002", (String)"FaDisposalSubmitValidator_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), billNos));
        }
    }
}

