/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRow;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;

public class FaDisposalUnauditValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            billIds.add(Long.parseLong(dataEntity.getBillPkId().toString()));
        }
        Map targetBills = BFTrackerServiceHelper.findDirtTargetBills((String)this.getEntityKey(), (Long[])billIds.toArray(new Long[0]));
        this.validateUnudit(dataEntities, targetBills);
        Map<Long, Long> daptrackerMap = this.validateVoucher(billIds);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            if (!daptrackerMap.containsKey(dataEntity.getBillPkId())) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"FaDisposalUnauditValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private void validateUnudit(ExtendedDataEntity[] dataEntities, Map<Long, List<BFRow>> targetBills) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Object id = dataEntity.getBillPkId();
            List<BFRow> pushBills = targetBills.get(id);
            if (pushBills == null || pushBills.size() <= 0) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5904\u7f6e\u5355\u5b58\u5728\u4e0b\u63a8\u5355\u636e\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"FaDisposalUnauditValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private Map<Long, Long> validateVoucher(List<Long> billIds) {
        String selectfields = "id,sourcebillid";
        DynamicObjectCollection daptrackers = QueryServiceHelper.query((String)"ai_daptracker", (String)selectfields, (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", billIds)});
        HashMap<Long, Long> daptrackerMap = new HashMap<Long, Long>(16);
        for (DynamicObject daptracker : daptrackers) {
            Long id = daptracker.getLong("id");
            Long sourcebillid = daptracker.getLong("sourcebillid");
            if (sourcebillid == null || sourcebillid == 0L || id == null || id == 0L || !billIds.contains(daptracker.get("sourcebillid"))) continue;
            daptrackerMap.put(sourcebillid, id);
        }
        return daptrackerMap;
    }
}

