/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;

public class FaImportInventorySaveOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> inventoryRecordIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            inventoryRecordIds.add(dataEntity.getLong("id"));
        }
        if (dataEntities[0] == null) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)dataEntities[0].getString("reason"))) {
            String sic = Fa.join((String)",", (String[])new String[]{"difference,inventoryuser,inventorystate,inventoryway,inventorytime,bookquantity"});
            QFilter idCond = new QFilter("id", "in", inventoryRecordIds);
            DynamicObjectCollection inventoryRecords = QueryServiceHelper.query((String)"fa_inventory_record", (String)sic, (QFilter[])new QFilter[]{idCond});
            Date now = new Date();
            Long userIdLong = ContextUtil.getUserId();
            for (DynamicObject inventoryRecord : inventoryRecords) {
                inventoryRecord.set("inventoryuser", (Object)userIdLong);
                inventoryRecord.set("inventorystate", (Object)"A");
                inventoryRecord.set("inventoryway", (Object)"A");
                inventoryRecord.set("inventorytime", (Object)now);
            }
            MainEntityType inventoryRecordType = EntityMetadataCache.getDataEntityType((String)"fa_inventory_record");
            SaveServiceHelper.save((IDataEntityType)inventoryRecordType, (Object[])inventoryRecords.toArray((Object[])new DynamicObject[0]));
        } else {
            for (DynamicObject dataEntity : dataEntities) {
                dataEntity.set("reason", (Object)dataEntity.getString("reason"));
            }
        }
    }
}

