/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.calc.DynamicObjectWrapper;
import kd.fi.fa.business.calc.FinCardCalc;
import kd.fi.fa.business.calc.IObjWrapper;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaBaseDaoFactory;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.business.dao.factory.FaRealCardDaoFactory;
import kd.fi.fa.business.enums.BusyTypeDetailEnum;
import kd.fi.fa.business.periodclose.FutureBizChecker;
import kd.fi.fa.business.utils.AssetPolicyUtil;
import kd.fi.fa.business.utils.FaCardBotpUtil;
import kd.fi.fa.business.utils.FaFinCardUtil;
import kd.fi.fa.business.utils.PeriodUtil;
import kd.fi.fa.business.validator.FinCardValidator;
import kd.fi.fa.common.util.DateUtil;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaAbstractFinCardOp;
import kd.fi.fa.opplugin.FaFinValidatorUtils;
import kd.fi.fa.opplugin.LeasePushCardValidator;
import kd.fi.fa.utils.FaAssetCardUtils;

public class FaInitFinCardSaveOp
extends FaAbstractFinCardOp {
    private static final String DATE_FORMAT = "yyyy-MM-dd";
    private final Map<Object, List<String>> depresystemCache = new HashMap<Object, List<String>>();
    private final Map<Object, DynamicObject> assetObjects = new HashMap<Object, DynamicObject>();
    private final Map<Object, Date> enablePeriodMapCache = new HashMap<Object, Date>();

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("realcard");
        fieldKeys.add(Fa.join((String)".", (String[])new String[]{"realcard", "sourceflag"}));
        fieldKeys.add("org");
        fieldKeys.add("depreuse");
        fieldKeys.add("number");
        fieldKeys.add("depreuse");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        super.beginOperationTransaction(e);
        for (DynamicObject fincard : dataEntities = e.getDataEntities()) {
            DynamicObjectWrapper objWrapper = new DynamicObjectWrapper(fincard);
            FinCardCalc.setNetWorth((IObjWrapper)objWrapper);
            FinCardCalc.setNetAmount((IObjWrapper)objWrapper);
        }
        String oerateName = e.getOperationKey();
        if ("save".equals(oerateName)) {
            Stream.of(dataEntities).forEach(v -> v.set("billstatus", (Object)BillStatus.C));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Long> fincards = new ArrayList<Long>(dataEntities.length);
        HashMap<Long, Set> depreUseToRealMap = new HashMap<Long, Set>(4);
        for (DynamicObject finCard : dataEntities) {
            long depreUseId = finCard.getLong(Fa.id((String)"depreuse"));
            Set realCardIdSet = depreUseToRealMap.computeIfAbsent(depreUseId, v -> new HashSet(dataEntities.length));
            long realCardId = finCard.getLong(Fa.id((String)"realcard"));
            realCardIdSet.add(realCardId);
            fincards.add(finCard.getLong("id"));
        }
        String selectfields = "realcard.id,assetbook.id,depreuse.id,finaccountdate,accumdepre,decval,realcard.initialcard";
        DynamicObjectCollection finCardPlainObjs = QueryServiceHelper.query((String)"fa_card_fin", (String)selectfields, (QFilter[])new QFilter("id", "in", fincards).toArray());
        Set realCardPks = finCardPlainObjs.stream().map(v -> v.get("realcard.id")).collect(Collectors.toSet());
        QFilter[] unAuditFilter = new QFilter[]{new QFilter("realcard.id", "in", realCardPks), new QFilter("billstatus", "!=", (Object)BillStatus.C.toString())};
        DynamicObjectCollection finCardUnAuditPlainObjs = QueryServiceHelper.query((String)"fa_card_fin", (String)"realcard.id", (QFilter[])unAuditFilter);
        Set realCardNotReadyPks = finCardUnAuditPlainObjs.stream().map(v -> v.get("realcard.id")).collect(Collectors.toSet());
        realCardPks.removeAll(realCardNotReadyPks);
        FaRealCardDaoFactory.getInstance().batchUpdateBizStatus(realCardPks.toArray(), BizStatusEnum.READY);
        IFaFinCardDao fCardDao = FaFinCardDaoFactory.getInstance();
        for (Map.Entry entry : depreUseToRealMap.entrySet()) {
            fCardDao.copyFinCards(0L, ((Long)entry.getKey()).longValue(), ((Set)entry.getValue()).toArray(), null, null, null);
        }
        Object[] finCardIdArr = Stream.of(dataEntities).map(v -> v.getLong("id")).toArray();
        FaCardBotpUtil.repairBotp((Object[])finCardIdArr);
        FaAssetCardUtils.updateAssetCardFinEntry4FinSave(e.getDataEntities());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        StringBuilder sb;
        super.afterExecuteOperationTransaction(e);
        if (this.getOperationResult().isSuccess()) {
            this.deleteBotp4InitFinCard(e.getDataEntities());
        }
        DynamicObject[] entities = e.getDataEntities();
        Object[] finCardIdArr = Stream.of(entities).map(v -> v.getLong("id")).toArray();
        DynamicObject[] newFinArr = BusinessDataServiceHelper.load((Object[])finCardIdArr, (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"fa_card_fin"));
        HashMap<String, Object> number2NewID = new HashMap<String, Object>(finCardIdArr.length, 1.0f);
        for (DynamicObject newFin : newFinArr) {
            sb = new StringBuilder();
            sb.append(newFin.getString("assetbook.id")).append("_").append(newFin.getString("number"));
            number2NewID.put(sb.toString(), newFin.get("id"));
        }
        for (DynamicObject fin : entities) {
            sb = new StringBuilder();
            sb.append(fin.getString("assetbook.id")).append("_").append(fin.getString("number"));
            Object newId = number2NewID.get(sb.toString());
            fin.set("id", newId);
        }
    }

    private void deleteBotp4InitFinCard(DynamicObject[] finCards) {
        Object[] finCardIdArr = Arrays.stream(finCards).map(DataEntityBase::getPkValue).toArray();
        FaCardBotpUtil.deleteBotp4InitFinCard((Object[])finCardIdArr);
    }

    private Optional<String> checkFutureBiz(DynamicObject realCard) {
        DynamicObject[] realCards = FaRealCardDaoFactory.getInstance().query("id", new QFilter("masterid", "=", (Object)realCard.getLong("masterid")));
        Set realCardPkSet = Arrays.stream(realCards).map(v -> (Long)v.get("id")).collect(Collectors.toSet());
        Object orgId = realCard.get("org.id");
        FutureBizChecker futureBizChecker = new FutureBizChecker(null, orgId, realCardPkSet, null, BusyTypeDetailEnum.REAL_FIN_CHG);
        futureBizChecker.setFromFin(true);
        return futureBizChecker.check();
    }

    private Optional<String> checkFinFutureBiz(DynamicObject finCard) {
        DynamicObject realCard = finCard.getDynamicObject("realcard");
        realCard = FaRealCardDaoFactory.getInstance().queryOne("masterid", realCard.getPkValue());
        DynamicObject[] realCards = FaRealCardDaoFactory.getInstance().query("id", new QFilter("masterid", "=", (Object)realCard.getLong("masterid")));
        Set realCardPkSet = Arrays.stream(realCards).map(v -> (Long)v.get("id")).collect(Collectors.toSet());
        Object orgId = finCard.get("org.id");
        FutureBizChecker futureBizChecker = new FutureBizChecker(null, orgId, realCardPkSet, null, BusyTypeDetailEnum.REAL_FIN_CHG);
        futureBizChecker.setFromFin(true);
        return futureBizChecker.checkWhenun();
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (dataEntities.length > 0 && !dataEntities[0].getBoolean("isimport")) {
            return;
        }
        HashSet<Long> orgIdSet = new HashSet<Long>(dataEntities.length);
        HashSet<String> numbersFinSet = new HashSet<String>(dataEntities.length);
        for (DynamicObject fincard : dataEntities) {
            orgIdSet.add(fincard.getLong("org_id"));
            numbersFinSet.add(fincard.getString("number"));
        }
        DynamicObjectCollection realCards = QueryServiceHelper.query((String)"fa_card_real", (String)String.join((CharSequence)",", "id", "org", "headusedept", "assetcat", "billno", "number", "sourceflag", "realaccountdate", "billstatus"), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdSet), new QFilter("number", "in", numbersFinSet), new QFilter("sourceflag", "in", (Object)new String[]{"INITIAL", "INITLEASECONTRACT"})});
        HashMap<String, DynamicObject> realCardsMap = new HashMap<String, DynamicObject>(realCards.size());
        for (DynamicObject realCard : realCards) {
            realCardsMap.put(realCard.getString("org") + "-" + realCard.getString("number"), realCard);
        }
        for (DynamicObject finCard : dataEntities) {
            DynamicObject realCard = (DynamicObject)realCardsMap.get(finCard.getString("org_id") + "-" + finCard.getString("number"));
            if (realCard == null) continue;
            long realCardId = realCard.getLong("id");
            finCard.set("realcard", null);
            finCard.set("realcard_id", (Object)realCardId);
            finCard.set("billno", (Object)realCard.getString("billno"));
            finCard.set("assetcat_id", (Object)realCard.getLong("assetcat"));
            finCard.set("depredept_id", (Object)realCard.getLong("headusedept"));
        }
    }

    private Set getNumbers(ExtendedDataEntity[] dataEntities) {
        Set numbers = Arrays.stream(dataEntities).map(v -> v.getDataEntity().getString("number")).collect(Collectors.toSet());
        return numbers;
    }

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            /*
             * WARNING - void declaration
             */
            public void validate() {
                String operationName = this.getValidateContext().getOperateName();
                if ("save".equals(this.getOperateKey())) {
                    ExtendedDataEntity[] dataEntities = this.getDataEntities();
                    if (dataEntities.length < 1) {
                        return;
                    }
                    this.checkAssetBookEnable(dataEntities);
                    Set numbers = FaInitFinCardSaveOp.this.getNumbers(dataEntities);
                    QFilter[] filters = new QFilter[]{new QFilter("bizperiod", "=", (Object)0L), new QFilter("number", "in", (Object)numbers)};
                    DynamicObjectCollection fincards = QueryServiceHelper.query((String)"fa_card_fin", (String)"depreuse,number", (QFilter[])filters);
                    HashMap<Object, Set> depreuse_numbers = new HashMap<Object, Set>();
                    for (DynamicObject fincard : fincards) {
                        Object key = fincard.get("depreuse");
                        if (!depreuse_numbers.containsKey(key)) {
                            depreuse_numbers.put(key, new HashSet());
                        }
                        ExtendedDataEntity[] value = (ExtendedDataEntity[])depreuse_numbers.get(key);
                        value.add(fincard.getString("number"));
                    }
                    HashSet<Long> orgIdSet = new HashSet<Long>(dataEntities.length);
                    HashSet<String> numbersFinSet = new HashSet<String>(dataEntities.length);
                    HashSet<Long> depreuseIdSet = new HashSet<Long>(dataEntities.length);
                    for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                        Set numberSet;
                        boolean fromDatabase;
                        DynamicObject fincard = extendedDataEntity.getDataEntity();
                        long depreuseId = fincard.getLong("depreuse_id");
                        String number = fincard.getString("number");
                        String chResult = FaFinValidatorUtils.checkFinAmountPrecision(extendedDataEntity);
                        if (chResult != null && chResult.length() > 0) {
                            this.addMessage(extendedDataEntity, chResult, ErrorLevel.Error);
                        }
                        if (!(fromDatabase = extendedDataEntity.getDataEntity().getDataEntityState().getFromDatabase())) {
                            numberSet = (Set)depreuse_numbers.get(depreuseId);
                            if (depreuse_numbers.containsKey(depreuseId) && numberSet.contains(number)) {
                                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u540c\u4e00\u6298\u65e7\u7528\u9014\u4e0b\uff0c\u8d22\u52a1\u5361\u7247\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u4e0d\u5141\u8bb8\u91cd\u590d\u5bfc\u5165", (String)"FaInitFinCardSaveOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                            }
                        }
                        orgIdSet.add(fincard.getLong("org_id"));
                        numbersFinSet.add(number);
                        depreuseIdSet.add(depreuseId);
                        numberSet = depreuse_numbers.computeIfAbsent(depreuseId, k -> new HashSet(4));
                        numberSet.add(number);
                    }
                    DynamicObject[] realCards = BusinessDataServiceHelper.load((String)"fa_card_real", (String)String.join((CharSequence)",", "id", "org", "headusedept", "assetcat", "billno", "number", "masterid", "sourceflag", "realaccountdate", "billstatus"), (QFilter[])new QFilter[]{new QFilter("org", "in", orgIdSet), new QFilter("number", "in", numbersFinSet), new QFilter("sourceflag", "in", (Object)new String[]{"INITIAL", "INITLEASECONTRACT"})});
                    HashSet<String> numbersSet = new HashSet<String>(realCards.length);
                    HashMap<String, DynamicObject> realCardsMap = new HashMap<String, DynamicObject>(realCards.length);
                    for (DynamicObject dynamicObject : realCards) {
                        realCardsMap.put(dynamicObject.getString(Fa.id((String)"org")) + "-" + dynamicObject.getString("number"), dynamicObject);
                        numbersSet.add(dynamicObject.getString("number"));
                    }
                    if (realCardsMap.size() < 1 || numbersSet.size() < 1 || depreuseIdSet.size() < 1) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u5bf9\u5e94\u7684\u5b9e\u7269\u5361\u7247\u3001\u6298\u65e7\u7528\u9014\u7b49\u57fa\u7840\u8d44\u6599\u627e\u4e0d\u5230", (String)"FaInitFinCardSaveOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                        Optional checkResultInitFinCard;
                        DynamicObject finCard = extendedDataEntity.getDataEntity();
                        DynamicObject realCard = (DynamicObject)realCardsMap.get(finCard.getString("org_id") + "-" + finCard.getString("number"));
                        if (realCard == null) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8be5\u8d22\u52a1\u5361\u7247\u5bf9\u5e94\u7684\u5b9e\u7269\u5361\u7247\u627e\u4e0d\u5230", (String)"FaInitFinCardSaveOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        extendedDataEntity.setValue("realcard", (Object)realCard);
                        Optional checkResult = FaInitFinCardSaveOp.this.checkFutureBiz(realCard);
                        if (checkResult.isPresent()) {
                            String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\u6216\u66f4\u65b0\uff1a %s", (String)"FaInitFinCardSaveOp_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResult.get());
                            this.addMessage(extendedDataEntity, operationName, msg, ErrorLevel.Error);
                        }
                        if ((checkResultInitFinCard = FaInitFinCardSaveOp.this.checkFinFutureBiz(finCard)).isPresent()) {
                            String msg = String.format(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u5361\u7247\u5b58\u5728\u540e\u7eed\u4e1a\u52a1\uff0c\u65e0\u6cd5\u5220\u9664\u6216\u66f4\u65b0\uff1a %s", (String)"FaInitFinCardSaveOp_3", (String)"fi-fa-opplugin", (Object[])new Object[0]), checkResultInitFinCard.get());
                            this.addMessage(extendedDataEntity, operationName, msg, ErrorLevel.Error);
                        }
                        finCard.set("depredept_id", (Object)realCard.getLong(Fa.id((String)"headusedept")));
                        finCard.set("assetcat_id", (Object)realCard.getLong(Fa.id((String)"assetcat")));
                        String realCardStates = realCard.getString("billstatus");
                        if (!realCardStates.equals(BillStatus.C.name())) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u5bfc\u5165\u8d22\u52a1\u5361\u7247", (String)"FaInitFinCardSaveOp_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        DynamicObject depreMethod = finCard.getDynamicObject("depremethod");
                        DynamicObject assetPolicyEntry = AssetPolicyUtil.getByBookAndCat((Object)finCard.get("assetbook_id"), (Object)finCard.get("assetcat_id"));
                        if ("1".equals(assetPolicyEntry.getString("decpolicy")) && finCard.getBigDecimal("decval").compareTo(new BigDecimal(0)) != 0) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u653f\u7b56\u662f\u4e0d\u51cf\u503c\uff0c\u51cf\u503c\u51c6\u5907\u4e0d\u80fd\u6709\u503c", (String)"FaInitFinCardSaveOp_5", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                        }
                        if (depreMethod == null && !assetPolicyEntry.getBoolean("nodepre")) {
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6298\u65e7\u65b9\u6cd5", (String)"FaInitFinCardSaveOp_6", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                            continue;
                        }
                        if (finCard.get("addupyeardepre") != null) {
                            this.checkAddUpYearDepre(extendedDataEntity, finCard);
                        }
                        this.checkRealFinDate(extendedDataEntity, finCard);
                        if (depreMethod != null) {
                            long depredamount = finCard.getLong("depredamount");
                            BigDecimal accumdepre = finCard.getBigDecimal("accumdepre");
                            BigDecimal accumWorkLoad = finCard.getBigDecimal("depredamount");
                            String depreMethodType = depreMethod.getString("type");
                            if (!"5".equals(depreMethodType)) {
                                boolean checkNotWorkLoad;
                                boolean bl = checkNotWorkLoad = depredamount == 0L && BigDecimal.ZERO.compareTo(accumdepre) < 0 || depredamount != 0L && BigDecimal.ZERO.compareTo(accumdepre) == 0;
                                if (checkNotWorkLoad) {
                                    this.addMessage(extendedDataEntity, operationName, ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5bff\u547d\u548c\u7d2f\u8ba1\u6298\u65e7\u5fc5\u987b\u540c\u65f6\u4e3a0\uff0c\u6216\u8005\u540c\u65f6\u5927\u4e8e0\u3002", (String)"FaInitFinCardSaveOp_7", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                                    continue;
                                }
                            } else {
                                boolean checkWorkLoad;
                                boolean bl = checkWorkLoad = BigDecimal.ZERO.compareTo(accumWorkLoad) == 0 && BigDecimal.ZERO.compareTo(accumdepre) < 0 || BigDecimal.ZERO.compareTo(accumWorkLoad) != 0 && BigDecimal.ZERO.compareTo(accumdepre) == 0;
                                if (checkWorkLoad) {
                                    this.addMessage(extendedDataEntity, operationName, ResManager.loadKDString((String)"\u5df2\u6298\u65e7\u5de5\u4f5c\u91cf\u548c\u7d2f\u8ba1\u5de5\u4f5c\u91cf\u5fc5\u987b\u540c\u65f6\u4e3a0\uff0c\u6216\u8005\u540c\u65f6\u5927\u4e8e0\u3002", (String)"FaInitFinCardSaveOp_8", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                                    continue;
                                }
                                boolean mustInputWorkLoadUnit = FaFinCardUtil.isMustInputWorkLoadUnit();
                                Object workLoadUnitObj = finCard.get("workloadunit");
                                if (mustInputWorkLoadUnit && Objects.isNull(workLoadUnitObj)) {
                                    this.addMessage(extendedDataEntity, operationName, ResManager.loadKDString((String)"\u5de5\u4f5c\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FaInitFinCardSaveOp_9", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                                    continue;
                                }
                            }
                            BigDecimal preUsingAmount = finCard.getBigDecimal("preusingamount");
                            boolean isGenFinCard = this.getOption().containsVariable("genfincard");
                            if (preUsingAmount == null || preUsingAmount.compareTo(BigDecimal.ZERO) <= 0) {
                                this.addMessage(extendedDataEntity, operationName, ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u9884\u8ba1\u5bff\u547d\u3002", (String)"FaInitFinCardSaveOp_10", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                                continue;
                            }
                            BigDecimal depredamountBig = finCard.getBigDecimal("depredamount");
                            if (preUsingAmount.compareTo(depredamountBig) < 0 && !"5".equals(depreMethodType)) {
                                this.addMessage(extendedDataEntity, operationName, ResManager.loadKDString((String)"\u9884\u8ba1\u5bff\u547d\u4e0d\u80fd\u5c0f\u4e8e\u5df2\u6298\u65e7\u5bff\u547d\u3002", (String)"FaInitFinCardSaveOp_11", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                            }
                        }
                        this.fincCardAssetValidate(operationName, extendedDataEntity, finCard);
                    }
                    List list = Arrays.stream(this.getDataEntities()).filter(v -> v.getDataEntity().getDataEntityState().getFromDatabase()).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
                    if (!list.isEmpty()) {
                        void var16_34;
                        FinCardValidator validator = FinCardValidator.getInstanceForSeparateCard(list);
                        Map errInfo = validator.validateInitFinCardForDelete();
                        boolean bl = false;
                        while (var16_34 < this.getDataEntities().length) {
                            List errMsg = (List)errInfo.get((int)var16_34);
                            if (errMsg != null && !errMsg.isEmpty()) {
                                ExtendedDataEntity dataEntity = this.getDataEntities()[var16_34];
                                errMsg.forEach(v -> this.addErrorMessage(dataEntity, (String)v));
                            }
                            ++var16_34;
                        }
                    }
                }
            }

            private void checkAssetBookEnable(ExtendedDataEntity[] dataEntities) {
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    DynamicObject finCard = dataEntity.getDataEntity();
                    DynamicObject assetBook = finCard.getDynamicObject("assetbook");
                    if (assetBook == null) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5361\u7247\u6570\u636e\u5f02\u5e38\uff0c\u672a\u5173\u8054\u8d44\u4ea7\u8d26\u7c3f\u3002", (String)"FaInitFinCardSaveOp_12", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                        continue;
                    }
                    boolean enable = assetBook.getBoolean("enable");
                    String status = assetBook.getString("status");
                    if (!enable || !BillStatus.C.name().equals(status)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d44\u4ea7\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u4fdd\u5b58\u521d\u59cb\u5316\u8d22\u52a1\u5361\u7247\u3002", (String)"FaInitFinCardSaveOp_13", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }

            private void checkRealFinDate(ExtendedDataEntity dataEntity, DynamicObject initCard) {
                Date finRecordingPeriod = initCard.getDate("finaccountdate");
                Date realRecordingPeriod = initCard.getDynamicObject("realcard").getDate("realaccountdate");
                Date enableStartPeriod = this.getTypePeriodStartDate(initCard, "startperiod");
                SimpleDateFormat dateFormat = new SimpleDateFormat(FaInitFinCardSaveOp.DATE_FORMAT);
                if (finRecordingPeriod != null) {
                    if (DateUtil.compareShortDate((Date)finRecordingPeriod, (Date)realRecordingPeriod) < 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%1$s)\u5e94\u665a\u4e8e\u5b9e\u7269\u5361\u7247\u542f\u7528\u65e5\u671f(%2$s)", (String)"FaInitFinCardSaveOp_14", (String)"fi-fa-opplugin", (Object[])new Object[0]), dateFormat.format(finRecordingPeriod), dateFormat.format(realRecordingPeriod)));
                    }
                    if (DateUtil.compareShortDate((Date)enableStartPeriod, (Date)finRecordingPeriod) <= 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5165\u8d26\u65e5\u671f(%1$s)\u5e94\u65e9\u4e8e\u8d44\u4ea7\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u7684\u5f00\u59cb\u65f6\u95f4(%2$s)\u3002", (String)"FaInitFinCardSaveOp_15", (String)"fi-fa-opplugin", (Object[])new Object[0]), dateFormat.format(finRecordingPeriod), dateFormat.format(enableStartPeriod)));
                    }
                }
            }

            private void checkAddUpYearDepre(ExtendedDataEntity dataEntity, DynamicObject finCard) {
                BigDecimal addUpYearDepre = finCard.getBigDecimal("addupyeardepre");
                DynamicObject enablePeriod = finCard.getDynamicObject("assetbook").getDynamicObject("startperiod");
                Long periodId = (Long)enablePeriod.getPkValue();
                int periodNumber = PeriodUtil.getPeriodNumberById((long)periodId);
                if (periodNumber == 1 && addUpYearDepre.compareTo(BigDecimal.ZERO) != 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8d26\u7c3f\u542f\u7528\u671f\u95f4\u4e3a1\u671f\u65f6\uff0c\u4e0d\u5141\u8bb8\u5f55\u5165\u672c\u5e74\u7d2f\u8ba1\u6298\u65e7", (String)"FaInitFinCardSaveOp_16", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }

            private void fincCardAssetValidate(String operationName, ExtendedDataEntity de, DynamicObject initCard) {
                Long assetCateId = initCard.getDynamicObject("realcard").getLong(Fa.id((String)"assetcat"));
                DynamicObject faAssetCate = null;
                if (FaInitFinCardSaveOp.this.assetObjects.get(assetCateId) == null) {
                    QFilter[] filter = new QFilter("id", "=", (Object)assetCateId).toArray();
                    faAssetCate = QueryServiceHelper.queryOne((String)"fa_assetcategory", (String)"longnumber", (QFilter[])filter);
                } else {
                    faAssetCate = (DynamicObject)FaInitFinCardSaveOp.this.assetObjects.get(assetCateId);
                }
                String assetcatLongNumber = faAssetCate.getString("longnumber");
                DynamicObject depresystem = initCard.getDynamicObject("assetbook").getDynamicObject("depresystem");
                Object depresystemId = depresystem.getPkValue();
                List<String> entryLongNumber = new ArrayList();
                boolean isContainLongNumber = false;
                if (FaInitFinCardSaveOp.this.depresystemCache.get(depresystemId) != null) {
                    entryLongNumber = (List)FaInitFinCardSaveOp.this.depresystemCache.get(depresystemId);
                    for (String entryNumber : entryLongNumber) {
                        if (assetcatLongNumber.indexOf(entryNumber) != 0) continue;
                        isContainLongNumber = true;
                        break;
                    }
                } else {
                    String longnumber;
                    DynamicObjectCollection entrysDoc = BusinessDataServiceHelper.loadSingle((Object)depresystemId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"fa_depresystem")).getDynamicObjectCollection("assetpolicy_entry");
                    for (DynamicObject entry : entrysDoc) {
                        longnumber = entry.getDynamicObject("assetcat").getString("longnumber");
                        entryLongNumber.add(longnumber);
                    }
                    FaInitFinCardSaveOp.this.depresystemCache.put(depresystemId, entryLongNumber);
                    for (DynamicObject entry : entrysDoc) {
                        longnumber = entry.getDynamicObject("assetcat").getString("longnumber");
                        if (assetcatLongNumber.indexOf(longnumber) != 0) continue;
                        isContainLongNumber = true;
                        break;
                    }
                }
                if (!isContainLongNumber) {
                    this.addMessage(de, operationName, new LocaleString(ResManager.loadKDString((String)"\u8d22\u52a1\u5361\u7247\u5bf9\u5e94\u7684\u8d44\u4ea7\u7c7b\u522b\u672a\u7ef4\u62a4\u8d44\u4ea7\u653f\u7b56", (String)"FaInitFinCardSaveOp_17", (String)"fi-fa-opplugin", (Object[])new Object[0])).toString(), ErrorLevel.Error);
                }
            }

            private Date getTypePeriodStartDate(DynamicObject finCard, String periodType) {
                if (finCard == null) {
                    return null;
                }
                DynamicObject enablePeriod = finCard.getDynamicObject("assetbook").getDynamicObject(periodType);
                if (enablePeriod == null) {
                    return null;
                }
                Object enablePeriodPk = enablePeriod.getPkValue();
                Date enableDate = (Date)FaInitFinCardSaveOp.this.enablePeriodMapCache.get(enablePeriodPk);
                if (enableDate != null) {
                    return enableDate;
                }
                DynamicObject period = FaBaseDaoFactory.getInstance((String)"bd_period").queryOne(String.format("%s,%s", "id", "begindate"), enablePeriodPk);
                if (period == null) {
                    return null;
                }
                enableDate = period.getDate("begindate");
                FaInitFinCardSaveOp.this.enablePeriodMapCache.put(enablePeriodPk, enableDate);
                return enableDate;
            }
        });
        e.addValidator((AbstractValidator)new LeasePushCardValidator());
    }
}

