/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.botp.ConvertDataService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FaInitRealDeleteOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(FaInitRealDeleteOpPlugin.class);

    public void onAddValidators(AddValidatorsEventArgs e) {
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<DynamicObject> initLeaseToRealCardList = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            Object srcBillEntityName = dataEntity.get("srcbillentityname");
            if (!"fa_lease_contract_init".equals(srcBillEntityName)) continue;
            initLeaseToRealCardList.add(dataEntity);
        }
        if (!initLeaseToRealCardList.isEmpty()) {
            this.deleteLeaseContractLinkRealCard(initLeaseToRealCardList);
        }
    }

    private void deleteLeaseContractLinkRealCard(List<DynamicObject> initLeaseToRealCardList) {
        ConvertDataService reader = new ConvertDataService();
        TableDefine leaseTableDefine = reader.loadTableDefine("fa_lease_contract", "fa_lease_contract");
        TableDefine realCardTableDefine = reader.loadTableDefine("fa_card_real", "fa_card_real");
        Long leaseTableId = leaseTableDefine.getTableId();
        Long realCardTableId = realCardTableDefine.getTableId();
        Set realCardIds = initLeaseToRealCardList.stream().map(v -> v.getPkValue()).collect(Collectors.toSet());
        try {
            SqlBuilder sqlBuilder = new SqlBuilder();
            sqlBuilder.append("delete from t_botp_billtracker where ", new Object[0]);
            sqlBuilder.append("fstableid = ?", new Object[]{leaseTableId});
            sqlBuilder.append(" and fttableid = ?", new Object[]{realCardTableId});
            sqlBuilder.appendIn(" and ftbillid", realCardIds.toArray());
            DB.execute((DBRoute)DBRoute.basedata, (SqlBuilder)sqlBuilder);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            throw new KDBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458", (String)"FaInitRealDeleteOpPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }
}

