/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.validate.AbstractValidator;

public class FaInventSchemeDeletePlugin
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("billstate");
        e.getFieldKeys().add("taskstatus");
        e.getFieldKeys().add("entryentity");
        e.getFieldKeys().add("entryentity.splitdetailentity");
        e.getFieldKeys().add("splitdetailentity.entrystatus");
        e.getFieldKeys().add("entryentity.splitdetailentity.entrystatus");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        this.getOption().setVariableValue("ignorerefentityids", "fa_inventory_task,fa_inventory_sope,fa_inv_task_merge");
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject inventScheme = dataEntity.getDataEntity();
                    boolean hasAssigned = FaInventSchemeDeletePlugin.this.getTaskStatus(inventScheme);
                    if (!hasAssigned) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u4e0b\u8fbe\u7684\u76d8\u70b9\u4efb\u52a1\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FaInventSchemeDeletePlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if (!"C".equals(inventScheme.getString("billstate"))) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\u3002", (String)"FaInventSchemeDeletePlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    Boolean getTaskStatus(DynamicObject inventScheme) {
        Boolean result = true;
        DynamicObjectCollection entries = inventScheme.getDynamicObjectCollection("entryentity");
        if (entries != null && entries.size() > 0) {
            for (DynamicObject rowDy : entries) {
                DynamicObjectCollection taskDys = rowDy.getDynamicObjectCollection("splitdetailentity");
                for (DynamicObject taskDy : taskDys) {
                    String status = taskDy.getString("entrystatus");
                    if ("A".equalsIgnoreCase(status) || "Z".equalsIgnoreCase(status)) continue;
                    result = false;
                    return result;
                }
            }
        }
        return result;
    }
}

