/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class FaInventSchemeSavePlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject bill = dataEntity.getDataEntity();
                    if ("C".equals(bill.getString("billstate"))) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u65b9\u6848\u5df2\u5173\u95ed\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"FaInventSchemeSavePlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                        continue;
                    }
                    HashMap orgCat = new HashMap();
                    DynamicObjectCollection entries = bill.getDynamicObjectCollection("entryentity");
                    for (DynamicObject entry : entries) {
                        Object orgid = entry.get("assetunit_id");
                        if (!orgCat.containsKey(orgid)) {
                            orgCat.put(orgid, new HashSet());
                        }
                        Set catSet = (Set)orgCat.get(orgid);
                        String taskrule = entry.get("taskrule") == null ? "" : entry.get("taskrule").toString();
                        Long chargeperson = entry.getLong("chargeperson_id");
                        if (!StringUtils.isBlank((String)taskrule) || chargeperson != 0L) continue;
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4efb\u52a1\u62c6\u5206\u89c4\u5219\u548c\u7ec4\u7ec7\u8d1f\u8d23\u4eba\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"FaInventSchemeSavePlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                }
            }
        });
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        super.afterExecuteOperationTransaction(e);
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            this.refreshBaseData(dataEntity);
        }
    }

    void refreshBaseData(DynamicObject dataEntity) {
        MainEntityType dataEntityType;
        Object[] entryPKArray;
        DynamicObject[] entrys;
        DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entryentity");
        ArrayList<Object> entryPKList = new ArrayList<Object>();
        ArrayList<Object> rulePKList = new ArrayList<Object>();
        for (DynamicObject entry : entries) {
            entryPKList.add(entry.getPkValue());
            DynamicObjectCollection ruleEntries = entry.getDynamicObjectCollection("splitdetailentity");
            for (DynamicObject ruleEntry : ruleEntries) {
                rulePKList.add(ruleEntry.getPkValue());
            }
        }
        if (entryPKList.size() > 0 && (entrys = BusinessDataServiceHelper.load((Object[])(entryPKArray = entryPKList.toArray(new Object[entryPKList.size()])), (DynamicObjectType)(dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_inventory_sope")))).length > 0) {
            SaveServiceHelper.save((DynamicObject[])entrys);
        }
        if (rulePKList.size() > 0) {
            Object[] rulePKArray = rulePKList.toArray(new Object[rulePKList.size()]);
            dataEntityType = EntityMetadataCache.getDataEntityType((String)"fa_inventory_task");
            DynamicObject[] rules = BusinessDataServiceHelper.load((Object[])rulePKArray, (DynamicObjectType)dataEntityType);
            long currentTimeMillis = System.currentTimeMillis() * 100000L;
            for (DynamicObject rule : rules) {
                if (!StringUtils.isEmpty((String)rule.getString("number"))) continue;
                rule.set("number", (Object)(++currentTimeMillis + ""));
            }
            if (rules.length > 0) {
                SaveServiceHelper.save((DynamicObject[])rules);
            }
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            dataEntity.set("status", (Object)"C");
            dataEntity.set("billstate", (Object)"A");
            DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entries) {
                if (!"Z".equals(entry.getString("taskstatus"))) continue;
                entry.set("taskstatus", (Object)"A");
            }
            this.setRuleRow(dataEntity);
        }
    }

    private void setRuleRow(DynamicObject dataEntity) {
        DynamicObjectCollection entries = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entries) {
            DynamicObject person;
            DynamicObjectCollection ruleEntries = entry.getDynamicObjectCollection("splitdetailentity");
            String taskRule = entry.getString("taskrule");
            if (StringUtils.isEmpty((String)taskRule) && (person = entry.getDynamicObject("chargeperson")) != null) {
                if (ruleEntries.size() == 0) {
                    DynamicObject ruleEntry = ruleEntries.addNew();
                    ruleEntry.set("inventperson", (Object)person);
                    ruleEntry.set("entrystatus", (Object)"A");
                } else {
                    ((DynamicObject)ruleEntries.get(0)).set("inventperson", (Object)person);
                }
            }
            for (DynamicObject ruleEntry : ruleEntries) {
                ruleEntry.set("inventschemeid", (Object)dataEntity.getLong("id"));
            }
        }
    }
}

