/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.enums.inventory.InventoryBackLogEnum;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;

public class FaInventoryNoFoundOp
extends AbstractOperationServicePlugIn {
    private static final String SELECT_FIELDS = "id,inventoryquantity,inventorystate,inventorytime,inventoryuser,reason,difference,inventoryway,bookquantity";

    public void onAddValidators(final AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (DynamicObject entity : e.getDataEntities()) {
                    int size = entity.getDynamicObjectCollection("entryentity").size();
                    if (size == 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u76d8\u70b9\u8d44\u4ea7\u3002", (String)"FaInventoryNoFoundOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    ArrayList result = new ArrayList(size);
                    entity.getDynamicObjectCollection("entryentity").forEach(e -> {
                        if (e.getString("reason").isEmpty()) {
                            result.add(e.getString("inventoryrecord.name"));
                        }
                    });
                    if (result.size() == 0) continue;
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u672a\u627e\u5230\uff0c\u8bf7\u586b\u5199\u539f\u56e0\u3002", (String)"FaInventoryNoFoundOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), result));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] inventoryRecords;
        super.beginOperationTransaction(e);
        HashMap map = new HashMap(32);
        for (DynamicObject entity : e.getDataEntities()) {
            DynamicObjectCollection dynamicObjects = entity.getDynamicObjectCollection("entryentity");
            dynamicObjects.forEach(dynamicObject -> {
                Long id = dynamicObject.getLong(Fa.id((String)"inventoryrecord"));
                map.put(id, dynamicObject.getString("reason"));
            });
        }
        for (DynamicObject inventoryRecord : inventoryRecords = BusinessDataServiceHelper.load((String)"fa_inventory_record", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", map.keySet())})) {
            inventoryRecord.set("inventorystate", (Object)InventoryBackLogEnum.A);
            inventoryRecord.set("inventorytime", (Object)new Date());
            inventoryRecord.set("inventoryway", (Object)InventoryBackLogEnum.D);
            BigDecimal inventoryQuantity = inventoryRecord.getBigDecimal("inventoryquantity") != null ? inventoryRecord.getBigDecimal("inventoryquantity") : BigDecimal.ZERO;
            BigDecimal bookquantity = inventoryRecord.getBigDecimal("bookquantity") != null ? inventoryRecord.getBigDecimal("bookquantity") : BigDecimal.ZERO;
            inventoryRecord.set("difference", (Object)inventoryQuantity.subtract(bookquantity));
            inventoryRecord.set("inventoryquantity", (Object)0);
            inventoryRecord.set("inventoryuser", (Object)ContextUtil.getUserId());
            inventoryRecord.set("reason", map.get(inventoryRecord.getLong("id")));
        }
        if (inventoryRecords.length > 0) {
            SaveServiceHelper.update((DynamicObject[])inventoryRecords);
        }
    }
}

