/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.ContextUtil;

public class FaInventoryRecordSavePlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(final AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                DynamicObject[] bills = e.getDataEntities();
                if (bills.length == 0) {
                    return;
                }
                Map recordMap = FaInventoryRecordSavePlugin.this.getRecordMap(bills);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    int inventoryquantity;
                    DynamicObject bill = dataEntity.getDataEntity();
                    long pkId = bill.getLong("id");
                    DynamicObject dyn = (DynamicObject)recordMap.get(pkId);
                    if (dyn != null && "C".equals(dyn.getString("billstate"))) {
                        this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u5ba1\u6838\u7684\u76d8\u70b9\u8bb0\u5f55\u4e0d\u5141\u8bb8\u5f15\u5165\u3002", (String)"FaInventoryRecordSavePlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if ((inventoryquantity = bill.getInt("inventoryquantity")) >= 0) continue;
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u76d8\u70b9\u6570\u91cf\u5c0f\u4e8e\u96f6\u4e0d\u5141\u8bb8\u5f15\u5165\u3002", (String)"FaInventoryRecordSavePlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills.length == 0) {
            return;
        }
        String select = "id,assetunit,inventschemeentry";
        Date now = new Date();
        Map<Long, DynamicObject> recordMap = this.getRecordMap(bills);
        HashSet<Object> scopeIds = new HashSet<Object>(bills.length);
        for (DynamicObject bill : bills) {
            scopeIds.add(bill.get("inventorytask.inventsscopeid_id"));
        }
        QFilter[] filters = new QFilter("id", "in", scopeIds).toArray();
        DynamicObjectCollection scopes = QueryServiceHelper.query((String)"fa_inventory_sope", (String)select, (QFilter[])filters);
        HashMap<Object, DynamicObject> scopeMap = new HashMap<Object, DynamicObject>();
        for (DynamicObject scope : scopes) {
            scopeMap.put(scope.get("id"), scope);
        }
        for (DynamicObject bill : bills) {
            long pkId = bill.getLong("id");
            Object scopeId = bill.get("inventorytask.inventsscopeid_id");
            DynamicObject scope = (DynamicObject)scopeMap.get(scopeId);
            Object inventschemeentry = scope.get("inventschemeentry");
            DynamicObject oldBill = recordMap.get(pkId);
            bill.set("realcard", oldBill.get("realcard"));
            bill.set("number", oldBill.get("number"));
            bill.set("barcode", oldBill.get("barcode"));
            bill.set("name", oldBill.get("name"));
            bill.set("model", oldBill.get("model"));
            bill.set("bookquantity", oldBill.get("bookquantity"));
            bill.set("unit", oldBill.get("unit"));
            BigDecimal inventoryquantity = bill.getBigDecimal("inventoryquantity");
            BigDecimal bookQuantity = bill.getBigDecimal("bookquantity");
            bill.set("difference", (Object)inventoryquantity.subtract(bookQuantity));
            bill.set("inventorystate", (Object)"A");
            bill.set("inventschemeentry_id", inventschemeentry);
            if (!"C".equals(bill.getString("billstate"))) {
                bill.set("billstate", (Object)"A");
            }
            if (oldBill.get("inventoryuser") == null) {
                bill.set("inventoryuser_id", (Object)ContextUtil.getUserId());
                bill.set("inventorytime", (Object)now);
                continue;
            }
            String way = oldBill.getString("inventoryway");
            bill.set("inventoryway", (Object)way);
        }
    }

    private Map<Long, DynamicObject> getRecordMap(DynamicObject[] bills) {
        Set taskIdSet = Stream.of(bills).map(v -> v.get("id")).collect(Collectors.toSet());
        String select = "id,realcard,barcode,inventorystate,inventorytask,billstate,inventoryquantity,number,name,unit,model,bookquantity,inventoryuser,inventoryway";
        QFilter[] filters = new QFilter("id", "in", taskIdSet).toArray();
        DynamicObject[] existRecords = BusinessDataServiceHelper.load((String)"fa_inventory_record", (String)select, (QFilter[])filters);
        HashMap<Long, DynamicObject> recordMap = new HashMap<Long, DynamicObject>(existRecords.length);
        for (DynamicObject existRecord : existRecords) {
            recordMap.put(existRecord.getLong("id"), existRecord);
        }
        return recordMap;
    }
}

