/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.common.util.ContextUtil;

public class FaInventoryRecrodOpPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(FaInventoryRecrodOpPlugin.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Object[]> updateInventoryRecordList = new ArrayList<Object[]>(dataEntities.length);
        Long userId = ContextUtil.getUserId();
        Date newDate = new Date();
        for (DynamicObject dataEntity : dataEntities) {
            Object[] updateInventoryRecord = new Object[8];
            BigDecimal inventoryquantity = dataEntity.getBigDecimal("inventoryquantity");
            BigDecimal bookquantity = dataEntity.getBigDecimal("bookquantity");
            updateInventoryRecord[0] = inventoryquantity.subtract(bookquantity);
            updateInventoryRecord[1] = userId + "";
            updateInventoryRecord[2] = "A";
            updateInventoryRecord[3] = "B";
            updateInventoryRecord[4] = newDate;
            updateInventoryRecord[5] = inventoryquantity;
            updateInventoryRecord[6] = "A";
            updateInventoryRecord[7] = dataEntity.getString("number");
            updateInventoryRecordList.add(updateInventoryRecord);
        }
        if (updateInventoryRecordList.size() > 0) {
            String sql = "update t_fa_inventory_record set fdifference=?, finventoryuser=?, finventorystate=?, finventoryway=?, finventorytime=?, finventoryquantity=?, fbillstate=? where fnumber=?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"fa"), (String)sql, updateInventoryRecordList);
            log.info("FaInventoryRecrodOpPlugin updateInventoryRecordList sucess,\u5bfc\u5165\u66f4\u65b0\u76d8\u70b9\u8bb0\u5f55\u6210\u529f params are " + updateInventoryRecordList);
        }
    }
}

