/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.fa.business.enums.inventory.InventoryBackLogEnum;
import kd.fi.fa.common.util.Fa;

public class FaInventoryRestartOp
extends AbstractOperationServicePlugIn {
    private static final String SELECT_FIELDS = "id,inventoryquantity,inventorystate,inventorytime,inventoryuser,reason,difference,inventoryway,bookquantity,modifier,modifytime";

    public void onAddValidators(final AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (DynamicObject entity : e.getDataEntities()) {
                    if (entity.getDynamicObjectCollection("entryentity").size() != 0) continue;
                    throw new KDBizException(ResManager.loadKDString((String)"\u6ca1\u6709\u7b26\u5408\u6761\u4ef6\u7684\u76d8\u70b9\u8d44\u4ea7\u3002", (String)"FaInventoryRestartOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] inventoryRecords;
        super.beginOperationTransaction(e);
        ArrayList ids = new ArrayList(20);
        for (DynamicObject entity : e.getDataEntities()) {
            DynamicObjectCollection dynamicObjects = entity.getDynamicObjectCollection("entryentity");
            dynamicObjects.forEach(dynamicObject -> {
                Long id = dynamicObject.getLong(Fa.id((String)"inventoryrecord"));
                ids.add(id);
            });
        }
        for (DynamicObject inventoryRecord : inventoryRecords = BusinessDataServiceHelper.load((String)"fa_inventory_record", (String)SELECT_FIELDS, (QFilter[])new QFilter[]{new QFilter("id", "in", ids)})) {
            inventoryRecord.set("inventoryquantity", (Object)0);
            inventoryRecord.set("inventorystate", (Object)InventoryBackLogEnum.B);
            inventoryRecord.set("inventorytime", null);
            inventoryRecord.set("inventoryway", null);
            inventoryRecord.set("difference", null);
            inventoryRecord.set("reason", null);
            inventoryRecord.set("inventoryuser", null);
        }
        if (inventoryRecords.length > 0) {
            SaveServiceHelper.update((DynamicObject[])inventoryRecords);
        }
    }
}

