/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;
import kd.fi.fa.opplugin.FaPurchaseCompleteBuildUtils;
import kd.fi.fa.opplugin.FaUseDeptCheckValidator;
import kd.fi.fa.opplugin.validator.FaPurchaseBillMaterialAndProductLineValidator;

public class FaPurchasebillSubmitOp
extends AbstractOperationServicePlugIn {
    private static final String BUILDBYQTY = "2";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("assetqtyleft");
        fieldKeys.add("assetqty");
        fieldKeys.add("assetsentry");
        fieldKeys.add("handleorg");
        fieldKeys.add("costcentrer");
        fieldKeys.add("buildway");
        fieldKeys.add("ismainline");
        fieldKeys.add("materielfield");
        fieldKeys.add("productline");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operationKey = this.getOperateKey();
                ExtendedDataEntity[] purchasebills = this.getDataEntities();
                HashSet<Long> orgSet = new HashSet<Long>(purchasebills.length, 1.0f);
                for (ExtendedDataEntity purchasebill : purchasebills) {
                    DynamicObject org;
                    DynamicObject entity = purchasebill.getDataEntity();
                    if (entity.getDynamicObjectCollection("assetsentry").size() < 1) {
                        this.addErrorMessage(purchasebill, new LocaleString(ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u5f55\u5165\u4e00\u6761\u5206\u5f55\u4fe1\u606f\u3002", (String)"FaPurchasebillSubmitOp_0", (String)"fi-fa-opplugin", (Object[])new Object[0])).toString());
                    }
                    if ((org = entity.getDynamicObject("org")) != null) {
                        orgSet.add(org.getLong("id"));
                    } else {
                        this.addErrorMessage(purchasebill, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaPurchasebillSubmitOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    String buildway = entity.getString("buildway");
                    if (!FaPurchasebillSubmitOp.BUILDBYQTY.equals(buildway)) continue;
                    DynamicObjectCollection entries = entity.getDynamicObjectCollection("assetsentry");
                    for (int i = 0; i < entries.size(); ++i) {
                        DynamicObject entry = (DynamicObject)entries.get(i);
                        BigDecimal assetqty = entry.getBigDecimal("assetqty");
                        if (new BigDecimal(assetqty.intValue()).compareTo(assetqty) == 0) continue;
                        this.addErrorMessage(purchasebill, String.format(ResManager.loadKDString((String)"\u5206\u5f55\u7b2c%s\u884c\uff1a\u6570\u91cf\u4e0d\u4e3a\u6574\u6570\uff0c\u4e0d\u80fd\u4ee5\u6570\u91cf\u62c6\u5206\u5efa\u5361", (String)"FaPurchasebillSubmitOp_2", (String)"fi-fa-opplugin", (Object[])new Object[0]), i + 1));
                    }
                }
                QFilter isMainFilter = new QFilter("ismainbook", "=", (Object)true);
                QFilter orgFilter = new QFilter("org", "in", orgSet);
                DynamicObjectCollection assetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"org", "basecurrency"}), (QFilter[])new QFilter[]{isMainFilter, orgFilter});
                Map<Long, Long> orgAndBaseCurrency = assetBooks.stream().collect(Collectors.toMap(v -> v.getLong("org"), v -> v.getLong("basecurrency")));
                for (ExtendedDataEntity purchasebill : purchasebills) {
                    String msg;
                    DynamicObject entity = purchasebill.getDataEntity();
                    DynamicObject org = entity.getDynamicObject("org");
                    DynamicObject baseCurrency = entity.getDynamicObject("basecurrency");
                    long baseCurrencyId = 0L;
                    long orgId = 0L;
                    if (org != null) {
                        orgId = org.getLong("id");
                    } else {
                        this.addErrorMessage(purchasebill, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"FaPurchasebillSubmitOp_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if (baseCurrency != null) {
                        baseCurrencyId = baseCurrency.getLong("id");
                    } else {
                        this.addErrorMessage(purchasebill, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u672c\u4f4d\u5e01", (String)"FaPurchasebillSubmitOp_3", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if (orgAndBaseCurrency.get(orgId) != null) {
                        if (baseCurrencyId != orgAndBaseCurrency.get(orgId)) {
                            this.addErrorMessage(purchasebill, ResManager.loadKDString((String)"\u672c\u4f4d\u5e01\u5fc5\u987b\u662f\u4e3b\u8d26\u7c3f\u672c\u4f4d\u5e01", (String)"FaPurchasebillSubmitOp_4", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                        }
                    } else {
                        this.addErrorMessage(purchasebill, ResManager.loadKDString((String)"\u8bf7\u5148\u521b\u5efa\u4e3b\u8d26\u7c3f", (String)"FaPurchasebillSubmitOp_5", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                    }
                    if ((msg = FaPurchaseCompleteBuildUtils.checkAndMainLine(entity)) == null) continue;
                    this.addErrorMessage(purchasebill, msg);
                }
            }
        });
        e.addValidator((AbstractValidator)new FaUseDeptCheckValidator());
        e.addValidator((AbstractValidator)new FaPurchaseBillMaterialAndProductLineValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        assert ("submit".equalsIgnoreCase(e.getOperationKey()));
        DynamicObject[] purBillObjs = e.getDataEntities();
        Stream.of(purBillObjs).forEach(this::setAssetQtyLeft);
        Stream.of(purBillObjs).forEach(FaPurchaseCompleteBuildUtils::setDefaultMainLine);
    }

    private void setAssetQtyLeft(DynamicObject purBillObj) {
        DynamicObjectCollection purEntryObjs = purBillObj.getDynamicObjectCollection("assetsentry");
        purEntryObjs.stream().forEach(v -> v.set("assetqtyleft", v.get("assetqty")));
    }
}

