/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.fa.common.util.ContextUtil;
import kd.fi.fa.common.util.Fa;

public class FaQueryRepairAccDepreOpPlugin
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity entity : this.getDataEntities()) {
                    DynamicObject object = entity.getDataEntity();
                    if (object == null) continue;
                    int year = object.getInt("integerfield");
                    if (QueryServiceHelper.exists((String)"bd_period", (QFilter[])new QFilter[]{new QFilter("periodyear", "=", (Object)year)})) continue;
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u586b\u5199\u7684\u4fee\u590d\u5e74\u4efd\u5728\u6240\u6709\u4f1a\u8ba1\u671f\u95f4\u7c7b\u578b\u4e0b\u4e0d\u5b58\u5728\u3002", (String)"FaQueryRepairAccDepreOpPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        Arrays.stream(e.getDataEntities()).forEach(v -> {
            Set<String> realNums;
            DynamicObjectCollection assetbooks;
            int year = v.getInt("integerfield");
            Set assetbookIds = v.getDynamicObjectCollection("mulbasedatafield").stream().map(obj -> obj.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
            if (year > 0) {
                qFilters.add(new QFilter(Fa.dot((String[])new String[]{"startperiod", "periodyear"}), "<", (Object)year));
            }
            if (!assetbookIds.isEmpty()) {
                qFilters.add(new QFilter("id", "in", assetbookIds));
            }
            if ((assetbooks = QueryServiceHelper.query((String)"fa_assetbook", (String)Fa.comma((String[])new String[]{"org", "periodtype"}), (QFilter[])qFilters.toArray(new QFilter[0]))).isEmpty()) {
                return;
            }
            HashMap<Long, Set> periodTypeAndOrgIds = new HashMap<Long, Set>(assetbooks.size());
            for (Object assetbook : assetbooks) {
                periodTypeAndOrgIds.computeIfAbsent(assetbook.getLong("periodtype"), p -> new HashSet(assetbooks.size())).add(assetbook.getLong("org"));
            }
            HashSet<String> bizNums = new HashSet<String>();
            for (Map.Entry entry : periodTypeAndOrgIds.entrySet()) {
                HashSet<String> periodBizNums = new HashSet<String>();
                HashMap map = new HashMap(2);
                DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)Fa.comma((String[])new String[]{"id", "periodnumber", "begindate", "enddate"}), (QFilter[])new QFilter[]{new QFilter("periodtype", "=", entry.getKey()), new QFilter("periodyear", "=", (Object)year), new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE)});
                periods.stream().filter(p -> p.getInt("periodnumber") == 1).forEach(p -> {
                    map.put("firstPeriod", p.getLong("id"));
                    map.put("firstPeriodBeginDate", p.getDate("begindate"));
                });
                periods.stream().filter(p -> p.getInt("periodnumber") == 2).forEach(p -> map.put("beginDate", p.getDate("begindate")));
                periods.stream().filter(p -> p.getInt("periodnumber") == 12).forEach(p -> map.put("endDate", p.getDate("enddate")));
                Set<String> changeNums = this.queryBizBillRealMsg("fa_change_dept", Fa.dot((String[])new String[]{"realentry", "realcard", "number"}), "org", new QFilter[]{new QFilter("changedate", ">=", map.get("beginDate")), new QFilter("changedate", "<=", map.get("endDate")), new QFilter("org", "in", entry.getValue())});
                Set<String> clearNums = this.queryBizBillRealMsg("fa_clearbill", Fa.dot((String[])new String[]{"detail_entry", "realcard", "number"}), "org", new QFilter[]{new QFilter("cleardate", ">=", map.get("beginDate")), new QFilter("cleardate", "<=", map.get("endDate")), new QFilter("org", "in", entry.getValue())});
                Set<String> splitNums = this.queryBizBillRealMsg("fa_assetsplitbill", Fa.dot((String[])new String[]{"assetsplitentry", "realcard", "number"}), "org", new QFilter[]{new QFilter("splitdate", ">=", map.get("beginDate")), new QFilter("splitdate", "<=", map.get("endDate")), new QFilter("org", "in", entry.getValue())});
                Set<String> devalueNums = this.queryBizBillRealMsg("fa_asset_devalue", Fa.dot((String[])new String[]{"changebillentry", "realcard", "number"}), "org", new QFilter[]{new QFilter("businessdate", ">=", map.get("beginDate")), new QFilter("businessdate", "<=", map.get("endDate")), new QFilter("org", "in", entry.getValue())});
                periodBizNums.addAll(changeNums);
                periodBizNums.addAll(splitNums);
                periodBizNums.addAll(clearNums);
                periodBizNums.addAll(devalueNums);
                Set realOrgs2 = periodBizNums.stream().map(b -> Long.parseLong(b.substring(0, b.indexOf("-")))).collect(Collectors.toSet());
                Set realNums2 = periodBizNums.stream().map(b -> b.substring(b.indexOf("-") + 1)).collect(Collectors.toSet());
                if (!realOrgs2.isEmpty() && !realNums2.isEmpty()) {
                    Set<String> firstNums = this.queryBizBillRealMsg("fa_card_fin", Fa.dot((String[])new String[]{"realcard", "number"}), "org", new QFilter[]{new QFilter("bizperiod", "=", map.get("firstPeriod")), new QFilter("org", "in", realOrgs2), new QFilter("number", "in", realNums2)});
                    Set<String> newNums = this.queryBizBillRealMsg("fa_card_fin", Fa.dot((String[])new String[]{"realcard", "number"}), "org", new QFilter[]{new QFilter("finaccountdate", ">=", map.get("beginDate")), new QFilter("finaccountdate", "<=", map.get("endDate")), new QFilter("org", "in", realOrgs2), new QFilter("number", "in", realNums2)});
                    periodBizNums.removeAll(firstNums);
                    periodBizNums.removeAll(newNums);
                }
                bizNums.addAll(periodBizNums);
            }
            HashMap<String, Map<Long, List<DynamicObject>>> depreResult = new HashMap<String, Map<Long, List<DynamicObject>>>(bizNums.size());
            if (!bizNums.isEmpty()) {
                Set<Long> set = bizNums.stream().map(b -> Long.parseLong(b.substring(0, b.indexOf("-")))).collect(Collectors.toSet());
                realNums = bizNums.stream().map(b -> b.substring(b.indexOf("-") + 1)).collect(Collectors.toSet());
                this.insertDepreResult(set, realNums, depreResult, false, year, bizNums);
            }
            Set<String> dispatchInNums = this.queryDispatchInBillRealMsg("fa_dispatch_in", Fa.dot((String[])new String[]{"dispatchentry", "realcard", "number"}), "inorg", new QFilter[0], year);
            ArrayList<DynamicObject> repairAccDepres = new ArrayList<DynamicObject>(bizNums.size() + dispatchInNums.size());
            if (!dispatchInNums.isEmpty()) {
                Set<Long> set = dispatchInNums.stream().map(b -> Long.parseLong(b.substring(0, b.indexOf("-")))).collect(Collectors.toSet());
                realNums = dispatchInNums.stream().map(b -> b.substring(b.indexOf("-") + 1)).collect(Collectors.toSet());
                this.insertDisptchInDepreResult(set, realNums, year, dispatchInNums, repairAccDepres);
            }
            for (Map.Entry entry : depreResult.entrySet()) {
                Map map = (Map)entry.getValue();
                for (Map.Entry depreEntry : map.entrySet()) {
                    DynamicObject fincard;
                    List finCards = (List)depreEntry.getValue();
                    if (finCards.isEmpty() || (fincard = (DynamicObject)finCards.get(0)) == null) continue;
                    BigDecimal monthDepre = (BigDecimal)fincard.get("monthdepre");
                    BigDecimal yearDepre = (BigDecimal)fincard.get("addupyeardepre");
                    BigDecimal adjustDepreAmount = yearDepre.subtract(monthDepre);
                    if (adjustDepreAmount.compareTo(new BigDecimal(0)) <= 0) continue;
                    DynamicObject repairAccDepre = BusinessDataServiceHelper.newDynamicObject((String)"fa_rs_yaccudepre");
                    repairAccDepre.set(Fa.id((String)"org"), (Object)fincard.getLong("org"));
                    repairAccDepre.set("billno", (Object)fincard.getString("billno"));
                    repairAccDepre.set("billstatus", (Object)BillStatus.A);
                    repairAccDepre.set("number", (Object)fincard.getString("number"));
                    repairAccDepre.set(Fa.id((String)"depreuse"), (Object)fincard.getLong("depreuse"));
                    repairAccDepre.set("finid", (Object)fincard.getLong("id"));
                    repairAccDepre.set("bfyeardepre", (Object)yearDepre);
                    repairAccDepre.set("yeardepreadjust", (Object)adjustDepreAmount);
                    repairAccDepre.set(Fa.id((String)"basecurrency"), (Object)fincard.getLong("basecurrency"));
                    repairAccDepre.set(Fa.id((String)"bizperiod"), (Object)fincard.getLong("bizperiod"));
                    repairAccDepre.set("creator", (Object)ContextUtil.getUserId());
                    repairAccDepres.add(repairAccDepre);
                }
            }
            if (!repairAccDepres.isEmpty()) {
                Map<Long, BigDecimal> newRepairMap = repairAccDepres.stream().collect(Collectors.toMap(t -> t.getLong("finid"), t -> t.getBigDecimal("bfyeardepre")));
                HashSet<Long> hasDiffFinIds = new HashSet<Long>(newRepairMap.size());
                if (!newRepairMap.isEmpty()) {
                    DynamicObject[] newRepairs;
                    DynamicObjectCollection collection = QueryServiceHelper.query((String)"fa_rs_yaccudepre", (String)Fa.comma((String[])new String[]{"finid", "bfyeardepre"}), (QFilter[])new QFilter[]{new QFilter("finid", "in", newRepairMap.keySet())});
                    Set exitFinIds = collection.stream().map(s -> s.getLong("finid")).collect(Collectors.toSet());
                    for (DynamicObject repair : collection) {
                        BigDecimal newBfYearDepre;
                        long finId = repair.getLong("finid");
                        BigDecimal bfYearDepre = repair.getBigDecimal("bfyeardepre");
                        if (bfYearDepre.compareTo(newBfYearDepre = newRepairMap.get(finId)) == 0) continue;
                        hasDiffFinIds.add(finId);
                    }
                    if (!hasDiffFinIds.isEmpty()) {
                        DeleteServiceHelper.delete((String)"fa_rs_yaccudepre", (QFilter[])new QFilter[]{new QFilter("finid", "in", hasDiffFinIds)});
                        exitFinIds.removeAll(hasDiffFinIds);
                    }
                    if ((newRepairs = (DynamicObject[])repairAccDepres.stream().filter(g -> !exitFinIds.contains(g.getLong("finid"))).toArray(DynamicObject[]::new)).length != 0) {
                        OperationServiceHelper.executeOperate((String)"save", (String)"fa_rs_yaccudepre", (DynamicObject[])newRepairs, null);
                    }
                }
            }
        });
    }

    private Set<String> queryBizBillRealMsg(String entityName, String realNum, String org, QFilter[] qFilters) {
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityName, (String)Fa.comma((String[])new String[]{realNum, org}), (QFilter[])qFilters);
        return bills.stream().map(v -> v.getLong(org) + "-" + v.getString(realNum)).collect(Collectors.toSet());
    }

    private Set<String> queryDispatchInBillRealMsg(String entityName, String realNum, String org, QFilter[] qFilters, int year) {
        List bills = QueryServiceHelper.query((String)entityName, (String)Fa.comma((String[])new String[]{realNum, org, "dispatchdate"}), (QFilter[])qFilters).stream().filter(v -> {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(v.getDate("dispatchdate"));
            return year == calendar.get(1);
        }).collect(Collectors.toList());
        return bills.stream().map(v -> v.getLong(org) + "-" + v.getString(realNum)).collect(Collectors.toSet());
    }

    private void insertDepreResult(Set<Long> realOrgs, Set<String> realNums, Map<String, Map<Long, List<DynamicObject>>> depreResult, boolean isDispatchIn, int year, Set<String> bizNums) {
        String selectFields = Fa.comma((String[])new String[]{"id", "number", "org", "monthdepre", "addupyeardepre", "realcard", "bizperiod", Fa.dot((String[])new String[]{"period", "periodyear"}), Fa.dot((String[])new String[]{"bizperiod", "periodyear"}), "depreuse", "basecurrency", "billno"});
        List fincards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("number", "in", realNums), new QFilter("org", "in", realOrgs), new QFilter("originaldata", "=", (Object)false)}, (String)"bizperiod asc").stream().filter(v -> bizNums.contains(v.getLong("org") + "-" + v.getString("number"))).collect(Collectors.toList());
        HashMap<String, List> result = new HashMap<String, List>(fincards.size());
        for (DynamicObject dynamicObject : fincards) {
            result.computeIfAbsent(dynamicObject.getLong("org") + "-" + dynamicObject.getString("number"), k -> new ArrayList()).add(dynamicObject);
        }
        for (Map.Entry entry : result.entrySet()) {
            HashMap<Long, List> depreMap = new HashMap<Long, List>(result.size());
            long count = ((List)entry.getValue()).stream().filter(h -> h.getInt(Fa.dot((String[])new String[]{"bizperiod", "periodyear"})) < year).count();
            if (count <= 0L) continue;
            List finCards = ((List)entry.getValue()).stream().filter(h -> h.getInt(Fa.dot((String[])new String[]{"bizperiod", "periodyear"})) == year).collect(Collectors.toList());
            for (DynamicObject finCard : finCards) {
                depreMap.computeIfAbsent(finCard.getLong("depreuse"), k -> new ArrayList()).add(finCard);
            }
            depreResult.put((String)entry.getKey(), (Map<Long, List<DynamicObject>>)depreMap);
        }
    }

    private void insertDisptchInDepreResult(Set<Long> realOrgs, Set<String> realNums, int year, Set<String> bizNums, List<DynamicObject> repairAccDepres) {
        String selectFields = Fa.comma((String[])new String[]{"id", "number", "org", "monthdepre", "addupyeardepre", "realcard", "bizperiod", "period", Fa.dot((String[])new String[]{"period", "periodyear"}), Fa.dot((String[])new String[]{"bizperiod", "periodyear"}), "depreuse", "basecurrency", "billno"});
        List fincards = QueryServiceHelper.query((String)"fa_card_fin", (String)selectFields, (QFilter[])new QFilter[]{new QFilter("number", "in", realNums), new QFilter("org", "in", realOrgs), new QFilter(Fa.dot((String[])new String[]{"realcard", "sourceflag"}), "=", (Object)"DISPATCH"), new QFilter("originaldata", "=", (Object)false), new QFilter(Fa.dot((String[])new String[]{"bizperiod", "periodyear"}), "=", (Object)year)}, (String)"bizperiod asc").stream().filter(v -> v.getLong("period") == v.getLong("bizperiod")).filter(v -> bizNums.contains(v.getLong("org") + "-" + v.getString("number"))).collect(Collectors.toList());
        for (DynamicObject fincard : fincards) {
            if (fincard == null) continue;
            BigDecimal monthDepre = (BigDecimal)fincard.get("monthdepre");
            BigDecimal yearDepre = (BigDecimal)fincard.get("addupyeardepre");
            BigDecimal adjustDepreAmount = yearDepre.subtract(monthDepre);
            if (adjustDepreAmount.compareTo(new BigDecimal(0)) <= 0) continue;
            DynamicObject repairAccDepre = BusinessDataServiceHelper.newDynamicObject((String)"fa_rs_yaccudepre");
            repairAccDepre.set(Fa.id((String)"org"), (Object)fincard.getLong("org"));
            repairAccDepre.set("billno", (Object)fincard.getString("billno"));
            repairAccDepre.set("billstatus", (Object)BillStatus.A);
            repairAccDepre.set("number", (Object)fincard.getString("number"));
            repairAccDepre.set(Fa.id((String)"depreuse"), (Object)fincard.getLong("depreuse"));
            repairAccDepre.set("finid", (Object)fincard.getLong("id"));
            repairAccDepre.set("bfyeardepre", (Object)yearDepre);
            repairAccDepre.set("yeardepreadjust", (Object)adjustDepreAmount);
            repairAccDepre.set(Fa.id((String)"basecurrency"), (Object)fincard.getLong("basecurrency"));
            repairAccDepre.set(Fa.id((String)"bizperiod"), (Object)fincard.getLong("bizperiod"));
            repairAccDepre.set("creator", (Object)ContextUtil.getUserId());
            repairAccDepres.add(repairAccDepre);
        }
    }
}

