/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaRealCardValidator
extends AbstractValidator {
    public void validate() {
        OperateOption option = this.getOption();
        boolean assetCardOperate = option.containsVariable("assetCardOperate");
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        List<Object> realCardsHasUnStagingFin = new LinkedList();
        if (!assetCardOperate) {
            ArrayList<Long> realCardPks = new ArrayList<Long>(dataEntities.length);
            ExtendedDataEntity[] extendedDataEntityArray = dataEntities;
            int n = extendedDataEntityArray.length;
            for (int i = 0; i < n; ++i) {
                ExtendedDataEntity dataEntity = extendedDataEntityArray[i];
                DynamicObject realCard = dataEntity.getDataEntity();
                realCardPks.add((Long)realCard.getPkValue());
            }
            realCardsHasUnStagingFin = this.getRealCardsHasUnStagingFin(realCardPks);
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject realCard = dataEntity.getDataEntity();
            boolean initCard = realCard.getBoolean("initialcard");
            if (initCard) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u521d\u59cb\u5316\u5b9e\u7269\u5361\u7247\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838", (String)"FaRealCardValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                continue;
            }
            if (assetCardOperate || !realCardsHasUnStagingFin.contains(realCard.getPkValue())) continue;
            this.addMessage(dataEntity, this.getValidateContext().getOperateName(), ResManager.loadKDString((String)"\u5b9e\u7269\u5361\u7247\u5bf9\u5e94\u7684\u8d22\u52a1\u5361\u7247\u4e0d\u662f\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u80fd\u8fdb\u884c\u53cd\u5ba1\u6838\u3002", (String)"FaRealCardValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
        }
    }

    private List<Long> getRealCardsHasUnStagingFin(List<Long> realCardPks) {
        LinkedList<Long> realCardsHasUnStagingFin = new LinkedList<Long>();
        String fields = Fa.comma((String[])new String[]{"billstatus", "realcardmasterid"});
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"fa_card_fin", (String)fields, (QFilter[])new QFilter[]{new QFilter("realcardmasterid", "in", realCardPks)}, null);
        for (Row row : dataSet) {
            Long realMasterId = row.getLong("realcardmasterid");
            String finStatus = row.getString("billstatus");
            if (BillStatus.A.name().equals(finStatus)) continue;
            realCardsHasUnStagingFin.add(realMasterId);
        }
        return realCardsHasUnStagingFin;
    }
}

