/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class FaRealCheckClearApplyValidator
extends AbstractValidator {
    private MainEntityType billEntityType;
    private static Set<String> realCardOpSet = new HashSet<String>();

    public FaRealCheckClearApplyValidator(MainEntityType billEntityType) {
        this.billEntityType = billEntityType;
    }

    public void validate() {
        HashMap<String, DynamicObjectCollection> org2ClearApplyBills = new HashMap<String, DynamicObjectCollection>();
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String operateName = this.getOperateKey();
            String billEntityName = this.billEntityType.getName();
            if (billEntityName.equals("fa_initcard_real") && !operateName.equals("save") || billEntityName.equals("fa_card_real") && !realCardOpSet.contains(operateName)) continue;
            Long realCardid = (Long)dataEntity.getBillPkId();
            DynamicObject dy = dataEntity.getDataEntity();
            String assetUnitidStr = dy.getString("assetunit.id");
            DynamicObjectCollection clearApplyBills = (DynamicObjectCollection)org2ClearApplyBills.get(assetUnitidStr);
            if (clearApplyBills == null) {
                String selectFields = Fa.dot((String[])new String[]{"clrapplybill_entry", "realcard"});
                QFilter[] filters = new QFilter[]{new QFilter("assetunit", "=", dy.get("assetunit.id")), new QFilter("billstatus", "!=", (Object)BillStatus.C)};
                clearApplyBills = QueryServiceHelper.query((String)"fa_clearapplybill", (String)selectFields, (QFilter[])filters);
                org2ClearApplyBills.put(assetUnitidStr, clearApplyBills);
            }
            if (clearApplyBills == null || clearApplyBills.size() == 0) continue;
            for (DynamicObject clearApplyBill : clearApplyBills) {
                if (realCardid.longValue() != clearApplyBill.getLong("clrapplybill_entry.realcard")) continue;
                String errorMsg = ResManager.loadKDString((String)"\u5361\u7247\u5728\u6e05\u7406\u7533\u8bf7\u5355\u4e2d\uff0c\u4e0d\u80fd\u64cd\u4f5c", (String)"FaRealCheckClearApplyValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.Error);
            }
        }
    }

    static {
        realCardOpSet.add("save");
        realCardOpSet.add("unaudit");
        realCardOpSet.add("delete");
    }
}

