/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.MonthClose;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.fa.business.dao.factory.FaAssetBookDaoFactory;
import kd.fi.fa.business.depretask.DepreStatusEnum2;
import kd.fi.fa.business.enums.depre.FaOperationOpTypeEnum;
import kd.fi.fa.business.enums.depre.FaOperationStatusEnum;
import kd.fi.fa.business.periodclose.PeriodAutoCloseSingleHandler;
import kd.fi.fa.business.po.FaOperationLogInsertPo;
import kd.fi.fa.business.utils.FaOperationLogUtils;
import kd.fi.fa.common.util.Fa;

public class ClosePeriodOpPlugin
extends AbstractOperationServicePlugIn {
    private static Log logger = LogFactory.getLog(ClosePeriodOpPlugin.class);
    private Date beginDate;
    private DynamicObject assetBook;

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] periodCloseBills;
        super.beginOperationTransaction(e);
        for (DynamicObject periodCloseBill : periodCloseBills = e.getDataEntities()) {
            this.monthClose(periodCloseBill);
        }
    }

    private void monthClose(DynamicObject periodCloseBill) {
        this.beginDate = new Date();
        String orgName = periodCloseBill.getString("org.name");
        Object pkValue = periodCloseBill.getPkValue();
        try {
            logger.info(orgName + ": \u5f00\u59cb\u6267\u884c\u6708\u7ed3");
            this.assetBook = FaAssetBookDaoFactory.getInstance().queryOne(pkValue);
            new PeriodAutoCloseSingleHandler((AbstractOperationServicePlugIn)this).forIntelligence(this.assetBook);
            logger.info(orgName + ": \u6267\u884c\u6708\u7ed3\u6210\u529f");
        }
        catch (Exception e) {
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            errorInfo.setErrorLevel(ErrorLevel.Error.name());
            errorInfo.setPkValue(pkValue);
            errorInfo.setMessage(e.toString());
            if (e instanceof KDBizException) {
                errorInfo.setMessage(e.getMessage());
            }
            this.operationResult.addErrorInfo(errorInfo);
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DepreStatusEnum2 status = DepreStatusEnum2.SUC;
        String message = ResManager.loadKDString((String)"\u6210\u529f", (String)"ClosePeriodOpPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
        if (this.operationResult.getMessage() != null) {
            message = this.operationResult.getMessage();
            this.operationResult.setMessage(null);
            status = DepreStatusEnum2.FAI;
        }
        String prams = "ClosePeriodOpPlugin -> " + String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7: %1$s, \u6298\u65e7\u7528\u9014\uff1a%2$s, \u671f\u95f4\uff1a%3$s", (String)"ClosePeriodOpPlugin_1", (String)"fi-fa-opplugin", (Object[])new Object[0]), this.assetBook.getString(Fa.dot((String[])new String[]{"org", "id"})), this.assetBook.getString(Fa.dot((String[])new String[]{"depreuse", "id"})), this.assetBook.getString(Fa.dot((String[])new String[]{"curperiod", "id"})));
        FaOperationLogInsertPo insertPo = new FaOperationLogInsertPo(this.assetBook.getString(Fa.dot((String[])new String[]{"org", "name"})), this.assetBook.getString(Fa.dot((String[])new String[]{"depreuse", "name"})), this.assetBook.getString("name"), this.assetBook.getString(Fa.dot((String[])new String[]{"curperiod", "name"})), Integer.valueOf(0), "fa_periodclosebill", prams, FaOperationOpTypeEnum.PERIODCLOSE);
        if (status.getValue().equals(DepreStatusEnum2.SUC.getValue())) {
            FaOperationLogUtils.insertOperationLog((FaOperationLogInsertPo)insertPo, (FaOperationStatusEnum)FaOperationStatusEnum.SUCCESS, null);
        } else {
            FaOperationLogUtils.insertOperationLog((FaOperationLogInsertPo)insertPo, (FaOperationStatusEnum)FaOperationStatusEnum.FAILED, (String)message);
        }
    }
}

