/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.MonthClose;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.enums.lease.LeaseContractBizStatus;
import kd.fi.fa.business.enums.lease.LeaseContractRentSettleStatus;

public class LeaseContractRentSettleCheck
implements IClosePeriodCheckPlugin {
    public CheckResult execute(CheckContext context) throws Throwable {
        Long orgId = context.getOrgId();
        QFilter[] filters = new QFilter[]{new QFilter("org", "=", (Object)orgId), new QFilter("rentsettlestatus", "=", (Object)LeaseContractRentSettleStatus.A.name()), new QFilter("bizstatus", "!=", (Object)LeaseContractBizStatus.B.name()), new QFilter("sourcetype", "!=", (Object)"C"), new QFilter("leasetermstartdate", "<=", (Object)context.getPeriodEndDate())};
        DynamicObjectCollection data = QueryServiceHelper.query((String)"fa_lease_contract", (String)"id", (QFilter[])filters);
        CheckResult checkResult = new CheckResult();
        if (!data.isEmpty()) {
            Set billIds = data.stream().map(v -> v.getLong("id")).collect(Collectors.toSet());
            checkResult.setOnlineViewId("fa_lease_contract");
            QFilter idFilter = new QFilter("id", "in", billIds);
            checkResult.setOnlineQueryParams(idFilter.toSerializedString());
            checkResult.setMessages(Collections.singletonList(LeaseContractRentSettleCheck.buildFailMsg(data.size())));
            checkResult.setIsSuccess(Boolean.FALSE.booleanValue());
        } else {
            checkResult.setMessages(Collections.singletonList(LeaseContractRentSettleCheck.buildSuccessMsg()));
            checkResult.setIsSuccess(Boolean.TRUE.booleanValue());
        }
        return checkResult;
    }

    private static String buildSuccessMsg() {
        return ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u672a\u8ba1\u606f\u7684\u5408\u540c\u3002", (String)"LeaseContractRentSettleCheck_0", (String)"fi-fa-opplugin", (Object[])new Object[0]);
    }

    private static String buildFailMsg(int count) {
        return ResManager.loadKDString((String)"\u5b58\u5728%s\u5f20\u672a\u8ba1\u606f\u7684\u5408\u540c\u3002", (String)"LeaseContractRentSettleCheck_1", (String)"fi-fa-opplugin", (Object[])new Object[]{count});
    }
}

