/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.common.util.Fa;

public class AbstractAssetCardValidator
extends AbstractValidator {
    public void validate() {
        HashSet<Long> orgIds = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            boolean isInitCard;
            DynamicObject assetCard = dataEntity.getDataEntity();
            boolean mergedCard = assetCard.getBoolean("mergedcard");
            if (!mergedCard) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u8d44\u4ea7\u5361\u7247\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c\u3002", (String)"AbstractAssetCardValidator_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
            }
            if (isInitCard = assetCard.getBoolean("initialcard")) continue;
            orgIds.add(assetCard.getLong(Fa.id((String)"org")));
        }
        if (orgIds.isEmpty()) {
            return;
        }
        DynamicObjectCollection notEnableAssetBooks = QueryServiceHelper.query((String)"fa_assetbook", (String)"org", (QFilter[])new QFilter[]{new QFilter("org", "in", orgIds), new QFilter("status", "=", (Object)BillStatus.B.name())});
        if (notEnableAssetBooks.isEmpty()) {
            return;
        }
        Set notEnableBookOrgIds = notEnableAssetBooks.stream().map(v -> v.getLong("org")).collect(Collectors.toSet());
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            long orgId = dataEntity.getDataEntity().getLong(Fa.id((String)"org"));
            if (!notEnableBookOrgIds.contains(orgId)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8d44\u4ea7\u8d26\u7c3f\u672a\u542f\u7528\uff0c\u8bf7\u5148\u7ed3\u675f\u521d\u59cb\u5316\u3002", (String)"AbstractAssetCardValidator_1", (String)"fi-fa-opplugin", (Object[])new Object[0]));
        }
    }
}

