/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.fa.opplugin.assetcard;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.BillStatus;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.fa.business.BizStatusEnum;
import kd.fi.fa.business.SourceFlagEnum;
import kd.fi.fa.business.dao.IFaFinCardDao;
import kd.fi.fa.business.dao.factory.FaFinCardDaoFactory;
import kd.fi.fa.opplugin.FaRealCheckClearApplyValidator;
import kd.fi.fa.opplugin.realcard.FaRealCardSaveOp;
import kd.fi.fa.opplugin.validator.FaProductLineValidator;
import kd.fi.fa.utils.FaOpUtils;

public class FaAssetCardInitOperationPlugin
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(FaAssetCardInitOperationPlugin.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("org");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        this.setMasterId(e);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        HashSet<Object> realIds = new HashSet<Object>(dataEntities.length);
        for (DynamicObject assetCard : dataEntities) {
            Object realCardId = assetCard.get("id");
            if (realCardId == null) continue;
            realIds.add(realCardId);
        }
        IFaFinCardDao fCardDao = FaFinCardDaoFactory.getInstance();
        fCardDao.copyFinCards(0L, 0L, realIds.toArray(), null, null, null);
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        String oerateName = e.getOperationKey();
        if ("assetcardinitsave".equals(oerateName)) {
            DynamicObject[] daynamicObjects = e.getDataEntities();
            HashSet<DynamicObject> srcEntityName4InitLease = new HashSet<DynamicObject>(daynamicObjects.length);
            for (DynamicObject dataEntity : daynamicObjects) {
                dataEntity.set("billstatus", (Object)BillStatus.C.toString());
                dataEntity.set("bizstatus", (Object)BizStatusEnum.READY);
                dataEntity.set("initialcard", (Object)Boolean.TRUE);
                Object srcBillEntityName = dataEntity.get("srcbillentityname");
                if (!"fa_lease_contract_init".equals(srcBillEntityName)) {
                    dataEntity.set("sourceflag", (Object)SourceFlagEnum.INITIAL);
                    continue;
                }
                srcEntityName4InitLease.add(dataEntity);
            }
            if (!srcEntityName4InitLease.isEmpty()) {
                FaRealCardSaveOp.addLeaseContractLinkRealCard(srcEntityName4InitLease, "fa_asset_card");
            }
        }
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                String operateName = this.getOperateKey();
                HashMap<String, Boolean> org2HasEndInitBook = new HashMap<String, Boolean>();
                block6: for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                    DynamicObject realCardObj = extendedDataEntity.getDataEntity();
                    switch (operateName) {
                        case "assetcardinitsave": {
                            String orgIdStr = realCardObj.getString("org_id");
                            Long orgId = realCardObj.getLong("org_id");
                            Boolean hasEndInitBook = (Boolean)org2HasEndInitBook.get(orgIdStr);
                            if (hasEndInitBook == null) {
                                QFilter filterOrg = new QFilter("org.id", "=", (Object)orgId);
                                QFilter filterEnable = new QFilter("status", "=", (Object)"C");
                                boolean isHasEndInitBook = QueryServiceHelper.exists((String)"fa_assetbook", (QFilter[])new QFilter[]{filterOrg, filterEnable});
                                org2HasEndInitBook.put(orgIdStr, isHasEndInitBook);
                                hasEndInitBook = isHasEndInitBook;
                            }
                            if (!hasEndInitBook.booleanValue()) continue block6;
                            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5bf9\u5e94\u8d26\u7c3f\u5df2\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u80fd\u64cd\u4f5c\u3002", (String)"FaAssetCardInitOperationPlugin_0", (String)"fi-fa-opplugin", (Object[])new Object[0]));
                            continue block6;
                        }
                    }
                }
            }
        });
        e.addValidator((AbstractValidator)new FaRealCheckClearApplyValidator(this.billEntityType));
        e.addValidator((AbstractValidator)new FaProductLineValidator());
    }

    protected void setMasterId(BeginOperationTransactionArgs e) {
        List<DynamicObject> cards = FaOpUtils.getDataEntities(e);
        for (DynamicObject card : cards) {
            long master = card.getLong("masterid");
            if (master != 0L) continue;
            card.set("masterid", (Object)card.getLong("id"));
        }
    }
}

